@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin

import com.pulumi.azurenative.netapp.SnapshotPolicyArgs.builder
import com.pulumi.azurenative.netapp.kotlin.inputs.DailyScheduleArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.DailyScheduleArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.HourlyScheduleArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.HourlyScheduleArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.MonthlyScheduleArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.MonthlyScheduleArgsBuilder
import com.pulumi.azurenative.netapp.kotlin.inputs.WeeklyScheduleArgs
import com.pulumi.azurenative.netapp.kotlin.inputs.WeeklyScheduleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Snapshot policy information
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2022-11-01-preview, 2023-05-01, 2023-05-01-preview, 2023-07-01.
 * ## Example Usage
 * ### SnapshotPolicies_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshotPolicy = new AzureNative.NetApp.SnapshotPolicy("snapshotPolicy", new()
 *     {
 *         AccountName = "account1",
 *         DailySchedule = new AzureNative.NetApp.Inputs.DailyScheduleArgs
 *         {
 *             Hour = 14,
 *             Minute = 30,
 *             SnapshotsToKeep = 4,
 *         },
 *         Enabled = true,
 *         HourlySchedule = new AzureNative.NetApp.Inputs.HourlyScheduleArgs
 *         {
 *             Minute = 50,
 *             SnapshotsToKeep = 2,
 *         },
 *         Location = "eastus",
 *         MonthlySchedule = new AzureNative.NetApp.Inputs.MonthlyScheduleArgs
 *         {
 *             DaysOfMonth = "10,11,12",
 *             Hour = 14,
 *             Minute = 15,
 *             SnapshotsToKeep = 5,
 *         },
 *         ResourceGroupName = "myRG",
 *         SnapshotPolicyName = "snapshotPolicyName",
 *         WeeklySchedule = new AzureNative.NetApp.Inputs.WeeklyScheduleArgs
 *         {
 *             Day = "Wednesday",
 *             Hour = 14,
 *             Minute = 45,
 *             SnapshotsToKeep = 3,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/netapp/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := netapp.NewSnapshotPolicy(ctx, "snapshotPolicy", &netapp.SnapshotPolicyArgs{
 * 			AccountName: pulumi.String("account1"),
 * 			DailySchedule: &netapp.DailyScheduleArgs{
 * 				Hour:            pulumi.Int(14),
 * 				Minute:          pulumi.Int(30),
 * 				SnapshotsToKeep: pulumi.Int(4),
 * 			},
 * 			Enabled: pulumi.Bool(true),
 * 			HourlySchedule: &netapp.HourlyScheduleArgs{
 * 				Minute:          pulumi.Int(50),
 * 				SnapshotsToKeep: pulumi.Int(2),
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			MonthlySchedule: &netapp.MonthlyScheduleArgs{
 * 				DaysOfMonth:     pulumi.String("10,11,12"),
 * 				Hour:            pulumi.Int(14),
 * 				Minute:          pulumi.Int(15),
 * 				SnapshotsToKeep: pulumi.Int(5),
 * 			},
 * 			ResourceGroupName:  pulumi.String("myRG"),
 * 			SnapshotPolicyName: pulumi.String("snapshotPolicyName"),
 * 			WeeklySchedule: &netapp.WeeklyScheduleArgs{
 * 				Day:             pulumi.String("Wednesday"),
 * 				Hour:            pulumi.Int(14),
 * 				Minute:          pulumi.Int(45),
 * 				SnapshotsToKeep: pulumi.Int(3),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.netapp.SnapshotPolicy;
 * import com.pulumi.azurenative.netapp.SnapshotPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshotPolicy = new SnapshotPolicy("snapshotPolicy", SnapshotPolicyArgs.builder()
 *             .accountName("account1")
 *             .dailySchedule(Map.ofEntries(
 *                 Map.entry("hour", 14),
 *                 Map.entry("minute", 30),
 *                 Map.entry("snapshotsToKeep", 4)
 *             ))
 *             .enabled(true)
 *             .hourlySchedule(Map.ofEntries(
 *                 Map.entry("minute", 50),
 *                 Map.entry("snapshotsToKeep", 2)
 *             ))
 *             .location("eastus")
 *             .monthlySchedule(Map.ofEntries(
 *                 Map.entry("daysOfMonth", "10,11,12"),
 *                 Map.entry("hour", 14),
 *                 Map.entry("minute", 15),
 *                 Map.entry("snapshotsToKeep", 5)
 *             ))
 *             .resourceGroupName("myRG")
 *             .snapshotPolicyName("snapshotPolicyName")
 *             .weeklySchedule(Map.ofEntries(
 *                 Map.entry("day", "Wednesday"),
 *                 Map.entry("hour", 14),
 *                 Map.entry("minute", 45),
 *                 Map.entry("snapshotsToKeep", 3)
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:netapp:SnapshotPolicy account1/snapshotPolicy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetApp/netAppAccounts/{accountName}/snapshotPolicies/{snapshotPolicyName}
 * ```
 * @property accountName The name of the NetApp account
 * @property dailySchedule Schedule for daily snapshots
 * @property enabled The property to decide policy is enabled or not
 * @property hourlySchedule Schedule for hourly snapshots
 * @property location The geo-location where the resource lives
 * @property monthlySchedule Schedule for monthly snapshots
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property snapshotPolicyName The name of the snapshot policy
 * @property tags Resource tags.
 * @property weeklySchedule Schedule for weekly snapshots
 */
public data class SnapshotPolicyArgs(
    public val accountName: Output<String>? = null,
    public val dailySchedule: Output<DailyScheduleArgs>? = null,
    public val enabled: Output<Boolean>? = null,
    public val hourlySchedule: Output<HourlyScheduleArgs>? = null,
    public val location: Output<String>? = null,
    public val monthlySchedule: Output<MonthlyScheduleArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val snapshotPolicyName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val weeklySchedule: Output<WeeklyScheduleArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.SnapshotPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.SnapshotPolicyArgs =
        com.pulumi.azurenative.netapp.SnapshotPolicyArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .dailySchedule(dailySchedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .hourlySchedule(hourlySchedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .monthlySchedule(monthlySchedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .snapshotPolicyName(snapshotPolicyName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .weeklySchedule(
                weeklySchedule?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SnapshotPolicyArgs].
 */
@PulumiTagMarker
public class SnapshotPolicyArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var dailySchedule: Output<DailyScheduleArgs>? = null

    private var enabled: Output<Boolean>? = null

    private var hourlySchedule: Output<HourlyScheduleArgs>? = null

    private var location: Output<String>? = null

    private var monthlySchedule: Output<MonthlyScheduleArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var snapshotPolicyName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var weeklySchedule: Output<WeeklyScheduleArgs>? = null

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("lhwlfvbjqkyqfhos")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Schedule for daily snapshots
     */
    @JvmName("gpkvegpgpgtnfojs")
    public suspend fun dailySchedule(`value`: Output<DailyScheduleArgs>) {
        this.dailySchedule = value
    }

    /**
     * @param value The property to decide policy is enabled or not
     */
    @JvmName("mfywruxinwprulhq")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Schedule for hourly snapshots
     */
    @JvmName("fligircxsbinmyom")
    public suspend fun hourlySchedule(`value`: Output<HourlyScheduleArgs>) {
        this.hourlySchedule = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gqodnfuptamluglk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Schedule for monthly snapshots
     */
    @JvmName("clfddlqaknofcxvy")
    public suspend fun monthlySchedule(`value`: Output<MonthlyScheduleArgs>) {
        this.monthlySchedule = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tbxqastxlrwvevxu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the snapshot policy
     */
    @JvmName("qrtkliponvicyhkc")
    public suspend fun snapshotPolicyName(`value`: Output<String>) {
        this.snapshotPolicyName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bioxetbjfeaiqlcb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Schedule for weekly snapshots
     */
    @JvmName("ffehddukajsinnvm")
    public suspend fun weeklySchedule(`value`: Output<WeeklyScheduleArgs>) {
        this.weeklySchedule = value
    }

    /**
     * @param value The name of the NetApp account
     */
    @JvmName("kdkxqdacwivwspaq")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Schedule for daily snapshots
     */
    @JvmName("lrffrwopqmthykts")
    public suspend fun dailySchedule(`value`: DailyScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailySchedule = mapped
    }

    /**
     * @param argument Schedule for daily snapshots
     */
    @JvmName("hpvivxevxsjxfjdi")
    public suspend fun dailySchedule(argument: suspend DailyScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = DailyScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dailySchedule = mapped
    }

    /**
     * @param value The property to decide policy is enabled or not
     */
    @JvmName("nmgppmwhtnrrmnav")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Schedule for hourly snapshots
     */
    @JvmName("nxaplyuplrjjvdpd")
    public suspend fun hourlySchedule(`value`: HourlyScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hourlySchedule = mapped
    }

    /**
     * @param argument Schedule for hourly snapshots
     */
    @JvmName("ccfooofwrxuervpb")
    public suspend fun hourlySchedule(argument: suspend HourlyScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = HourlyScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hourlySchedule = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pakugadllkhxqbnn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Schedule for monthly snapshots
     */
    @JvmName("jlevbwacdjryerdr")
    public suspend fun monthlySchedule(`value`: MonthlyScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthlySchedule = mapped
    }

    /**
     * @param argument Schedule for monthly snapshots
     */
    @JvmName("qggyhbweskwqjiku")
    public suspend fun monthlySchedule(argument: suspend MonthlyScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = MonthlyScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.monthlySchedule = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yhkxadwjbbablmuu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the snapshot policy
     */
    @JvmName("cwpltfonlnmqrxme")
    public suspend fun snapshotPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotPolicyName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kyhnaeywenwhwyxu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("lxwqjghmwcayrisr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Schedule for weekly snapshots
     */
    @JvmName("artyambfllqucaho")
    public suspend fun weeklySchedule(`value`: WeeklyScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklySchedule = mapped
    }

    /**
     * @param argument Schedule for weekly snapshots
     */
    @JvmName("ionwnwhixgosjatd")
    public suspend fun weeklySchedule(argument: suspend WeeklyScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = WeeklyScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.weeklySchedule = mapped
    }

    internal fun build(): SnapshotPolicyArgs = SnapshotPolicyArgs(
        accountName = accountName,
        dailySchedule = dailySchedule,
        enabled = enabled,
        hourlySchedule = hourlySchedule,
        location = location,
        monthlySchedule = monthlySchedule,
        resourceGroupName = resourceGroupName,
        snapshotPolicyName = snapshotPolicyName,
        tags = tags,
        weeklySchedule = weeklySchedule,
    )
}
