@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This parameter specifies who is authorized to change the ownership of a file. restricted - Only root user can change the ownership of the file. unrestricted - Non-root users can change ownership of files that they own.
 */
public enum class ChownMode(
    public val javaValue: com.pulumi.azurenative.netapp.enums.ChownMode,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.enums.ChownMode> {
    Restricted(com.pulumi.azurenative.netapp.enums.ChownMode.Restricted),
    Unrestricted(com.pulumi.azurenative.netapp.enums.ChownMode.Unrestricted),
    ;

    override fun toJava(): com.pulumi.azurenative.netapp.enums.ChownMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.enums.ChownMode): ChownMode =
            ChownMode.values().first { it.javaValue == javaType }
    }
}
