@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Source of key used to encrypt data in volume. Applicable if NetApp account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive) are: 'Microsoft.NetApp, Microsoft.KeyVault'
 */
public enum class EncryptionKeySource(
    public val javaValue: com.pulumi.azurenative.netapp.enums.EncryptionKeySource,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.enums.EncryptionKeySource> {
    /**
     * Microsoft-managed key encryption
     */
    Microsoft_NetApp(com.pulumi.azurenative.netapp.enums.EncryptionKeySource.Microsoft_NetApp),

    /**
     * Customer-managed key encryption
     */
    Microsoft_KeyVault(com.pulumi.azurenative.netapp.enums.EncryptionKeySource.Microsoft_KeyVault),
    ;

    override fun toJava(): com.pulumi.azurenative.netapp.enums.EncryptionKeySource = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.enums.EncryptionKeySource):
            EncryptionKeySource = EncryptionKeySource.values().first { it.javaValue == javaType }
    }
}
