@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The service level of the file system
 */
public enum class ServiceLevel(
    public val javaValue: com.pulumi.azurenative.netapp.enums.ServiceLevel,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.enums.ServiceLevel> {
    /**
     * Standard service level
     */
    Standard(com.pulumi.azurenative.netapp.enums.ServiceLevel.Standard),

    /**
     * Premium service level
     */
    Premium(com.pulumi.azurenative.netapp.enums.ServiceLevel.Premium),

    /**
     * Ultra service level
     */
    Ultra(com.pulumi.azurenative.netapp.enums.ServiceLevel.Ultra),

    /**
     * Zone redundant storage service level
     */
    StandardZRS(com.pulumi.azurenative.netapp.enums.ServiceLevel.StandardZRS),
    ;

    override fun toJava(): com.pulumi.azurenative.netapp.enums.ServiceLevel = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.enums.ServiceLevel): ServiceLevel =
            ServiceLevel.values().first { it.javaValue == javaType }
    }
}
