@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.LdapSearchScopeOptArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * LDAP search scope
 * @property groupDN This specifies the group DN, which overrides the base DN for group lookups.
 * @property groupMembershipFilter This specifies the custom LDAP search filter to be used when looking up group membership from LDAP server.
 * @property userDN This specifies the user DN, which overrides the base DN for user lookups.
 */
public data class LdapSearchScopeOptArgs(
    public val groupDN: Output<String>? = null,
    public val groupMembershipFilter: Output<String>? = null,
    public val userDN: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.LdapSearchScopeOptArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.LdapSearchScopeOptArgs =
        com.pulumi.azurenative.netapp.inputs.LdapSearchScopeOptArgs.builder()
            .groupDN(groupDN?.applyValue({ args0 -> args0 }))
            .groupMembershipFilter(groupMembershipFilter?.applyValue({ args0 -> args0 }))
            .userDN(userDN?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LdapSearchScopeOptArgs].
 */
@PulumiTagMarker
public class LdapSearchScopeOptArgsBuilder internal constructor() {
    private var groupDN: Output<String>? = null

    private var groupMembershipFilter: Output<String>? = null

    private var userDN: Output<String>? = null

    /**
     * @param value This specifies the group DN, which overrides the base DN for group lookups.
     */
    @JvmName("fuispcwsouttdhee")
    public suspend fun groupDN(`value`: Output<String>) {
        this.groupDN = value
    }

    /**
     * @param value This specifies the custom LDAP search filter to be used when looking up group membership from LDAP server.
     */
    @JvmName("viisclrfwddeidvh")
    public suspend fun groupMembershipFilter(`value`: Output<String>) {
        this.groupMembershipFilter = value
    }

    /**
     * @param value This specifies the user DN, which overrides the base DN for user lookups.
     */
    @JvmName("fevklsnlcxpjrvrm")
    public suspend fun userDN(`value`: Output<String>) {
        this.userDN = value
    }

    /**
     * @param value This specifies the group DN, which overrides the base DN for group lookups.
     */
    @JvmName("dxeovqljkkqtdqnm")
    public suspend fun groupDN(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupDN = mapped
    }

    /**
     * @param value This specifies the custom LDAP search filter to be used when looking up group membership from LDAP server.
     */
    @JvmName("blhmgwkuevxiebty")
    public suspend fun groupMembershipFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupMembershipFilter = mapped
    }

    /**
     * @param value This specifies the user DN, which overrides the base DN for user lookups.
     */
    @JvmName("wngqgcwsfsidmfgo")
    public suspend fun userDN(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDN = mapped
    }

    internal fun build(): LdapSearchScopeOptArgs = LdapSearchScopeOptArgs(
        groupDN = groupDN,
        groupMembershipFilter = groupMembershipFilter,
        userDN = userDN,
    )
}
