@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.PlacementKeyValuePairsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Application specific parameters for the placement of volumes in the volume group
 * @property key Key for an application specific parameter for the placement of volumes in the volume group
 * @property value Value for an application specific parameter for the placement of volumes in the volume group
 */
public data class PlacementKeyValuePairsArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.PlacementKeyValuePairsArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.PlacementKeyValuePairsArgs =
        com.pulumi.azurenative.netapp.inputs.PlacementKeyValuePairsArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PlacementKeyValuePairsArgs].
 */
@PulumiTagMarker
public class PlacementKeyValuePairsArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Key for an application specific parameter for the placement of volumes in the volume group
     */
    @JvmName("sqqutbbhvvrugyhk")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Value for an application specific parameter for the placement of volumes in the volume group
     */
    @JvmName("upqonvdevjqsqpoh")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Key for an application specific parameter for the placement of volumes in the volume group
     */
    @JvmName("suaumdtaufkcdcnm")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Value for an application specific parameter for the placement of volumes in the volume group
     */
    @JvmName("oinmhrmxugqittvu")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): PlacementKeyValuePairsArgs = PlacementKeyValuePairsArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
