@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.VolumeGroupVolumePropertiesArgs.builder
import com.pulumi.azurenative.netapp.kotlin.enums.AvsDataStore
import com.pulumi.azurenative.netapp.kotlin.enums.EnableSubvolumes
import com.pulumi.azurenative.netapp.kotlin.enums.EncryptionKeySource
import com.pulumi.azurenative.netapp.kotlin.enums.NetworkFeatures
import com.pulumi.azurenative.netapp.kotlin.enums.SecurityStyle
import com.pulumi.azurenative.netapp.kotlin.enums.ServiceLevel
import com.pulumi.azurenative.netapp.kotlin.enums.SmbAccessBasedEnumeration
import com.pulumi.azurenative.netapp.kotlin.enums.SmbNonBrowsable
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Volume resource
 * @property avsDataStore Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
 * @property backupId UUID v4 or resource identifier used to identify the Backup.
 * @property capacityPoolResourceId Pool Resource Id used in case of creating a volume through volume group
 * @property coolAccess Specifies whether Cool Access(tiering) is enabled for the volume.
 * @property coolnessPeriod Specifies the number of days after which data that is not accessed by clients will be tiered.
 * @property creationToken A unique file path for the volume. Used when creating mount targets
 * @property dataProtection DataProtection type volumes include an object containing details of the replication
 * @property defaultGroupQuotaInKiBs Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
 * @property defaultUserQuotaInKiBs Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
 * @property deleteBaseSnapshot If enabled (true) the snapshot the volume was created from will be automatically deleted after the volume create operation has finished.  Defaults to false
 * @property enableSubvolumes Flag indicating whether subvolume operations are enabled on the volume
 * @property encryptionKeySource Source of key used to encrypt data in volume. Applicable if NetApp account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive) are: 'Microsoft.NetApp, Microsoft.KeyVault'
 * @property exportPolicy Set of export policy rules
 * @property isDefaultQuotaEnabled Specifies if default quota is enabled for the volume.
 * @property isLargeVolume Specifies whether volume is a Large Volume or Regular Volume.
 * @property isRestoring Restoring
 * @property kerberosEnabled Describe if a volume is KerberosEnabled. To be use with swagger version 2020-05-01 or later
 * @property keyVaultPrivateEndpointResourceId The resource ID of private endpoint for KeyVault. It must reside in the same VNET as the volume. Only applicable if encryptionKeySource = 'Microsoft.KeyVault'.
 * @property ldapEnabled Specifies whether LDAP is enabled or not for a given NFS volume.
 * @property name Resource name
 * @property networkFeatures Basic network, or Standard features available to the volume.
 * @property placementRules Application specific placement rules for the particular volume
 * @property protocolTypes Set of protocol types, default NFSv3, CIFS for SMB protocol
 * @property proximityPlacementGroup Proximity placement group associated with the volume
 * @property securityStyle The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
 * @property serviceLevel The service level of the file system
 * @property smbAccessBasedEnumeration Enables access based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
 * @property smbContinuouslyAvailable Enables continuously available share property for smb volume. Only applicable for SMB volume
 * @property smbEncryption Enables encryption for in-flight smb3 data. Only applicable for SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later
 * @property smbNonBrowsable Enables non browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
 * @property snapshotDirectoryVisible If enabled (true) the volume will contain a read-only snapshot directory which provides access to each of the volume's snapshots (defaults to true).
 * @property snapshotId UUID v4 or resource identifier used to identify the Snapshot.
 * @property subnetId The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
 * @property tags Resource tags
 * @property throughputMibps
 * @property unixPermissions UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second digit selects permission for the owner of the file: read (4), write (2) and execute (1). Third selects permissions for other users in the same group. the fourth for other users not in the group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other users.
 * @property usageThreshold Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB, 500Tib for LargeVolume. Specified in bytes.
 * @property volumeSpecName Volume spec name is the application specific designation or identifier for the particular volume in a volume group for e.g. data, log
 * @property volumeType What type of volume is this. For destination volumes in Cross Region Replication, set type to DataProtection
 */
public data class VolumeGroupVolumePropertiesArgs(
    public val avsDataStore: Output<Either<String, AvsDataStore>>? = null,
    public val backupId: Output<String>? = null,
    public val capacityPoolResourceId: Output<String>? = null,
    public val coolAccess: Output<Boolean>? = null,
    public val coolnessPeriod: Output<Int>? = null,
    public val creationToken: Output<String>,
    public val dataProtection: Output<VolumePropertiesDataProtectionArgs>? = null,
    public val defaultGroupQuotaInKiBs: Output<Double>? = null,
    public val defaultUserQuotaInKiBs: Output<Double>? = null,
    public val deleteBaseSnapshot: Output<Boolean>? = null,
    public val enableSubvolumes: Output<Either<String, EnableSubvolumes>>? = null,
    public val encryptionKeySource: Output<Either<String, EncryptionKeySource>>? = null,
    public val exportPolicy: Output<VolumePropertiesExportPolicyArgs>? = null,
    public val isDefaultQuotaEnabled: Output<Boolean>? = null,
    public val isLargeVolume: Output<Boolean>? = null,
    public val isRestoring: Output<Boolean>? = null,
    public val kerberosEnabled: Output<Boolean>? = null,
    public val keyVaultPrivateEndpointResourceId: Output<String>? = null,
    public val ldapEnabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val networkFeatures: Output<Either<String, NetworkFeatures>>? = null,
    public val placementRules: Output<List<PlacementKeyValuePairsArgs>>? = null,
    public val protocolTypes: Output<List<String>>? = null,
    public val proximityPlacementGroup: Output<String>? = null,
    public val securityStyle: Output<Either<String, SecurityStyle>>? = null,
    public val serviceLevel: Output<Either<String, ServiceLevel>>? = null,
    public val smbAccessBasedEnumeration: Output<Either<String, SmbAccessBasedEnumeration>>? = null,
    public val smbContinuouslyAvailable: Output<Boolean>? = null,
    public val smbEncryption: Output<Boolean>? = null,
    public val smbNonBrowsable: Output<Either<String, SmbNonBrowsable>>? = null,
    public val snapshotDirectoryVisible: Output<Boolean>? = null,
    public val snapshotId: Output<String>? = null,
    public val subnetId: Output<String>,
    public val tags: Output<Map<String, String>>? = null,
    public val throughputMibps: Output<Double>? = null,
    public val unixPermissions: Output<String>? = null,
    public val usageThreshold: Output<Double>,
    public val volumeSpecName: Output<String>? = null,
    public val volumeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.VolumeGroupVolumePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.VolumeGroupVolumePropertiesArgs =
        com.pulumi.azurenative.netapp.inputs.VolumeGroupVolumePropertiesArgs.builder()
            .avsDataStore(
                avsDataStore?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .backupId(backupId?.applyValue({ args0 -> args0 }))
            .capacityPoolResourceId(capacityPoolResourceId?.applyValue({ args0 -> args0 }))
            .coolAccess(coolAccess?.applyValue({ args0 -> args0 }))
            .coolnessPeriod(coolnessPeriod?.applyValue({ args0 -> args0 }))
            .creationToken(creationToken.applyValue({ args0 -> args0 }))
            .dataProtection(dataProtection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .defaultGroupQuotaInKiBs(defaultGroupQuotaInKiBs?.applyValue({ args0 -> args0 }))
            .defaultUserQuotaInKiBs(defaultUserQuotaInKiBs?.applyValue({ args0 -> args0 }))
            .deleteBaseSnapshot(deleteBaseSnapshot?.applyValue({ args0 -> args0 }))
            .enableSubvolumes(
                enableSubvolumes?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .encryptionKeySource(
                encryptionKeySource?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .exportPolicy(exportPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .isDefaultQuotaEnabled(isDefaultQuotaEnabled?.applyValue({ args0 -> args0 }))
            .isLargeVolume(isLargeVolume?.applyValue({ args0 -> args0 }))
            .isRestoring(isRestoring?.applyValue({ args0 -> args0 }))
            .kerberosEnabled(kerberosEnabled?.applyValue({ args0 -> args0 }))
            .keyVaultPrivateEndpointResourceId(
                keyVaultPrivateEndpointResourceId?.applyValue({ args0 ->
                    args0
                }),
            )
            .ldapEnabled(ldapEnabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkFeatures(
                networkFeatures?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .placementRules(
                placementRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .protocolTypes(protocolTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .proximityPlacementGroup(proximityPlacementGroup?.applyValue({ args0 -> args0 }))
            .securityStyle(
                securityStyle?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serviceLevel(
                serviceLevel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .smbAccessBasedEnumeration(
                smbAccessBasedEnumeration?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .smbContinuouslyAvailable(smbContinuouslyAvailable?.applyValue({ args0 -> args0 }))
            .smbEncryption(smbEncryption?.applyValue({ args0 -> args0 }))
            .smbNonBrowsable(
                smbNonBrowsable?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .snapshotDirectoryVisible(snapshotDirectoryVisible?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .throughputMibps(throughputMibps?.applyValue({ args0 -> args0 }))
            .unixPermissions(unixPermissions?.applyValue({ args0 -> args0 }))
            .usageThreshold(usageThreshold.applyValue({ args0 -> args0 }))
            .volumeSpecName(volumeSpecName?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeGroupVolumePropertiesArgs].
 */
@PulumiTagMarker
public class VolumeGroupVolumePropertiesArgsBuilder internal constructor() {
    private var avsDataStore: Output<Either<String, AvsDataStore>>? = null

    private var backupId: Output<String>? = null

    private var capacityPoolResourceId: Output<String>? = null

    private var coolAccess: Output<Boolean>? = null

    private var coolnessPeriod: Output<Int>? = null

    private var creationToken: Output<String>? = null

    private var dataProtection: Output<VolumePropertiesDataProtectionArgs>? = null

    private var defaultGroupQuotaInKiBs: Output<Double>? = null

    private var defaultUserQuotaInKiBs: Output<Double>? = null

    private var deleteBaseSnapshot: Output<Boolean>? = null

    private var enableSubvolumes: Output<Either<String, EnableSubvolumes>>? = null

    private var encryptionKeySource: Output<Either<String, EncryptionKeySource>>? = null

    private var exportPolicy: Output<VolumePropertiesExportPolicyArgs>? = null

    private var isDefaultQuotaEnabled: Output<Boolean>? = null

    private var isLargeVolume: Output<Boolean>? = null

    private var isRestoring: Output<Boolean>? = null

    private var kerberosEnabled: Output<Boolean>? = null

    private var keyVaultPrivateEndpointResourceId: Output<String>? = null

    private var ldapEnabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var networkFeatures: Output<Either<String, NetworkFeatures>>? = null

    private var placementRules: Output<List<PlacementKeyValuePairsArgs>>? = null

    private var protocolTypes: Output<List<String>>? = null

    private var proximityPlacementGroup: Output<String>? = null

    private var securityStyle: Output<Either<String, SecurityStyle>>? = null

    private var serviceLevel: Output<Either<String, ServiceLevel>>? = null

    private var smbAccessBasedEnumeration: Output<Either<String, SmbAccessBasedEnumeration>>? = null

    private var smbContinuouslyAvailable: Output<Boolean>? = null

    private var smbEncryption: Output<Boolean>? = null

    private var smbNonBrowsable: Output<Either<String, SmbNonBrowsable>>? = null

    private var snapshotDirectoryVisible: Output<Boolean>? = null

    private var snapshotId: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var throughputMibps: Output<Double>? = null

    private var unixPermissions: Output<String>? = null

    private var usageThreshold: Output<Double>? = null

    private var volumeSpecName: Output<String>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
     */
    @JvmName("orlxpthoyepwaono")
    public suspend fun avsDataStore(`value`: Output<Either<String, AvsDataStore>>) {
        this.avsDataStore = value
    }

    /**
     * @param value UUID v4 or resource identifier used to identify the Backup.
     */
    @JvmName("ogxoaekdimjwjdfc")
    public suspend fun backupId(`value`: Output<String>) {
        this.backupId = value
    }

    /**
     * @param value Pool Resource Id used in case of creating a volume through volume group
     */
    @JvmName("aiyxfsuykrpqmsmp")
    public suspend fun capacityPoolResourceId(`value`: Output<String>) {
        this.capacityPoolResourceId = value
    }

    /**
     * @param value Specifies whether Cool Access(tiering) is enabled for the volume.
     */
    @JvmName("rbqseedwfqhnuewv")
    public suspend fun coolAccess(`value`: Output<Boolean>) {
        this.coolAccess = value
    }

    /**
     * @param value Specifies the number of days after which data that is not accessed by clients will be tiered.
     */
    @JvmName("wchwsysqqsprmuaq")
    public suspend fun coolnessPeriod(`value`: Output<Int>) {
        this.coolnessPeriod = value
    }

    /**
     * @param value A unique file path for the volume. Used when creating mount targets
     */
    @JvmName("uiajiacqywnslgio")
    public suspend fun creationToken(`value`: Output<String>) {
        this.creationToken = value
    }

    /**
     * @param value DataProtection type volumes include an object containing details of the replication
     */
    @JvmName("vbhudjeqhnsjkmoe")
    public suspend fun dataProtection(`value`: Output<VolumePropertiesDataProtectionArgs>) {
        this.dataProtection = value
    }

    /**
     * @param value Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
     */
    @JvmName("upvykclrwgklubwm")
    public suspend fun defaultGroupQuotaInKiBs(`value`: Output<Double>) {
        this.defaultGroupQuotaInKiBs = value
    }

    /**
     * @param value Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
     */
    @JvmName("hdmdhlihesivsrqd")
    public suspend fun defaultUserQuotaInKiBs(`value`: Output<Double>) {
        this.defaultUserQuotaInKiBs = value
    }

    /**
     * @param value If enabled (true) the snapshot the volume was created from will be automatically deleted after the volume create operation has finished.  Defaults to false
     */
    @JvmName("ryqfwfftvxpjpxih")
    public suspend fun deleteBaseSnapshot(`value`: Output<Boolean>) {
        this.deleteBaseSnapshot = value
    }

    /**
     * @param value Flag indicating whether subvolume operations are enabled on the volume
     */
    @JvmName("norhsspsmfnnklki")
    public suspend fun enableSubvolumes(`value`: Output<Either<String, EnableSubvolumes>>) {
        this.enableSubvolumes = value
    }

    /**
     * @param value Source of key used to encrypt data in volume. Applicable if NetApp account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive) are: 'Microsoft.NetApp, Microsoft.KeyVault'
     */
    @JvmName("cwdtiiwddwdjqwvb")
    public suspend fun encryptionKeySource(`value`: Output<Either<String, EncryptionKeySource>>) {
        this.encryptionKeySource = value
    }

    /**
     * @param value Set of export policy rules
     */
    @JvmName("reegxwkahsjxyyra")
    public suspend fun exportPolicy(`value`: Output<VolumePropertiesExportPolicyArgs>) {
        this.exportPolicy = value
    }

    /**
     * @param value Specifies if default quota is enabled for the volume.
     */
    @JvmName("fwmihvllwnlkghdj")
    public suspend fun isDefaultQuotaEnabled(`value`: Output<Boolean>) {
        this.isDefaultQuotaEnabled = value
    }

    /**
     * @param value Specifies whether volume is a Large Volume or Regular Volume.
     */
    @JvmName("jqmkmwigwsdurhty")
    public suspend fun isLargeVolume(`value`: Output<Boolean>) {
        this.isLargeVolume = value
    }

    /**
     * @param value Restoring
     */
    @JvmName("xmhowhsarcbkuyjp")
    public suspend fun isRestoring(`value`: Output<Boolean>) {
        this.isRestoring = value
    }

    /**
     * @param value Describe if a volume is KerberosEnabled. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("vhdldgvlmwoqnthq")
    public suspend fun kerberosEnabled(`value`: Output<Boolean>) {
        this.kerberosEnabled = value
    }

    /**
     * @param value The resource ID of private endpoint for KeyVault. It must reside in the same VNET as the volume. Only applicable if encryptionKeySource = 'Microsoft.KeyVault'.
     */
    @JvmName("nbvuptpwqtbrjybc")
    public suspend fun keyVaultPrivateEndpointResourceId(`value`: Output<String>) {
        this.keyVaultPrivateEndpointResourceId = value
    }

    /**
     * @param value Specifies whether LDAP is enabled or not for a given NFS volume.
     */
    @JvmName("wxcrmlmqbgplodis")
    public suspend fun ldapEnabled(`value`: Output<Boolean>) {
        this.ldapEnabled = value
    }

    /**
     * @param value Resource name
     */
    @JvmName("bcgiyishucmpfhsv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Basic network, or Standard features available to the volume.
     */
    @JvmName("jyllmwehyxwjtqob")
    public suspend fun networkFeatures(`value`: Output<Either<String, NetworkFeatures>>) {
        this.networkFeatures = value
    }

    /**
     * @param value Application specific placement rules for the particular volume
     */
    @JvmName("rklivkwyrwxqqocq")
    public suspend fun placementRules(`value`: Output<List<PlacementKeyValuePairsArgs>>) {
        this.placementRules = value
    }

    @JvmName("asochfygcnjeeoit")
    public suspend fun placementRules(vararg values: Output<PlacementKeyValuePairsArgs>) {
        this.placementRules = Output.all(values.asList())
    }

    /**
     * @param values Application specific placement rules for the particular volume
     */
    @JvmName("osvrlujeybqqkbfn")
    public suspend fun placementRules(values: List<Output<PlacementKeyValuePairsArgs>>) {
        this.placementRules = Output.all(values)
    }

    /**
     * @param value Set of protocol types, default NFSv3, CIFS for SMB protocol
     */
    @JvmName("lflfitvxsrsdaqcm")
    public suspend fun protocolTypes(`value`: Output<List<String>>) {
        this.protocolTypes = value
    }

    @JvmName("xavxvuskbaukmdbg")
    public suspend fun protocolTypes(vararg values: Output<String>) {
        this.protocolTypes = Output.all(values.asList())
    }

    /**
     * @param values Set of protocol types, default NFSv3, CIFS for SMB protocol
     */
    @JvmName("xrbxmofijqhjyfdl")
    public suspend fun protocolTypes(values: List<Output<String>>) {
        this.protocolTypes = Output.all(values)
    }

    /**
     * @param value Proximity placement group associated with the volume
     */
    @JvmName("yeiqdmtenilmosud")
    public suspend fun proximityPlacementGroup(`value`: Output<String>) {
        this.proximityPlacementGroup = value
    }

    /**
     * @param value The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
     */
    @JvmName("furhhrkpsidcform")
    public suspend fun securityStyle(`value`: Output<Either<String, SecurityStyle>>) {
        this.securityStyle = value
    }

    /**
     * @param value The service level of the file system
     */
    @JvmName("jnbwljsxavmcnfqq")
    public suspend fun serviceLevel(`value`: Output<Either<String, ServiceLevel>>) {
        this.serviceLevel = value
    }

    /**
     * @param value Enables access based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("tbhghpodoxoiooiw")
    public suspend
    fun smbAccessBasedEnumeration(`value`: Output<Either<String, SmbAccessBasedEnumeration>>) {
        this.smbAccessBasedEnumeration = value
    }

    /**
     * @param value Enables continuously available share property for smb volume. Only applicable for SMB volume
     */
    @JvmName("rmfdumdodjcxlccp")
    public suspend fun smbContinuouslyAvailable(`value`: Output<Boolean>) {
        this.smbContinuouslyAvailable = value
    }

    /**
     * @param value Enables encryption for in-flight smb3 data. Only applicable for SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later
     */
    @JvmName("fevpswpdkkqyfgtr")
    public suspend fun smbEncryption(`value`: Output<Boolean>) {
        this.smbEncryption = value
    }

    /**
     * @param value Enables non browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("pcpirvdxjgmteiwl")
    public suspend fun smbNonBrowsable(`value`: Output<Either<String, SmbNonBrowsable>>) {
        this.smbNonBrowsable = value
    }

    /**
     * @param value If enabled (true) the volume will contain a read-only snapshot directory which provides access to each of the volume's snapshots (defaults to true).
     */
    @JvmName("fcqutvbkputwbqrt")
    public suspend fun snapshotDirectoryVisible(`value`: Output<Boolean>) {
        this.snapshotDirectoryVisible = value
    }

    /**
     * @param value UUID v4 or resource identifier used to identify the Snapshot.
     */
    @JvmName("haschewvjpnrqkec")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
     */
    @JvmName("ueyjpuoffqomrvox")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("kayjphkkvtrmtevy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("cvyqteswmytpaofx")
    public suspend fun throughputMibps(`value`: Output<Double>) {
        this.throughputMibps = value
    }

    /**
     * @param value UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second digit selects permission for the owner of the file: read (4), write (2) and execute (1). Third selects permissions for other users in the same group. the fourth for other users not in the group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other users.
     */
    @JvmName("npvojywqscgqpkfr")
    public suspend fun unixPermissions(`value`: Output<String>) {
        this.unixPermissions = value
    }

    /**
     * @param value Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB, 500Tib for LargeVolume. Specified in bytes.
     */
    @JvmName("wilhxpthxcdpsvra")
    public suspend fun usageThreshold(`value`: Output<Double>) {
        this.usageThreshold = value
    }

    /**
     * @param value Volume spec name is the application specific designation or identifier for the particular volume in a volume group for e.g. data, log
     */
    @JvmName("ebyakfjnbnrtfhtv")
    public suspend fun volumeSpecName(`value`: Output<String>) {
        this.volumeSpecName = value
    }

    /**
     * @param value What type of volume is this. For destination volumes in Cross Region Replication, set type to DataProtection
     */
    @JvmName("tjntvovmwdlnhiin")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
     */
    @JvmName("gbbcoestuhbxiwxo")
    public suspend fun avsDataStore(`value`: Either<String, AvsDataStore>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.avsDataStore = mapped
    }

    /**
     * @param value Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
     */
    @JvmName("qrxlougkcmskjvbj")
    public fun avsDataStore(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AvsDataStore>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.avsDataStore = mapped
    }

    /**
     * @param value Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
     */
    @JvmName("nqxkedrlwyccucuq")
    public fun avsDataStore(`value`: AvsDataStore) {
        val toBeMapped = Either.ofRight<String, AvsDataStore>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.avsDataStore = mapped
    }

    /**
     * @param value UUID v4 or resource identifier used to identify the Backup.
     */
    @JvmName("jywninulpabgrohh")
    public suspend fun backupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupId = mapped
    }

    /**
     * @param value Pool Resource Id used in case of creating a volume through volume group
     */
    @JvmName("laimtqedqvjirgxv")
    public suspend fun capacityPoolResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityPoolResourceId = mapped
    }

    /**
     * @param value Specifies whether Cool Access(tiering) is enabled for the volume.
     */
    @JvmName("wufyjbhydckrcgoa")
    public suspend fun coolAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coolAccess = mapped
    }

    /**
     * @param value Specifies the number of days after which data that is not accessed by clients will be tiered.
     */
    @JvmName("fegompjyboxcmisu")
    public suspend fun coolnessPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coolnessPeriod = mapped
    }

    /**
     * @param value A unique file path for the volume. Used when creating mount targets
     */
    @JvmName("eyyeosihiovpxujc")
    public suspend fun creationToken(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.creationToken = mapped
    }

    /**
     * @param value DataProtection type volumes include an object containing details of the replication
     */
    @JvmName("nbfoygrprbijihsv")
    public suspend fun dataProtection(`value`: VolumePropertiesDataProtectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataProtection = mapped
    }

    /**
     * @param argument DataProtection type volumes include an object containing details of the replication
     */
    @JvmName("tvdvpvyjwflckqvr")
    public suspend
    fun dataProtection(argument: suspend VolumePropertiesDataProtectionArgsBuilder.() -> Unit) {
        val toBeMapped = VolumePropertiesDataProtectionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataProtection = mapped
    }

    /**
     * @param value Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
     */
    @JvmName("fvxfsirvcxghydux")
    public suspend fun defaultGroupQuotaInKiBs(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultGroupQuotaInKiBs = mapped
    }

    /**
     * @param value Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
     */
    @JvmName("jrwvwpjncgavgekn")
    public suspend fun defaultUserQuotaInKiBs(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultUserQuotaInKiBs = mapped
    }

    /**
     * @param value If enabled (true) the snapshot the volume was created from will be automatically deleted after the volume create operation has finished.  Defaults to false
     */
    @JvmName("ktioywrkbhfcckih")
    public suspend fun deleteBaseSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteBaseSnapshot = mapped
    }

    /**
     * @param value Flag indicating whether subvolume operations are enabled on the volume
     */
    @JvmName("webcvcvqejcedkeo")
    public suspend fun enableSubvolumes(`value`: Either<String, EnableSubvolumes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSubvolumes = mapped
    }

    /**
     * @param value Flag indicating whether subvolume operations are enabled on the volume
     */
    @JvmName("pdxbnvobaetqpbcn")
    public fun enableSubvolumes(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnableSubvolumes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableSubvolumes = mapped
    }

    /**
     * @param value Flag indicating whether subvolume operations are enabled on the volume
     */
    @JvmName("ltgndqenpjjykuxl")
    public fun enableSubvolumes(`value`: EnableSubvolumes) {
        val toBeMapped = Either.ofRight<String, EnableSubvolumes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enableSubvolumes = mapped
    }

    /**
     * @param value Source of key used to encrypt data in volume. Applicable if NetApp account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive) are: 'Microsoft.NetApp, Microsoft.KeyVault'
     */
    @JvmName("rqpqbxpxlsrxnawb")
    public suspend fun encryptionKeySource(`value`: Either<String, EncryptionKeySource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKeySource = mapped
    }

    /**
     * @param value Source of key used to encrypt data in volume. Applicable if NetApp account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive) are: 'Microsoft.NetApp, Microsoft.KeyVault'
     */
    @JvmName("jlxgfbtrpkilnfsy")
    public fun encryptionKeySource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionKeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionKeySource = mapped
    }

    /**
     * @param value Source of key used to encrypt data in volume. Applicable if NetApp account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive) are: 'Microsoft.NetApp, Microsoft.KeyVault'
     */
    @JvmName("ijxpxltgxtohbxln")
    public fun encryptionKeySource(`value`: EncryptionKeySource) {
        val toBeMapped = Either.ofRight<String, EncryptionKeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionKeySource = mapped
    }

    /**
     * @param value Set of export policy rules
     */
    @JvmName("amnirhpewailsjvo")
    public suspend fun exportPolicy(`value`: VolumePropertiesExportPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportPolicy = mapped
    }

    /**
     * @param argument Set of export policy rules
     */
    @JvmName("nfvjmrepmdqnkoep")
    public suspend
    fun exportPolicy(argument: suspend VolumePropertiesExportPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = VolumePropertiesExportPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.exportPolicy = mapped
    }

    /**
     * @param value Specifies if default quota is enabled for the volume.
     */
    @JvmName("agvsvfxxvecrmcpi")
    public suspend fun isDefaultQuotaEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDefaultQuotaEnabled = mapped
    }

    /**
     * @param value Specifies whether volume is a Large Volume or Regular Volume.
     */
    @JvmName("ihwsqgpsiivjocor")
    public suspend fun isLargeVolume(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isLargeVolume = mapped
    }

    /**
     * @param value Restoring
     */
    @JvmName("asjlhcobvwfysbmq")
    public suspend fun isRestoring(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRestoring = mapped
    }

    /**
     * @param value Describe if a volume is KerberosEnabled. To be use with swagger version 2020-05-01 or later
     */
    @JvmName("nkkaqtsjmdiddoin")
    public suspend fun kerberosEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kerberosEnabled = mapped
    }

    /**
     * @param value The resource ID of private endpoint for KeyVault. It must reside in the same VNET as the volume. Only applicable if encryptionKeySource = 'Microsoft.KeyVault'.
     */
    @JvmName("magfyfdcfvaegsdf")
    public suspend fun keyVaultPrivateEndpointResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultPrivateEndpointResourceId = mapped
    }

    /**
     * @param value Specifies whether LDAP is enabled or not for a given NFS volume.
     */
    @JvmName("cqffwbkdndgwqhkf")
    public suspend fun ldapEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ldapEnabled = mapped
    }

    /**
     * @param value Resource name
     */
    @JvmName("csqabtikxpnipmra")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Basic network, or Standard features available to the volume.
     */
    @JvmName("ynrpvetryuwintvp")
    public suspend fun networkFeatures(`value`: Either<String, NetworkFeatures>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFeatures = mapped
    }

    /**
     * @param value Basic network, or Standard features available to the volume.
     */
    @JvmName("dfiganxekkvjmeni")
    public fun networkFeatures(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NetworkFeatures>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFeatures = mapped
    }

    /**
     * @param value Basic network, or Standard features available to the volume.
     */
    @JvmName("hvhimnbsvnlinhep")
    public fun networkFeatures(`value`: NetworkFeatures) {
        val toBeMapped = Either.ofRight<String, NetworkFeatures>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkFeatures = mapped
    }

    /**
     * @param value Application specific placement rules for the particular volume
     */
    @JvmName("xsodwejtrhcphdwe")
    public suspend fun placementRules(`value`: List<PlacementKeyValuePairsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementRules = mapped
    }

    /**
     * @param argument Application specific placement rules for the particular volume
     */
    @JvmName("jlomkbplyighhonj")
    public suspend
    fun placementRules(argument: List<suspend PlacementKeyValuePairsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PlacementKeyValuePairsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementRules = mapped
    }

    /**
     * @param argument Application specific placement rules for the particular volume
     */
    @JvmName("ubrgyknpdqxfgiww")
    public suspend fun placementRules(
        vararg
        argument: suspend PlacementKeyValuePairsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PlacementKeyValuePairsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.placementRules = mapped
    }

    /**
     * @param argument Application specific placement rules for the particular volume
     */
    @JvmName("gahgquwikarxjevk")
    public suspend
    fun placementRules(argument: suspend PlacementKeyValuePairsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PlacementKeyValuePairsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.placementRules = mapped
    }

    /**
     * @param values Application specific placement rules for the particular volume
     */
    @JvmName("ucwmspqskekkrfjo")
    public suspend fun placementRules(vararg values: PlacementKeyValuePairsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.placementRules = mapped
    }

    /**
     * @param value Set of protocol types, default NFSv3, CIFS for SMB protocol
     */
    @JvmName("passulihoyielmlm")
    public suspend fun protocolTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolTypes = mapped
    }

    /**
     * @param values Set of protocol types, default NFSv3, CIFS for SMB protocol
     */
    @JvmName("sxagurtxfvnlagxb")
    public suspend fun protocolTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolTypes = mapped
    }

    /**
     * @param value Proximity placement group associated with the volume
     */
    @JvmName("pedmkbknagqsmfli")
    public suspend fun proximityPlacementGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proximityPlacementGroup = mapped
    }

    /**
     * @param value The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
     */
    @JvmName("dpdriegjfipcwots")
    public suspend fun securityStyle(`value`: Either<String, SecurityStyle>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityStyle = mapped
    }

    /**
     * @param value The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
     */
    @JvmName("roxvlrxfcopacshr")
    public fun securityStyle(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityStyle>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityStyle = mapped
    }

    /**
     * @param value The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
     */
    @JvmName("ldgdhranqbpbbhef")
    public fun securityStyle(`value`: SecurityStyle) {
        val toBeMapped = Either.ofRight<String, SecurityStyle>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityStyle = mapped
    }

    /**
     * @param value The service level of the file system
     */
    @JvmName("ocbwgywyoipskwko")
    public suspend fun serviceLevel(`value`: Either<String, ServiceLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceLevel = mapped
    }

    /**
     * @param value The service level of the file system
     */
    @JvmName("yowtrmbcfplfsxoa")
    public fun serviceLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceLevel = mapped
    }

    /**
     * @param value The service level of the file system
     */
    @JvmName("sogjogjgygbrycpl")
    public fun serviceLevel(`value`: ServiceLevel) {
        val toBeMapped = Either.ofRight<String, ServiceLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceLevel = mapped
    }

    /**
     * @param value Enables access based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("kpojjqvskqhuvqcp")
    public suspend
    fun smbAccessBasedEnumeration(`value`: Either<String, SmbAccessBasedEnumeration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbAccessBasedEnumeration = mapped
    }

    /**
     * @param value Enables access based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("mephqomvkdahhvun")
    public fun smbAccessBasedEnumeration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SmbAccessBasedEnumeration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.smbAccessBasedEnumeration = mapped
    }

    /**
     * @param value Enables access based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("umjcscokqiejraad")
    public fun smbAccessBasedEnumeration(`value`: SmbAccessBasedEnumeration) {
        val toBeMapped = Either.ofRight<String, SmbAccessBasedEnumeration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.smbAccessBasedEnumeration = mapped
    }

    /**
     * @param value Enables continuously available share property for smb volume. Only applicable for SMB volume
     */
    @JvmName("askeibamjgwcnmpl")
    public suspend fun smbContinuouslyAvailable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbContinuouslyAvailable = mapped
    }

    /**
     * @param value Enables encryption for in-flight smb3 data. Only applicable for SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later
     */
    @JvmName("hatogntsmymfeaxg")
    public suspend fun smbEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbEncryption = mapped
    }

    /**
     * @param value Enables non browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("bqfegowbakukyuys")
    public suspend fun smbNonBrowsable(`value`: Either<String, SmbNonBrowsable>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbNonBrowsable = mapped
    }

    /**
     * @param value Enables non browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("kdoyrdpnyqhmpchs")
    public fun smbNonBrowsable(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SmbNonBrowsable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.smbNonBrowsable = mapped
    }

    /**
     * @param value Enables non browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
     */
    @JvmName("jtymjneobvhdaxov")
    public fun smbNonBrowsable(`value`: SmbNonBrowsable) {
        val toBeMapped = Either.ofRight<String, SmbNonBrowsable>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.smbNonBrowsable = mapped
    }

    /**
     * @param value If enabled (true) the volume will contain a read-only snapshot directory which provides access to each of the volume's snapshots (defaults to true).
     */
    @JvmName("hatnrjoauqhotduv")
    public suspend fun snapshotDirectoryVisible(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotDirectoryVisible = mapped
    }

    /**
     * @param value UUID v4 or resource identifier used to identify the Snapshot.
     */
    @JvmName("rghgnfxusdulwkww")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
     */
    @JvmName("vnqinccwntrjhiae")
    public suspend fun subnetId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("fxhqnsgwfucqumxu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("drflflnmkxhewdnt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("omwbncfhdtgjfoxk")
    public suspend fun throughputMibps(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughputMibps = mapped
    }

    /**
     * @param value UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second digit selects permission for the owner of the file: read (4), write (2) and execute (1). Third selects permissions for other users in the same group. the fourth for other users not in the group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other users.
     */
    @JvmName("jsjxcdmapfvvgdjx")
    public suspend fun unixPermissions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unixPermissions = mapped
    }

    /**
     * @param value Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB, 500Tib for LargeVolume. Specified in bytes.
     */
    @JvmName("tlkcwshkvagrkiiv")
    public suspend fun usageThreshold(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usageThreshold = mapped
    }

    /**
     * @param value Volume spec name is the application specific designation or identifier for the particular volume in a volume group for e.g. data, log
     */
    @JvmName("isbpsgeclbefliqr")
    public suspend fun volumeSpecName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSpecName = mapped
    }

    /**
     * @param value What type of volume is this. For destination volumes in Cross Region Replication, set type to DataProtection
     */
    @JvmName("qsccnydwlydfhnht")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): VolumeGroupVolumePropertiesArgs = VolumeGroupVolumePropertiesArgs(
        avsDataStore = avsDataStore,
        backupId = backupId,
        capacityPoolResourceId = capacityPoolResourceId,
        coolAccess = coolAccess,
        coolnessPeriod = coolnessPeriod,
        creationToken = creationToken ?: throw PulumiNullFieldException("creationToken"),
        dataProtection = dataProtection,
        defaultGroupQuotaInKiBs = defaultGroupQuotaInKiBs,
        defaultUserQuotaInKiBs = defaultUserQuotaInKiBs,
        deleteBaseSnapshot = deleteBaseSnapshot,
        enableSubvolumes = enableSubvolumes,
        encryptionKeySource = encryptionKeySource,
        exportPolicy = exportPolicy,
        isDefaultQuotaEnabled = isDefaultQuotaEnabled,
        isLargeVolume = isLargeVolume,
        isRestoring = isRestoring,
        kerberosEnabled = kerberosEnabled,
        keyVaultPrivateEndpointResourceId = keyVaultPrivateEndpointResourceId,
        ldapEnabled = ldapEnabled,
        name = name,
        networkFeatures = networkFeatures,
        placementRules = placementRules,
        protocolTypes = protocolTypes,
        proximityPlacementGroup = proximityPlacementGroup,
        securityStyle = securityStyle,
        serviceLevel = serviceLevel,
        smbAccessBasedEnumeration = smbAccessBasedEnumeration,
        smbContinuouslyAvailable = smbContinuouslyAvailable,
        smbEncryption = smbEncryption,
        smbNonBrowsable = smbNonBrowsable,
        snapshotDirectoryVisible = snapshotDirectoryVisible,
        snapshotId = snapshotId,
        subnetId = subnetId ?: throw PulumiNullFieldException("subnetId"),
        tags = tags,
        throughputMibps = throughputMibps,
        unixPermissions = unixPermissions,
        usageThreshold = usageThreshold ?: throw PulumiNullFieldException("usageThreshold"),
        volumeSpecName = volumeSpecName,
        volumeType = volumeType,
    )
}
