@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.inputs

import com.pulumi.azurenative.netapp.inputs.VolumePropertiesExportPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Set of export policy rules
 * @property rules Export policy rule
 */
public data class VolumePropertiesExportPolicyArgs(
    public val rules: Output<List<ExportPolicyRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.netapp.inputs.VolumePropertiesExportPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.netapp.inputs.VolumePropertiesExportPolicyArgs =
        com.pulumi.azurenative.netapp.inputs.VolumePropertiesExportPolicyArgs.builder()
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VolumePropertiesExportPolicyArgs].
 */
@PulumiTagMarker
public class VolumePropertiesExportPolicyArgsBuilder internal constructor() {
    private var rules: Output<List<ExportPolicyRuleArgs>>? = null

    /**
     * @param value Export policy rule
     */
    @JvmName("ihtdlidbcpuiysys")
    public suspend fun rules(`value`: Output<List<ExportPolicyRuleArgs>>) {
        this.rules = value
    }

    @JvmName("mdpmdcdvatsvkahe")
    public suspend fun rules(vararg values: Output<ExportPolicyRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Export policy rule
     */
    @JvmName("lmxdqbooluobwrke")
    public suspend fun rules(values: List<Output<ExportPolicyRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Export policy rule
     */
    @JvmName("otsdpgxminkshjfr")
    public suspend fun rules(`value`: List<ExportPolicyRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Export policy rule
     */
    @JvmName("dvutjgsbouhirelj")
    public suspend fun rules(argument: List<suspend ExportPolicyRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExportPolicyRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Export policy rule
     */
    @JvmName("jfxxisrsrvuvthei")
    public suspend fun rules(vararg argument: suspend ExportPolicyRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExportPolicyRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Export policy rule
     */
    @JvmName("yxnllnnkgfuaddsi")
    public suspend fun rules(argument: suspend ExportPolicyRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ExportPolicyRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Export policy rule
     */
    @JvmName("fdiymsbsvpdrrhhv")
    public suspend fun rules(vararg values: ExportPolicyRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): VolumePropertiesExportPolicyArgs = VolumePropertiesExportPolicyArgs(
        rules = rules,
    )
}
