@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Capacity pool resource
 * @property coolAccess If enabled (true) the pool can contain cool Access enabled volumes.
 * @property encryptionType Encryption type of the capacity pool, set encryption type for data at rest for this pool and all volumes in it. This value can only be set when creating new pool.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property poolId UUID v4 used to identify the Pool
 * @property provisioningState Azure lifecycle management
 * @property qosType The qos type of the pool
 * @property serviceLevel The service level of the file system
 * @property size Provisioned size of the pool (in bytes). Allowed values are in 1TiB chunks (value must be multiply of 4398046511104).
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property totalThroughputMibps Total throughput of pool in MiB/s
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property utilizedThroughputMibps Utilized throughput of pool in MiB/s
 */
public data class GetPoolResult(
    public val coolAccess: Boolean? = null,
    public val encryptionType: String? = null,
    public val etag: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val poolId: String,
    public val provisioningState: String,
    public val qosType: String? = null,
    public val serviceLevel: String,
    public val size: Double,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val totalThroughputMibps: Double,
    public val type: String,
    public val utilizedThroughputMibps: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.GetPoolResult):
            GetPoolResult = GetPoolResult(
            coolAccess = javaType.coolAccess().map({ args0 -> args0 }).orElse(null),
            encryptionType = javaType.encryptionType().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            poolId = javaType.poolId(),
            provisioningState = javaType.provisioningState(),
            qosType = javaType.qosType().map({ args0 -> args0 }).orElse(null),
            serviceLevel = javaType.serviceLevel(),
            size = javaType.size(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalThroughputMibps = javaType.totalThroughputMibps(),
            type = javaType.type(),
            utilizedThroughputMibps = javaType.utilizedThroughputMibps(),
        )
    }
}
