@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Snapshot policy information
 * @property dailySchedule Schedule for daily snapshots
 * @property enabled The property to decide policy is enabled or not
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property hourlySchedule Schedule for hourly snapshots
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property monthlySchedule Schedule for monthly snapshots
 * @property name The name of the resource
 * @property provisioningState Azure lifecycle management
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property weeklySchedule Schedule for weekly snapshots
 */
public data class GetSnapshotPolicyResult(
    public val dailySchedule: DailyScheduleResponse? = null,
    public val enabled: Boolean? = null,
    public val etag: String,
    public val hourlySchedule: HourlyScheduleResponse? = null,
    public val id: String,
    public val location: String,
    public val monthlySchedule: MonthlyScheduleResponse? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val weeklySchedule: WeeklyScheduleResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.GetSnapshotPolicyResult):
            GetSnapshotPolicyResult = GetSnapshotPolicyResult(
            dailySchedule = javaType.dailySchedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.DailyScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            hourlySchedule = javaType.hourlySchedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.HourlyScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            monthlySchedule = javaType.monthlySchedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.MonthlyScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.netapp.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            weeklySchedule = javaType.weeklySchedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.WeeklyScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
