@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * LDAP search scope
 * @property groupDN This specifies the group DN, which overrides the base DN for group lookups.
 * @property groupMembershipFilter This specifies the custom LDAP search filter to be used when looking up group membership from LDAP server.
 * @property userDN This specifies the user DN, which overrides the base DN for user lookups.
 */
public data class LdapSearchScopeOptResponse(
    public val groupDN: String? = null,
    public val groupMembershipFilter: String? = null,
    public val userDN: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.LdapSearchScopeOptResponse):
            LdapSearchScopeOptResponse = LdapSearchScopeOptResponse(
            groupDN = javaType.groupDN().map({ args0 -> args0 }).orElse(null),
            groupMembershipFilter = javaType.groupMembershipFilter().map({ args0 -> args0 }).orElse(null),
            userDN = javaType.userDN().map({ args0 -> args0 }).orElse(null),
        )
    }
}
