@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.netapp.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Volume resource
 * @property actualThroughputMibps Actual throughput in MiB/s for auto qosType volumes calculated based on size and serviceLevel
 * @property avsDataStore Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
 * @property backupId UUID v4 or resource identifier used to identify the Backup.
 * @property baremetalTenantId Unique Baremetal Tenant Identifier.
 * @property capacityPoolResourceId Pool Resource Id used in case of creating a volume through volume group
 * @property cloneProgress When a volume is being restored from another volume's snapshot, will show the percentage completion of this cloning process. When this value is empty/null there is no cloning process currently happening on this volume. This value will update every 5 minutes during cloning.
 * @property coolAccess Specifies whether Cool Access(tiering) is enabled for the volume.
 * @property coolnessPeriod Specifies the number of days after which data that is not accessed by clients will be tiered.
 * @property creationToken A unique file path for the volume. Used when creating mount targets
 * @property dataProtection DataProtection type volumes include an object containing details of the replication
 * @property dataStoreResourceId Data store resource unique identifier
 * @property defaultGroupQuotaInKiBs Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
 * @property defaultUserQuotaInKiBs Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
 * @property deleteBaseSnapshot If enabled (true) the snapshot the volume was created from will be automatically deleted after the volume create operation has finished.  Defaults to false
 * @property enableSubvolumes Flag indicating whether subvolume operations are enabled on the volume
 * @property encrypted Specifies if the volume is encrypted or not. Only available on volumes created or updated after 2022-01-01.
 * @property encryptionKeySource Source of key used to encrypt data in volume. Applicable if NetApp account has encryption.keySource = 'Microsoft.KeyVault'. Possible values (case-insensitive) are: 'Microsoft.NetApp, Microsoft.KeyVault'
 * @property exportPolicy Set of export policy rules
 * @property fileAccessLogs Flag indicating whether file access logs are enabled for the volume, based on active diagnostic settings present on the volume.
 * @property fileSystemId Unique FileSystem Identifier.
 * @property id Resource Id
 * @property isDefaultQuotaEnabled Specifies if default quota is enabled for the volume.
 * @property isLargeVolume Specifies whether volume is a Large Volume or Regular Volume.
 * @property isRestoring Restoring
 * @property kerberosEnabled Describe if a volume is KerberosEnabled. To be use with swagger version 2020-05-01 or later
 * @property keyVaultPrivateEndpointResourceId The resource ID of private endpoint for KeyVault. It must reside in the same VNET as the volume. Only applicable if encryptionKeySource = 'Microsoft.KeyVault'.
 * @property ldapEnabled Specifies whether LDAP is enabled or not for a given NFS volume.
 * @property maximumNumberOfFiles Maximum number of files allowed. Needs a service request in order to be changed. Only allowed to be changed if volume quota is more than 4TiB.
 * @property mountTargets List of mount targets
 * @property name Resource name
 * @property networkFeatures Basic network, or Standard features available to the volume.
 * @property networkSiblingSetId Network Sibling Set ID for the the group of volumes sharing networking resources.
 * @property originatingResourceId Id of the snapshot or backup that the volume is restored from.
 * @property placementRules Application specific placement rules for the particular volume
 * @property protocolTypes Set of protocol types, default NFSv3, CIFS for SMB protocol
 * @property provisionedAvailabilityZone The availability zone where the volume is provisioned. This refers to the logical availability zone where the volume resides.
 * @property provisioningState Azure lifecycle management
 * @property proximityPlacementGroup Proximity placement group associated with the volume
 * @property securityStyle The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
 * @property serviceLevel The service level of the file system
 * @property smbAccessBasedEnumeration Enables access based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
 * @property smbContinuouslyAvailable Enables continuously available share property for smb volume. Only applicable for SMB volume
 * @property smbEncryption Enables encryption for in-flight smb3 data. Only applicable for SMB/DualProtocol volume. To be used with swagger version 2020-08-01 or later
 * @property smbNonBrowsable Enables non browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
 * @property snapshotDirectoryVisible If enabled (true) the volume will contain a read-only snapshot directory which provides access to each of the volume's snapshots (defaults to true).
 * @property snapshotId UUID v4 or resource identifier used to identify the Snapshot.
 * @property storageToNetworkProximity Provides storage to network proximity information for the volume.
 * @property subnetId The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
 * @property t2Network T2 network information
 * @property tags Resource tags
 * @property throughputMibps
 * @property type Resource type
 * @property unixPermissions UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set user ID(4), set group ID (2) and sticky (1) attributes. Second digit selects permission for the owner of the file: read (4), write (2) and execute (1). Third selects permissions for other users in the same group. the fourth for other users not in the group. 0755 - gives read/write/execute permissions to owner and read/execute to group and other users.
 * @property usageThreshold Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. Minimum size is 100 GiB. Upper limit is 100TiB, 500Tib for LargeVolume. Specified in bytes.
 * @property volumeGroupName Volume Group Name
 * @property volumeSpecName Volume spec name is the application specific designation or identifier for the particular volume in a volume group for e.g. data, log
 * @property volumeType What type of volume is this. For destination volumes in Cross Region Replication, set type to DataProtection
 */
public data class VolumeGroupVolumePropertiesResponse(
    public val actualThroughputMibps: Double,
    public val avsDataStore: String? = null,
    public val backupId: String? = null,
    public val baremetalTenantId: String,
    public val capacityPoolResourceId: String? = null,
    public val cloneProgress: Int,
    public val coolAccess: Boolean? = null,
    public val coolnessPeriod: Int? = null,
    public val creationToken: String,
    public val dataProtection: VolumePropertiesResponseDataProtection? = null,
    public val dataStoreResourceId: List<String>,
    public val defaultGroupQuotaInKiBs: Double? = null,
    public val defaultUserQuotaInKiBs: Double? = null,
    public val deleteBaseSnapshot: Boolean? = null,
    public val enableSubvolumes: String? = null,
    public val encrypted: Boolean,
    public val encryptionKeySource: String? = null,
    public val exportPolicy: VolumePropertiesResponseExportPolicy? = null,
    public val fileAccessLogs: String,
    public val fileSystemId: String,
    public val id: String,
    public val isDefaultQuotaEnabled: Boolean? = null,
    public val isLargeVolume: Boolean? = null,
    public val isRestoring: Boolean? = null,
    public val kerberosEnabled: Boolean? = null,
    public val keyVaultPrivateEndpointResourceId: String? = null,
    public val ldapEnabled: Boolean? = null,
    public val maximumNumberOfFiles: Double,
    public val mountTargets: List<MountTargetPropertiesResponse>,
    public val name: String? = null,
    public val networkFeatures: String? = null,
    public val networkSiblingSetId: String,
    public val originatingResourceId: String,
    public val placementRules: List<PlacementKeyValuePairsResponse>? = null,
    public val protocolTypes: List<String>? = null,
    public val provisionedAvailabilityZone: String,
    public val provisioningState: String,
    public val proximityPlacementGroup: String? = null,
    public val securityStyle: String? = null,
    public val serviceLevel: String? = null,
    public val smbAccessBasedEnumeration: String? = null,
    public val smbContinuouslyAvailable: Boolean? = null,
    public val smbEncryption: Boolean? = null,
    public val smbNonBrowsable: String? = null,
    public val snapshotDirectoryVisible: Boolean? = null,
    public val snapshotId: String? = null,
    public val storageToNetworkProximity: String,
    public val subnetId: String,
    public val t2Network: String,
    public val tags: Map<String, String>? = null,
    public val throughputMibps: Double? = null,
    public val type: String,
    public val unixPermissions: String? = null,
    public val usageThreshold: Double,
    public val volumeGroupName: String,
    public val volumeSpecName: String? = null,
    public val volumeType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.netapp.outputs.VolumeGroupVolumePropertiesResponse):
            VolumeGroupVolumePropertiesResponse = VolumeGroupVolumePropertiesResponse(
            actualThroughputMibps = javaType.actualThroughputMibps(),
            avsDataStore = javaType.avsDataStore().map({ args0 -> args0 }).orElse(null),
            backupId = javaType.backupId().map({ args0 -> args0 }).orElse(null),
            baremetalTenantId = javaType.baremetalTenantId(),
            capacityPoolResourceId = javaType.capacityPoolResourceId().map({ args0 -> args0 }).orElse(null),
            cloneProgress = javaType.cloneProgress(),
            coolAccess = javaType.coolAccess().map({ args0 -> args0 }).orElse(null),
            coolnessPeriod = javaType.coolnessPeriod().map({ args0 -> args0 }).orElse(null),
            creationToken = javaType.creationToken(),
            dataProtection = javaType.dataProtection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.VolumePropertiesResponseDataProtection.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataStoreResourceId = javaType.dataStoreResourceId().map({ args0 -> args0 }),
            defaultGroupQuotaInKiBs = javaType.defaultGroupQuotaInKiBs().map({ args0 -> args0 }).orElse(null),
            defaultUserQuotaInKiBs = javaType.defaultUserQuotaInKiBs().map({ args0 -> args0 }).orElse(null),
            deleteBaseSnapshot = javaType.deleteBaseSnapshot().map({ args0 -> args0 }).orElse(null),
            enableSubvolumes = javaType.enableSubvolumes().map({ args0 -> args0 }).orElse(null),
            encrypted = javaType.encrypted(),
            encryptionKeySource = javaType.encryptionKeySource().map({ args0 -> args0 }).orElse(null),
            exportPolicy = javaType.exportPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.VolumePropertiesResponseExportPolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fileAccessLogs = javaType.fileAccessLogs(),
            fileSystemId = javaType.fileSystemId(),
            id = javaType.id(),
            isDefaultQuotaEnabled = javaType.isDefaultQuotaEnabled().map({ args0 -> args0 }).orElse(null),
            isLargeVolume = javaType.isLargeVolume().map({ args0 -> args0 }).orElse(null),
            isRestoring = javaType.isRestoring().map({ args0 -> args0 }).orElse(null),
            kerberosEnabled = javaType.kerberosEnabled().map({ args0 -> args0 }).orElse(null),
            keyVaultPrivateEndpointResourceId = javaType.keyVaultPrivateEndpointResourceId().map({ args0 ->
                args0
            }).orElse(null),
            ldapEnabled = javaType.ldapEnabled().map({ args0 -> args0 }).orElse(null),
            maximumNumberOfFiles = javaType.maximumNumberOfFiles(),
            mountTargets = javaType.mountTargets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.MountTargetPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            networkFeatures = javaType.networkFeatures().map({ args0 -> args0 }).orElse(null),
            networkSiblingSetId = javaType.networkSiblingSetId(),
            originatingResourceId = javaType.originatingResourceId(),
            placementRules = javaType.placementRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.netapp.kotlin.outputs.PlacementKeyValuePairsResponse.Companion.toKotlin(args0)
                })
            }),
            protocolTypes = javaType.protocolTypes().map({ args0 -> args0 }),
            provisionedAvailabilityZone = javaType.provisionedAvailabilityZone(),
            provisioningState = javaType.provisioningState(),
            proximityPlacementGroup = javaType.proximityPlacementGroup().map({ args0 -> args0 }).orElse(null),
            securityStyle = javaType.securityStyle().map({ args0 -> args0 }).orElse(null),
            serviceLevel = javaType.serviceLevel().map({ args0 -> args0 }).orElse(null),
            smbAccessBasedEnumeration = javaType.smbAccessBasedEnumeration().map({ args0 ->
                args0
            }).orElse(null),
            smbContinuouslyAvailable = javaType.smbContinuouslyAvailable().map({ args0 -> args0 }).orElse(null),
            smbEncryption = javaType.smbEncryption().map({ args0 -> args0 }).orElse(null),
            smbNonBrowsable = javaType.smbNonBrowsable().map({ args0 -> args0 }).orElse(null),
            snapshotDirectoryVisible = javaType.snapshotDirectoryVisible().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
            storageToNetworkProximity = javaType.storageToNetworkProximity(),
            subnetId = javaType.subnetId(),
            t2Network = javaType.t2Network(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            throughputMibps = javaType.throughputMibps().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            unixPermissions = javaType.unixPermissions().map({ args0 -> args0 }).orElse(null),
            usageThreshold = javaType.usageThreshold(),
            volumeGroupName = javaType.volumeGroupName(),
            volumeSpecName = javaType.volumeSpecName().map({ args0 -> args0 }).orElse(null),
            volumeType = javaType.volumeType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
