@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallApplicationRuleCollectionResponse
import com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallIPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallIpGroupsResponse
import com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallNatRuleCollectionResponse
import com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallNetworkRuleCollectionResponse
import com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallSkuResponse
import com.pulumi.azurenative.network.kotlin.outputs.HubIPAddressesResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallApplicationRuleCollectionResponse.Companion.toKotlin as azureFirewallApplicationRuleCollectionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallIPConfigurationResponse.Companion.toKotlin as azureFirewallIPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallIpGroupsResponse.Companion.toKotlin as azureFirewallIpGroupsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallNatRuleCollectionResponse.Companion.toKotlin as azureFirewallNatRuleCollectionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallNetworkRuleCollectionResponse.Companion.toKotlin as azureFirewallNetworkRuleCollectionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallSkuResponse.Companion.toKotlin as azureFirewallSkuResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.HubIPAddressesResponse.Companion.toKotlin as hubIPAddressesResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [AzureFirewall].
 */
@PulumiTagMarker
public class AzureFirewallResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AzureFirewallArgs = AzureFirewallArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AzureFirewallArgsBuilder.() -> Unit) {
        val builder = AzureFirewallArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AzureFirewall {
        val builtJavaResource = com.pulumi.azurenative.network.AzureFirewall(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AzureFirewall(builtJavaResource)
    }
}

/**
 * Azure Firewall resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2020-04-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create Azure Firewall
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureFirewall = new AzureNative.Network.AzureFirewall("azureFirewall", new()
 *     {
 *         ApplicationRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "apprulecoll",
 *                 Priority = 110,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallApplicationRuleArgs
 *                     {
 *                         Description = "Deny inbound rule",
 *                         Name = "rule1",
 *                         Protocols = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleProtocolArgs
 *                             {
 *                                 Port = 443,
 *                                 ProtocolType = "Https",
 *                             },
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "216.58.216.164",
 *                             "10.0.0.0/24",
 *                         },
 *                         TargetFqdns = new[]
 *                         {
 *                             "www.test.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         AzureFirewallName = "azurefirewall",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallIPConfigurationArgs
 *             {
 *                 Name = "azureFirewallIpConfiguration",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet",
 *                 },
 *             },
 *         },
 *         Location = "West US",
 *         NatRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNatRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallNatRCActionArgs
 *                 {
 *                     Type = "Dnat",
 *                 },
 *                 Name = "natrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all outbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443",
 *                         },
 *                         Name = "DNAT-HTTPS-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedAddress = "1.2.3.5",
 *                         TranslatedPort = "8443",
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all inbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "80",
 *                         },
 *                         Name = "DNAT-HTTP-traffic-With-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedFqdn = "internalhttpserver",
 *                         TranslatedPort = "880",
 *                     },
 *                 },
 *             },
 *         },
 *         NetworkRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNetworkRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "netrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255",
 *                         },
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports to amazon",
 *                         DestinationFqdns = new[]
 *                         {
 *                             "www.amazon.com",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic-with-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.2.4.12-10.2.4.255",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.AzureFirewallSkuArgs
 *         {
 *             Name = "AZFW_VNet",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ThreatIntelMode = "Alert",
 *         Zones = new[] {},
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAzureFirewall(ctx, "azureFirewall", &network.AzureFirewallArgs{
 * 			ApplicationRuleCollections: []network.AzureFirewallApplicationRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("apprulecoll"),
 * 					Priority: pulumi.Int(110),
 * 					Rules: network.AzureFirewallApplicationRuleArray{
 * 						{
 * 							Description: pulumi.String("Deny inbound rule"),
 * 							Name:        pulumi.String("rule1"),
 * 							Protocols: network.AzureFirewallApplicationRuleProtocolArray{
 * 								{
 * 									Port:         pulumi.Int(443),
 * 									ProtocolType: pulumi.String("Https"),
 * 								},
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("216.58.216.164"),
 * 								pulumi.String("10.0.0.0/24"),
 * 							},
 * 							TargetFqdns: pulumi.StringArray{
 * 								pulumi.String("www.test.com"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			AzureFirewallName: pulumi.String("azurefirewall"),
 * 			IpConfigurations: []network.AzureFirewallIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("azureFirewallIpConfiguration"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			NatRuleCollections: []network.AzureFirewallNatRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Dnat"),
 * 					},
 * 					Name:     pulumi.String("natrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNatRuleArray{
 * 						{
 * 							Description: pulumi.String("D-NAT all outbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTPS-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedAddress: pulumi.String("1.2.3.5"),
 * 							TranslatedPort:    pulumi.String("8443"),
 * 						},
 * 						{
 * 							Description: pulumi.String("D-NAT all inbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("80"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTP-traffic-With-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedFqdn: pulumi.String("internalhttpserver"),
 * 							TranslatedPort: pulumi.String("880"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			NetworkRuleCollections: []network.AzureFirewallNetworkRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("netrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNetworkRuleArray{
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("192.168.1.1-192.168.1.12"),
 * 								pulumi.String("10.1.4.12-10.1.4.255"),
 * 							},
 * 						},
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports to amazon"),
 * 							DestinationFqdns: pulumi.StringArray{
 * 								pulumi.String("www.amazon.com"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic-with-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("10.2.4.12-10.2.4.255"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.AzureFirewallSkuArgs{
 * 				Name: pulumi.String("AZFW_VNet"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			ThreatIntelMode: pulumi.String("Alert"),
 * 			Zones:           pulumi.StringArray{},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AzureFirewall;
 * import com.pulumi.azurenative.network.AzureFirewallArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureFirewall = new AzureFirewall("azureFirewall", AzureFirewallArgs.builder()
 *             .applicationRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "apprulecoll"),
 *                 Map.entry("priority", 110),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("description", "Deny inbound rule"),
 *                     Map.entry("name", "rule1"),
 *                     Map.entry("protocols", Map.ofEntries(
 *                         Map.entry("port", 443),
 *                         Map.entry("protocolType", "Https")
 *                     )),
 *                     Map.entry("sourceAddresses",
 *                         "216.58.216.164",
 *                         "10.0.0.0/24"),
 *                     Map.entry("targetFqdns", "www.test.com")
 *                 ))
 *             ))
 *             .azureFirewallName("azurefirewall")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "azureFirewallIpConfiguration"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"))
 *             ))
 *             .location("West US")
 *             .natRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Dnat")),
 *                 Map.entry("name", "natrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all outbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "443"),
 *                         Map.entry("name", "DNAT-HTTPS-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedAddress", "1.2.3.5"),
 *                         Map.entry("translatedPort", "8443")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all inbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "80"),
 *                         Map.entry("name", "DNAT-HTTP-traffic-With-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedFqdn", "internalhttpserver"),
 *                         Map.entry("translatedPort", "880")
 *                     ))
 *             ))
 *             .networkRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "netrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports"),
 *                         Map.entry("destinationAddresses", "*"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses",
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports to amazon"),
 *                         Map.entry("destinationFqdns", "www.amazon.com"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic-with-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "10.2.4.12-10.2.4.255")
 *                     ))
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "AZFW_VNet"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .threatIntelMode("Alert")
 *             .zones()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Azure Firewall With Additional Properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureFirewall = new AzureNative.Network.AzureFirewall("azureFirewall", new()
 *     {
 *         AdditionalProperties =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *         ApplicationRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "apprulecoll",
 *                 Priority = 110,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallApplicationRuleArgs
 *                     {
 *                         Description = "Deny inbound rule",
 *                         Name = "rule1",
 *                         Protocols = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleProtocolArgs
 *                             {
 *                                 Port = 443,
 *                                 ProtocolType = "Https",
 *                             },
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "216.58.216.164",
 *                             "10.0.0.0/24",
 *                         },
 *                         TargetFqdns = new[]
 *                         {
 *                             "www.test.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         AzureFirewallName = "azurefirewall",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallIPConfigurationArgs
 *             {
 *                 Name = "azureFirewallIpConfiguration",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet",
 *                 },
 *             },
 *         },
 *         Location = "West US",
 *         NatRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNatRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallNatRCActionArgs
 *                 {
 *                     Type = "Dnat",
 *                 },
 *                 Name = "natrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all outbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443",
 *                         },
 *                         Name = "DNAT-HTTPS-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedAddress = "1.2.3.5",
 *                         TranslatedPort = "8443",
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all inbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "80",
 *                         },
 *                         Name = "DNAT-HTTP-traffic-With-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedFqdn = "internalhttpserver",
 *                         TranslatedPort = "880",
 *                     },
 *                 },
 *             },
 *         },
 *         NetworkRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNetworkRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "netrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255",
 *                         },
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports to amazon",
 *                         DestinationFqdns = new[]
 *                         {
 *                             "www.amazon.com",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic-with-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.2.4.12-10.2.4.255",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.AzureFirewallSkuArgs
 *         {
 *             Name = "AZFW_VNet",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ThreatIntelMode = "Alert",
 *         Zones = new[] {},
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAzureFirewall(ctx, "azureFirewall", &network.AzureFirewallArgs{
 * 			AdditionalProperties: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 			ApplicationRuleCollections: []network.AzureFirewallApplicationRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("apprulecoll"),
 * 					Priority: pulumi.Int(110),
 * 					Rules: network.AzureFirewallApplicationRuleArray{
 * 						{
 * 							Description: pulumi.String("Deny inbound rule"),
 * 							Name:        pulumi.String("rule1"),
 * 							Protocols: network.AzureFirewallApplicationRuleProtocolArray{
 * 								{
 * 									Port:         pulumi.Int(443),
 * 									ProtocolType: pulumi.String("Https"),
 * 								},
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("216.58.216.164"),
 * 								pulumi.String("10.0.0.0/24"),
 * 							},
 * 							TargetFqdns: pulumi.StringArray{
 * 								pulumi.String("www.test.com"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			AzureFirewallName: pulumi.String("azurefirewall"),
 * 			IpConfigurations: []network.AzureFirewallIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("azureFirewallIpConfiguration"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			NatRuleCollections: []network.AzureFirewallNatRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Dnat"),
 * 					},
 * 					Name:     pulumi.String("natrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNatRuleArray{
 * 						{
 * 							Description: pulumi.String("D-NAT all outbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTPS-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedAddress: pulumi.String("1.2.3.5"),
 * 							TranslatedPort:    pulumi.String("8443"),
 * 						},
 * 						{
 * 							Description: pulumi.String("D-NAT all inbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("80"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTP-traffic-With-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedFqdn: pulumi.String("internalhttpserver"),
 * 							TranslatedPort: pulumi.String("880"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			NetworkRuleCollections: []network.AzureFirewallNetworkRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("netrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNetworkRuleArray{
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("192.168.1.1-192.168.1.12"),
 * 								pulumi.String("10.1.4.12-10.1.4.255"),
 * 							},
 * 						},
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports to amazon"),
 * 							DestinationFqdns: pulumi.StringArray{
 * 								pulumi.String("www.amazon.com"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic-with-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("10.2.4.12-10.2.4.255"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.AzureFirewallSkuArgs{
 * 				Name: pulumi.String("AZFW_VNet"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			ThreatIntelMode: pulumi.String("Alert"),
 * 			Zones:           pulumi.StringArray{},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AzureFirewall;
 * import com.pulumi.azurenative.network.AzureFirewallArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureFirewall = new AzureFirewall("azureFirewall", AzureFirewallArgs.builder()
 *             .additionalProperties(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .applicationRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "apprulecoll"),
 *                 Map.entry("priority", 110),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("description", "Deny inbound rule"),
 *                     Map.entry("name", "rule1"),
 *                     Map.entry("protocols", Map.ofEntries(
 *                         Map.entry("port", 443),
 *                         Map.entry("protocolType", "Https")
 *                     )),
 *                     Map.entry("sourceAddresses",
 *                         "216.58.216.164",
 *                         "10.0.0.0/24"),
 *                     Map.entry("targetFqdns", "www.test.com")
 *                 ))
 *             ))
 *             .azureFirewallName("azurefirewall")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "azureFirewallIpConfiguration"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"))
 *             ))
 *             .location("West US")
 *             .natRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Dnat")),
 *                 Map.entry("name", "natrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all outbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "443"),
 *                         Map.entry("name", "DNAT-HTTPS-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedAddress", "1.2.3.5"),
 *                         Map.entry("translatedPort", "8443")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all inbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "80"),
 *                         Map.entry("name", "DNAT-HTTP-traffic-With-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedFqdn", "internalhttpserver"),
 *                         Map.entry("translatedPort", "880")
 *                     ))
 *             ))
 *             .networkRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "netrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports"),
 *                         Map.entry("destinationAddresses", "*"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses",
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports to amazon"),
 *                         Map.entry("destinationFqdns", "www.amazon.com"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic-with-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "10.2.4.12-10.2.4.255")
 *                     ))
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "AZFW_VNet"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .threatIntelMode("Alert")
 *             .zones()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Azure Firewall With IpGroups
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureFirewall = new AzureNative.Network.AzureFirewall("azureFirewall", new()
 *     {
 *         ApplicationRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "apprulecoll",
 *                 Priority = 110,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallApplicationRuleArgs
 *                     {
 *                         Description = "Deny inbound rule",
 *                         Name = "rule1",
 *                         Protocols = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleProtocolArgs
 *                             {
 *                                 Port = 443,
 *                                 ProtocolType = "Https",
 *                             },
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "216.58.216.164",
 *                             "10.0.0.0/24",
 *                         },
 *                         TargetFqdns = new[]
 *                         {
 *                             "www.test.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         AzureFirewallName = "azurefirewall",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallIPConfigurationArgs
 *             {
 *                 Name = "azureFirewallIpConfiguration",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet",
 *                 },
 *             },
 *         },
 *         Location = "West US",
 *         NatRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNatRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallNatRCActionArgs
 *                 {
 *                     Type = "Dnat",
 *                 },
 *                 Name = "natrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all outbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443",
 *                         },
 *                         Name = "DNAT-HTTPS-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedAddress = "1.2.3.5",
 *                         TranslatedPort = "8443",
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all inbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "80",
 *                         },
 *                         Name = "DNAT-HTTP-traffic-With-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedFqdn = "internalhttpserver",
 *                         TranslatedPort = "880",
 *                     },
 *                 },
 *             },
 *         },
 *         NetworkRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNetworkRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "netrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255",
 *                         },
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports to amazon",
 *                         DestinationFqdns = new[]
 *                         {
 *                             "www.amazon.com",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic-with-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.2.4.12-10.2.4.255",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.AzureFirewallSkuArgs
 *         {
 *             Name = "AZFW_VNet",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ThreatIntelMode = "Alert",
 *         Zones = new[] {},
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAzureFirewall(ctx, "azureFirewall", &network.AzureFirewallArgs{
 * 			ApplicationRuleCollections: []network.AzureFirewallApplicationRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("apprulecoll"),
 * 					Priority: pulumi.Int(110),
 * 					Rules: network.AzureFirewallApplicationRuleArray{
 * 						{
 * 							Description: pulumi.String("Deny inbound rule"),
 * 							Name:        pulumi.String("rule1"),
 * 							Protocols: network.AzureFirewallApplicationRuleProtocolArray{
 * 								{
 * 									Port:         pulumi.Int(443),
 * 									ProtocolType: pulumi.String("Https"),
 * 								},
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("216.58.216.164"),
 * 								pulumi.String("10.0.0.0/24"),
 * 							},
 * 							TargetFqdns: pulumi.StringArray{
 * 								pulumi.String("www.test.com"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			AzureFirewallName: pulumi.String("azurefirewall"),
 * 			IpConfigurations: []network.AzureFirewallIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("azureFirewallIpConfiguration"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			NatRuleCollections: []network.AzureFirewallNatRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Dnat"),
 * 					},
 * 					Name:     pulumi.String("natrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNatRuleArray{
 * 						{
 * 							Description: pulumi.String("D-NAT all outbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTPS-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedAddress: pulumi.String("1.2.3.5"),
 * 							TranslatedPort:    pulumi.String("8443"),
 * 						},
 * 						{
 * 							Description: pulumi.String("D-NAT all inbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("80"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTP-traffic-With-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedFqdn: pulumi.String("internalhttpserver"),
 * 							TranslatedPort: pulumi.String("880"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			NetworkRuleCollections: []network.AzureFirewallNetworkRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("netrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNetworkRuleArray{
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("192.168.1.1-192.168.1.12"),
 * 								pulumi.String("10.1.4.12-10.1.4.255"),
 * 							},
 * 						},
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports to amazon"),
 * 							DestinationFqdns: pulumi.StringArray{
 * 								pulumi.String("www.amazon.com"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic-with-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("10.2.4.12-10.2.4.255"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.AzureFirewallSkuArgs{
 * 				Name: pulumi.String("AZFW_VNet"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			ThreatIntelMode: pulumi.String("Alert"),
 * 			Zones:           pulumi.StringArray{},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AzureFirewall;
 * import com.pulumi.azurenative.network.AzureFirewallArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureFirewall = new AzureFirewall("azureFirewall", AzureFirewallArgs.builder()
 *             .applicationRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "apprulecoll"),
 *                 Map.entry("priority", 110),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("description", "Deny inbound rule"),
 *                     Map.entry("name", "rule1"),
 *                     Map.entry("protocols", Map.ofEntries(
 *                         Map.entry("port", 443),
 *                         Map.entry("protocolType", "Https")
 *                     )),
 *                     Map.entry("sourceAddresses",
 *                         "216.58.216.164",
 *                         "10.0.0.0/24"),
 *                     Map.entry("targetFqdns", "www.test.com")
 *                 ))
 *             ))
 *             .azureFirewallName("azurefirewall")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "azureFirewallIpConfiguration"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"))
 *             ))
 *             .location("West US")
 *             .natRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Dnat")),
 *                 Map.entry("name", "natrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all outbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "443"),
 *                         Map.entry("name", "DNAT-HTTPS-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedAddress", "1.2.3.5"),
 *                         Map.entry("translatedPort", "8443")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all inbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "80"),
 *                         Map.entry("name", "DNAT-HTTP-traffic-With-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedFqdn", "internalhttpserver"),
 *                         Map.entry("translatedPort", "880")
 *                     ))
 *             ))
 *             .networkRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "netrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports"),
 *                         Map.entry("destinationAddresses", "*"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses",
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports to amazon"),
 *                         Map.entry("destinationFqdns", "www.amazon.com"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic-with-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "10.2.4.12-10.2.4.255")
 *                     ))
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "AZFW_VNet"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .threatIntelMode("Alert")
 *             .zones()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Azure Firewall With Zones
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureFirewall = new AzureNative.Network.AzureFirewall("azureFirewall", new()
 *     {
 *         ApplicationRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "apprulecoll",
 *                 Priority = 110,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallApplicationRuleArgs
 *                     {
 *                         Description = "Deny inbound rule",
 *                         Name = "rule1",
 *                         Protocols = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleProtocolArgs
 *                             {
 *                                 Port = 443,
 *                                 ProtocolType = "Https",
 *                             },
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "216.58.216.164",
 *                             "10.0.0.0/24",
 *                         },
 *                         TargetFqdns = new[]
 *                         {
 *                             "www.test.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         AzureFirewallName = "azurefirewall",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallIPConfigurationArgs
 *             {
 *                 Name = "azureFirewallIpConfiguration",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet",
 *                 },
 *             },
 *         },
 *         Location = "West US 2",
 *         NatRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNatRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallNatRCActionArgs
 *                 {
 *                     Type = "Dnat",
 *                 },
 *                 Name = "natrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all outbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443",
 *                         },
 *                         Name = "DNAT-HTTPS-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedAddress = "1.2.3.5",
 *                         TranslatedPort = "8443",
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all inbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "80",
 *                         },
 *                         Name = "DNAT-HTTP-traffic-With-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedFqdn = "internalhttpserver",
 *                         TranslatedPort = "880",
 *                     },
 *                 },
 *             },
 *         },
 *         NetworkRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNetworkRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "netrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255",
 *                         },
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports to amazon",
 *                         DestinationFqdns = new[]
 *                         {
 *                             "www.amazon.com",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic-with-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.2.4.12-10.2.4.255",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.AzureFirewallSkuArgs
 *         {
 *             Name = "AZFW_VNet",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ThreatIntelMode = "Alert",
 *         Zones = new[]
 *         {
 *             "1",
 *             "2",
 *             "3",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAzureFirewall(ctx, "azureFirewall", &network.AzureFirewallArgs{
 * 			ApplicationRuleCollections: []network.AzureFirewallApplicationRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("apprulecoll"),
 * 					Priority: pulumi.Int(110),
 * 					Rules: network.AzureFirewallApplicationRuleArray{
 * 						{
 * 							Description: pulumi.String("Deny inbound rule"),
 * 							Name:        pulumi.String("rule1"),
 * 							Protocols: network.AzureFirewallApplicationRuleProtocolArray{
 * 								{
 * 									Port:         pulumi.Int(443),
 * 									ProtocolType: pulumi.String("Https"),
 * 								},
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("216.58.216.164"),
 * 								pulumi.String("10.0.0.0/24"),
 * 							},
 * 							TargetFqdns: pulumi.StringArray{
 * 								pulumi.String("www.test.com"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			AzureFirewallName: pulumi.String("azurefirewall"),
 * 			IpConfigurations: []network.AzureFirewallIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("azureFirewallIpConfiguration"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("West US 2"),
 * 			NatRuleCollections: []network.AzureFirewallNatRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Dnat"),
 * 					},
 * 					Name:     pulumi.String("natrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNatRuleArray{
 * 						{
 * 							Description: pulumi.String("D-NAT all outbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTPS-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedAddress: pulumi.String("1.2.3.5"),
 * 							TranslatedPort:    pulumi.String("8443"),
 * 						},
 * 						{
 * 							Description: pulumi.String("D-NAT all inbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("80"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTP-traffic-With-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedFqdn: pulumi.String("internalhttpserver"),
 * 							TranslatedPort: pulumi.String("880"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			NetworkRuleCollections: []network.AzureFirewallNetworkRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("netrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNetworkRuleArray{
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("192.168.1.1-192.168.1.12"),
 * 								pulumi.String("10.1.4.12-10.1.4.255"),
 * 							},
 * 						},
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports to amazon"),
 * 							DestinationFqdns: pulumi.StringArray{
 * 								pulumi.String("www.amazon.com"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic-with-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("10.2.4.12-10.2.4.255"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.AzureFirewallSkuArgs{
 * 				Name: pulumi.String("AZFW_VNet"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			ThreatIntelMode: pulumi.String("Alert"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 				pulumi.String("3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AzureFirewall;
 * import com.pulumi.azurenative.network.AzureFirewallArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureFirewall = new AzureFirewall("azureFirewall", AzureFirewallArgs.builder()
 *             .applicationRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "apprulecoll"),
 *                 Map.entry("priority", 110),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("description", "Deny inbound rule"),
 *                     Map.entry("name", "rule1"),
 *                     Map.entry("protocols", Map.ofEntries(
 *                         Map.entry("port", 443),
 *                         Map.entry("protocolType", "Https")
 *                     )),
 *                     Map.entry("sourceAddresses",
 *                         "216.58.216.164",
 *                         "10.0.0.0/24"),
 *                     Map.entry("targetFqdns", "www.test.com")
 *                 ))
 *             ))
 *             .azureFirewallName("azurefirewall")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "azureFirewallIpConfiguration"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"))
 *             ))
 *             .location("West US 2")
 *             .natRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Dnat")),
 *                 Map.entry("name", "natrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all outbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "443"),
 *                         Map.entry("name", "DNAT-HTTPS-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedAddress", "1.2.3.5"),
 *                         Map.entry("translatedPort", "8443")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all inbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "80"),
 *                         Map.entry("name", "DNAT-HTTP-traffic-With-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedFqdn", "internalhttpserver"),
 *                         Map.entry("translatedPort", "880")
 *                     ))
 *             ))
 *             .networkRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "netrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports"),
 *                         Map.entry("destinationAddresses", "*"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses",
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports to amazon"),
 *                         Map.entry("destinationFqdns", "www.amazon.com"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic-with-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "10.2.4.12-10.2.4.255")
 *                     ))
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "AZFW_VNet"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .threatIntelMode("Alert")
 *             .zones(
 *                 "1",
 *                 "2",
 *                 "3")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Azure Firewall With management subnet
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureFirewall = new AzureNative.Network.AzureFirewall("azureFirewall", new()
 *     {
 *         ApplicationRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "apprulecoll",
 *                 Priority = 110,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallApplicationRuleArgs
 *                     {
 *                         Description = "Deny inbound rule",
 *                         Name = "rule1",
 *                         Protocols = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleProtocolArgs
 *                             {
 *                                 Port = 443,
 *                                 ProtocolType = "Https",
 *                             },
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "216.58.216.164",
 *                             "10.0.0.0/24",
 *                         },
 *                         TargetFqdns = new[]
 *                         {
 *                             "www.test.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         AzureFirewallName = "azurefirewall",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallIPConfigurationArgs
 *             {
 *                 Name = "azureFirewallIpConfiguration",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet",
 *                 },
 *             },
 *         },
 *         Location = "West US",
 *         ManagementIpConfiguration = new AzureNative.Network.Inputs.AzureFirewallIPConfigurationArgs
 *         {
 *             Name = "azureFirewallMgmtIpConfiguration",
 *             PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/managementPipName",
 *             },
 *             Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallManagementSubnet",
 *             },
 *         },
 *         NatRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNatRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallNatRCActionArgs
 *                 {
 *                     Type = "Dnat",
 *                 },
 *                 Name = "natrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all outbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443",
 *                         },
 *                         Name = "DNAT-HTTPS-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedAddress = "1.2.3.5",
 *                         TranslatedPort = "8443",
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all inbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "80",
 *                         },
 *                         Name = "DNAT-HTTP-traffic-With-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedFqdn = "internalhttpserver",
 *                         TranslatedPort = "880",
 *                     },
 *                 },
 *             },
 *         },
 *         NetworkRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNetworkRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "netrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255",
 *                         },
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports to amazon",
 *                         DestinationFqdns = new[]
 *                         {
 *                             "www.amazon.com",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic-with-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.2.4.12-10.2.4.255",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.AzureFirewallSkuArgs
 *         {
 *             Name = "AZFW_VNet",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ThreatIntelMode = "Alert",
 *         Zones = new[] {},
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAzureFirewall(ctx, "azureFirewall", &network.AzureFirewallArgs{
 * 			ApplicationRuleCollections: []network.AzureFirewallApplicationRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("apprulecoll"),
 * 					Priority: pulumi.Int(110),
 * 					Rules: network.AzureFirewallApplicationRuleArray{
 * 						{
 * 							Description: pulumi.String("Deny inbound rule"),
 * 							Name:        pulumi.String("rule1"),
 * 							Protocols: network.AzureFirewallApplicationRuleProtocolArray{
 * 								{
 * 									Port:         pulumi.Int(443),
 * 									ProtocolType: pulumi.String("Https"),
 * 								},
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("216.58.216.164"),
 * 								pulumi.String("10.0.0.0/24"),
 * 							},
 * 							TargetFqdns: pulumi.StringArray{
 * 								pulumi.String("www.test.com"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			AzureFirewallName: pulumi.String("azurefirewall"),
 * 			IpConfigurations: []network.AzureFirewallIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("azureFirewallIpConfiguration"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			ManagementIpConfiguration: network.AzureFirewallIPConfigurationResponse{
 * 				Name: pulumi.String("azureFirewallMgmtIpConfiguration"),
 * 				PublicIPAddress: &network.SubResourceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/managementPipName"),
 * 				},
 * 				Subnet: &network.SubResourceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallManagementSubnet"),
 * 				},
 * 			},
 * 			NatRuleCollections: []network.AzureFirewallNatRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Dnat"),
 * 					},
 * 					Name:     pulumi.String("natrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNatRuleArray{
 * 						{
 * 							Description: pulumi.String("D-NAT all outbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTPS-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedAddress: pulumi.String("1.2.3.5"),
 * 							TranslatedPort:    pulumi.String("8443"),
 * 						},
 * 						{
 * 							Description: pulumi.String("D-NAT all inbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("80"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTP-traffic-With-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedFqdn: pulumi.String("internalhttpserver"),
 * 							TranslatedPort: pulumi.String("880"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			NetworkRuleCollections: []network.AzureFirewallNetworkRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("netrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNetworkRuleArray{
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("192.168.1.1-192.168.1.12"),
 * 								pulumi.String("10.1.4.12-10.1.4.255"),
 * 							},
 * 						},
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports to amazon"),
 * 							DestinationFqdns: pulumi.StringArray{
 * 								pulumi.String("www.amazon.com"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic-with-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("10.2.4.12-10.2.4.255"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.AzureFirewallSkuArgs{
 * 				Name: pulumi.String("AZFW_VNet"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			ThreatIntelMode: pulumi.String("Alert"),
 * 			Zones:           pulumi.StringArray{},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AzureFirewall;
 * import com.pulumi.azurenative.network.AzureFirewallArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureFirewall = new AzureFirewall("azureFirewall", AzureFirewallArgs.builder()
 *             .applicationRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "apprulecoll"),
 *                 Map.entry("priority", 110),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("description", "Deny inbound rule"),
 *                     Map.entry("name", "rule1"),
 *                     Map.entry("protocols", Map.ofEntries(
 *                         Map.entry("port", 443),
 *                         Map.entry("protocolType", "Https")
 *                     )),
 *                     Map.entry("sourceAddresses",
 *                         "216.58.216.164",
 *                         "10.0.0.0/24"),
 *                     Map.entry("targetFqdns", "www.test.com")
 *                 ))
 *             ))
 *             .azureFirewallName("azurefirewall")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "azureFirewallIpConfiguration"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"))
 *             ))
 *             .location("West US")
 *             .managementIpConfiguration(Map.ofEntries(
 *                 Map.entry("name", "azureFirewallMgmtIpConfiguration"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/managementPipName")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallManagementSubnet"))
 *             ))
 *             .natRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Dnat")),
 *                 Map.entry("name", "natrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all outbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "443"),
 *                         Map.entry("name", "DNAT-HTTPS-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedAddress", "1.2.3.5"),
 *                         Map.entry("translatedPort", "8443")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all inbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "80"),
 *                         Map.entry("name", "DNAT-HTTP-traffic-With-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedFqdn", "internalhttpserver"),
 *                         Map.entry("translatedPort", "880")
 *                     ))
 *             ))
 *             .networkRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "netrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports"),
 *                         Map.entry("destinationAddresses", "*"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses",
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports to amazon"),
 *                         Map.entry("destinationFqdns", "www.amazon.com"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic-with-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "10.2.4.12-10.2.4.255")
 *                     ))
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "AZFW_VNet"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .threatIntelMode("Alert")
 *             .zones()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Azure Firewall in virtual Hub
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureFirewall = new AzureNative.Network.AzureFirewall("azureFirewall", new()
 *     {
 *         AzureFirewallName = "azurefirewall",
 *         FirewallPolicy = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/firewallPolicies/policy1",
 *         },
 *         HubIPAddresses = new AzureNative.Network.Inputs.HubIPAddressesArgs
 *         {
 *             PublicIPs = new AzureNative.Network.Inputs.HubPublicIPAddressesArgs
 *             {
 *                 Addresses = new[] {},
 *                 Count = 1,
 *             },
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.AzureFirewallSkuArgs
 *         {
 *             Name = "AZFW_Hub",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ThreatIntelMode = "Alert",
 *         VirtualHub = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1",
 *         },
 *         Zones = new[] {},
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := network.NewAzureFirewall(ctx, "azureFirewall", &network.AzureFirewallArgs{
 * AzureFirewallName: pulumi.String("azurefirewall"),
 * FirewallPolicy: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/firewallPolicies/policy1"),
 * },
 * HubIPAddresses: network.HubIPAddressesResponse{
 * PublicIPs: interface{}{
 * Addresses: network.AzureFirewallPublicIPAddressArray{
 * },
 * Count: pulumi.Int(1),
 * },
 * },
 * Location: pulumi.String("West US"),
 * ResourceGroupName: pulumi.String("rg1"),
 * Sku: &network.AzureFirewallSkuArgs{
 * Name: pulumi.String("AZFW_Hub"),
 * Tier: pulumi.String("Standard"),
 * },
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("value1"),
 * },
 * ThreatIntelMode: pulumi.String("Alert"),
 * VirtualHub: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1"),
 * },
 * Zones: pulumi.StringArray{
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AzureFirewall;
 * import com.pulumi.azurenative.network.AzureFirewallArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureFirewall = new AzureFirewall("azureFirewall", AzureFirewallArgs.builder()
 *             .azureFirewallName("azurefirewall")
 *             .firewallPolicy(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/firewallPolicies/policy1"))
 *             .hubIPAddresses(Map.of("publicIPs", Map.ofEntries(
 *                 Map.entry("addresses", ),
 *                 Map.entry("count", 1)
 *             )))
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "AZFW_Hub"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .threatIntelMode("Alert")
 *             .virtualHub(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1"))
 *             .zones()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:AzureFirewall azurefirewall /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/azureFirewalls/{azureFirewallName}
 * ```
 */
public class AzureFirewall internal constructor(
    override val javaResource: com.pulumi.azurenative.network.AzureFirewall,
) : KotlinCustomResource(javaResource, AzureFirewallMapper) {
    /**
     * The additional properties used to further config this azure firewall.
     */
    public val additionalProperties: Output<Map<String, String>>?
        get() = javaResource.additionalProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Collection of application rule collections used by Azure Firewall.
     */
    public val applicationRuleCollections:
        Output<List<AzureFirewallApplicationRuleCollectionResponse>>?
        get() = javaResource.applicationRuleCollections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        azureFirewallApplicationRuleCollectionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The firewallPolicy associated with this azure firewall.
     */
    public val firewallPolicy: Output<SubResourceResponse>?
        get() = javaResource.firewallPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * IP addresses associated with AzureFirewall.
     */
    public val hubIPAddresses: Output<HubIPAddressesResponse>?
        get() = javaResource.hubIPAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> hubIPAddressesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * IP configuration of the Azure Firewall resource.
     */
    public val ipConfigurations: Output<List<AzureFirewallIPConfigurationResponse>>?
        get() = javaResource.ipConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        azureFirewallIPConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * IpGroups associated with AzureFirewall.
     */
    public val ipGroups: Output<List<AzureFirewallIpGroupsResponse>>
        get() = javaResource.ipGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    azureFirewallIpGroupsResponseToKotlin(args0)
                })
            })
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * IP configuration of the Azure Firewall used for management traffic.
     */
    public val managementIpConfiguration: Output<AzureFirewallIPConfigurationResponse>?
        get() = javaResource.managementIpConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> azureFirewallIPConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Collection of NAT rule collections used by Azure Firewall.
     */
    public val natRuleCollections: Output<List<AzureFirewallNatRuleCollectionResponse>>?
        get() = javaResource.natRuleCollections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        azureFirewallNatRuleCollectionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Collection of network rule collections used by Azure Firewall.
     */
    public val networkRuleCollections: Output<List<AzureFirewallNetworkRuleCollectionResponse>>?
        get() = javaResource.networkRuleCollections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        azureFirewallNetworkRuleCollectionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the Azure firewall resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The Azure Firewall Resource SKU.
     */
    public val sku: Output<AzureFirewallSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    azureFirewallSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The operation mode for Threat Intelligence.
     */
    public val threatIntelMode: Output<String>?
        get() = javaResource.threatIntelMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The virtualHub to which the firewall belongs.
     */
    public val virtualHub: Output<SubResourceResponse>?
        get() = javaResource.virtualHub().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A list of availability zones denoting where the resource needs to come from.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object AzureFirewallMapper : ResourceMapper<AzureFirewall> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.AzureFirewall::class == javaResource::class

    override fun map(javaResource: Resource): AzureFirewall = AzureFirewall(
        javaResource as
            com.pulumi.azurenative.network.AzureFirewall,
    )
}

/**
 * @see [AzureFirewall].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AzureFirewall].
 */
public suspend fun azureFirewall(
    name: String,
    block: suspend AzureFirewallResourceBuilder.() -> Unit,
): AzureFirewall {
    val builder = AzureFirewallResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AzureFirewall].
 * @param name The _unique_ name of the resulting resource.
 */
public fun azureFirewall(name: String): AzureFirewall {
    val builder = AzureFirewallResourceBuilder()
    builder.name(name)
    return builder.build()
}
