@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.AzureFirewallArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AzureFirewallThreatIntelMode
import com.pulumi.azurenative.network.kotlin.inputs.AzureFirewallApplicationRuleCollectionArgs
import com.pulumi.azurenative.network.kotlin.inputs.AzureFirewallApplicationRuleCollectionArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.AzureFirewallIPConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.AzureFirewallIPConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.AzureFirewallNatRuleCollectionArgs
import com.pulumi.azurenative.network.kotlin.inputs.AzureFirewallNatRuleCollectionArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.AzureFirewallNetworkRuleCollectionArgs
import com.pulumi.azurenative.network.kotlin.inputs.AzureFirewallNetworkRuleCollectionArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.AzureFirewallSkuArgs
import com.pulumi.azurenative.network.kotlin.inputs.AzureFirewallSkuArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.HubIPAddressesArgs
import com.pulumi.azurenative.network.kotlin.inputs.HubIPAddressesArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure Firewall resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2020-04-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create Azure Firewall
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureFirewall = new AzureNative.Network.AzureFirewall("azureFirewall", new()
 *     {
 *         ApplicationRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "apprulecoll",
 *                 Priority = 110,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallApplicationRuleArgs
 *                     {
 *                         Description = "Deny inbound rule",
 *                         Name = "rule1",
 *                         Protocols = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleProtocolArgs
 *                             {
 *                                 Port = 443,
 *                                 ProtocolType = "Https",
 *                             },
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "216.58.216.164",
 *                             "10.0.0.0/24",
 *                         },
 *                         TargetFqdns = new[]
 *                         {
 *                             "www.test.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         AzureFirewallName = "azurefirewall",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallIPConfigurationArgs
 *             {
 *                 Name = "azureFirewallIpConfiguration",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet",
 *                 },
 *             },
 *         },
 *         Location = "West US",
 *         NatRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNatRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallNatRCActionArgs
 *                 {
 *                     Type = "Dnat",
 *                 },
 *                 Name = "natrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all outbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443",
 *                         },
 *                         Name = "DNAT-HTTPS-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedAddress = "1.2.3.5",
 *                         TranslatedPort = "8443",
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all inbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "80",
 *                         },
 *                         Name = "DNAT-HTTP-traffic-With-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedFqdn = "internalhttpserver",
 *                         TranslatedPort = "880",
 *                     },
 *                 },
 *             },
 *         },
 *         NetworkRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNetworkRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "netrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255",
 *                         },
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports to amazon",
 *                         DestinationFqdns = new[]
 *                         {
 *                             "www.amazon.com",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic-with-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.2.4.12-10.2.4.255",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.AzureFirewallSkuArgs
 *         {
 *             Name = "AZFW_VNet",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ThreatIntelMode = "Alert",
 *         Zones = new[] {},
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAzureFirewall(ctx, "azureFirewall", &network.AzureFirewallArgs{
 * 			ApplicationRuleCollections: []network.AzureFirewallApplicationRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("apprulecoll"),
 * 					Priority: pulumi.Int(110),
 * 					Rules: network.AzureFirewallApplicationRuleArray{
 * 						{
 * 							Description: pulumi.String("Deny inbound rule"),
 * 							Name:        pulumi.String("rule1"),
 * 							Protocols: network.AzureFirewallApplicationRuleProtocolArray{
 * 								{
 * 									Port:         pulumi.Int(443),
 * 									ProtocolType: pulumi.String("Https"),
 * 								},
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("216.58.216.164"),
 * 								pulumi.String("10.0.0.0/24"),
 * 							},
 * 							TargetFqdns: pulumi.StringArray{
 * 								pulumi.String("www.test.com"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			AzureFirewallName: pulumi.String("azurefirewall"),
 * 			IpConfigurations: []network.AzureFirewallIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("azureFirewallIpConfiguration"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			NatRuleCollections: []network.AzureFirewallNatRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Dnat"),
 * 					},
 * 					Name:     pulumi.String("natrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNatRuleArray{
 * 						{
 * 							Description: pulumi.String("D-NAT all outbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTPS-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedAddress: pulumi.String("1.2.3.5"),
 * 							TranslatedPort:    pulumi.String("8443"),
 * 						},
 * 						{
 * 							Description: pulumi.String("D-NAT all inbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("80"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTP-traffic-With-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedFqdn: pulumi.String("internalhttpserver"),
 * 							TranslatedPort: pulumi.String("880"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			NetworkRuleCollections: []network.AzureFirewallNetworkRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("netrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNetworkRuleArray{
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("192.168.1.1-192.168.1.12"),
 * 								pulumi.String("10.1.4.12-10.1.4.255"),
 * 							},
 * 						},
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports to amazon"),
 * 							DestinationFqdns: pulumi.StringArray{
 * 								pulumi.String("www.amazon.com"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic-with-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("10.2.4.12-10.2.4.255"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.AzureFirewallSkuArgs{
 * 				Name: pulumi.String("AZFW_VNet"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			ThreatIntelMode: pulumi.String("Alert"),
 * 			Zones:           pulumi.StringArray{},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AzureFirewall;
 * import com.pulumi.azurenative.network.AzureFirewallArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureFirewall = new AzureFirewall("azureFirewall", AzureFirewallArgs.builder()
 *             .applicationRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "apprulecoll"),
 *                 Map.entry("priority", 110),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("description", "Deny inbound rule"),
 *                     Map.entry("name", "rule1"),
 *                     Map.entry("protocols", Map.ofEntries(
 *                         Map.entry("port", 443),
 *                         Map.entry("protocolType", "Https")
 *                     )),
 *                     Map.entry("sourceAddresses",
 *                         "216.58.216.164",
 *                         "10.0.0.0/24"),
 *                     Map.entry("targetFqdns", "www.test.com")
 *                 ))
 *             ))
 *             .azureFirewallName("azurefirewall")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "azureFirewallIpConfiguration"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"))
 *             ))
 *             .location("West US")
 *             .natRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Dnat")),
 *                 Map.entry("name", "natrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all outbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "443"),
 *                         Map.entry("name", "DNAT-HTTPS-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedAddress", "1.2.3.5"),
 *                         Map.entry("translatedPort", "8443")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all inbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "80"),
 *                         Map.entry("name", "DNAT-HTTP-traffic-With-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedFqdn", "internalhttpserver"),
 *                         Map.entry("translatedPort", "880")
 *                     ))
 *             ))
 *             .networkRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "netrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports"),
 *                         Map.entry("destinationAddresses", "*"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses",
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports to amazon"),
 *                         Map.entry("destinationFqdns", "www.amazon.com"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic-with-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "10.2.4.12-10.2.4.255")
 *                     ))
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "AZFW_VNet"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .threatIntelMode("Alert")
 *             .zones()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Azure Firewall With Additional Properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureFirewall = new AzureNative.Network.AzureFirewall("azureFirewall", new()
 *     {
 *         AdditionalProperties =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *         ApplicationRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "apprulecoll",
 *                 Priority = 110,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallApplicationRuleArgs
 *                     {
 *                         Description = "Deny inbound rule",
 *                         Name = "rule1",
 *                         Protocols = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleProtocolArgs
 *                             {
 *                                 Port = 443,
 *                                 ProtocolType = "Https",
 *                             },
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "216.58.216.164",
 *                             "10.0.0.0/24",
 *                         },
 *                         TargetFqdns = new[]
 *                         {
 *                             "www.test.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         AzureFirewallName = "azurefirewall",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallIPConfigurationArgs
 *             {
 *                 Name = "azureFirewallIpConfiguration",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet",
 *                 },
 *             },
 *         },
 *         Location = "West US",
 *         NatRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNatRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallNatRCActionArgs
 *                 {
 *                     Type = "Dnat",
 *                 },
 *                 Name = "natrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all outbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443",
 *                         },
 *                         Name = "DNAT-HTTPS-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedAddress = "1.2.3.5",
 *                         TranslatedPort = "8443",
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all inbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "80",
 *                         },
 *                         Name = "DNAT-HTTP-traffic-With-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedFqdn = "internalhttpserver",
 *                         TranslatedPort = "880",
 *                     },
 *                 },
 *             },
 *         },
 *         NetworkRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNetworkRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "netrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255",
 *                         },
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports to amazon",
 *                         DestinationFqdns = new[]
 *                         {
 *                             "www.amazon.com",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic-with-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.2.4.12-10.2.4.255",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.AzureFirewallSkuArgs
 *         {
 *             Name = "AZFW_VNet",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ThreatIntelMode = "Alert",
 *         Zones = new[] {},
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAzureFirewall(ctx, "azureFirewall", &network.AzureFirewallArgs{
 * 			AdditionalProperties: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 			ApplicationRuleCollections: []network.AzureFirewallApplicationRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("apprulecoll"),
 * 					Priority: pulumi.Int(110),
 * 					Rules: network.AzureFirewallApplicationRuleArray{
 * 						{
 * 							Description: pulumi.String("Deny inbound rule"),
 * 							Name:        pulumi.String("rule1"),
 * 							Protocols: network.AzureFirewallApplicationRuleProtocolArray{
 * 								{
 * 									Port:         pulumi.Int(443),
 * 									ProtocolType: pulumi.String("Https"),
 * 								},
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("216.58.216.164"),
 * 								pulumi.String("10.0.0.0/24"),
 * 							},
 * 							TargetFqdns: pulumi.StringArray{
 * 								pulumi.String("www.test.com"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			AzureFirewallName: pulumi.String("azurefirewall"),
 * 			IpConfigurations: []network.AzureFirewallIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("azureFirewallIpConfiguration"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			NatRuleCollections: []network.AzureFirewallNatRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Dnat"),
 * 					},
 * 					Name:     pulumi.String("natrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNatRuleArray{
 * 						{
 * 							Description: pulumi.String("D-NAT all outbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTPS-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedAddress: pulumi.String("1.2.3.5"),
 * 							TranslatedPort:    pulumi.String("8443"),
 * 						},
 * 						{
 * 							Description: pulumi.String("D-NAT all inbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("80"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTP-traffic-With-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedFqdn: pulumi.String("internalhttpserver"),
 * 							TranslatedPort: pulumi.String("880"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			NetworkRuleCollections: []network.AzureFirewallNetworkRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("netrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNetworkRuleArray{
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("192.168.1.1-192.168.1.12"),
 * 								pulumi.String("10.1.4.12-10.1.4.255"),
 * 							},
 * 						},
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports to amazon"),
 * 							DestinationFqdns: pulumi.StringArray{
 * 								pulumi.String("www.amazon.com"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic-with-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("10.2.4.12-10.2.4.255"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.AzureFirewallSkuArgs{
 * 				Name: pulumi.String("AZFW_VNet"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			ThreatIntelMode: pulumi.String("Alert"),
 * 			Zones:           pulumi.StringArray{},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AzureFirewall;
 * import com.pulumi.azurenative.network.AzureFirewallArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureFirewall = new AzureFirewall("azureFirewall", AzureFirewallArgs.builder()
 *             .additionalProperties(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .applicationRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "apprulecoll"),
 *                 Map.entry("priority", 110),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("description", "Deny inbound rule"),
 *                     Map.entry("name", "rule1"),
 *                     Map.entry("protocols", Map.ofEntries(
 *                         Map.entry("port", 443),
 *                         Map.entry("protocolType", "Https")
 *                     )),
 *                     Map.entry("sourceAddresses",
 *                         "216.58.216.164",
 *                         "10.0.0.0/24"),
 *                     Map.entry("targetFqdns", "www.test.com")
 *                 ))
 *             ))
 *             .azureFirewallName("azurefirewall")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "azureFirewallIpConfiguration"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"))
 *             ))
 *             .location("West US")
 *             .natRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Dnat")),
 *                 Map.entry("name", "natrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all outbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "443"),
 *                         Map.entry("name", "DNAT-HTTPS-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedAddress", "1.2.3.5"),
 *                         Map.entry("translatedPort", "8443")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all inbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "80"),
 *                         Map.entry("name", "DNAT-HTTP-traffic-With-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedFqdn", "internalhttpserver"),
 *                         Map.entry("translatedPort", "880")
 *                     ))
 *             ))
 *             .networkRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "netrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports"),
 *                         Map.entry("destinationAddresses", "*"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses",
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports to amazon"),
 *                         Map.entry("destinationFqdns", "www.amazon.com"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic-with-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "10.2.4.12-10.2.4.255")
 *                     ))
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "AZFW_VNet"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .threatIntelMode("Alert")
 *             .zones()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Azure Firewall With IpGroups
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureFirewall = new AzureNative.Network.AzureFirewall("azureFirewall", new()
 *     {
 *         ApplicationRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "apprulecoll",
 *                 Priority = 110,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallApplicationRuleArgs
 *                     {
 *                         Description = "Deny inbound rule",
 *                         Name = "rule1",
 *                         Protocols = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleProtocolArgs
 *                             {
 *                                 Port = 443,
 *                                 ProtocolType = "Https",
 *                             },
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "216.58.216.164",
 *                             "10.0.0.0/24",
 *                         },
 *                         TargetFqdns = new[]
 *                         {
 *                             "www.test.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         AzureFirewallName = "azurefirewall",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallIPConfigurationArgs
 *             {
 *                 Name = "azureFirewallIpConfiguration",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet",
 *                 },
 *             },
 *         },
 *         Location = "West US",
 *         NatRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNatRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallNatRCActionArgs
 *                 {
 *                     Type = "Dnat",
 *                 },
 *                 Name = "natrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all outbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443",
 *                         },
 *                         Name = "DNAT-HTTPS-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedAddress = "1.2.3.5",
 *                         TranslatedPort = "8443",
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all inbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "80",
 *                         },
 *                         Name = "DNAT-HTTP-traffic-With-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedFqdn = "internalhttpserver",
 *                         TranslatedPort = "880",
 *                     },
 *                 },
 *             },
 *         },
 *         NetworkRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNetworkRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "netrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255",
 *                         },
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports to amazon",
 *                         DestinationFqdns = new[]
 *                         {
 *                             "www.amazon.com",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic-with-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.2.4.12-10.2.4.255",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.AzureFirewallSkuArgs
 *         {
 *             Name = "AZFW_VNet",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ThreatIntelMode = "Alert",
 *         Zones = new[] {},
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAzureFirewall(ctx, "azureFirewall", &network.AzureFirewallArgs{
 * 			ApplicationRuleCollections: []network.AzureFirewallApplicationRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("apprulecoll"),
 * 					Priority: pulumi.Int(110),
 * 					Rules: network.AzureFirewallApplicationRuleArray{
 * 						{
 * 							Description: pulumi.String("Deny inbound rule"),
 * 							Name:        pulumi.String("rule1"),
 * 							Protocols: network.AzureFirewallApplicationRuleProtocolArray{
 * 								{
 * 									Port:         pulumi.Int(443),
 * 									ProtocolType: pulumi.String("Https"),
 * 								},
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("216.58.216.164"),
 * 								pulumi.String("10.0.0.0/24"),
 * 							},
 * 							TargetFqdns: pulumi.StringArray{
 * 								pulumi.String("www.test.com"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			AzureFirewallName: pulumi.String("azurefirewall"),
 * 			IpConfigurations: []network.AzureFirewallIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("azureFirewallIpConfiguration"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			NatRuleCollections: []network.AzureFirewallNatRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Dnat"),
 * 					},
 * 					Name:     pulumi.String("natrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNatRuleArray{
 * 						{
 * 							Description: pulumi.String("D-NAT all outbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTPS-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedAddress: pulumi.String("1.2.3.5"),
 * 							TranslatedPort:    pulumi.String("8443"),
 * 						},
 * 						{
 * 							Description: pulumi.String("D-NAT all inbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("80"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTP-traffic-With-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedFqdn: pulumi.String("internalhttpserver"),
 * 							TranslatedPort: pulumi.String("880"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			NetworkRuleCollections: []network.AzureFirewallNetworkRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("netrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNetworkRuleArray{
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("192.168.1.1-192.168.1.12"),
 * 								pulumi.String("10.1.4.12-10.1.4.255"),
 * 							},
 * 						},
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports to amazon"),
 * 							DestinationFqdns: pulumi.StringArray{
 * 								pulumi.String("www.amazon.com"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic-with-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("10.2.4.12-10.2.4.255"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.AzureFirewallSkuArgs{
 * 				Name: pulumi.String("AZFW_VNet"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			ThreatIntelMode: pulumi.String("Alert"),
 * 			Zones:           pulumi.StringArray{},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AzureFirewall;
 * import com.pulumi.azurenative.network.AzureFirewallArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureFirewall = new AzureFirewall("azureFirewall", AzureFirewallArgs.builder()
 *             .applicationRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "apprulecoll"),
 *                 Map.entry("priority", 110),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("description", "Deny inbound rule"),
 *                     Map.entry("name", "rule1"),
 *                     Map.entry("protocols", Map.ofEntries(
 *                         Map.entry("port", 443),
 *                         Map.entry("protocolType", "Https")
 *                     )),
 *                     Map.entry("sourceAddresses",
 *                         "216.58.216.164",
 *                         "10.0.0.0/24"),
 *                     Map.entry("targetFqdns", "www.test.com")
 *                 ))
 *             ))
 *             .azureFirewallName("azurefirewall")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "azureFirewallIpConfiguration"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"))
 *             ))
 *             .location("West US")
 *             .natRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Dnat")),
 *                 Map.entry("name", "natrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all outbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "443"),
 *                         Map.entry("name", "DNAT-HTTPS-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedAddress", "1.2.3.5"),
 *                         Map.entry("translatedPort", "8443")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all inbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "80"),
 *                         Map.entry("name", "DNAT-HTTP-traffic-With-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedFqdn", "internalhttpserver"),
 *                         Map.entry("translatedPort", "880")
 *                     ))
 *             ))
 *             .networkRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "netrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports"),
 *                         Map.entry("destinationAddresses", "*"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses",
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports to amazon"),
 *                         Map.entry("destinationFqdns", "www.amazon.com"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic-with-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "10.2.4.12-10.2.4.255")
 *                     ))
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "AZFW_VNet"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .threatIntelMode("Alert")
 *             .zones()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Azure Firewall With Zones
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureFirewall = new AzureNative.Network.AzureFirewall("azureFirewall", new()
 *     {
 *         ApplicationRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "apprulecoll",
 *                 Priority = 110,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallApplicationRuleArgs
 *                     {
 *                         Description = "Deny inbound rule",
 *                         Name = "rule1",
 *                         Protocols = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleProtocolArgs
 *                             {
 *                                 Port = 443,
 *                                 ProtocolType = "Https",
 *                             },
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "216.58.216.164",
 *                             "10.0.0.0/24",
 *                         },
 *                         TargetFqdns = new[]
 *                         {
 *                             "www.test.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         AzureFirewallName = "azurefirewall",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallIPConfigurationArgs
 *             {
 *                 Name = "azureFirewallIpConfiguration",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet",
 *                 },
 *             },
 *         },
 *         Location = "West US 2",
 *         NatRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNatRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallNatRCActionArgs
 *                 {
 *                     Type = "Dnat",
 *                 },
 *                 Name = "natrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all outbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443",
 *                         },
 *                         Name = "DNAT-HTTPS-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedAddress = "1.2.3.5",
 *                         TranslatedPort = "8443",
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all inbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "80",
 *                         },
 *                         Name = "DNAT-HTTP-traffic-With-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedFqdn = "internalhttpserver",
 *                         TranslatedPort = "880",
 *                     },
 *                 },
 *             },
 *         },
 *         NetworkRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNetworkRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "netrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255",
 *                         },
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports to amazon",
 *                         DestinationFqdns = new[]
 *                         {
 *                             "www.amazon.com",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic-with-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.2.4.12-10.2.4.255",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.AzureFirewallSkuArgs
 *         {
 *             Name = "AZFW_VNet",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ThreatIntelMode = "Alert",
 *         Zones = new[]
 *         {
 *             "1",
 *             "2",
 *             "3",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAzureFirewall(ctx, "azureFirewall", &network.AzureFirewallArgs{
 * 			ApplicationRuleCollections: []network.AzureFirewallApplicationRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("apprulecoll"),
 * 					Priority: pulumi.Int(110),
 * 					Rules: network.AzureFirewallApplicationRuleArray{
 * 						{
 * 							Description: pulumi.String("Deny inbound rule"),
 * 							Name:        pulumi.String("rule1"),
 * 							Protocols: network.AzureFirewallApplicationRuleProtocolArray{
 * 								{
 * 									Port:         pulumi.Int(443),
 * 									ProtocolType: pulumi.String("Https"),
 * 								},
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("216.58.216.164"),
 * 								pulumi.String("10.0.0.0/24"),
 * 							},
 * 							TargetFqdns: pulumi.StringArray{
 * 								pulumi.String("www.test.com"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			AzureFirewallName: pulumi.String("azurefirewall"),
 * 			IpConfigurations: []network.AzureFirewallIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("azureFirewallIpConfiguration"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("West US 2"),
 * 			NatRuleCollections: []network.AzureFirewallNatRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Dnat"),
 * 					},
 * 					Name:     pulumi.String("natrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNatRuleArray{
 * 						{
 * 							Description: pulumi.String("D-NAT all outbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTPS-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedAddress: pulumi.String("1.2.3.5"),
 * 							TranslatedPort:    pulumi.String("8443"),
 * 						},
 * 						{
 * 							Description: pulumi.String("D-NAT all inbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("80"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTP-traffic-With-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedFqdn: pulumi.String("internalhttpserver"),
 * 							TranslatedPort: pulumi.String("880"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			NetworkRuleCollections: []network.AzureFirewallNetworkRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("netrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNetworkRuleArray{
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("192.168.1.1-192.168.1.12"),
 * 								pulumi.String("10.1.4.12-10.1.4.255"),
 * 							},
 * 						},
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports to amazon"),
 * 							DestinationFqdns: pulumi.StringArray{
 * 								pulumi.String("www.amazon.com"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic-with-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("10.2.4.12-10.2.4.255"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.AzureFirewallSkuArgs{
 * 				Name: pulumi.String("AZFW_VNet"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			ThreatIntelMode: pulumi.String("Alert"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 				pulumi.String("2"),
 * 				pulumi.String("3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AzureFirewall;
 * import com.pulumi.azurenative.network.AzureFirewallArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureFirewall = new AzureFirewall("azureFirewall", AzureFirewallArgs.builder()
 *             .applicationRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "apprulecoll"),
 *                 Map.entry("priority", 110),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("description", "Deny inbound rule"),
 *                     Map.entry("name", "rule1"),
 *                     Map.entry("protocols", Map.ofEntries(
 *                         Map.entry("port", 443),
 *                         Map.entry("protocolType", "Https")
 *                     )),
 *                     Map.entry("sourceAddresses",
 *                         "216.58.216.164",
 *                         "10.0.0.0/24"),
 *                     Map.entry("targetFqdns", "www.test.com")
 *                 ))
 *             ))
 *             .azureFirewallName("azurefirewall")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "azureFirewallIpConfiguration"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"))
 *             ))
 *             .location("West US 2")
 *             .natRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Dnat")),
 *                 Map.entry("name", "natrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all outbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "443"),
 *                         Map.entry("name", "DNAT-HTTPS-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedAddress", "1.2.3.5"),
 *                         Map.entry("translatedPort", "8443")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all inbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "80"),
 *                         Map.entry("name", "DNAT-HTTP-traffic-With-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedFqdn", "internalhttpserver"),
 *                         Map.entry("translatedPort", "880")
 *                     ))
 *             ))
 *             .networkRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "netrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports"),
 *                         Map.entry("destinationAddresses", "*"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses",
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports to amazon"),
 *                         Map.entry("destinationFqdns", "www.amazon.com"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic-with-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "10.2.4.12-10.2.4.255")
 *                     ))
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "AZFW_VNet"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .threatIntelMode("Alert")
 *             .zones(
 *                 "1",
 *                 "2",
 *                 "3")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Azure Firewall With management subnet
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureFirewall = new AzureNative.Network.AzureFirewall("azureFirewall", new()
 *     {
 *         ApplicationRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "apprulecoll",
 *                 Priority = 110,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallApplicationRuleArgs
 *                     {
 *                         Description = "Deny inbound rule",
 *                         Name = "rule1",
 *                         Protocols = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.AzureFirewallApplicationRuleProtocolArgs
 *                             {
 *                                 Port = 443,
 *                                 ProtocolType = "Https",
 *                             },
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "216.58.216.164",
 *                             "10.0.0.0/24",
 *                         },
 *                         TargetFqdns = new[]
 *                         {
 *                             "www.test.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         AzureFirewallName = "azurefirewall",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallIPConfigurationArgs
 *             {
 *                 Name = "azureFirewallIpConfiguration",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet",
 *                 },
 *             },
 *         },
 *         Location = "West US",
 *         ManagementIpConfiguration = new AzureNative.Network.Inputs.AzureFirewallIPConfigurationArgs
 *         {
 *             Name = "azureFirewallMgmtIpConfiguration",
 *             PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/managementPipName",
 *             },
 *             Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallManagementSubnet",
 *             },
 *         },
 *         NatRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNatRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallNatRCActionArgs
 *                 {
 *                     Type = "Dnat",
 *                 },
 *                 Name = "natrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all outbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443",
 *                         },
 *                         Name = "DNAT-HTTPS-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedAddress = "1.2.3.5",
 *                         TranslatedPort = "8443",
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNatRuleArgs
 *                     {
 *                         Description = "D-NAT all inbound web traffic for inspection",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "1.2.3.4",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "80",
 *                         },
 *                         Name = "DNAT-HTTP-traffic-With-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         TranslatedFqdn = "internalhttpserver",
 *                         TranslatedPort = "880",
 *                     },
 *                 },
 *             },
 *         },
 *         NetworkRuleCollections = new[]
 *         {
 *             new AzureNative.Network.Inputs.AzureFirewallNetworkRuleCollectionArgs
 *             {
 *                 Action = new AzureNative.Network.Inputs.AzureFirewallRCActionArgs
 *                 {
 *                     Type = "Deny",
 *                 },
 *                 Name = "netrulecoll",
 *                 Priority = 112,
 *                 Rules = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports",
 *                         DestinationAddresses = new[]
 *                         {
 *                             "*",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255",
 *                         },
 *                     },
 *                     new AzureNative.Network.Inputs.AzureFirewallNetworkRuleArgs
 *                     {
 *                         Description = "Block traffic based on source IPs and ports to amazon",
 *                         DestinationFqdns = new[]
 *                         {
 *                             "www.amazon.com",
 *                         },
 *                         DestinationPorts = new[]
 *                         {
 *                             "443-444",
 *                             "8443",
 *                         },
 *                         Name = "L4-traffic-with-FQDN",
 *                         Protocols = new[]
 *                         {
 *                             "TCP",
 *                         },
 *                         SourceAddresses = new[]
 *                         {
 *                             "10.2.4.12-10.2.4.255",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.AzureFirewallSkuArgs
 *         {
 *             Name = "AZFW_VNet",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ThreatIntelMode = "Alert",
 *         Zones = new[] {},
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewAzureFirewall(ctx, "azureFirewall", &network.AzureFirewallArgs{
 * 			ApplicationRuleCollections: []network.AzureFirewallApplicationRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("apprulecoll"),
 * 					Priority: pulumi.Int(110),
 * 					Rules: network.AzureFirewallApplicationRuleArray{
 * 						{
 * 							Description: pulumi.String("Deny inbound rule"),
 * 							Name:        pulumi.String("rule1"),
 * 							Protocols: network.AzureFirewallApplicationRuleProtocolArray{
 * 								{
 * 									Port:         pulumi.Int(443),
 * 									ProtocolType: pulumi.String("Https"),
 * 								},
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("216.58.216.164"),
 * 								pulumi.String("10.0.0.0/24"),
 * 							},
 * 							TargetFqdns: pulumi.StringArray{
 * 								pulumi.String("www.test.com"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			AzureFirewallName: pulumi.String("azurefirewall"),
 * 			IpConfigurations: []network.AzureFirewallIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("azureFirewallIpConfiguration"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			ManagementIpConfiguration: network.AzureFirewallIPConfigurationResponse{
 * 				Name: pulumi.String("azureFirewallMgmtIpConfiguration"),
 * 				PublicIPAddress: &network.SubResourceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/managementPipName"),
 * 				},
 * 				Subnet: &network.SubResourceArgs{
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallManagementSubnet"),
 * 				},
 * 			},
 * 			NatRuleCollections: []network.AzureFirewallNatRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Dnat"),
 * 					},
 * 					Name:     pulumi.String("natrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNatRuleArray{
 * 						{
 * 							Description: pulumi.String("D-NAT all outbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTPS-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedAddress: pulumi.String("1.2.3.5"),
 * 							TranslatedPort:    pulumi.String("8443"),
 * 						},
 * 						{
 * 							Description: pulumi.String("D-NAT all inbound web traffic for inspection"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("1.2.3.4"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("80"),
 * 							},
 * 							Name: pulumi.String("DNAT-HTTP-traffic-With-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							TranslatedFqdn: pulumi.String("internalhttpserver"),
 * 							TranslatedPort: pulumi.String("880"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			NetworkRuleCollections: []network.AzureFirewallNetworkRuleCollectionArgs{
 * 				{
 * 					Action: {
 * 						Type: pulumi.String("Deny"),
 * 					},
 * 					Name:     pulumi.String("netrulecoll"),
 * 					Priority: pulumi.Int(112),
 * 					Rules: network.AzureFirewallNetworkRuleArray{
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports"),
 * 							DestinationAddresses: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("192.168.1.1-192.168.1.12"),
 * 								pulumi.String("10.1.4.12-10.1.4.255"),
 * 							},
 * 						},
 * 						{
 * 							Description: pulumi.String("Block traffic based on source IPs and ports to amazon"),
 * 							DestinationFqdns: pulumi.StringArray{
 * 								pulumi.String("www.amazon.com"),
 * 							},
 * 							DestinationPorts: pulumi.StringArray{
 * 								pulumi.String("443-444"),
 * 								pulumi.String("8443"),
 * 							},
 * 							Name: pulumi.String("L4-traffic-with-FQDN"),
 * 							Protocols: pulumi.StringArray{
 * 								pulumi.String("TCP"),
 * 							},
 * 							SourceAddresses: pulumi.StringArray{
 * 								pulumi.String("10.2.4.12-10.2.4.255"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.AzureFirewallSkuArgs{
 * 				Name: pulumi.String("AZFW_VNet"),
 * 				Tier: pulumi.String("Standard"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			ThreatIntelMode: pulumi.String("Alert"),
 * 			Zones:           pulumi.StringArray{},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AzureFirewall;
 * import com.pulumi.azurenative.network.AzureFirewallArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureFirewall = new AzureFirewall("azureFirewall", AzureFirewallArgs.builder()
 *             .applicationRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "apprulecoll"),
 *                 Map.entry("priority", 110),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("description", "Deny inbound rule"),
 *                     Map.entry("name", "rule1"),
 *                     Map.entry("protocols", Map.ofEntries(
 *                         Map.entry("port", 443),
 *                         Map.entry("protocolType", "Https")
 *                     )),
 *                     Map.entry("sourceAddresses",
 *                         "216.58.216.164",
 *                         "10.0.0.0/24"),
 *                     Map.entry("targetFqdns", "www.test.com")
 *                 ))
 *             ))
 *             .azureFirewallName("azurefirewall")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "azureFirewallIpConfiguration"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pipName")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallSubnet"))
 *             ))
 *             .location("West US")
 *             .managementIpConfiguration(Map.ofEntries(
 *                 Map.entry("name", "azureFirewallMgmtIpConfiguration"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/managementPipName")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet2/subnets/AzureFirewallManagementSubnet"))
 *             ))
 *             .natRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Dnat")),
 *                 Map.entry("name", "natrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all outbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "443"),
 *                         Map.entry("name", "DNAT-HTTPS-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedAddress", "1.2.3.5"),
 *                         Map.entry("translatedPort", "8443")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "D-NAT all inbound web traffic for inspection"),
 *                         Map.entry("destinationAddresses", "1.2.3.4"),
 *                         Map.entry("destinationPorts", "80"),
 *                         Map.entry("name", "DNAT-HTTP-traffic-With-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "*"),
 *                         Map.entry("translatedFqdn", "internalhttpserver"),
 *                         Map.entry("translatedPort", "880")
 *                     ))
 *             ))
 *             .networkRuleCollections(Map.ofEntries(
 *                 Map.entry("action", Map.of("type", "Deny")),
 *                 Map.entry("name", "netrulecoll"),
 *                 Map.entry("priority", 112),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports"),
 *                         Map.entry("destinationAddresses", "*"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses",
 *                             "192.168.1.1-192.168.1.12",
 *                             "10.1.4.12-10.1.4.255")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("description", "Block traffic based on source IPs and ports to amazon"),
 *                         Map.entry("destinationFqdns", "www.amazon.com"),
 *                         Map.entry("destinationPorts",
 *                             "443-444",
 *                             "8443"),
 *                         Map.entry("name", "L4-traffic-with-FQDN"),
 *                         Map.entry("protocols", "TCP"),
 *                         Map.entry("sourceAddresses", "10.2.4.12-10.2.4.255")
 *                     ))
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "AZFW_VNet"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .threatIntelMode("Alert")
 *             .zones()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Azure Firewall in virtual Hub
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureFirewall = new AzureNative.Network.AzureFirewall("azureFirewall", new()
 *     {
 *         AzureFirewallName = "azurefirewall",
 *         FirewallPolicy = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/firewallPolicies/policy1",
 *         },
 *         HubIPAddresses = new AzureNative.Network.Inputs.HubIPAddressesArgs
 *         {
 *             PublicIPs = new AzureNative.Network.Inputs.HubPublicIPAddressesArgs
 *             {
 *                 Addresses = new[] {},
 *                 Count = 1,
 *             },
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.AzureFirewallSkuArgs
 *         {
 *             Name = "AZFW_Hub",
 *             Tier = "Standard",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ThreatIntelMode = "Alert",
 *         VirtualHub = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1",
 *         },
 *         Zones = new[] {},
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := network.NewAzureFirewall(ctx, "azureFirewall", &network.AzureFirewallArgs{
 * AzureFirewallName: pulumi.String("azurefirewall"),
 * FirewallPolicy: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/firewallPolicies/policy1"),
 * },
 * HubIPAddresses: network.HubIPAddressesResponse{
 * PublicIPs: interface{}{
 * Addresses: network.AzureFirewallPublicIPAddressArray{
 * },
 * Count: pulumi.Int(1),
 * },
 * },
 * Location: pulumi.String("West US"),
 * ResourceGroupName: pulumi.String("rg1"),
 * Sku: &network.AzureFirewallSkuArgs{
 * Name: pulumi.String("AZFW_Hub"),
 * Tier: pulumi.String("Standard"),
 * },
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("value1"),
 * },
 * ThreatIntelMode: pulumi.String("Alert"),
 * VirtualHub: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1"),
 * },
 * Zones: pulumi.StringArray{
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.AzureFirewall;
 * import com.pulumi.azurenative.network.AzureFirewallArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureFirewall = new AzureFirewall("azureFirewall", AzureFirewallArgs.builder()
 *             .azureFirewallName("azurefirewall")
 *             .firewallPolicy(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/firewallPolicies/policy1"))
 *             .hubIPAddresses(Map.of("publicIPs", Map.ofEntries(
 *                 Map.entry("addresses", ),
 *                 Map.entry("count", 1)
 *             )))
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "AZFW_Hub"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .threatIntelMode("Alert")
 *             .virtualHub(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1"))
 *             .zones()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:AzureFirewall azurefirewall /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/azureFirewalls/{azureFirewallName}
 * ```
 * @property additionalProperties The additional properties used to further config this azure firewall.
 * @property applicationRuleCollections Collection of application rule collections used by Azure Firewall.
 * @property azureFirewallName The name of the Azure Firewall.
 * @property firewallPolicy The firewallPolicy associated with this azure firewall.
 * @property hubIPAddresses IP addresses associated with AzureFirewall.
 * @property id Resource ID.
 * @property ipConfigurations IP configuration of the Azure Firewall resource.
 * @property location Resource location.
 * @property managementIpConfiguration IP configuration of the Azure Firewall used for management traffic.
 * @property natRuleCollections Collection of NAT rule collections used by Azure Firewall.
 * @property networkRuleCollections Collection of network rule collections used by Azure Firewall.
 * @property resourceGroupName The name of the resource group.
 * @property sku The Azure Firewall Resource SKU.
 * @property tags Resource tags.
 * @property threatIntelMode The operation mode for Threat Intelligence.
 * @property virtualHub The virtualHub to which the firewall belongs.
 * @property zones A list of availability zones denoting where the resource needs to come from.
 */
public data class AzureFirewallArgs(
    public val additionalProperties: Output<Map<String, String>>? = null,
    public val applicationRuleCollections: Output<List<AzureFirewallApplicationRuleCollectionArgs>>? =
        null,
    public val azureFirewallName: Output<String>? = null,
    public val firewallPolicy: Output<SubResourceArgs>? = null,
    public val hubIPAddresses: Output<HubIPAddressesArgs>? = null,
    public val id: Output<String>? = null,
    public val ipConfigurations: Output<List<AzureFirewallIPConfigurationArgs>>? = null,
    public val location: Output<String>? = null,
    public val managementIpConfiguration: Output<AzureFirewallIPConfigurationArgs>? = null,
    public val natRuleCollections: Output<List<AzureFirewallNatRuleCollectionArgs>>? = null,
    public val networkRuleCollections: Output<List<AzureFirewallNetworkRuleCollectionArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<AzureFirewallSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val threatIntelMode: Output<Either<String, AzureFirewallThreatIntelMode>>? = null,
    public val virtualHub: Output<SubResourceArgs>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.AzureFirewallArgs> {
    override fun toJava(): com.pulumi.azurenative.network.AzureFirewallArgs =
        com.pulumi.azurenative.network.AzureFirewallArgs.builder()
            .additionalProperties(
                additionalProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .applicationRuleCollections(
                applicationRuleCollections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azureFirewallName(azureFirewallName?.applyValue({ args0 -> args0 }))
            .firewallPolicy(firewallPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hubIPAddresses(hubIPAddresses?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .managementIpConfiguration(
                managementIpConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .natRuleCollections(
                natRuleCollections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkRuleCollections(
                networkRuleCollections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .threatIntelMode(
                threatIntelMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .virtualHub(virtualHub?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AzureFirewallArgs].
 */
@PulumiTagMarker
public class AzureFirewallArgsBuilder internal constructor() {
    private var additionalProperties: Output<Map<String, String>>? = null

    private var applicationRuleCollections: Output<List<AzureFirewallApplicationRuleCollectionArgs>>? =
        null

    private var azureFirewallName: Output<String>? = null

    private var firewallPolicy: Output<SubResourceArgs>? = null

    private var hubIPAddresses: Output<HubIPAddressesArgs>? = null

    private var id: Output<String>? = null

    private var ipConfigurations: Output<List<AzureFirewallIPConfigurationArgs>>? = null

    private var location: Output<String>? = null

    private var managementIpConfiguration: Output<AzureFirewallIPConfigurationArgs>? = null

    private var natRuleCollections: Output<List<AzureFirewallNatRuleCollectionArgs>>? = null

    private var networkRuleCollections: Output<List<AzureFirewallNetworkRuleCollectionArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<AzureFirewallSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var threatIntelMode: Output<Either<String, AzureFirewallThreatIntelMode>>? = null

    private var virtualHub: Output<SubResourceArgs>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value The additional properties used to further config this azure firewall.
     */
    @JvmName("bgpgkwxehffqcmrr")
    public suspend fun additionalProperties(`value`: Output<Map<String, String>>) {
        this.additionalProperties = value
    }

    /**
     * @param value Collection of application rule collections used by Azure Firewall.
     */
    @JvmName("wemjtrfjgeweaftc")
    public suspend
    fun applicationRuleCollections(`value`: Output<List<AzureFirewallApplicationRuleCollectionArgs>>) {
        this.applicationRuleCollections = value
    }

    @JvmName("qorkabxtdqxbyski")
    public suspend fun applicationRuleCollections(
        vararg
        values: Output<AzureFirewallApplicationRuleCollectionArgs>,
    ) {
        this.applicationRuleCollections = Output.all(values.asList())
    }

    /**
     * @param values Collection of application rule collections used by Azure Firewall.
     */
    @JvmName("lxctnbsiabauokja")
    public suspend
    fun applicationRuleCollections(values: List<Output<AzureFirewallApplicationRuleCollectionArgs>>) {
        this.applicationRuleCollections = Output.all(values)
    }

    /**
     * @param value The name of the Azure Firewall.
     */
    @JvmName("pdkfmqycdupemmjl")
    public suspend fun azureFirewallName(`value`: Output<String>) {
        this.azureFirewallName = value
    }

    /**
     * @param value The firewallPolicy associated with this azure firewall.
     */
    @JvmName("dnlkbojswrudtopy")
    public suspend fun firewallPolicy(`value`: Output<SubResourceArgs>) {
        this.firewallPolicy = value
    }

    /**
     * @param value IP addresses associated with AzureFirewall.
     */
    @JvmName("yhoutcmnahnnluwc")
    public suspend fun hubIPAddresses(`value`: Output<HubIPAddressesArgs>) {
        this.hubIPAddresses = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("mylhwhicysgyjcpi")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value IP configuration of the Azure Firewall resource.
     */
    @JvmName("xagvtmdponwmtosw")
    public suspend fun ipConfigurations(`value`: Output<List<AzureFirewallIPConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("vcvuvncyifejfbus")
    public suspend fun ipConfigurations(vararg values: Output<AzureFirewallIPConfigurationArgs>) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values IP configuration of the Azure Firewall resource.
     */
    @JvmName("nggvhattolihmxnr")
    public suspend fun ipConfigurations(values: List<Output<AzureFirewallIPConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("dodnwceltdbmbkhm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value IP configuration of the Azure Firewall used for management traffic.
     */
    @JvmName("ndjxlyjjyqqyabyx")
    public suspend fun managementIpConfiguration(`value`: Output<AzureFirewallIPConfigurationArgs>) {
        this.managementIpConfiguration = value
    }

    /**
     * @param value Collection of NAT rule collections used by Azure Firewall.
     */
    @JvmName("kuqahqektrqjpmtt")
    public suspend fun natRuleCollections(`value`: Output<List<AzureFirewallNatRuleCollectionArgs>>) {
        this.natRuleCollections = value
    }

    @JvmName("khlgeakboceeuicw")
    public suspend fun natRuleCollections(vararg values: Output<AzureFirewallNatRuleCollectionArgs>) {
        this.natRuleCollections = Output.all(values.asList())
    }

    /**
     * @param values Collection of NAT rule collections used by Azure Firewall.
     */
    @JvmName("sdsihvttgvstigat")
    public suspend fun natRuleCollections(values: List<Output<AzureFirewallNatRuleCollectionArgs>>) {
        this.natRuleCollections = Output.all(values)
    }

    /**
     * @param value Collection of network rule collections used by Azure Firewall.
     */
    @JvmName("iokvebsaswqdvuck")
    public suspend
    fun networkRuleCollections(`value`: Output<List<AzureFirewallNetworkRuleCollectionArgs>>) {
        this.networkRuleCollections = value
    }

    @JvmName("cjaioypxdpxvbrhg")
    public suspend fun networkRuleCollections(
        vararg
        values: Output<AzureFirewallNetworkRuleCollectionArgs>,
    ) {
        this.networkRuleCollections = Output.all(values.asList())
    }

    /**
     * @param values Collection of network rule collections used by Azure Firewall.
     */
    @JvmName("bpupcypecbtctqvn")
    public suspend
    fun networkRuleCollections(values: List<Output<AzureFirewallNetworkRuleCollectionArgs>>) {
        this.networkRuleCollections = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mbrbhhcmekbrwfkw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Azure Firewall Resource SKU.
     */
    @JvmName("onnduqkfgjuigxqh")
    public suspend fun sku(`value`: Output<AzureFirewallSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kvueksmsjnyfpcyr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The operation mode for Threat Intelligence.
     */
    @JvmName("lwfyhrkfuqjnkdev")
    public suspend
    fun threatIntelMode(`value`: Output<Either<String, AzureFirewallThreatIntelMode>>) {
        this.threatIntelMode = value
    }

    /**
     * @param value The virtualHub to which the firewall belongs.
     */
    @JvmName("ppeyrinmmwgxakvv")
    public suspend fun virtualHub(`value`: Output<SubResourceArgs>) {
        this.virtualHub = value
    }

    /**
     * @param value A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("hlvpckxotcwrtkbo")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("tupdycyqcndvhrcf")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("gxkxrsawdldwvqul")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value The additional properties used to further config this azure firewall.
     */
    @JvmName("ghkajkdmxswxcvqt")
    public suspend fun additionalProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalProperties = mapped
    }

    /**
     * @param values The additional properties used to further config this azure firewall.
     */
    @JvmName("gajsttcdukchqpxt")
    public fun additionalProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalProperties = mapped
    }

    /**
     * @param value Collection of application rule collections used by Azure Firewall.
     */
    @JvmName("rpmculleqwhjspfd")
    public suspend
    fun applicationRuleCollections(`value`: List<AzureFirewallApplicationRuleCollectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationRuleCollections = mapped
    }

    /**
     * @param argument Collection of application rule collections used by Azure Firewall.
     */
    @JvmName("upjbfvkkjwxmtqlr")
    public suspend
    fun applicationRuleCollections(argument: List<suspend AzureFirewallApplicationRuleCollectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureFirewallApplicationRuleCollectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationRuleCollections = mapped
    }

    /**
     * @param argument Collection of application rule collections used by Azure Firewall.
     */
    @JvmName("syyfpeukeqacsafe")
    public suspend fun applicationRuleCollections(
        vararg
        argument: suspend AzureFirewallApplicationRuleCollectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AzureFirewallApplicationRuleCollectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.applicationRuleCollections = mapped
    }

    /**
     * @param argument Collection of application rule collections used by Azure Firewall.
     */
    @JvmName("bfeecrqmlhncrmxj")
    public suspend
    fun applicationRuleCollections(argument: suspend AzureFirewallApplicationRuleCollectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AzureFirewallApplicationRuleCollectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.applicationRuleCollections = mapped
    }

    /**
     * @param values Collection of application rule collections used by Azure Firewall.
     */
    @JvmName("xqtojfianmanrbjd")
    public suspend fun applicationRuleCollections(
        vararg
        values: AzureFirewallApplicationRuleCollectionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationRuleCollections = mapped
    }

    /**
     * @param value The name of the Azure Firewall.
     */
    @JvmName("gpfgcqeyttjqqlui")
    public suspend fun azureFirewallName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureFirewallName = mapped
    }

    /**
     * @param value The firewallPolicy associated with this azure firewall.
     */
    @JvmName("lnkcmvtdxwvkaqdr")
    public suspend fun firewallPolicy(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallPolicy = mapped
    }

    /**
     * @param argument The firewallPolicy associated with this azure firewall.
     */
    @JvmName("agghnpagkvcgyrvd")
    public suspend fun firewallPolicy(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.firewallPolicy = mapped
    }

    /**
     * @param value IP addresses associated with AzureFirewall.
     */
    @JvmName("kfkaefoejavrxgjw")
    public suspend fun hubIPAddresses(`value`: HubIPAddressesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubIPAddresses = mapped
    }

    /**
     * @param argument IP addresses associated with AzureFirewall.
     */
    @JvmName("umfuyykbnbctjnuo")
    public suspend fun hubIPAddresses(argument: suspend HubIPAddressesArgsBuilder.() -> Unit) {
        val toBeMapped = HubIPAddressesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hubIPAddresses = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("jxrhtkqkpfyhntbk")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value IP configuration of the Azure Firewall resource.
     */
    @JvmName("dancdgbabtrgmwoy")
    public suspend fun ipConfigurations(`value`: List<AzureFirewallIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IP configuration of the Azure Firewall resource.
     */
    @JvmName("enyxfgkffvsdumpy")
    public suspend
    fun ipConfigurations(argument: List<suspend AzureFirewallIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureFirewallIPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IP configuration of the Azure Firewall resource.
     */
    @JvmName("ocxvgpbdimllhqth")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend AzureFirewallIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AzureFirewallIPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IP configuration of the Azure Firewall resource.
     */
    @JvmName("khhwdqphjlxuiqat")
    public suspend
    fun ipConfigurations(argument: suspend AzureFirewallIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AzureFirewallIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values IP configuration of the Azure Firewall resource.
     */
    @JvmName("lljspipplspwtjio")
    public suspend fun ipConfigurations(vararg values: AzureFirewallIPConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ubvjfptivytpsadj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value IP configuration of the Azure Firewall used for management traffic.
     */
    @JvmName("twpthxqnnribaisv")
    public suspend fun managementIpConfiguration(`value`: AzureFirewallIPConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementIpConfiguration = mapped
    }

    /**
     * @param argument IP configuration of the Azure Firewall used for management traffic.
     */
    @JvmName("sajfkhcyxhavorfy")
    public suspend
    fun managementIpConfiguration(argument: suspend AzureFirewallIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFirewallIPConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managementIpConfiguration = mapped
    }

    /**
     * @param value Collection of NAT rule collections used by Azure Firewall.
     */
    @JvmName("qmkurtypyngvbhxy")
    public suspend fun natRuleCollections(`value`: List<AzureFirewallNatRuleCollectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natRuleCollections = mapped
    }

    /**
     * @param argument Collection of NAT rule collections used by Azure Firewall.
     */
    @JvmName("dnucxgcgywxnkbih")
    public suspend
    fun natRuleCollections(argument: List<suspend AzureFirewallNatRuleCollectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureFirewallNatRuleCollectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.natRuleCollections = mapped
    }

    /**
     * @param argument Collection of NAT rule collections used by Azure Firewall.
     */
    @JvmName("eohpdilljfjhrdyd")
    public suspend fun natRuleCollections(
        vararg
        argument: suspend AzureFirewallNatRuleCollectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AzureFirewallNatRuleCollectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.natRuleCollections = mapped
    }

    /**
     * @param argument Collection of NAT rule collections used by Azure Firewall.
     */
    @JvmName("athjallhwaunigyc")
    public suspend
    fun natRuleCollections(argument: suspend AzureFirewallNatRuleCollectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AzureFirewallNatRuleCollectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.natRuleCollections = mapped
    }

    /**
     * @param values Collection of NAT rule collections used by Azure Firewall.
     */
    @JvmName("kliwwqngobdkbjjl")
    public suspend fun natRuleCollections(vararg values: AzureFirewallNatRuleCollectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.natRuleCollections = mapped
    }

    /**
     * @param value Collection of network rule collections used by Azure Firewall.
     */
    @JvmName("kckbbmvyaysrsoij")
    public suspend
    fun networkRuleCollections(`value`: List<AzureFirewallNetworkRuleCollectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkRuleCollections = mapped
    }

    /**
     * @param argument Collection of network rule collections used by Azure Firewall.
     */
    @JvmName("raevepauavpiusbp")
    public suspend
    fun networkRuleCollections(argument: List<suspend AzureFirewallNetworkRuleCollectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureFirewallNetworkRuleCollectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkRuleCollections = mapped
    }

    /**
     * @param argument Collection of network rule collections used by Azure Firewall.
     */
    @JvmName("dcrnjyfxohcjmcbt")
    public suspend fun networkRuleCollections(
        vararg
        argument: suspend AzureFirewallNetworkRuleCollectionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AzureFirewallNetworkRuleCollectionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkRuleCollections = mapped
    }

    /**
     * @param argument Collection of network rule collections used by Azure Firewall.
     */
    @JvmName("gpxegqfxdmbxdfxt")
    public suspend
    fun networkRuleCollections(argument: suspend AzureFirewallNetworkRuleCollectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AzureFirewallNetworkRuleCollectionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkRuleCollections = mapped
    }

    /**
     * @param values Collection of network rule collections used by Azure Firewall.
     */
    @JvmName("xhcyfubbfflwstgu")
    public suspend fun networkRuleCollections(vararg values: AzureFirewallNetworkRuleCollectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkRuleCollections = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("efvsmrwbkttlhkaa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Azure Firewall Resource SKU.
     */
    @JvmName("xffiidnjnipfneux")
    public suspend fun sku(`value`: AzureFirewallSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The Azure Firewall Resource SKU.
     */
    @JvmName("mxwqlvstwsabixja")
    public suspend fun sku(argument: suspend AzureFirewallSkuArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFirewallSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wamxunlcchaayhag")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xrtwsgxuferogsvu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The operation mode for Threat Intelligence.
     */
    @JvmName("ebhoulhsthpncfvo")
    public suspend fun threatIntelMode(`value`: Either<String, AzureFirewallThreatIntelMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threatIntelMode = mapped
    }

    /**
     * @param value The operation mode for Threat Intelligence.
     */
    @JvmName("phgkkkdgtejkjkeg")
    public fun threatIntelMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureFirewallThreatIntelMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatIntelMode = mapped
    }

    /**
     * @param value The operation mode for Threat Intelligence.
     */
    @JvmName("bgyyulhbyafrfvsn")
    public fun threatIntelMode(`value`: AzureFirewallThreatIntelMode) {
        val toBeMapped = Either.ofRight<String, AzureFirewallThreatIntelMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.threatIntelMode = mapped
    }

    /**
     * @param value The virtualHub to which the firewall belongs.
     */
    @JvmName("inewdjirjgwuvaom")
    public suspend fun virtualHub(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHub = mapped
    }

    /**
     * @param argument The virtualHub to which the firewall belongs.
     */
    @JvmName("wpvcrlappskiopyi")
    public suspend fun virtualHub(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualHub = mapped
    }

    /**
     * @param value A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("txqprjrjlxehlaju")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("lvimfkjlsfchsqig")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): AzureFirewallArgs = AzureFirewallArgs(
        additionalProperties = additionalProperties,
        applicationRuleCollections = applicationRuleCollections,
        azureFirewallName = azureFirewallName,
        firewallPolicy = firewallPolicy,
        hubIPAddresses = hubIPAddresses,
        id = id,
        ipConfigurations = ipConfigurations,
        location = location,
        managementIpConfiguration = managementIpConfiguration,
        natRuleCollections = natRuleCollections,
        networkRuleCollections = networkRuleCollections,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        threatIntelMode = threatIntelMode,
        virtualHub = virtualHub,
        zones = zones,
    )
}
