@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.DscpConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ProtocolType
import com.pulumi.azurenative.network.kotlin.inputs.QosDefinitionArgs
import com.pulumi.azurenative.network.kotlin.inputs.QosDefinitionArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.QosIpRangeArgs
import com.pulumi.azurenative.network.kotlin.inputs.QosIpRangeArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.QosPortRangeArgs
import com.pulumi.azurenative.network.kotlin.inputs.QosPortRangeArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Differentiated Services Code Point configuration for any given network interface
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create DSCP Configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dscpConfiguration = new AzureNative.Network.DscpConfiguration("dscpConfiguration", new()
 *     {
 *         DscpConfigurationName = "mydscpconfig",
 *         Location = "eastus",
 *         QosDefinitionCollection = new[]
 *         {
 *             new AzureNative.Network.Inputs.QosDefinitionArgs
 *             {
 *                 DestinationIpRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosIpRangeArgs
 *                     {
 *                         EndIP = "127.0.10.2",
 *                         StartIP = "127.0.10.1",
 *                     },
 *                 },
 *                 DestinationPortRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosPortRangeArgs
 *                     {
 *                         End = 15,
 *                         Start = 15,
 *                     },
 *                 },
 *                 Markings = new[]
 *                 {
 *                     1,
 *                 },
 *                 Protocol = "Tcp",
 *                 SourceIpRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosIpRangeArgs
 *                     {
 *                         EndIP = "127.0.0.2",
 *                         StartIP = "127.0.0.1",
 *                     },
 *                 },
 *                 SourcePortRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosPortRangeArgs
 *                     {
 *                         End = 11,
 *                         Start = 10,
 *                     },
 *                     new AzureNative.Network.Inputs.QosPortRangeArgs
 *                     {
 *                         End = 21,
 *                         Start = 20,
 *                     },
 *                 },
 *             },
 *             new AzureNative.Network.Inputs.QosDefinitionArgs
 *             {
 *                 DestinationIpRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosIpRangeArgs
 *                     {
 *                         EndIP = "12.0.10.2",
 *                         StartIP = "12.0.10.1",
 *                     },
 *                 },
 *                 DestinationPortRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosPortRangeArgs
 *                     {
 *                         End = 52,
 *                         Start = 51,
 *                     },
 *                 },
 *                 Markings = new[]
 *                 {
 *                     2,
 *                 },
 *                 Protocol = "Udp",
 *                 SourceIpRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosIpRangeArgs
 *                     {
 *                         EndIP = "12.0.0.2",
 *                         StartIP = "12.0.0.1",
 *                     },
 *                 },
 *                 SourcePortRanges = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.QosPortRangeArgs
 *                     {
 *                         End = 12,
 *                         Start = 11,
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewDscpConfiguration(ctx, "dscpConfiguration", &network.DscpConfigurationArgs{
 * 			DscpConfigurationName: pulumi.String("mydscpconfig"),
 * 			Location:              pulumi.String("eastus"),
 * 			QosDefinitionCollection: []network.QosDefinitionArgs{
 * 				{
 * 					DestinationIpRanges: network.QosIpRangeArray{
 * 						{
 * 							EndIP:   pulumi.String("127.0.10.2"),
 * 							StartIP: pulumi.String("127.0.10.1"),
 * 						},
 * 					},
 * 					DestinationPortRanges: network.QosPortRangeArray{
 * 						{
 * 							End:   pulumi.Int(15),
 * 							Start: pulumi.Int(15),
 * 						},
 * 					},
 * 					Markings: pulumi.IntArray{
 * 						pulumi.Int(1),
 * 					},
 * 					Protocol: pulumi.String("Tcp"),
 * 					SourceIpRanges: network.QosIpRangeArray{
 * 						{
 * 							EndIP:   pulumi.String("127.0.0.2"),
 * 							StartIP: pulumi.String("127.0.0.1"),
 * 						},
 * 					},
 * 					SourcePortRanges: network.QosPortRangeArray{
 * 						{
 * 							End:   pulumi.Int(11),
 * 							Start: pulumi.Int(10),
 * 						},
 * 						{
 * 							End:   pulumi.Int(21),
 * 							Start: pulumi.Int(20),
 * 						},
 * 					},
 * 				},
 * 				{
 * 					DestinationIpRanges: network.QosIpRangeArray{
 * 						{
 * 							EndIP:   pulumi.String("12.0.10.2"),
 * 							StartIP: pulumi.String("12.0.10.1"),
 * 						},
 * 					},
 * 					DestinationPortRanges: network.QosPortRangeArray{
 * 						{
 * 							End:   pulumi.Int(52),
 * 							Start: pulumi.Int(51),
 * 						},
 * 					},
 * 					Markings: pulumi.IntArray{
 * 						pulumi.Int(2),
 * 					},
 * 					Protocol: pulumi.String("Udp"),
 * 					SourceIpRanges: network.QosIpRangeArray{
 * 						{
 * 							EndIP:   pulumi.String("12.0.0.2"),
 * 							StartIP: pulumi.String("12.0.0.1"),
 * 						},
 * 					},
 * 					SourcePortRanges: network.QosPortRangeArray{
 * 						{
 * 							End:   pulumi.Int(12),
 * 							Start: pulumi.Int(11),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.DscpConfiguration;
 * import com.pulumi.azurenative.network.DscpConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dscpConfiguration = new DscpConfiguration("dscpConfiguration", DscpConfigurationArgs.builder()
 *             .dscpConfigurationName("mydscpconfig")
 *             .location("eastus")
 *             .qosDefinitionCollection(
 *                 Map.ofEntries(
 *                     Map.entry("destinationIpRanges", Map.ofEntries(
 *                         Map.entry("endIP", "127.0.10.2"),
 *                         Map.entry("startIP", "127.0.10.1")
 *                     )),
 *                     Map.entry("destinationPortRanges", Map.ofEntries(
 *                         Map.entry("end", 15),
 *                         Map.entry("start", 15)
 *                     )),
 *                     Map.entry("markings", 1),
 *                     Map.entry("protocol", "Tcp"),
 *                     Map.entry("sourceIpRanges", Map.ofEntries(
 *                         Map.entry("endIP", "127.0.0.2"),
 *                         Map.entry("startIP", "127.0.0.1")
 *                     )),
 *                     Map.entry("sourcePortRanges",
 *                         Map.ofEntries(
 *                             Map.entry("end", 11),
 *                             Map.entry("start", 10)
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("end", 21),
 *                             Map.entry("start", 20)
 *                         ))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("destinationIpRanges", Map.ofEntries(
 *                         Map.entry("endIP", "12.0.10.2"),
 *                         Map.entry("startIP", "12.0.10.1")
 *                     )),
 *                     Map.entry("destinationPortRanges", Map.ofEntries(
 *                         Map.entry("end", 52),
 *                         Map.entry("start", 51)
 *                     )),
 *                     Map.entry("markings", 2),
 *                     Map.entry("protocol", "Udp"),
 *                     Map.entry("sourceIpRanges", Map.ofEntries(
 *                         Map.entry("endIP", "12.0.0.2"),
 *                         Map.entry("startIP", "12.0.0.1")
 *                     )),
 *                     Map.entry("sourcePortRanges", Map.ofEntries(
 *                         Map.entry("end", 12),
 *                         Map.entry("start", 11)
 *                     ))
 *                 ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:DscpConfiguration mydscpConfig /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dscpConfigurations/{dscpConfigurationName}
 * ```
 * @property destinationIpRanges Destination IP ranges.
 * @property destinationPortRanges Destination port ranges.
 * @property dscpConfigurationName The name of the resource.
 * @property id Resource ID.
 * @property location Resource location.
 * @property markings List of markings to be used in the configuration.
 * @property protocol RNM supported protocol types.
 * @property qosDefinitionCollection QoS object definitions
 * @property resourceGroupName The name of the resource group.
 * @property sourceIpRanges Source IP ranges.
 * @property sourcePortRanges Sources port ranges.
 * @property tags Resource tags.
 */
public data class DscpConfigurationArgs(
    public val destinationIpRanges: Output<List<QosIpRangeArgs>>? = null,
    public val destinationPortRanges: Output<List<QosPortRangeArgs>>? = null,
    public val dscpConfigurationName: Output<String>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val markings: Output<List<Int>>? = null,
    public val protocol: Output<Either<String, ProtocolType>>? = null,
    public val qosDefinitionCollection: Output<List<QosDefinitionArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceIpRanges: Output<List<QosIpRangeArgs>>? = null,
    public val sourcePortRanges: Output<List<QosPortRangeArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.DscpConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.DscpConfigurationArgs =
        com.pulumi.azurenative.network.DscpConfigurationArgs.builder()
            .destinationIpRanges(
                destinationIpRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .destinationPortRanges(
                destinationPortRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dscpConfigurationName(dscpConfigurationName?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .markings(markings?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .qosDefinitionCollection(
                qosDefinitionCollection?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceIpRanges(
                sourceIpRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourcePortRanges(
                sourcePortRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DscpConfigurationArgs].
 */
@PulumiTagMarker
public class DscpConfigurationArgsBuilder internal constructor() {
    private var destinationIpRanges: Output<List<QosIpRangeArgs>>? = null

    private var destinationPortRanges: Output<List<QosPortRangeArgs>>? = null

    private var dscpConfigurationName: Output<String>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var markings: Output<List<Int>>? = null

    private var protocol: Output<Either<String, ProtocolType>>? = null

    private var qosDefinitionCollection: Output<List<QosDefinitionArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceIpRanges: Output<List<QosIpRangeArgs>>? = null

    private var sourcePortRanges: Output<List<QosPortRangeArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Destination IP ranges.
     */
    @JvmName("hojosaeaquumbxoy")
    public suspend fun destinationIpRanges(`value`: Output<List<QosIpRangeArgs>>) {
        this.destinationIpRanges = value
    }

    @JvmName("rxlaaldslcogksat")
    public suspend fun destinationIpRanges(vararg values: Output<QosIpRangeArgs>) {
        this.destinationIpRanges = Output.all(values.asList())
    }

    /**
     * @param values Destination IP ranges.
     */
    @JvmName("rdmgpsqfliqbkoyv")
    public suspend fun destinationIpRanges(values: List<Output<QosIpRangeArgs>>) {
        this.destinationIpRanges = Output.all(values)
    }

    /**
     * @param value Destination port ranges.
     */
    @JvmName("gwehgljepxcwrapf")
    public suspend fun destinationPortRanges(`value`: Output<List<QosPortRangeArgs>>) {
        this.destinationPortRanges = value
    }

    @JvmName("yiycbvcrrtwtexiy")
    public suspend fun destinationPortRanges(vararg values: Output<QosPortRangeArgs>) {
        this.destinationPortRanges = Output.all(values.asList())
    }

    /**
     * @param values Destination port ranges.
     */
    @JvmName("roaeqqsgnnikliyl")
    public suspend fun destinationPortRanges(values: List<Output<QosPortRangeArgs>>) {
        this.destinationPortRanges = Output.all(values)
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("ctyublolvlkehfhx")
    public suspend fun dscpConfigurationName(`value`: Output<String>) {
        this.dscpConfigurationName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("wvxuntbrhksqoysb")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xwmbxumodwtlgwvi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value List of markings to be used in the configuration.
     */
    @JvmName("abayadvveupwjdcm")
    public suspend fun markings(`value`: Output<List<Int>>) {
        this.markings = value
    }

    @JvmName("cxtifqradxihluhw")
    public suspend fun markings(vararg values: Output<Int>) {
        this.markings = Output.all(values.asList())
    }

    /**
     * @param values List of markings to be used in the configuration.
     */
    @JvmName("wmuyhteocipepcht")
    public suspend fun markings(values: List<Output<Int>>) {
        this.markings = Output.all(values)
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("gylgcgojtcmpybme")
    public suspend fun protocol(`value`: Output<Either<String, ProtocolType>>) {
        this.protocol = value
    }

    /**
     * @param value QoS object definitions
     */
    @JvmName("hfcxqgnlidjhwdbu")
    public suspend fun qosDefinitionCollection(`value`: Output<List<QosDefinitionArgs>>) {
        this.qosDefinitionCollection = value
    }

    @JvmName("jmyoshxvvjuugiau")
    public suspend fun qosDefinitionCollection(vararg values: Output<QosDefinitionArgs>) {
        this.qosDefinitionCollection = Output.all(values.asList())
    }

    /**
     * @param values QoS object definitions
     */
    @JvmName("tqobkpjxyykawqhx")
    public suspend fun qosDefinitionCollection(values: List<Output<QosDefinitionArgs>>) {
        this.qosDefinitionCollection = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("indpoxvmdlbttjtw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Source IP ranges.
     */
    @JvmName("uyabmvrhvthjsjmf")
    public suspend fun sourceIpRanges(`value`: Output<List<QosIpRangeArgs>>) {
        this.sourceIpRanges = value
    }

    @JvmName("ehkbrxihkumiytid")
    public suspend fun sourceIpRanges(vararg values: Output<QosIpRangeArgs>) {
        this.sourceIpRanges = Output.all(values.asList())
    }

    /**
     * @param values Source IP ranges.
     */
    @JvmName("tdnklkcudvicqdnu")
    public suspend fun sourceIpRanges(values: List<Output<QosIpRangeArgs>>) {
        this.sourceIpRanges = Output.all(values)
    }

    /**
     * @param value Sources port ranges.
     */
    @JvmName("ddpuajvebqsfrnkk")
    public suspend fun sourcePortRanges(`value`: Output<List<QosPortRangeArgs>>) {
        this.sourcePortRanges = value
    }

    @JvmName("gvtfapbobgaxwqbt")
    public suspend fun sourcePortRanges(vararg values: Output<QosPortRangeArgs>) {
        this.sourcePortRanges = Output.all(values.asList())
    }

    /**
     * @param values Sources port ranges.
     */
    @JvmName("qeminpgtcdsaucrw")
    public suspend fun sourcePortRanges(values: List<Output<QosPortRangeArgs>>) {
        this.sourcePortRanges = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("eclqekvxdfacdnmo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Destination IP ranges.
     */
    @JvmName("htsnaxgarmlxndls")
    public suspend fun destinationIpRanges(`value`: List<QosIpRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationIpRanges = mapped
    }

    /**
     * @param argument Destination IP ranges.
     */
    @JvmName("iprbvmyffapkvlmy")
    public suspend fun destinationIpRanges(argument: List<suspend QosIpRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.destinationIpRanges = mapped
    }

    /**
     * @param argument Destination IP ranges.
     */
    @JvmName("anpxidamkjatpbsq")
    public suspend fun destinationIpRanges(
        vararg
        argument: suspend QosIpRangeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.destinationIpRanges = mapped
    }

    /**
     * @param argument Destination IP ranges.
     */
    @JvmName("jwlerptexocyuqac")
    public suspend fun destinationIpRanges(argument: suspend QosIpRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosIpRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.destinationIpRanges = mapped
    }

    /**
     * @param values Destination IP ranges.
     */
    @JvmName("aevbstxitvfronoc")
    public suspend fun destinationIpRanges(vararg values: QosIpRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationIpRanges = mapped
    }

    /**
     * @param value Destination port ranges.
     */
    @JvmName("qehxouoetabciefo")
    public suspend fun destinationPortRanges(`value`: List<QosPortRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param argument Destination port ranges.
     */
    @JvmName("cbuqwrrxoudhxymr")
    public suspend
    fun destinationPortRanges(argument: List<suspend QosPortRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationPortRanges = mapped
    }

    /**
     * @param argument Destination port ranges.
     */
    @JvmName("frutughybwysrowi")
    public suspend fun destinationPortRanges(
        vararg
        argument: suspend QosPortRangeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinationPortRanges = mapped
    }

    /**
     * @param argument Destination port ranges.
     */
    @JvmName("onyolgpjtffgcnya")
    public suspend fun destinationPortRanges(argument: suspend QosPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosPortRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.destinationPortRanges = mapped
    }

    /**
     * @param values Destination port ranges.
     */
    @JvmName("kfalsxleoftiujcb")
    public suspend fun destinationPortRanges(vararg values: QosPortRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationPortRanges = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("uuaffnsngdtcmbnr")
    public suspend fun dscpConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dscpConfigurationName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("pbgrexonucawomhr")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("tjtfscflyaslrenx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value List of markings to be used in the configuration.
     */
    @JvmName("pnjigmavihhdcain")
    public suspend fun markings(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.markings = mapped
    }

    /**
     * @param values List of markings to be used in the configuration.
     */
    @JvmName("hnadmfhxacctmlvo")
    public suspend fun markings(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.markings = mapped
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("afcwkmmmomomhuwx")
    public suspend fun protocol(`value`: Either<String, ProtocolType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("hshsxqbjrhlbvshs")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value RNM supported protocol types.
     */
    @JvmName("fmincieyinjkykdm")
    public fun protocol(`value`: ProtocolType) {
        val toBeMapped = Either.ofRight<String, ProtocolType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value QoS object definitions
     */
    @JvmName("ybdimfvhnhbsussc")
    public suspend fun qosDefinitionCollection(`value`: List<QosDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qosDefinitionCollection = mapped
    }

    /**
     * @param argument QoS object definitions
     */
    @JvmName("igjjtywbvkbnxubx")
    public suspend
    fun qosDefinitionCollection(argument: List<suspend QosDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QosDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.qosDefinitionCollection = mapped
    }

    /**
     * @param argument QoS object definitions
     */
    @JvmName("eeiytpbkjmfcxyiy")
    public suspend fun qosDefinitionCollection(
        vararg
        argument: suspend QosDefinitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            QosDefinitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.qosDefinitionCollection = mapped
    }

    /**
     * @param argument QoS object definitions
     */
    @JvmName("gylihuyxeijoriaq")
    public suspend
    fun qosDefinitionCollection(argument: suspend QosDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosDefinitionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.qosDefinitionCollection = mapped
    }

    /**
     * @param values QoS object definitions
     */
    @JvmName("obvxllhnatltgdfd")
    public suspend fun qosDefinitionCollection(vararg values: QosDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.qosDefinitionCollection = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("kmljphjdxooqgftb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Source IP ranges.
     */
    @JvmName("xxurmsehcqaoenrc")
    public suspend fun sourceIpRanges(`value`: List<QosIpRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpRanges = mapped
    }

    /**
     * @param argument Source IP ranges.
     */
    @JvmName("hknmscdnorwrikcc")
    public suspend fun sourceIpRanges(argument: List<suspend QosIpRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sourceIpRanges = mapped
    }

    /**
     * @param argument Source IP ranges.
     */
    @JvmName("wvrrrqyswqfqaegq")
    public suspend fun sourceIpRanges(vararg argument: suspend QosIpRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { QosIpRangeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sourceIpRanges = mapped
    }

    /**
     * @param argument Source IP ranges.
     */
    @JvmName("yersuihgocidtoun")
    public suspend fun sourceIpRanges(argument: suspend QosIpRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosIpRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sourceIpRanges = mapped
    }

    /**
     * @param values Source IP ranges.
     */
    @JvmName("wpvcmmuwwgabskjv")
    public suspend fun sourceIpRanges(vararg values: QosIpRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpRanges = mapped
    }

    /**
     * @param value Sources port ranges.
     */
    @JvmName("fbgllbcaeimscxlf")
    public suspend fun sourcePortRanges(`value`: List<QosPortRangeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param argument Sources port ranges.
     */
    @JvmName("ryoxstioxwlcrfga")
    public suspend fun sourcePortRanges(argument: List<suspend QosPortRangeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourcePortRanges = mapped
    }

    /**
     * @param argument Sources port ranges.
     */
    @JvmName("jqdmkakcuypffqym")
    public suspend fun sourcePortRanges(vararg argument: suspend QosPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            QosPortRangeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sourcePortRanges = mapped
    }

    /**
     * @param argument Sources port ranges.
     */
    @JvmName("vxhouxbfomvfykjm")
    public suspend fun sourcePortRanges(argument: suspend QosPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(QosPortRangeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sourcePortRanges = mapped
    }

    /**
     * @param values Sources port ranges.
     */
    @JvmName("ncborsshowbvtggf")
    public suspend fun sourcePortRanges(vararg values: QosPortRangeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePortRanges = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vwfuaadnnldbtmrc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vkjjtvuekhtxjnic")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DscpConfigurationArgs = DscpConfigurationArgs(
        destinationIpRanges = destinationIpRanges,
        destinationPortRanges = destinationPortRanges,
        dscpConfigurationName = dscpConfigurationName,
        id = id,
        location = location,
        markings = markings,
        protocol = protocol,
        qosDefinitionCollection = qosDefinitionCollection,
        resourceGroupName = resourceGroupName,
        sourceIpRanges = sourceIpRanges,
        sourcePortRanges = sourcePortRanges,
        tags = tags,
    )
}
