@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.EndpointPropertiesResponseCustomHeaders
import com.pulumi.azurenative.network.kotlin.outputs.EndpointPropertiesResponseSubnets
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.network.kotlin.outputs.EndpointPropertiesResponseCustomHeaders.Companion.toKotlin as endpointPropertiesResponseCustomHeadersToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.EndpointPropertiesResponseSubnets.Companion.toKotlin as endpointPropertiesResponseSubnetsToKotlin

/**
 * Builder for [Endpoint].
 */
@PulumiTagMarker
public class EndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EndpointArgs = EndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EndpointArgsBuilder.() -> Unit) {
        val builder = EndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Endpoint {
        val builtJavaResource = com.pulumi.azurenative.network.Endpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Endpoint(builtJavaResource)
    }
}

/**
 * Class representing a Traffic Manager endpoint.
 * Azure REST API version: 2022-04-01. Prior API version in Azure Native 1.x: 2018-08-01.
 * Other available API versions: 2017-03-01, 2018-02-01, 2022-04-01-preview.
 * ## Example Usage
 * ### Endpoint-PUT-External-WithAlwaysServe
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.Network.Endpoint("endpoint", new()
 *     {
 *         AlwaysServe = "Enabled",
 *         EndpointLocation = "North Europe",
 *         EndpointName = "azsmnet7187",
 *         EndpointStatus = "Enabled",
 *         EndpointType = "ExternalEndpoints",
 *         Name = "azsmnet7187",
 *         ProfileName = "azsmnet6386",
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager1421",
 *         Target = "foobar.contoso.com",
 *         Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewEndpoint(ctx, "endpoint", &network.EndpointArgs{
 * 			AlwaysServe:       pulumi.String("Enabled"),
 * 			EndpointLocation:  pulumi.String("North Europe"),
 * 			EndpointName:      pulumi.String("azsmnet7187"),
 * 			EndpointStatus:    pulumi.String("Enabled"),
 * 			EndpointType:      pulumi.String("ExternalEndpoints"),
 * 			Name:              pulumi.String("azsmnet7187"),
 * 			ProfileName:       pulumi.String("azsmnet6386"),
 * 			ResourceGroupName: pulumi.String("azuresdkfornetautoresttrafficmanager1421"),
 * 			Target:            pulumi.String("foobar.contoso.com"),
 * 			Type:              pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Endpoint;
 * import com.pulumi.azurenative.network.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .alwaysServe("Enabled")
 *             .endpointLocation("North Europe")
 *             .endpointName("azsmnet7187")
 *             .endpointStatus("Enabled")
 *             .endpointType("ExternalEndpoints")
 *             .name("azsmnet7187")
 *             .profileName("azsmnet6386")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager1421")
 *             .target("foobar.contoso.com")
 *             .type("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *             .build());
 *     }
 * }
 * ```
 * ### Endpoint-PUT-External-WithCustomHeaders
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.Network.Endpoint("endpoint", new()
 *     {
 *         CustomHeaders = new[]
 *         {
 *             new AzureNative.Network.Inputs.EndpointPropertiesCustomHeadersArgs
 *             {
 *                 Name = "header-1",
 *                 Value = "value-1",
 *             },
 *             new AzureNative.Network.Inputs.EndpointPropertiesCustomHeadersArgs
 *             {
 *                 Name = "header-2",
 *                 Value = "value-2",
 *             },
 *         },
 *         EndpointLocation = "North Europe",
 *         EndpointName = "azsmnet7187",
 *         EndpointStatus = "Enabled",
 *         EndpointType = "ExternalEndpoints",
 *         Name = "azsmnet7187",
 *         ProfileName = "azsmnet6386",
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager1421",
 *         Target = "foobar.contoso.com",
 *         Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewEndpoint(ctx, "endpoint", &network.EndpointArgs{
 * 			CustomHeaders: []network.EndpointPropertiesCustomHeadersArgs{
 * 				{
 * 					Name:  pulumi.String("header-1"),
 * 					Value: pulumi.String("value-1"),
 * 				},
 * 				{
 * 					Name:  pulumi.String("header-2"),
 * 					Value: pulumi.String("value-2"),
 * 				},
 * 			},
 * 			EndpointLocation:  pulumi.String("North Europe"),
 * 			EndpointName:      pulumi.String("azsmnet7187"),
 * 			EndpointStatus:    pulumi.String("Enabled"),
 * 			EndpointType:      pulumi.String("ExternalEndpoints"),
 * 			Name:              pulumi.String("azsmnet7187"),
 * 			ProfileName:       pulumi.String("azsmnet6386"),
 * 			ResourceGroupName: pulumi.String("azuresdkfornetautoresttrafficmanager1421"),
 * 			Target:            pulumi.String("foobar.contoso.com"),
 * 			Type:              pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Endpoint;
 * import com.pulumi.azurenative.network.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .customHeaders(
 *                 Map.ofEntries(
 *                     Map.entry("name", "header-1"),
 *                     Map.entry("value", "value-1")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("name", "header-2"),
 *                     Map.entry("value", "value-2")
 *                 ))
 *             .endpointLocation("North Europe")
 *             .endpointName("azsmnet7187")
 *             .endpointStatus("Enabled")
 *             .endpointType("ExternalEndpoints")
 *             .name("azsmnet7187")
 *             .profileName("azsmnet6386")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager1421")
 *             .target("foobar.contoso.com")
 *             .type("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *             .build());
 *     }
 * }
 * ```
 * ### Endpoint-PUT-External-WithGeoMapping
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.Network.Endpoint("endpoint", new()
 *     {
 *         EndpointName = "My%20external%20endpoint",
 *         EndpointStatus = "Enabled",
 *         EndpointType = "ExternalEndpoints",
 *         GeoMapping = new[]
 *         {
 *             "GEO-AS",
 *             "GEO-AF",
 *         },
 *         Name = "My external endpoint",
 *         ProfileName = "azuresdkfornetautoresttrafficmanager8224",
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager2191",
 *         Target = "foobar.contoso.com",
 *         Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewEndpoint(ctx, "endpoint", &network.EndpointArgs{
 * 			EndpointName:   pulumi.String("My%20external%20endpoint"),
 * 			EndpointStatus: pulumi.String("Enabled"),
 * 			EndpointType:   pulumi.String("ExternalEndpoints"),
 * 			GeoMapping: pulumi.StringArray{
 * 				pulumi.String("GEO-AS"),
 * 				pulumi.String("GEO-AF"),
 * 			},
 * 			Name:              pulumi.String("My external endpoint"),
 * 			ProfileName:       pulumi.String("azuresdkfornetautoresttrafficmanager8224"),
 * 			ResourceGroupName: pulumi.String("azuresdkfornetautoresttrafficmanager2191"),
 * 			Target:            pulumi.String("foobar.contoso.com"),
 * 			Type:              pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Endpoint;
 * import com.pulumi.azurenative.network.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .endpointName("My%20external%20endpoint")
 *             .endpointStatus("Enabled")
 *             .endpointType("ExternalEndpoints")
 *             .geoMapping(
 *                 "GEO-AS",
 *                 "GEO-AF")
 *             .name("My external endpoint")
 *             .profileName("azuresdkfornetautoresttrafficmanager8224")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager2191")
 *             .target("foobar.contoso.com")
 *             .type("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *             .build());
 *     }
 * }
 * ```
 * ### Endpoint-PUT-External-WithLocation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.Network.Endpoint("endpoint", new()
 *     {
 *         EndpointLocation = "North Europe",
 *         EndpointName = "azsmnet7187",
 *         EndpointStatus = "Enabled",
 *         EndpointType = "ExternalEndpoints",
 *         Name = "azsmnet7187",
 *         ProfileName = "azsmnet6386",
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager1421",
 *         Target = "foobar.contoso.com",
 *         Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewEndpoint(ctx, "endpoint", &network.EndpointArgs{
 * 			EndpointLocation:  pulumi.String("North Europe"),
 * 			EndpointName:      pulumi.String("azsmnet7187"),
 * 			EndpointStatus:    pulumi.String("Enabled"),
 * 			EndpointType:      pulumi.String("ExternalEndpoints"),
 * 			Name:              pulumi.String("azsmnet7187"),
 * 			ProfileName:       pulumi.String("azsmnet6386"),
 * 			ResourceGroupName: pulumi.String("azuresdkfornetautoresttrafficmanager1421"),
 * 			Target:            pulumi.String("foobar.contoso.com"),
 * 			Type:              pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Endpoint;
 * import com.pulumi.azurenative.network.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .endpointLocation("North Europe")
 *             .endpointName("azsmnet7187")
 *             .endpointStatus("Enabled")
 *             .endpointType("ExternalEndpoints")
 *             .name("azsmnet7187")
 *             .profileName("azsmnet6386")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager1421")
 *             .target("foobar.contoso.com")
 *             .type("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *             .build());
 *     }
 * }
 * ```
 * ### Endpoint-PUT-External-WithSubnetMapping
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.Network.Endpoint("endpoint", new()
 *     {
 *         EndpointName = "My%20external%20endpoint",
 *         EndpointStatus = "Enabled",
 *         EndpointType = "ExternalEndpoints",
 *         Name = "My external endpoint",
 *         ProfileName = "azuresdkfornetautoresttrafficmanager8224",
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager2191",
 *         Subnets = new[]
 *         {
 *             new AzureNative.Network.Inputs.EndpointPropertiesSubnetsArgs
 *             {
 *                 First = "1.2.3.0",
 *                 Scope = 24,
 *             },
 *             new AzureNative.Network.Inputs.EndpointPropertiesSubnetsArgs
 *             {
 *                 First = "25.26.27.28",
 *                 Last = "29.30.31.32",
 *             },
 *         },
 *         Target = "foobar.contoso.com",
 *         Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewEndpoint(ctx, "endpoint", &network.EndpointArgs{
 * 			EndpointName:      pulumi.String("My%20external%20endpoint"),
 * 			EndpointStatus:    pulumi.String("Enabled"),
 * 			EndpointType:      pulumi.String("ExternalEndpoints"),
 * 			Name:              pulumi.String("My external endpoint"),
 * 			ProfileName:       pulumi.String("azuresdkfornetautoresttrafficmanager8224"),
 * 			ResourceGroupName: pulumi.String("azuresdkfornetautoresttrafficmanager2191"),
 * 			Subnets: []network.EndpointPropertiesSubnetsArgs{
 * 				{
 * 					First: pulumi.String("1.2.3.0"),
 * 					Scope: pulumi.Int(24),
 * 				},
 * 				{
 * 					First: pulumi.String("25.26.27.28"),
 * 					Last:  pulumi.String("29.30.31.32"),
 * 				},
 * 			},
 * 			Target: pulumi.String("foobar.contoso.com"),
 * 			Type:   pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Endpoint;
 * import com.pulumi.azurenative.network.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .endpointName("My%20external%20endpoint")
 *             .endpointStatus("Enabled")
 *             .endpointType("ExternalEndpoints")
 *             .name("My external endpoint")
 *             .profileName("azuresdkfornetautoresttrafficmanager8224")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager2191")
 *             .subnets(
 *                 Map.ofEntries(
 *                     Map.entry("first", "1.2.3.0"),
 *                     Map.entry("scope", 24)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("first", "25.26.27.28"),
 *                     Map.entry("last", "29.30.31.32")
 *                 ))
 *             .target("foobar.contoso.com")
 *             .type("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:Endpoint My external endpoint /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}/{endpointType}/{endpointName}
 * ```
 */
public class Endpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.network.Endpoint,
) : KotlinCustomResource(javaResource, EndpointMapper) {
    /**
     * If Always Serve is enabled, probing for endpoint health will be disabled and endpoints will be included in the traffic routing method.
     */
    public val alwaysServe: Output<String>?
        get() = javaResource.alwaysServe().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of custom headers.
     */
    public val customHeaders: Output<List<EndpointPropertiesResponseCustomHeaders>>?
        get() = javaResource.customHeaders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        endpointPropertiesResponseCustomHeadersToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Specifies the location of the external or nested endpoints when using the 'Performance' traffic routing method.
     */
    public val endpointLocation: Output<String>?
        get() = javaResource.endpointLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The monitoring status of the endpoint.
     */
    public val endpointMonitorStatus: Output<String>?
        get() = javaResource.endpointMonitorStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the endpoint. If the endpoint is Enabled, it is probed for endpoint health and is included in the traffic routing method.
     */
    public val endpointStatus: Output<String>?
        get() = javaResource.endpointStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of countries/regions mapped to this endpoint when using the 'Geographic' traffic routing method. Please consult Traffic Manager Geographic documentation for a full list of accepted values.
     */
    public val geoMapping: Output<List<String>>?
        get() = javaResource.geoMapping().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The minimum number of endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    public val minChildEndpoints: Output<Double>?
        get() = javaResource.minChildEndpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The minimum number of IPv4 (DNS record type A) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    public val minChildEndpointsIPv4: Output<Double>?
        get() = javaResource.minChildEndpointsIPv4().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The minimum number of IPv6 (DNS record type AAAA) endpoints that must be available in the child profile in order for the parent profile to be considered available. Only applicable to endpoint of type 'NestedEndpoints'.
     */
    public val minChildEndpointsIPv6: Output<Double>?
        get() = javaResource.minChildEndpointsIPv6().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The priority of this endpoint when using the 'Priority' traffic routing method. Possible values are from 1 to 1000, lower values represent higher priority. This is an optional parameter.  If specified, it must be specified on all endpoints, and no two endpoints can share the same priority value.
     */
    public val priority: Output<Double>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The list of subnets, IP addresses, and/or address ranges mapped to this endpoint when using the 'Subnet' traffic routing method. An empty list will match all ranges not covered by other endpoints.
     */
    public val subnets: Output<List<EndpointPropertiesResponseSubnets>>?
        get() = javaResource.subnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> endpointPropertiesResponseSubnetsToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The fully-qualified DNS name or IP address of the endpoint. Traffic Manager returns this value in DNS responses to direct traffic to this endpoint.
     */
    public val target: Output<String>?
        get() = javaResource.target().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Azure Resource URI of the of the endpoint. Not applicable to endpoints of type 'ExternalEndpoints'.
     */
    public val targetResourceId: Output<String>?
        get() = javaResource.targetResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The weight of this endpoint when using the 'Weighted' traffic routing method. Possible values are from 1 to 1000.
     */
    public val weight: Output<Double>?
        get() = javaResource.weight().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object EndpointMapper : ResourceMapper<Endpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.Endpoint::class == javaResource::class

    override fun map(javaResource: Resource): Endpoint = Endpoint(
        javaResource as
            com.pulumi.azurenative.network.Endpoint,
    )
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Endpoint].
 */
public suspend fun endpoint(name: String, block: suspend EndpointResourceBuilder.() -> Unit):
    Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Endpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun endpoint(name: String): Endpoint {
    val builder = EndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
