@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitPeeringIdResponse
import com.pulumi.azurenative.network.kotlin.outputs.RoutingConfigurationResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitPeeringIdResponse.Companion.toKotlin as expressRouteCircuitPeeringIdResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.RoutingConfigurationResponse.Companion.toKotlin as routingConfigurationResponseToKotlin

/**
 * Builder for [ExpressRouteConnection].
 */
@PulumiTagMarker
public class ExpressRouteConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExpressRouteConnectionArgs = ExpressRouteConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExpressRouteConnectionArgsBuilder.() -> Unit) {
        val builder = ExpressRouteConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ExpressRouteConnection {
        val builtJavaResource =
            com.pulumi.azurenative.network.ExpressRouteConnection(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ExpressRouteConnection(builtJavaResource)
    }
}

/**
 * ExpressRouteConnection resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### ExpressRouteConnectionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var expressRouteConnection = new AzureNative.Network.ExpressRouteConnection("expressRouteConnection", new()
 *     {
 *         AuthorizationKey = "authorizationKey",
 *         ConnectionName = "connectionName",
 *         ExpressRouteCircuitPeering = new AzureNative.Network.Inputs.ExpressRouteCircuitPeeringIdArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteCircuits/circuitName/peerings/AzurePrivatePeering",
 *         },
 *         ExpressRouteGatewayName = "gateway-2",
 *         Id = "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteGateways/gateway-2/expressRouteConnections/connectionName",
 *         Name = "connectionName",
 *         ResourceGroupName = "resourceGroupName",
 *         RoutingConfiguration = new AzureNative.Network.Inputs.RoutingConfigurationArgs
 *         {
 *             AssociatedRouteTable = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1",
 *             },
 *             InboundRouteMap = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1",
 *             },
 *             OutboundRouteMap = new AzureNative.Network.Inputs.SubResourceArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2",
 *             },
 *             PropagatedRouteTables = new AzureNative.Network.Inputs.PropagatedRouteTableArgs
 *             {
 *                 Ids = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1",
 *                     },
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable2",
 *                     },
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable3",
 *                     },
 *                 },
 *                 Labels = new[]
 *                 {
 *                     "label1",
 *                     "label2",
 *                 },
 *             },
 *         },
 *         RoutingWeight = 2,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := network.NewExpressRouteConnection(ctx, "expressRouteConnection", &network.ExpressRouteConnectionArgs{
 * AuthorizationKey: pulumi.String("authorizationKey"),
 * ConnectionName: pulumi.String("connectionName"),
 * ExpressRouteCircuitPeering: &network.ExpressRouteCircuitPeeringIdArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteCircuits/circuitName/peerings/AzurePrivatePeering"),
 * },
 * ExpressRouteGatewayName: pulumi.String("gateway-2"),
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteGateways/gateway-2/expressRouteConnections/connectionName"),
 * Name: pulumi.String("connectionName"),
 * ResourceGroupName: pulumi.String("resourceGroupName"),
 * RoutingConfiguration: network.RoutingConfigurationResponse{
 * AssociatedRouteTable: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1"),
 * },
 * InboundRouteMap: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1"),
 * },
 * OutboundRouteMap: &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2"),
 * },
 * PropagatedRouteTables: interface{}{
 * Ids: network.SubResourceArray{
 * &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1"),
 * },
 * &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable2"),
 * },
 * &network.SubResourceArgs{
 * Id: pulumi.String("/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable3"),
 * },
 * },
 * Labels: pulumi.StringArray{
 * pulumi.String("label1"),
 * pulumi.String("label2"),
 * },
 * },
 * },
 * RoutingWeight: pulumi.Int(2),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ExpressRouteConnection;
 * import com.pulumi.azurenative.network.ExpressRouteConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var expressRouteConnection = new ExpressRouteConnection("expressRouteConnection", ExpressRouteConnectionArgs.builder()
 *             .authorizationKey("authorizationKey")
 *             .connectionName("connectionName")
 *             .expressRouteCircuitPeering(Map.of("id", "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteCircuits/circuitName/peerings/AzurePrivatePeering"))
 *             .expressRouteGatewayName("gateway-2")
 *             .id("/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/expressRouteGateways/gateway-2/expressRouteConnections/connectionName")
 *             .name("connectionName")
 *             .resourceGroupName("resourceGroupName")
 *             .routingConfiguration(Map.ofEntries(
 *                 Map.entry("associatedRouteTable", Map.of("id", "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1")),
 *                 Map.entry("inboundRouteMap", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap1")),
 *                 Map.entry("outboundRouteMap", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/routeMaps/routeMap2")),
 *                 Map.entry("propagatedRouteTables", Map.ofEntries(
 *                     Map.entry("ids",
 *                         Map.of("id", "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable1"),
 *                         Map.of("id", "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable2"),
 *                         Map.of("id", "/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.Network/virtualHubs/hub1/hubRouteTables/hubRouteTable3")),
 *                     Map.entry("labels",
 *                         "label1",
 *                         "label2")
 *                 ))
 *             ))
 *             .routingWeight(2)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ExpressRouteConnection connectionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}/expressRouteConnections/{connectionName}
 * ```
 */
public class ExpressRouteConnection internal constructor(
    override val javaResource: com.pulumi.azurenative.network.ExpressRouteConnection,
) : KotlinCustomResource(javaResource, ExpressRouteConnectionMapper) {
    /**
     * Authorization key to establish the connection.
     */
    public val authorizationKey: Output<String>?
        get() = javaResource.authorizationKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable internet security.
     */
    public val enableInternetSecurity: Output<Boolean>?
        get() = javaResource.enableInternetSecurity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
     */
    public val enablePrivateLinkFastPath: Output<Boolean>?
        get() = javaResource.enablePrivateLinkFastPath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ExpressRoute circuit peering.
     */
    public val expressRouteCircuitPeering: Output<ExpressRouteCircuitPeeringIdResponse>
        get() = javaResource.expressRouteCircuitPeering().applyValue({ args0 ->
            args0.let({ args0 ->
                expressRouteCircuitPeeringIdResponseToKotlin(args0)
            })
        })

    /**
     * Enable FastPath to vWan Firewall hub.
     */
    public val expressRouteGatewayBypass: Output<Boolean>?
        get() = javaResource.expressRouteGatewayBypass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the express route connection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    public val routingConfiguration: Output<RoutingConfigurationResponse>?
        get() = javaResource.routingConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> routingConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The routing weight associated to the connection.
     */
    public val routingWeight: Output<Int>?
        get() = javaResource.routingWeight().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ExpressRouteConnectionMapper : ResourceMapper<ExpressRouteConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.ExpressRouteConnection::class == javaResource::class

    override fun map(javaResource: Resource): ExpressRouteConnection =
        ExpressRouteConnection(javaResource as com.pulumi.azurenative.network.ExpressRouteConnection)
}

/**
 * @see [ExpressRouteConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExpressRouteConnection].
 */
public suspend fun expressRouteConnection(
    name: String,
    block: suspend ExpressRouteConnectionResourceBuilder.() -> Unit,
): ExpressRouteConnection {
    val builder = ExpressRouteConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExpressRouteConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun expressRouteConnection(name: String): ExpressRouteConnection {
    val builder = ExpressRouteConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
