@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.LoadBalancerArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.BackendAddressPoolArgs
import com.pulumi.azurenative.network.kotlin.inputs.BackendAddressPoolArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.FrontendIPConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.FrontendIPConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.InboundNatPoolArgs
import com.pulumi.azurenative.network.kotlin.inputs.InboundNatPoolArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.InboundNatRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.InboundNatRuleArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.LoadBalancerSkuArgs
import com.pulumi.azurenative.network.kotlin.inputs.LoadBalancerSkuArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.LoadBalancingRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.LoadBalancingRuleArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.OutboundRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.OutboundRuleArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ProbeArgs
import com.pulumi.azurenative.network.kotlin.inputs.ProbeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * LoadBalancer resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2018-06-01, 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create load balancer
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         InboundNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatRuleArgs
 *             {
 *                 BackendPort = 3389,
 *                 EnableFloatingIP = true,
 *                 EnableTcpReset = false,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 3389,
 *                 IdleTimeoutInMinutes = 15,
 *                 Name = "in-nat-rule",
 *                 Protocol = "Tcp",
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 EnableFloatingIP = true,
 *                 EnableTcpReset = false,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = "Default",
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = "Tcp",
 *             },
 *         },
 *         Location = "eastus",
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = "Http",
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: []network.BackendAddressPoolArgs{
 * 				{
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: []network.FrontendIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{},
 * 			InboundNatRules: []network.InboundNatRuleTypeArgs{
 * 				{
 * 					BackendPort:      pulumi.Int(3389),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					EnableTcpReset:   pulumi.Bool(false),
 * 					FrontendIPConfiguration: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(3389),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					Name:                 pulumi.String("in-nat-rule"),
 * 					Protocol:             pulumi.String("Tcp"),
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: []network.LoadBalancingRuleArgs{
 * 				{
 * 					BackendAddressPool: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:      pulumi.Int(80),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					EnableTcpReset:   pulumi.Bool(false),
 * 					FrontendIPConfiguration: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String("Default"),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String("Tcp"),
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Probes: []network.ProbeArgs{
 * 				{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String("Http"),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(Map.of("name", "be-lb"))
 *             .frontendIPConfigurations(Map.ofEntries(
 *                 Map.entry("name", "fe-lb"),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"))
 *             ))
 *             .inboundNatPools()
 *             .inboundNatRules(Map.ofEntries(
 *                 Map.entry("backendPort", 3389),
 *                 Map.entry("enableFloatingIP", true),
 *                 Map.entry("enableTcpReset", false),
 *                 Map.entry("frontendIPConfiguration", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")),
 *                 Map.entry("frontendPort", 3389),
 *                 Map.entry("idleTimeoutInMinutes", 15),
 *                 Map.entry("name", "in-nat-rule"),
 *                 Map.entry("protocol", "Tcp")
 *             ))
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(Map.ofEntries(
 *                 Map.entry("backendAddressPool", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")),
 *                 Map.entry("backendPort", 80),
 *                 Map.entry("enableFloatingIP", true),
 *                 Map.entry("enableTcpReset", false),
 *                 Map.entry("frontendIPConfiguration", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")),
 *                 Map.entry("frontendPort", 80),
 *                 Map.entry("idleTimeoutInMinutes", 15),
 *                 Map.entry("loadDistribution", "Default"),
 *                 Map.entry("name", "rulelb"),
 *                 Map.entry("probe", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")),
 *                 Map.entry("protocol", "Tcp")
 *             ))
 *             .location("eastus")
 *             .probes(Map.ofEntries(
 *                 Map.entry("intervalInSeconds", 15),
 *                 Map.entry("name", "probe-lb"),
 *                 Map.entry("numberOfProbes", 2),
 *                 Map.entry("port", 80),
 *                 Map.entry("probeThreshold", 1),
 *                 Map.entry("protocol", "Http"),
 *                 Map.entry("requestPath", "healthcheck.aspx")
 *             ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Frontend IP in Zone 1
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *                 Zones = new[]
 *                 {
 *                     "1",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         InboundNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatRuleArgs
 *             {
 *                 BackendPort = 3389,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 3389,
 *                 IdleTimeoutInMinutes = 15,
 *                 Name = "in-nat-rule",
 *                 Protocol = "Tcp",
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = "Default",
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = "Tcp",
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = "Http",
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: []network.BackendAddressPoolArgs{
 * 				{
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: []network.FrontendIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 					Zones: pulumi.StringArray{
 * 						pulumi.String("1"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{},
 * 			InboundNatRules: []network.InboundNatRuleTypeArgs{
 * 				{
 * 					BackendPort:      pulumi.Int(3389),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(3389),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					Name:                 pulumi.String("in-nat-rule"),
 * 					Protocol:             pulumi.String("Tcp"),
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: []network.LoadBalancingRuleArgs{
 * 				{
 * 					BackendAddressPool: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:      pulumi.Int(80),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String("Default"),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String("Tcp"),
 * 				},
 * 			},
 * 			Location:      pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{},
 * 			Probes: []network.ProbeArgs{
 * 				{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String("Http"),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(Map.of("name", "be-lb"))
 *             .frontendIPConfigurations(Map.ofEntries(
 *                 Map.entry("name", "fe-lb"),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb")),
 *                 Map.entry("zones", "1")
 *             ))
 *             .inboundNatPools()
 *             .inboundNatRules(Map.ofEntries(
 *                 Map.entry("backendPort", 3389),
 *                 Map.entry("enableFloatingIP", true),
 *                 Map.entry("frontendIPConfiguration", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")),
 *                 Map.entry("frontendPort", 3389),
 *                 Map.entry("idleTimeoutInMinutes", 15),
 *                 Map.entry("name", "in-nat-rule"),
 *                 Map.entry("protocol", "Tcp")
 *             ))
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(Map.ofEntries(
 *                 Map.entry("backendAddressPool", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")),
 *                 Map.entry("backendPort", 80),
 *                 Map.entry("enableFloatingIP", true),
 *                 Map.entry("frontendIPConfiguration", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")),
 *                 Map.entry("frontendPort", 80),
 *                 Map.entry("idleTimeoutInMinutes", 15),
 *                 Map.entry("loadDistribution", "Default"),
 *                 Map.entry("name", "rulelb"),
 *                 Map.entry("probe", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")),
 *                 Map.entry("protocol", "Tcp")
 *             ))
 *             .location("eastus")
 *             .outboundRules()
 *             .probes(Map.ofEntries(
 *                 Map.entry("intervalInSeconds", 15),
 *                 Map.entry("name", "probe-lb"),
 *                 Map.entry("numberOfProbes", 2),
 *                 Map.entry("port", 80),
 *                 Map.entry("probeThreshold", 1),
 *                 Map.entry("protocol", "Http"),
 *                 Map.entry("requestPath", "healthcheck.aspx")
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("name", "Standard"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Gateway Load Balancer Consumer configured
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 GatewayLoadBalancer = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb-provider",
 *                 },
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         InboundNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatRuleArgs
 *             {
 *                 BackendPort = 3389,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 3389,
 *                 IdleTimeoutInMinutes = 15,
 *                 Name = "in-nat-rule",
 *                 Protocol = "Tcp",
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = "Default",
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = "Tcp",
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = "Http",
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: []network.BackendAddressPoolArgs{
 * 				{
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: []network.FrontendIPConfigurationArgs{
 * 				{
 * 					GatewayLoadBalancer: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb-provider"),
 * 					},
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{},
 * 			InboundNatRules: []network.InboundNatRuleTypeArgs{
 * 				{
 * 					BackendPort:      pulumi.Int(3389),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(3389),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					Name:                 pulumi.String("in-nat-rule"),
 * 					Protocol:             pulumi.String("Tcp"),
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: []network.LoadBalancingRuleArgs{
 * 				{
 * 					BackendAddressPool: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:      pulumi.Int(80),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String("Default"),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String("Tcp"),
 * 				},
 * 			},
 * 			Location:      pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{},
 * 			Probes: []network.ProbeArgs{
 * 				{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String("Http"),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(Map.of("name", "be-lb"))
 *             .frontendIPConfigurations(Map.ofEntries(
 *                 Map.entry("gatewayLoadBalancer", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb-provider")),
 *                 Map.entry("name", "fe-lb"),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"))
 *             ))
 *             .inboundNatPools()
 *             .inboundNatRules(Map.ofEntries(
 *                 Map.entry("backendPort", 3389),
 *                 Map.entry("enableFloatingIP", true),
 *                 Map.entry("frontendIPConfiguration", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")),
 *                 Map.entry("frontendPort", 3389),
 *                 Map.entry("idleTimeoutInMinutes", 15),
 *                 Map.entry("name", "in-nat-rule"),
 *                 Map.entry("protocol", "Tcp")
 *             ))
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(Map.ofEntries(
 *                 Map.entry("backendAddressPool", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")),
 *                 Map.entry("backendPort", 80),
 *                 Map.entry("enableFloatingIP", true),
 *                 Map.entry("frontendIPConfiguration", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")),
 *                 Map.entry("frontendPort", 80),
 *                 Map.entry("idleTimeoutInMinutes", 15),
 *                 Map.entry("loadDistribution", "Default"),
 *                 Map.entry("name", "rulelb"),
 *                 Map.entry("probe", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")),
 *                 Map.entry("protocol", "Tcp")
 *             ))
 *             .location("eastus")
 *             .outboundRules()
 *             .probes(Map.ofEntries(
 *                 Map.entry("intervalInSeconds", 15),
 *                 Map.entry("name", "probe-lb"),
 *                 Map.entry("numberOfProbes", 2),
 *                 Map.entry("port", 80),
 *                 Map.entry("probeThreshold", 1),
 *                 Map.entry("protocol", "Http"),
 *                 Map.entry("requestPath", "healthcheck.aspx")
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("name", "Standard"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Gateway Load Balancer Provider configured with one Backend Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *                 TunnelInterfaces = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.GatewayLoadBalancerTunnelInterfaceArgs
 *                     {
 *                         Identifier = 900,
 *                         Port = 15000,
 *                         Protocol = "VXLAN",
 *                         Type = "Internal",
 *                     },
 *                     new AzureNative.Network.Inputs.GatewayLoadBalancerTunnelInterfaceArgs
 *                     {
 *                         Identifier = 901,
 *                         Port = 15001,
 *                         Protocol = "VXLAN",
 *                         Type = "Internal",
 *                     },
 *                 },
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPools = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                     },
 *                 },
 *                 BackendPort = 0,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 0,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = "Default",
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = "All",
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = "Http",
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = "Premium",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: []network.BackendAddressPoolArgs{
 * 				{
 * 					Name: pulumi.String("be-lb"),
 * 					TunnelInterfaces: network.GatewayLoadBalancerTunnelInterfaceArray{
 * 						{
 * 							Identifier: pulumi.Int(900),
 * 							Port:       pulumi.Int(15000),
 * 							Protocol:   pulumi.String("VXLAN"),
 * 							Type:       pulumi.String("Internal"),
 * 						},
 * 						{
 * 							Identifier: pulumi.Int(901),
 * 							Port:       pulumi.Int(15001),
 * 							Protocol:   pulumi.String("VXLAN"),
 * 							Type:       pulumi.String("Internal"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			FrontendIPConfigurations: []network.FrontendIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools:  network.InboundNatPoolArray{},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: []network.LoadBalancingRuleArgs{
 * 				{
 * 					BackendAddressPools: network.SubResourceArray{
 * 						{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 						},
 * 					},
 * 					BackendPort:      pulumi.Int(0),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(0),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String("Default"),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String("All"),
 * 				},
 * 			},
 * 			Location:      pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{},
 * 			Probes: []network.ProbeArgs{
 * 				{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String("Http"),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String("Premium"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(Map.ofEntries(
 *                 Map.entry("name", "be-lb"),
 *                 Map.entry("tunnelInterfaces",
 *                     Map.ofEntries(
 *                         Map.entry("identifier", 900),
 *                         Map.entry("port", 15000),
 *                         Map.entry("protocol", "VXLAN"),
 *                         Map.entry("type", "Internal")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("identifier", 901),
 *                         Map.entry("port", 15001),
 *                         Map.entry("protocol", "VXLAN"),
 *                         Map.entry("type", "Internal")
 *                     ))
 *             ))
 *             .frontendIPConfigurations(Map.ofEntries(
 *                 Map.entry("name", "fe-lb"),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"))
 *             ))
 *             .inboundNatPools()
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(Map.ofEntries(
 *                 Map.entry("backendAddressPools", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")),
 *                 Map.entry("backendPort", 0),
 *                 Map.entry("enableFloatingIP", true),
 *                 Map.entry("frontendIPConfiguration", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")),
 *                 Map.entry("frontendPort", 0),
 *                 Map.entry("idleTimeoutInMinutes", 15),
 *                 Map.entry("loadDistribution", "Default"),
 *                 Map.entry("name", "rulelb"),
 *                 Map.entry("probe", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")),
 *                 Map.entry("protocol", "All")
 *             ))
 *             .location("eastus")
 *             .outboundRules()
 *             .probes(Map.ofEntries(
 *                 Map.entry("intervalInSeconds", 15),
 *                 Map.entry("name", "probe-lb"),
 *                 Map.entry("numberOfProbes", 2),
 *                 Map.entry("port", 80),
 *                 Map.entry("probeThreshold", 1),
 *                 Map.entry("protocol", "Http"),
 *                 Map.entry("requestPath", "healthcheck.aspx")
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("name", "Premium"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Gateway Load Balancer Provider configured with two Backend Pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb1",
 *             },
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb2",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = null,
 *                 BackendAddressPools = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb1",
 *                     },
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb2",
 *                     },
 *                 },
 *                 BackendPort = 0,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 0,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = "Default",
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = "All",
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = "Http",
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = "Premium",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: []network.BackendAddressPoolArgs{
 * 				{
 * 					Name: pulumi.String("be-lb1"),
 * 				},
 * 				{
 * 					Name: pulumi.String("be-lb2"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: []network.FrontendIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools:  network.InboundNatPoolArray{},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: []network.LoadBalancingRuleArgs{
 * 				{
 * 					BackendAddressPool: nil,
 * 					BackendAddressPools: network.SubResourceArray{
 * 						{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb1"),
 * 						},
 * 						{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb2"),
 * 						},
 * 					},
 * 					BackendPort:      pulumi.Int(0),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(0),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String("Default"),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String("All"),
 * 				},
 * 			},
 * 			Location:      pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{},
 * 			Probes: []network.ProbeArgs{
 * 				{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String("Http"),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String("Premium"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(
 *                 Map.of("name", "be-lb1"),
 *                 Map.of("name", "be-lb2"))
 *             .frontendIPConfigurations(Map.ofEntries(
 *                 Map.entry("name", "fe-lb"),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"))
 *             ))
 *             .inboundNatPools()
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(Map.ofEntries(
 *                 Map.entry("backendAddressPool", ),
 *                 Map.entry("backendAddressPools",
 *                     Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb1"),
 *                     Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb2")),
 *                 Map.entry("backendPort", 0),
 *                 Map.entry("enableFloatingIP", true),
 *                 Map.entry("frontendIPConfiguration", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")),
 *                 Map.entry("frontendPort", 0),
 *                 Map.entry("idleTimeoutInMinutes", 15),
 *                 Map.entry("loadDistribution", "Default"),
 *                 Map.entry("name", "rulelb"),
 *                 Map.entry("probe", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")),
 *                 Map.entry("protocol", "All")
 *             ))
 *             .location("eastus")
 *             .outboundRules()
 *             .probes(Map.ofEntries(
 *                 Map.entry("intervalInSeconds", 15),
 *                 Map.entry("name", "probe-lb"),
 *                 Map.entry("numberOfProbes", 2),
 *                 Map.entry("port", 80),
 *                 Map.entry("probeThreshold", 1),
 *                 Map.entry("protocol", "Http"),
 *                 Map.entry("requestPath", "healthcheck.aspx")
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("name", "Premium"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Global Tier and one regional load balancer in its backend pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 LoadBalancerBackendAddresses = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.LoadBalancerBackendAddressArgs
 *                     {
 *                         LoadBalancerFrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                         {
 *                             Id = "/subscriptions/subid/resourceGroups/regional-lb-rg1/providers/Microsoft.Network/loadBalancers/regional-lb/frontendIPConfigurations/fe-rlb",
 *                         },
 *                         Name = "regional-lb1-address",
 *                     },
 *                 },
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 EnableFloatingIP = false,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = "Default",
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = "Tcp",
 *             },
 *         },
 *         Location = "eastus",
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = "Http",
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = "Standard",
 *             Tier = "Global",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: []network.BackendAddressPoolArgs{
 * 				{
 * 					LoadBalancerBackendAddresses: network.LoadBalancerBackendAddressArray{
 * 						{
 * 							LoadBalancerFrontendIPConfiguration: {
 * 								Id: pulumi.String("/subscriptions/subid/resourceGroups/regional-lb-rg1/providers/Microsoft.Network/loadBalancers/regional-lb/frontendIPConfigurations/fe-rlb"),
 * 							},
 * 							Name: pulumi.String("regional-lb1-address"),
 * 						},
 * 					},
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: []network.FrontendIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: []network.LoadBalancingRuleArgs{
 * 				{
 * 					BackendAddressPool: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:      pulumi.Int(80),
 * 					EnableFloatingIP: pulumi.Bool(false),
 * 					FrontendIPConfiguration: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String("Default"),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String("Tcp"),
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Probes: []network.ProbeArgs{
 * 				{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String("Http"),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 				Tier: pulumi.String("Global"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(Map.ofEntries(
 *                 Map.entry("loadBalancerBackendAddresses", Map.ofEntries(
 *                     Map.entry("loadBalancerFrontendIPConfiguration", Map.of("id", "/subscriptions/subid/resourceGroups/regional-lb-rg1/providers/Microsoft.Network/loadBalancers/regional-lb/frontendIPConfigurations/fe-rlb")),
 *                     Map.entry("name", "regional-lb1-address")
 *                 )),
 *                 Map.entry("name", "be-lb")
 *             ))
 *             .frontendIPConfigurations(Map.ofEntries(
 *                 Map.entry("name", "fe-lb"),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"))
 *             ))
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(Map.ofEntries(
 *                 Map.entry("backendAddressPool", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")),
 *                 Map.entry("backendPort", 80),
 *                 Map.entry("enableFloatingIP", false),
 *                 Map.entry("frontendIPConfiguration", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")),
 *                 Map.entry("frontendPort", 80),
 *                 Map.entry("idleTimeoutInMinutes", 15),
 *                 Map.entry("loadDistribution", "Default"),
 *                 Map.entry("name", "rulelb"),
 *                 Map.entry("probe", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")),
 *                 Map.entry("protocol", "Tcp")
 *             ))
 *             .location("eastus")
 *             .probes(Map.ofEntries(
 *                 Map.entry("intervalInSeconds", 15),
 *                 Map.entry("name", "probe-lb"),
 *                 Map.entry("numberOfProbes", 2),
 *                 Map.entry("port", 80),
 *                 Map.entry("probeThreshold", 1),
 *                 Map.entry("protocol", "Http"),
 *                 Map.entry("requestPath", "healthcheck.aspx")
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Standard"),
 *                 Map.entry("tier", "Global")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with Standard SKU
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         InboundNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatRuleArgs
 *             {
 *                 BackendPort = 3389,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 3389,
 *                 IdleTimeoutInMinutes = 15,
 *                 Name = "in-nat-rule",
 *                 Protocol = "Tcp",
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = "Default",
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = "Tcp",
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = "Http",
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: []network.BackendAddressPoolArgs{
 * 				{
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: []network.FrontendIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("fe-lb"),
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{},
 * 			InboundNatRules: []network.InboundNatRuleTypeArgs{
 * 				{
 * 					BackendPort:      pulumi.Int(3389),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(3389),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					Name:                 pulumi.String("in-nat-rule"),
 * 					Protocol:             pulumi.String("Tcp"),
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: []network.LoadBalancingRuleArgs{
 * 				{
 * 					BackendAddressPool: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:      pulumi.Int(80),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String("Default"),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String("Tcp"),
 * 				},
 * 			},
 * 			Location:      pulumi.String("eastus"),
 * 			OutboundRules: network.OutboundRuleArray{},
 * 			Probes: []network.ProbeArgs{
 * 				{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String("Http"),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(Map.of("name", "be-lb"))
 *             .frontendIPConfigurations(Map.ofEntries(
 *                 Map.entry("name", "fe-lb"),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnetlb/subnets/subnetlb"))
 *             ))
 *             .inboundNatPools()
 *             .inboundNatRules(Map.ofEntries(
 *                 Map.entry("backendPort", 3389),
 *                 Map.entry("enableFloatingIP", true),
 *                 Map.entry("frontendIPConfiguration", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")),
 *                 Map.entry("frontendPort", 3389),
 *                 Map.entry("idleTimeoutInMinutes", 15),
 *                 Map.entry("name", "in-nat-rule"),
 *                 Map.entry("protocol", "Tcp")
 *             ))
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(Map.ofEntries(
 *                 Map.entry("backendAddressPool", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")),
 *                 Map.entry("backendPort", 80),
 *                 Map.entry("enableFloatingIP", true),
 *                 Map.entry("frontendIPConfiguration", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")),
 *                 Map.entry("frontendPort", 80),
 *                 Map.entry("idleTimeoutInMinutes", 15),
 *                 Map.entry("loadDistribution", "Default"),
 *                 Map.entry("name", "rulelb"),
 *                 Map.entry("probe", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")),
 *                 Map.entry("protocol", "Tcp")
 *             ))
 *             .location("eastus")
 *             .outboundRules()
 *             .probes(Map.ofEntries(
 *                 Map.entry("intervalInSeconds", 15),
 *                 Map.entry("name", "probe-lb"),
 *                 Map.entry("numberOfProbes", 2),
 *                 Map.entry("port", 80),
 *                 Map.entry("probeThreshold", 1),
 *                 Map.entry("protocol", "Http"),
 *                 Map.entry("requestPath", "healthcheck.aspx")
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("name", "Standard"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with inbound nat pool
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[] {},
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test",
 *                 Name = "test",
 *                 PrivateIPAllocationMethod = "Dynamic",
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/lbvnet/subnets/lbsubnet",
 *                 },
 *                 Zones = new() { },
 *             },
 *         },
 *         InboundNatPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatPoolArgs
 *             {
 *                 BackendPort = 8888,
 *                 EnableFloatingIP = true,
 *                 EnableTcpReset = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test",
 *                 },
 *                 FrontendPortRangeEnd = 8085,
 *                 FrontendPortRangeStart = 8080,
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/inboundNatPools/test",
 *                 IdleTimeoutInMinutes = 10,
 *                 Name = "test",
 *                 Protocol = "Tcp",
 *             },
 *         },
 *         InboundNatRules = new[] {},
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[] {},
 *         Location = "eastus",
 *         OutboundRules = new[] {},
 *         Probes = new[] {},
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: network.BackendAddressPoolArray{},
 * 			FrontendIPConfigurations: []network.FrontendIPConfigurationArgs{
 * 				{
 * 					Id:                        pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test"),
 * 					Name:                      pulumi.String("test"),
 * 					PrivateIPAllocationMethod: pulumi.String("Dynamic"),
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/lbvnet/subnets/lbsubnet"),
 * 					},
 * 					Zones: pulumi.StringArray{},
 * 				},
 * 			},
 * 			InboundNatPools: []network.InboundNatPoolArgs{
 * 				{
 * 					BackendPort:      pulumi.Int(8888),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					EnableTcpReset:   pulumi.Bool(true),
 * 					FrontendIPConfiguration: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test"),
 * 					},
 * 					FrontendPortRangeEnd:   pulumi.Int(8085),
 * 					FrontendPortRangeStart: pulumi.Int(8080),
 * 					Id:                     pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/inboundNatPools/test"),
 * 					IdleTimeoutInMinutes:   pulumi.Int(10),
 * 					Name:                   pulumi.String("test"),
 * 					Protocol:               pulumi.String("Tcp"),
 * 				},
 * 			},
 * 			InboundNatRules:    network.InboundNatRuleTypeArray{},
 * 			LoadBalancerName:   pulumi.String("lb"),
 * 			LoadBalancingRules: network.LoadBalancingRuleArray{},
 * 			Location:           pulumi.String("eastus"),
 * 			OutboundRules:      network.OutboundRuleArray{},
 * 			Probes:             network.ProbeArray{},
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools()
 *             .frontendIPConfigurations(Map.ofEntries(
 *                 Map.entry("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test"),
 *                 Map.entry("name", "test"),
 *                 Map.entry("privateIPAllocationMethod", "Dynamic"),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/lbvnet/subnets/lbsubnet")),
 *                 Map.entry("zones", )
 *             ))
 *             .inboundNatPools(Map.ofEntries(
 *                 Map.entry("backendPort", 8888),
 *                 Map.entry("enableFloatingIP", true),
 *                 Map.entry("enableTcpReset", true),
 *                 Map.entry("frontendIPConfiguration", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/test")),
 *                 Map.entry("frontendPortRangeEnd", 8085),
 *                 Map.entry("frontendPortRangeStart", 8080),
 *                 Map.entry("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/inboundNatPools/test"),
 *                 Map.entry("idleTimeoutInMinutes", 10),
 *                 Map.entry("name", "test"),
 *                 Map.entry("protocol", "Tcp")
 *             ))
 *             .inboundNatRules()
 *             .loadBalancerName("lb")
 *             .loadBalancingRules()
 *             .location("eastus")
 *             .outboundRules()
 *             .probes()
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("name", "Standard"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create load balancer with outbound rules
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var loadBalancer = new AzureNative.Network.LoadBalancer("loadBalancer", new()
 *     {
 *         BackendAddressPools = new[]
 *         {
 *             new AzureNative.Network.Inputs.BackendAddressPoolArgs
 *             {
 *                 Name = "be-lb",
 *             },
 *         },
 *         FrontendIPConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.FrontendIPConfigurationArgs
 *             {
 *                 Name = "fe-lb",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.PublicIPAddressArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pip",
 *                 },
 *             },
 *         },
 *         InboundNatPools = new[] {},
 *         InboundNatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.InboundNatRuleArgs
 *             {
 *                 BackendPort = 3389,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 3389,
 *                 IdleTimeoutInMinutes = 15,
 *                 Name = "in-nat-rule",
 *                 Protocol = "Tcp",
 *             },
 *         },
 *         LoadBalancerName = "lb",
 *         LoadBalancingRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.LoadBalancingRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 BackendPort = 80,
 *                 DisableOutboundSnat = true,
 *                 EnableFloatingIP = true,
 *                 FrontendIPConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                 },
 *                 FrontendPort = 80,
 *                 IdleTimeoutInMinutes = 15,
 *                 LoadDistribution = "Default",
 *                 Name = "rulelb",
 *                 Probe = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb",
 *                 },
 *                 Protocol = "Tcp",
 *             },
 *         },
 *         Location = "eastus",
 *         OutboundRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.OutboundRuleArgs
 *             {
 *                 BackendAddressPool = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb",
 *                 },
 *                 FrontendIPConfigurations = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb",
 *                     },
 *                 },
 *                 Name = "rule1",
 *                 Protocol = "All",
 *             },
 *         },
 *         Probes = new[]
 *         {
 *             new AzureNative.Network.Inputs.ProbeArgs
 *             {
 *                 IntervalInSeconds = 15,
 *                 Name = "probe-lb",
 *                 NumberOfProbes = 2,
 *                 Port = 80,
 *                 ProbeThreshold = 1,
 *                 Protocol = "Http",
 *                 RequestPath = "healthcheck.aspx",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.LoadBalancerSkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewLoadBalancer(ctx, "loadBalancer", &network.LoadBalancerArgs{
 * 			BackendAddressPools: []network.BackendAddressPoolArgs{
 * 				{
 * 					Name: pulumi.String("be-lb"),
 * 				},
 * 			},
 * 			FrontendIPConfigurations: []network.FrontendIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("fe-lb"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pip"),
 * 					},
 * 				},
 * 			},
 * 			InboundNatPools: network.InboundNatPoolArray{},
 * 			InboundNatRules: []network.InboundNatRuleTypeArgs{
 * 				{
 * 					BackendPort:      pulumi.Int(3389),
 * 					EnableFloatingIP: pulumi.Bool(true),
 * 					FrontendIPConfiguration: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(3389),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					Name:                 pulumi.String("in-nat-rule"),
 * 					Protocol:             pulumi.String("Tcp"),
 * 				},
 * 			},
 * 			LoadBalancerName: pulumi.String("lb"),
 * 			LoadBalancingRules: []network.LoadBalancingRuleArgs{
 * 				{
 * 					BackendAddressPool: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					BackendPort:         pulumi.Int(80),
 * 					DisableOutboundSnat: pulumi.Bool(true),
 * 					EnableFloatingIP:    pulumi.Bool(true),
 * 					FrontendIPConfiguration: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 					},
 * 					FrontendPort:         pulumi.Int(80),
 * 					IdleTimeoutInMinutes: pulumi.Int(15),
 * 					LoadDistribution:     pulumi.String("Default"),
 * 					Name:                 pulumi.String("rulelb"),
 * 					Probe: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb"),
 * 					},
 * 					Protocol: pulumi.String("Tcp"),
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			OutboundRules: []network.OutboundRuleArgs{
 * 				{
 * 					BackendAddressPool: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb"),
 * 					},
 * 					FrontendIPConfigurations: network.SubResourceArray{
 * 						{
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb"),
 * 						},
 * 					},
 * 					Name:     pulumi.String("rule1"),
 * 					Protocol: pulumi.String("All"),
 * 				},
 * 			},
 * 			Probes: []network.ProbeArgs{
 * 				{
 * 					IntervalInSeconds: pulumi.Int(15),
 * 					Name:              pulumi.String("probe-lb"),
 * 					NumberOfProbes:    pulumi.Int(2),
 * 					Port:              pulumi.Int(80),
 * 					ProbeThreshold:    pulumi.Int(1),
 * 					Protocol:          pulumi.String("Http"),
 * 					RequestPath:       pulumi.String("healthcheck.aspx"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.LoadBalancerSkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.LoadBalancer;
 * import com.pulumi.azurenative.network.LoadBalancerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var loadBalancer = new LoadBalancer("loadBalancer", LoadBalancerArgs.builder()
 *             .backendAddressPools(Map.of("name", "be-lb"))
 *             .frontendIPConfigurations(Map.ofEntries(
 *                 Map.entry("name", "fe-lb"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/pip"))
 *             ))
 *             .inboundNatPools()
 *             .inboundNatRules(Map.ofEntries(
 *                 Map.entry("backendPort", 3389),
 *                 Map.entry("enableFloatingIP", true),
 *                 Map.entry("frontendIPConfiguration", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")),
 *                 Map.entry("frontendPort", 3389),
 *                 Map.entry("idleTimeoutInMinutes", 15),
 *                 Map.entry("name", "in-nat-rule"),
 *                 Map.entry("protocol", "Tcp")
 *             ))
 *             .loadBalancerName("lb")
 *             .loadBalancingRules(Map.ofEntries(
 *                 Map.entry("backendAddressPool", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")),
 *                 Map.entry("backendPort", 80),
 *                 Map.entry("disableOutboundSnat", true),
 *                 Map.entry("enableFloatingIP", true),
 *                 Map.entry("frontendIPConfiguration", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")),
 *                 Map.entry("frontendPort", 80),
 *                 Map.entry("idleTimeoutInMinutes", 15),
 *                 Map.entry("loadDistribution", "Default"),
 *                 Map.entry("name", "rulelb"),
 *                 Map.entry("probe", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/probes/probe-lb")),
 *                 Map.entry("protocol", "Tcp")
 *             ))
 *             .location("eastus")
 *             .outboundRules(Map.ofEntries(
 *                 Map.entry("backendAddressPool", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/backendAddressPools/be-lb")),
 *                 Map.entry("frontendIPConfigurations", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb")),
 *                 Map.entry("name", "rule1"),
 *                 Map.entry("protocol", "All")
 *             ))
 *             .probes(Map.ofEntries(
 *                 Map.entry("intervalInSeconds", 15),
 *                 Map.entry("name", "probe-lb"),
 *                 Map.entry("numberOfProbes", 2),
 *                 Map.entry("port", 80),
 *                 Map.entry("probeThreshold", 1),
 *                 Map.entry("protocol", "Http"),
 *                 Map.entry("requestPath", "healthcheck.aspx")
 *             ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("name", "Standard"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:LoadBalancer lb /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}
 * ```
 * @property backendAddressPools Collection of backend address pools used by a load balancer.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property extendedLocation The extended location of the load balancer.
 * @property frontendIPConfigurations Object representing the frontend IPs to be used for the load balancer.
 * @property id Resource ID.
 * @property inboundNatPools Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
 * @property inboundNatRules Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property loadBalancerName The name of the load balancer.
 * @property loadBalancingRules Object collection representing the load balancing rules Gets the provisioning.
 * @property location Resource location.
 * @property outboundRules The outbound rules.
 * @property probes Collection of probe objects used in the load balancer.
 * @property resourceGroupName The name of the resource group.
 * @property sku The load balancer SKU.
 * @property tags Resource tags.
 */
public data class LoadBalancerArgs(
    public val backendAddressPools: Output<List<BackendAddressPoolArgs>>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val frontendIPConfigurations: Output<List<FrontendIPConfigurationArgs>>? = null,
    public val id: Output<String>? = null,
    public val inboundNatPools: Output<List<InboundNatPoolArgs>>? = null,
    public val inboundNatRules: Output<List<InboundNatRuleArgs>>? = null,
    public val loadBalancerName: Output<String>? = null,
    public val loadBalancingRules: Output<List<LoadBalancingRuleArgs>>? = null,
    public val location: Output<String>? = null,
    public val outboundRules: Output<List<OutboundRuleArgs>>? = null,
    public val probes: Output<List<ProbeArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<LoadBalancerSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.LoadBalancerArgs> {
    override fun toJava(): com.pulumi.azurenative.network.LoadBalancerArgs =
        com.pulumi.azurenative.network.LoadBalancerArgs.builder()
            .backendAddressPools(
                backendAddressPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .frontendIPConfigurations(
                frontendIPConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .inboundNatPools(
                inboundNatPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .inboundNatRules(
                inboundNatRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .loadBalancerName(loadBalancerName?.applyValue({ args0 -> args0 }))
            .loadBalancingRules(
                loadBalancingRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .outboundRules(
                outboundRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .probes(probes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LoadBalancerArgs].
 */
@PulumiTagMarker
public class LoadBalancerArgsBuilder internal constructor() {
    private var backendAddressPools: Output<List<BackendAddressPoolArgs>>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var frontendIPConfigurations: Output<List<FrontendIPConfigurationArgs>>? = null

    private var id: Output<String>? = null

    private var inboundNatPools: Output<List<InboundNatPoolArgs>>? = null

    private var inboundNatRules: Output<List<InboundNatRuleArgs>>? = null

    private var loadBalancerName: Output<String>? = null

    private var loadBalancingRules: Output<List<LoadBalancingRuleArgs>>? = null

    private var location: Output<String>? = null

    private var outboundRules: Output<List<OutboundRuleArgs>>? = null

    private var probes: Output<List<ProbeArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<LoadBalancerSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Collection of backend address pools used by a load balancer.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("skldblegfabblech")
    public suspend fun backendAddressPools(`value`: Output<List<BackendAddressPoolArgs>>) {
        this.backendAddressPools = value
    }

    @JvmName("mmlxfwnkrmcnfbiy")
    public suspend fun backendAddressPools(vararg values: Output<BackendAddressPoolArgs>) {
        this.backendAddressPools = Output.all(values.asList())
    }

    /**
     * @param values Collection of backend address pools used by a load balancer.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("ontryadlqjocqbbl")
    public suspend fun backendAddressPools(values: List<Output<BackendAddressPoolArgs>>) {
        this.backendAddressPools = Output.all(values)
    }

    /**
     * @param value The extended location of the load balancer.
     */
    @JvmName("xdvcysujnablvrxx")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Object representing the frontend IPs to be used for the load balancer.
     */
    @JvmName("syflfvmmeiwsvseu")
    public suspend fun frontendIPConfigurations(`value`: Output<List<FrontendIPConfigurationArgs>>) {
        this.frontendIPConfigurations = value
    }

    @JvmName("deuyennkxigeojyk")
    public suspend fun frontendIPConfigurations(vararg values: Output<FrontendIPConfigurationArgs>) {
        this.frontendIPConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Object representing the frontend IPs to be used for the load balancer.
     */
    @JvmName("otueinbpxvehxkoq")
    public suspend fun frontendIPConfigurations(values: List<Output<FrontendIPConfigurationArgs>>) {
        this.frontendIPConfigurations = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xarmuxjqwoqyhjmh")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    @JvmName("smemrdiuvqglqlaq")
    public suspend fun inboundNatPools(`value`: Output<List<InboundNatPoolArgs>>) {
        this.inboundNatPools = value
    }

    @JvmName("wetgfddjqpudnpmv")
    public suspend fun inboundNatPools(vararg values: Output<InboundNatPoolArgs>) {
        this.inboundNatPools = Output.all(values.asList())
    }

    /**
     * @param values Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    @JvmName("rmoqxmyvbacakwmy")
    public suspend fun inboundNatPools(values: List<Output<InboundNatPoolArgs>>) {
        this.inboundNatPools = Output.all(values)
    }

    /**
     * @param value Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("uxchvyloettjadhh")
    public suspend fun inboundNatRules(`value`: Output<List<InboundNatRuleArgs>>) {
        this.inboundNatRules = value
    }

    @JvmName("snqeoxqnuvibtbxs")
    public suspend fun inboundNatRules(vararg values: Output<InboundNatRuleArgs>) {
        this.inboundNatRules = Output.all(values.asList())
    }

    /**
     * @param values Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("ngddlrxypayreaix")
    public suspend fun inboundNatRules(values: List<Output<InboundNatRuleArgs>>) {
        this.inboundNatRules = Output.all(values)
    }

    /**
     * @param value The name of the load balancer.
     */
    @JvmName("xmhgyxarmovayhli")
    public suspend fun loadBalancerName(`value`: Output<String>) {
        this.loadBalancerName = value
    }

    /**
     * @param value Object collection representing the load balancing rules Gets the provisioning.
     */
    @JvmName("dvhyjvciprrjffnd")
    public suspend fun loadBalancingRules(`value`: Output<List<LoadBalancingRuleArgs>>) {
        this.loadBalancingRules = value
    }

    @JvmName("luxlkpykeobjljms")
    public suspend fun loadBalancingRules(vararg values: Output<LoadBalancingRuleArgs>) {
        this.loadBalancingRules = Output.all(values.asList())
    }

    /**
     * @param values Object collection representing the load balancing rules Gets the provisioning.
     */
    @JvmName("tgoaededypmntheh")
    public suspend fun loadBalancingRules(values: List<Output<LoadBalancingRuleArgs>>) {
        this.loadBalancingRules = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("vdbxetjterucpqce")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The outbound rules.
     */
    @JvmName("ukdbsxcxmhtmkljx")
    public suspend fun outboundRules(`value`: Output<List<OutboundRuleArgs>>) {
        this.outboundRules = value
    }

    @JvmName("vcnihawedjdibvuf")
    public suspend fun outboundRules(vararg values: Output<OutboundRuleArgs>) {
        this.outboundRules = Output.all(values.asList())
    }

    /**
     * @param values The outbound rules.
     */
    @JvmName("ymtvhcgaroeheoxh")
    public suspend fun outboundRules(values: List<Output<OutboundRuleArgs>>) {
        this.outboundRules = Output.all(values)
    }

    /**
     * @param value Collection of probe objects used in the load balancer.
     */
    @JvmName("evfxrapjtxhjchmb")
    public suspend fun probes(`value`: Output<List<ProbeArgs>>) {
        this.probes = value
    }

    @JvmName("lfemjnfwxvjuxopc")
    public suspend fun probes(vararg values: Output<ProbeArgs>) {
        this.probes = Output.all(values.asList())
    }

    /**
     * @param values Collection of probe objects used in the load balancer.
     */
    @JvmName("ghueisasoccgfgdu")
    public suspend fun probes(values: List<Output<ProbeArgs>>) {
        this.probes = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vpxggtjvwadxbsmb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The load balancer SKU.
     */
    @JvmName("tpcesjbqmldhkaeq")
    public suspend fun sku(`value`: Output<LoadBalancerSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hnqqpbgwdpmrpyop")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Collection of backend address pools used by a load balancer.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("plmovadlftijumhm")
    public suspend fun backendAddressPools(`value`: List<BackendAddressPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendAddressPools = mapped
    }

    /**
     * @param argument Collection of backend address pools used by a load balancer.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("qmrbbaapjoqnlswh")
    public suspend
    fun backendAddressPools(argument: List<suspend BackendAddressPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BackendAddressPoolArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.backendAddressPools = mapped
    }

    /**
     * @param argument Collection of backend address pools used by a load balancer.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("tieqijdkxalhggmi")
    public suspend fun backendAddressPools(
        vararg
        argument: suspend BackendAddressPoolArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BackendAddressPoolArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.backendAddressPools = mapped
    }

    /**
     * @param argument Collection of backend address pools used by a load balancer.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("tycgxkgyubnakfne")
    public suspend
    fun backendAddressPools(argument: suspend BackendAddressPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BackendAddressPoolArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.backendAddressPools = mapped
    }

    /**
     * @param values Collection of backend address pools used by a load balancer.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("hyyvdsbgdpydoryj")
    public suspend fun backendAddressPools(vararg values: BackendAddressPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendAddressPools = mapped
    }

    /**
     * @param value The extended location of the load balancer.
     */
    @JvmName("fnugsdpmsmaaevvg")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the load balancer.
     */
    @JvmName("mnkivqeqhcfubncn")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Object representing the frontend IPs to be used for the load balancer.
     */
    @JvmName("liexdrhvarfmkoej")
    public suspend fun frontendIPConfigurations(`value`: List<FrontendIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param argument Object representing the frontend IPs to be used for the load balancer.
     */
    @JvmName("ajedsyjpdjbafqcu")
    public suspend
    fun frontendIPConfigurations(argument: List<suspend FrontendIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrontendIPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param argument Object representing the frontend IPs to be used for the load balancer.
     */
    @JvmName("nbpwnmyybiccofrv")
    public suspend fun frontendIPConfigurations(
        vararg
        argument: suspend FrontendIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FrontendIPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param argument Object representing the frontend IPs to be used for the load balancer.
     */
    @JvmName("rvncsspccrgdblub")
    public suspend
    fun frontendIPConfigurations(argument: suspend FrontendIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FrontendIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param values Object representing the frontend IPs to be used for the load balancer.
     */
    @JvmName("nnxwwkaeknepvnuv")
    public suspend fun frontendIPConfigurations(vararg values: FrontendIPConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ugkbqqnarrskhlth")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    @JvmName("kesievlyhlqjolou")
    public suspend fun inboundNatPools(`value`: List<InboundNatPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundNatPools = mapped
    }

    /**
     * @param argument Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    @JvmName("onmofiyfqwbrpqol")
    public suspend fun inboundNatPools(argument: List<suspend InboundNatPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InboundNatPoolArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundNatPools = mapped
    }

    /**
     * @param argument Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    @JvmName("vusbpfaifhbojwms")
    public suspend fun inboundNatPools(
        vararg
        argument: suspend InboundNatPoolArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InboundNatPoolArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundNatPools = mapped
    }

    /**
     * @param argument Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    @JvmName("ywcmfdsbesnduvlx")
    public suspend fun inboundNatPools(argument: suspend InboundNatPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InboundNatPoolArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inboundNatPools = mapped
    }

    /**
     * @param values Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.
     */
    @JvmName("sekgyonxdvknoney")
    public suspend fun inboundNatPools(vararg values: InboundNatPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inboundNatPools = mapped
    }

    /**
     * @param value Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("tjxdvtqhcvxcdmra")
    public suspend fun inboundNatRules(`value`: List<InboundNatRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundNatRules = mapped
    }

    /**
     * @param argument Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("kqmqamajhgrnkxqj")
    public suspend fun inboundNatRules(argument: List<suspend InboundNatRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InboundNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundNatRules = mapped
    }

    /**
     * @param argument Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("uwfwovejmrgjmjcj")
    public suspend fun inboundNatRules(
        vararg
        argument: suspend InboundNatRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InboundNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inboundNatRules = mapped
    }

    /**
     * @param argument Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("srsujphwjynikqyq")
    public suspend fun inboundNatRules(argument: suspend InboundNatRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InboundNatRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inboundNatRules = mapped
    }

    /**
     * @param values Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("vctiwmjokunofapy")
    public suspend fun inboundNatRules(vararg values: InboundNatRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inboundNatRules = mapped
    }

    /**
     * @param value The name of the load balancer.
     */
    @JvmName("wtpiegltroybrkok")
    public suspend fun loadBalancerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerName = mapped
    }

    /**
     * @param value Object collection representing the load balancing rules Gets the provisioning.
     */
    @JvmName("crsxuifvagymvngv")
    public suspend fun loadBalancingRules(`value`: List<LoadBalancingRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancingRules = mapped
    }

    /**
     * @param argument Object collection representing the load balancing rules Gets the provisioning.
     */
    @JvmName("fqoxrxqsophsmhuf")
    public suspend
    fun loadBalancingRules(argument: List<suspend LoadBalancingRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancingRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancingRules = mapped
    }

    /**
     * @param argument Object collection representing the load balancing rules Gets the provisioning.
     */
    @JvmName("cltndneofhiendnb")
    public suspend fun loadBalancingRules(
        vararg
        argument: suspend LoadBalancingRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LoadBalancingRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancingRules = mapped
    }

    /**
     * @param argument Object collection representing the load balancing rules Gets the provisioning.
     */
    @JvmName("wiwlhbfymqqeqikk")
    public suspend fun loadBalancingRules(argument: suspend LoadBalancingRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LoadBalancingRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.loadBalancingRules = mapped
    }

    /**
     * @param values Object collection representing the load balancing rules Gets the provisioning.
     */
    @JvmName("ocktufacvtjawovy")
    public suspend fun loadBalancingRules(vararg values: LoadBalancingRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancingRules = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("plguayppmsxtuygr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The outbound rules.
     */
    @JvmName("scowgnjsutsxgnbm")
    public suspend fun outboundRules(`value`: List<OutboundRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundRules = mapped
    }

    /**
     * @param argument The outbound rules.
     */
    @JvmName("kcgsskmopshijxvk")
    public suspend fun outboundRules(argument: List<suspend OutboundRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OutboundRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.outboundRules = mapped
    }

    /**
     * @param argument The outbound rules.
     */
    @JvmName("nyekyqhvrlhwgcim")
    public suspend fun outboundRules(vararg argument: suspend OutboundRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OutboundRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.outboundRules = mapped
    }

    /**
     * @param argument The outbound rules.
     */
    @JvmName("otnuwwudpnnfpgii")
    public suspend fun outboundRules(argument: suspend OutboundRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(OutboundRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.outboundRules = mapped
    }

    /**
     * @param values The outbound rules.
     */
    @JvmName("nyvpycnrcacpynit")
    public suspend fun outboundRules(vararg values: OutboundRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outboundRules = mapped
    }

    /**
     * @param value Collection of probe objects used in the load balancer.
     */
    @JvmName("hihyixctftlumidp")
    public suspend fun probes(`value`: List<ProbeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.probes = mapped
    }

    /**
     * @param argument Collection of probe objects used in the load balancer.
     */
    @JvmName("reopwyjjnxesrwqn")
    public suspend fun probes(argument: List<suspend ProbeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ProbeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.probes = mapped
    }

    /**
     * @param argument Collection of probe objects used in the load balancer.
     */
    @JvmName("ucpublvlxkcybnof")
    public suspend fun probes(vararg argument: suspend ProbeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ProbeArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.probes = mapped
    }

    /**
     * @param argument Collection of probe objects used in the load balancer.
     */
    @JvmName("khgivrnppatyqweb")
    public suspend fun probes(argument: suspend ProbeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ProbeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.probes = mapped
    }

    /**
     * @param values Collection of probe objects used in the load balancer.
     */
    @JvmName("rbwjbthnlvxcougb")
    public suspend fun probes(vararg values: ProbeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.probes = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("bienrsnbpcpvbuqm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The load balancer SKU.
     */
    @JvmName("spimbjwftddchtcv")
    public suspend fun sku(`value`: LoadBalancerSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The load balancer SKU.
     */
    @JvmName("ouqfajlfhtulewgd")
    public suspend fun sku(argument: suspend LoadBalancerSkuArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sgcpgrglsbefhavw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wpisplpvkkislsij")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LoadBalancerArgs = LoadBalancerArgs(
        backendAddressPools = backendAddressPools,
        extendedLocation = extendedLocation,
        frontendIPConfigurations = frontendIPConfigurations,
        id = id,
        inboundNatPools = inboundNatPools,
        inboundNatRules = inboundNatRules,
        loadBalancerName = loadBalancerName,
        loadBalancingRules = loadBalancingRules,
        location = location,
        outboundRules = outboundRules,
        probes = probes,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
