@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.VpnNatRuleMappingResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VpnNatRuleMappingResponse.Companion.toKotlin as vpnNatRuleMappingResponseToKotlin

/**
 * Builder for [NatRule].
 */
@PulumiTagMarker
public class NatRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NatRuleArgs = NatRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NatRuleArgsBuilder.() -> Unit) {
        val builder = NatRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NatRule {
        val builtJavaResource = com.pulumi.azurenative.network.NatRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NatRule(builtJavaResource)
    }
}

/**
 * VpnGatewayNatRule Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### NatRulePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var natRule = new AzureNative.Network.NatRule("natRule", new()
 *     {
 *         ExternalMappings = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *             {
 *                 AddressSpace = "192.168.21.0/24",
 *             },
 *         },
 *         GatewayName = "gateway1",
 *         InternalMappings = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *             {
 *                 AddressSpace = "10.4.0.0/24",
 *             },
 *         },
 *         IpConfigurationId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/cloudnet1-VNG/ipConfigurations/default",
 *         Mode = "EgressSnat",
 *         NatRuleName = "natRule1",
 *         ResourceGroupName = "rg1",
 *         Type = "Static",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNatRule(ctx, "natRule", &network.NatRuleArgs{
 * 			ExternalMappings: []network.VpnNatRuleMappingArgs{
 * 				{
 * 					AddressSpace: pulumi.String("192.168.21.0/24"),
 * 				},
 * 			},
 * 			GatewayName: pulumi.String("gateway1"),
 * 			InternalMappings: []network.VpnNatRuleMappingArgs{
 * 				{
 * 					AddressSpace: pulumi.String("10.4.0.0/24"),
 * 				},
 * 			},
 * 			IpConfigurationId: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/cloudnet1-VNG/ipConfigurations/default"),
 * 			Mode:              pulumi.String("EgressSnat"),
 * 			NatRuleName:       pulumi.String("natRule1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Type:              pulumi.String("Static"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NatRule;
 * import com.pulumi.azurenative.network.NatRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var natRule = new NatRule("natRule", NatRuleArgs.builder()
 *             .externalMappings(Map.of("addressSpace", "192.168.21.0/24"))
 *             .gatewayName("gateway1")
 *             .internalMappings(Map.of("addressSpace", "10.4.0.0/24"))
 *             .ipConfigurationId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/cloudnet1-VNG/ipConfigurations/default")
 *             .mode("EgressSnat")
 *             .natRuleName("natRule1")
 *             .resourceGroupName("rg1")
 *             .type("Static")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NatRule natRule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnGateways/{gatewayName}/natRules/{natRuleName}
 * ```
 */
public class NatRule internal constructor(
    override val javaResource: com.pulumi.azurenative.network.NatRule,
) : KotlinCustomResource(javaResource, NatRuleMapper) {
    /**
     * List of egress VpnSiteLinkConnections.
     */
    public val egressVpnSiteLinkConnections: Output<List<SubResourceResponse>>
        get() = javaResource.egressVpnSiteLinkConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The private IP address external mapping for NAT.
     */
    public val externalMappings: Output<List<VpnNatRuleMappingResponse>>?
        get() = javaResource.externalMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        vpnNatRuleMappingResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * List of ingress VpnSiteLinkConnections.
     */
    public val ingressVpnSiteLinkConnections: Output<List<SubResourceResponse>>
        get() = javaResource.ingressVpnSiteLinkConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            })
        })

    /**
     * The private IP address internal mapping for NAT.
     */
    public val internalMappings: Output<List<VpnNatRuleMappingResponse>>?
        get() = javaResource.internalMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        vpnNatRuleMappingResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The IP Configuration ID this NAT rule applies to.
     */
    public val ipConfigurationId: Output<String>?
        get() = javaResource.ipConfigurationId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Source NAT direction of a VPN NAT.
     */
    public val mode: Output<String>?
        get() = javaResource.mode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the NAT Rule resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NatRuleMapper : ResourceMapper<NatRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.NatRule::class == javaResource::class

    override fun map(javaResource: Resource): NatRule = NatRule(
        javaResource as
            com.pulumi.azurenative.network.NatRule,
    )
}

/**
 * @see [NatRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NatRule].
 */
public suspend fun natRule(name: String, block: suspend NatRuleResourceBuilder.() -> Unit):
    NatRule {
    val builder = NatRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NatRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun natRule(name: String): NatRule {
    val builder = NatRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
