@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceDnsSettingsResponse
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceIPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceTapConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.NetworkSecurityGroupResponse
import com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointResponse
import com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceDnsSettingsResponse.Companion.toKotlin as networkInterfaceDnsSettingsResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceIPConfigurationResponse.Companion.toKotlin as networkInterfaceIPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceTapConfigurationResponse.Companion.toKotlin as networkInterfaceTapConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.NetworkSecurityGroupResponse.Companion.toKotlin as networkSecurityGroupResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin as privateEndpointResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceResponse.Companion.toKotlin as privateLinkServiceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin

/**
 * Builder for [NetworkInterface].
 */
@PulumiTagMarker
public class NetworkInterfaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkInterfaceArgs = NetworkInterfaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkInterfaceArgsBuilder.() -> Unit) {
        val builder = NetworkInterfaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NetworkInterface {
        val builtJavaResource = com.pulumi.azurenative.network.NetworkInterface(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkInterface(builtJavaResource)
    }
}

/**
 * A network interface in a resource group.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2015-05-01-preview, 2018-07-01, 2019-02-01, 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create network interface
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkInterface = new AzureNative.Network.NetworkInterface("networkInterface", new()
 *     {
 *         DisableTcpStateTracking = true,
 *         EnableAcceleratedNetworking = true,
 *         IpConfigurations = new[]
 *         {
 *             {
 *                 { "name", "ipconfig1" },
 *                 { "publicIPAddress", new AzureNative.Network.Inputs.PublicIPAddressArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/test-ip",
 *                 } },
 *                 { "subnet", new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/rg1-vnet/subnets/default",
 *                 } },
 *             },
 *         },
 *         Location = "eastus",
 *         NetworkInterfaceName = "test-nic",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkInterface(ctx, "networkInterface", &network.NetworkInterfaceArgs{
 * 			DisableTcpStateTracking:     pulumi.Bool(true),
 * 			EnableAcceleratedNetworking: pulumi.Bool(true),
 * 			IpConfigurations: []network.NetworkInterfaceIPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("ipconfig1"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/test-ip"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/rg1-vnet/subnets/default"),
 * 					},
 * 				},
 * 			},
 * 			Location:             pulumi.String("eastus"),
 * 			NetworkInterfaceName: pulumi.String("test-nic"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkInterface;
 * import com.pulumi.azurenative.network.NetworkInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkInterface = new NetworkInterface("networkInterface", NetworkInterfaceArgs.builder()
 *             .disableTcpStateTracking(true)
 *             .enableAcceleratedNetworking(true)
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "ipconfig1"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/test-ip")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/rg1-vnet/subnets/default"))
 *             ))
 *             .location("eastus")
 *             .networkInterfaceName("test-nic")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create network interface with Gateway Load Balancer Consumer configured
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkInterface = new AzureNative.Network.NetworkInterface("networkInterface", new()
 *     {
 *         EnableAcceleratedNetworking = true,
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.NetworkInterfaceIPConfigurationArgs
 *             {
 *                 GatewayLoadBalancer = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb-provider",
 *                 },
 *                 Name = "ipconfig1",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.PublicIPAddressArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/test-ip",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/rg1-vnet/subnets/default",
 *                 },
 *             },
 *         },
 *         Location = "eastus",
 *         NetworkInterfaceName = "test-nic",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkInterface(ctx, "networkInterface", &network.NetworkInterfaceArgs{
 * 			EnableAcceleratedNetworking: pulumi.Bool(true),
 * 			IpConfigurations: []network.NetworkInterfaceIPConfigurationArgs{
 * 				{
 * 					GatewayLoadBalancer: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb-provider"),
 * 					},
 * 					Name: pulumi.String("ipconfig1"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/test-ip"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/rg1-vnet/subnets/default"),
 * 					},
 * 				},
 * 			},
 * 			Location:             pulumi.String("eastus"),
 * 			NetworkInterfaceName: pulumi.String("test-nic"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkInterface;
 * import com.pulumi.azurenative.network.NetworkInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkInterface = new NetworkInterface("networkInterface", NetworkInterfaceArgs.builder()
 *             .enableAcceleratedNetworking(true)
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("gatewayLoadBalancer", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/loadBalancers/lb/frontendIPConfigurations/fe-lb-provider")),
 *                 Map.entry("name", "ipconfig1"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/test-ip")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/rg1-vnet/subnets/default"))
 *             ))
 *             .location("eastus")
 *             .networkInterfaceName("test-nic")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkInterface test-nic /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}
 * ```
 */
public class NetworkInterface internal constructor(
    override val javaResource: com.pulumi.azurenative.network.NetworkInterface,
) : KotlinCustomResource(javaResource, NetworkInterfaceMapper) {
    /**
     * Auxiliary mode of Network Interface resource.
     */
    public val auxiliaryMode: Output<String>?
        get() = javaResource.auxiliaryMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Auxiliary sku of Network Interface resource.
     */
    public val auxiliarySku: Output<String>?
        get() = javaResource.auxiliarySku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether to disable tcp state tracking.
     */
    public val disableTcpStateTracking: Output<Boolean>?
        get() = javaResource.disableTcpStateTracking().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The DNS settings in network interface.
     */
    public val dnsSettings: Output<NetworkInterfaceDnsSettingsResponse>?
        get() = javaResource.dnsSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    networkInterfaceDnsSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A reference to the dscp configuration to which the network interface is linked.
     */
    public val dscpConfiguration: Output<SubResourceResponse>
        get() = javaResource.dscpConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                subResourceResponseToKotlin(args0)
            })
        })

    /**
     * If the network interface is configured for accelerated networking. Not applicable to VM sizes which require accelerated networking.
     */
    public val enableAcceleratedNetworking: Output<Boolean>?
        get() = javaResource.enableAcceleratedNetworking().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether IP forwarding is enabled on this network interface.
     */
    public val enableIPForwarding: Output<Boolean>?
        get() = javaResource.enableIPForwarding().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The extended location of the network interface.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A list of references to linked BareMetal resources.
     */
    public val hostedWorkloads: Output<List<String>>
        get() = javaResource.hostedWorkloads().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A list of IPConfigurations of the network interface.
     */
    public val ipConfigurations: Output<List<NetworkInterfaceIPConfigurationResponse>>?
        get() = javaResource.ipConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        networkInterfaceIPConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The MAC address of the network interface.
     */
    public val macAddress: Output<String>
        get() = javaResource.macAddress().applyValue({ args0 -> args0 })

    /**
     * Migration phase of Network Interface resource.
     */
    public val migrationPhase: Output<String>?
        get() = javaResource.migrationPhase().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The reference to the NetworkSecurityGroup resource.
     */
    public val networkSecurityGroup: Output<NetworkSecurityGroupResponse>?
        get() = javaResource.networkSecurityGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkSecurityGroupResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Type of Network Interface resource.
     */
    public val nicType: Output<String>?
        get() = javaResource.nicType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether this is a primary network interface on a virtual machine.
     */
    public val primary: Output<Boolean>
        get() = javaResource.primary().applyValue({ args0 -> args0 })

    /**
     * A reference to the private endpoint to which the network interface is linked.
     */
    public val privateEndpoint: Output<PrivateEndpointResponse>
        get() = javaResource.privateEndpoint().applyValue({ args0 ->
            args0.let({ args0 ->
                privateEndpointResponseToKotlin(args0)
            })
        })

    /**
     * Privatelinkservice of the network interface resource.
     */
    public val privateLinkService: Output<PrivateLinkServiceResponse>?
        get() = javaResource.privateLinkService().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> privateLinkServiceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The provisioning state of the network interface resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The resource GUID property of the network interface resource.
     */
    public val resourceGuid: Output<String>
        get() = javaResource.resourceGuid().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A list of TapConfigurations of the network interface.
     */
    public val tapConfigurations: Output<List<NetworkInterfaceTapConfigurationResponse>>
        get() = javaResource.tapConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkInterfaceTapConfigurationResponseToKotlin(args0) })
            })
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The reference to a virtual machine.
     */
    public val virtualMachine: Output<SubResourceResponse>
        get() = javaResource.virtualMachine().applyValue({ args0 ->
            args0.let({ args0 ->
                subResourceResponseToKotlin(args0)
            })
        })

    /**
     * Whether the virtual machine this nic is attached to supports encryption.
     */
    public val vnetEncryptionSupported: Output<Boolean>
        get() = javaResource.vnetEncryptionSupported().applyValue({ args0 -> args0 })

    /**
     * WorkloadType of the NetworkInterface for BareMetal resources
     */
    public val workloadType: Output<String>?
        get() = javaResource.workloadType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object NetworkInterfaceMapper : ResourceMapper<NetworkInterface> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.NetworkInterface::class == javaResource::class

    override fun map(javaResource: Resource): NetworkInterface = NetworkInterface(
        javaResource as
            com.pulumi.azurenative.network.NetworkInterface,
    )
}

/**
 * @see [NetworkInterface].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkInterface].
 */
public suspend fun networkInterface(
    name: String,
    block: suspend NetworkInterfaceResourceBuilder.() -> Unit,
): NetworkInterface {
    val builder = NetworkInterfaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkInterface].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkInterface(name: String): NetworkInterface {
    val builder = NetworkInterfaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
