@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkTapResponse
import com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkTapResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NetworkInterfaceTapConfiguration].
 */
@PulumiTagMarker
public class NetworkInterfaceTapConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkInterfaceTapConfigurationArgs = NetworkInterfaceTapConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkInterfaceTapConfigurationArgsBuilder.() -> Unit) {
        val builder = NetworkInterfaceTapConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NetworkInterfaceTapConfiguration {
        val builtJavaResource =
            com.pulumi.azurenative.network.NetworkInterfaceTapConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NetworkInterfaceTapConfiguration(builtJavaResource)
    }
}

/**
 * Tap configuration in a Network Interface.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create Network Interface Tap Configurations
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkInterfaceTapConfiguration = new AzureNative.Network.NetworkInterfaceTapConfiguration("networkInterfaceTapConfiguration", new()
 *     {
 *         NetworkInterfaceName = "mynic",
 *         ResourceGroupName = "testrg",
 *         TapConfigurationName = "tapconfiguration1",
 *         VirtualNetworkTap = new AzureNative.Network.Inputs.VirtualNetworkTapArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworkTaps/testvtap",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNetworkInterfaceTapConfiguration(ctx, "networkInterfaceTapConfiguration", &network.NetworkInterfaceTapConfigurationArgs{
 * 			NetworkInterfaceName: pulumi.String("mynic"),
 * 			ResourceGroupName:    pulumi.String("testrg"),
 * 			TapConfigurationName: pulumi.String("tapconfiguration1"),
 * 			VirtualNetworkTap: &network.VirtualNetworkTapTypeArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworkTaps/testvtap"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NetworkInterfaceTapConfiguration;
 * import com.pulumi.azurenative.network.NetworkInterfaceTapConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkInterfaceTapConfiguration = new NetworkInterfaceTapConfiguration("networkInterfaceTapConfiguration", NetworkInterfaceTapConfigurationArgs.builder()
 *             .networkInterfaceName("mynic")
 *             .resourceGroupName("testrg")
 *             .tapConfigurationName("tapconfiguration1")
 *             .virtualNetworkTap(Map.of("id", "/subscriptions/subid/resourceGroups/testrg/providers/Microsoft.Network/virtualNetworkTaps/testvtap"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NetworkInterfaceTapConfiguration tapConfiguration1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkInterfaces/{networkInterfaceName}/tapConfigurations/{tapConfigurationName}
 * ```
 */
public class NetworkInterfaceTapConfiguration internal constructor(
    override val javaResource: com.pulumi.azurenative.network.NetworkInterfaceTapConfiguration,
) : KotlinCustomResource(javaResource, NetworkInterfaceTapConfigurationMapper) {
    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The provisioning state of the network interface tap configuration resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Sub Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The reference to the Virtual Network Tap resource.
     */
    public val virtualNetworkTap: Output<VirtualNetworkTapResponse>?
        get() = javaResource.virtualNetworkTap().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })
}

public object NetworkInterfaceTapConfigurationMapper :
    ResourceMapper<NetworkInterfaceTapConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.NetworkInterfaceTapConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): NetworkInterfaceTapConfiguration =
        NetworkInterfaceTapConfiguration(
            javaResource as
                com.pulumi.azurenative.network.NetworkInterfaceTapConfiguration,
        )
}

/**
 * @see [NetworkInterfaceTapConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkInterfaceTapConfiguration].
 */
public suspend fun networkInterfaceTapConfiguration(
    name: String,
    block: suspend NetworkInterfaceTapConfigurationResourceBuilder.() -> Unit,
):
    NetworkInterfaceTapConfiguration {
    val builder = NetworkInterfaceTapConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkInterfaceTapConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkInterfaceTapConfiguration(name: String): NetworkInterfaceTapConfiguration {
    val builder = NetworkInterfaceTapConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
