@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.PerimeterBasedAccessRuleResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubscriptionIdResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.PerimeterBasedAccessRuleResponse.Companion.toKotlin as perimeterBasedAccessRuleResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubscriptionIdResponse.Companion.toKotlin as subscriptionIdResponseToKotlin

/**
 * Builder for [NspAccessRule].
 */
@PulumiTagMarker
public class NspAccessRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NspAccessRuleArgs = NspAccessRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NspAccessRuleArgsBuilder.() -> Unit) {
        val builder = NspAccessRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NspAccessRule {
        val builtJavaResource = com.pulumi.azurenative.network.NspAccessRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NspAccessRule(builtJavaResource)
    }
}

/**
 * The NSP access rule resource
 * Azure REST API version: 2021-02-01-preview. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### NspAccessRulePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nspAccessRule = new AzureNative.Network.NspAccessRule("nspAccessRule", new()
 *     {
 *         AccessRuleName = "accessRule1",
 *         AddressPrefixes = new[]
 *         {
 *             "10.11.0.0/16",
 *             "10.10.1.0/24",
 *         },
 *         Direction = "Inbound",
 *         NetworkSecurityPerimeterName = "nsp1",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewNspAccessRule(ctx, "nspAccessRule", &network.NspAccessRuleArgs{
 * 			AccessRuleName: pulumi.String("accessRule1"),
 * 			AddressPrefixes: pulumi.StringArray{
 * 				pulumi.String("10.11.0.0/16"),
 * 				pulumi.String("10.10.1.0/24"),
 * 			},
 * 			Direction:                    pulumi.String("Inbound"),
 * 			NetworkSecurityPerimeterName: pulumi.String("nsp1"),
 * 			ProfileName:                  pulumi.String("profile1"),
 * 			ResourceGroupName:            pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.NspAccessRule;
 * import com.pulumi.azurenative.network.NspAccessRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nspAccessRule = new NspAccessRule("nspAccessRule", NspAccessRuleArgs.builder()
 *             .accessRuleName("accessRule1")
 *             .addressPrefixes(
 *                 "10.11.0.0/16",
 *                 "10.10.1.0/24")
 *             .direction("Inbound")
 *             .networkSecurityPerimeterName("nsp1")
 *             .profileName("profile1")
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:NspAccessRule accessRule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkSecurityPerimeters/{networkSecurityPerimeterName}/profiles/{profileName}/accessRules/{accessRuleName}
 * ```
 */
public class NspAccessRule internal constructor(
    override val javaResource: com.pulumi.azurenative.network.NspAccessRule,
) : KotlinCustomResource(javaResource, NspAccessRuleMapper) {
    /**
     * Inbound address prefixes (IPv4/IPv6)
     */
    public val addressPrefixes: Output<List<String>>?
        get() = javaResource.addressPrefixes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Direction that specifies whether the access rules is inbound/outbound.
     */
    public val direction: Output<String>?
        get() = javaResource.direction().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Outbound rules email address format.
     */
    public val emailAddresses: Output<List<String>>?
        get() = javaResource.emailAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Outbound rules fully qualified domain name format.
     */
    public val fullyQualifiedDomainNames: Output<List<String>>?
        get() = javaResource.fullyQualifiedDomainNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Rule specified by the perimeter id.
     */
    public val networkSecurityPerimeters: Output<List<PerimeterBasedAccessRuleResponse>>
        get() = javaResource.networkSecurityPerimeters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> perimeterBasedAccessRuleResponseToKotlin(args0) })
            })
        })

    /**
     * Outbound rules phone number format.
     */
    public val phoneNumbers: Output<List<String>>?
        get() = javaResource.phoneNumbers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the scope assignment resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * List of subscription ids
     */
    public val subscriptions: Output<List<SubscriptionIdResponse>>?
        get() = javaResource.subscriptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        subscriptionIdResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NspAccessRuleMapper : ResourceMapper<NspAccessRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.NspAccessRule::class == javaResource::class

    override fun map(javaResource: Resource): NspAccessRule = NspAccessRule(
        javaResource as
            com.pulumi.azurenative.network.NspAccessRule,
    )
}

/**
 * @see [NspAccessRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NspAccessRule].
 */
public suspend fun nspAccessRule(
    name: String,
    block: suspend NspAccessRuleResourceBuilder.() -> Unit,
): NspAccessRule {
    val builder = NspAccessRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NspAccessRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun nspAccessRule(name: String): NspAccessRule {
    val builder = NspAccessRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
