@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.OutboundEndpointArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes an outbound endpoint for a DNS resolver.
 * Azure REST API version: 2022-07-01. Prior API version in Azure Native 1.x: 2020-04-01-preview.
 * Other available API versions: 2020-04-01-preview.
 * ## Example Usage
 * ### Upsert outbound endpoint for DNS resolver
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var outboundEndpoint = new AzureNative.Network.OutboundEndpoint("outboundEndpoint", new()
 *     {
 *         DnsResolverName = "sampleDnsResolver",
 *         Location = "westus2",
 *         OutboundEndpointName = "sampleOutboundEndpoint",
 *         ResourceGroupName = "sampleResourceGroup",
 *         Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork/subnets/sampleSubnet",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewOutboundEndpoint(ctx, "outboundEndpoint", &network.OutboundEndpointArgs{
 * 			DnsResolverName:      pulumi.String("sampleDnsResolver"),
 * 			Location:             pulumi.String("westus2"),
 * 			OutboundEndpointName: pulumi.String("sampleOutboundEndpoint"),
 * 			ResourceGroupName:    pulumi.String("sampleResourceGroup"),
 * 			Subnet: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork/subnets/sampleSubnet"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.OutboundEndpoint;
 * import com.pulumi.azurenative.network.OutboundEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var outboundEndpoint = new OutboundEndpoint("outboundEndpoint", OutboundEndpointArgs.builder()
 *             .dnsResolverName("sampleDnsResolver")
 *             .location("westus2")
 *             .outboundEndpointName("sampleOutboundEndpoint")
 *             .resourceGroupName("sampleResourceGroup")
 *             .subnet(Map.of("id", "/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork/subnets/sampleSubnet"))
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:OutboundEndpoint sampleOutboundEndpoint /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsResolvers/{dnsResolverName}/outboundEndpoints/{outboundEndpointName}
 * ```
 * @property dnsResolverName The name of the DNS resolver.
 * @property location The geo-location where the resource lives
 * @property outboundEndpointName The name of the outbound endpoint for the DNS resolver.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property subnet The reference to the subnet used for the outbound endpoint.
 * @property tags Resource tags.
 */
public data class OutboundEndpointArgs(
    public val dnsResolverName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val outboundEndpointName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subnet: Output<SubResourceArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.OutboundEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.network.OutboundEndpointArgs =
        com.pulumi.azurenative.network.OutboundEndpointArgs.builder()
            .dnsResolverName(dnsResolverName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .outboundEndpointName(outboundEndpointName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [OutboundEndpointArgs].
 */
@PulumiTagMarker
public class OutboundEndpointArgsBuilder internal constructor() {
    private var dnsResolverName: Output<String>? = null

    private var location: Output<String>? = null

    private var outboundEndpointName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var subnet: Output<SubResourceArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the DNS resolver.
     */
    @JvmName("fkbajntglpuosjgg")
    public suspend fun dnsResolverName(`value`: Output<String>) {
        this.dnsResolverName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wdwfmpicpvlbisfq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the outbound endpoint for the DNS resolver.
     */
    @JvmName("qpwnetobeqhtmjke")
    public suspend fun outboundEndpointName(`value`: Output<String>) {
        this.outboundEndpointName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qbsnieefwvhsghse")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The reference to the subnet used for the outbound endpoint.
     */
    @JvmName("mychdkrqokagnaiw")
    public suspend fun subnet(`value`: Output<SubResourceArgs>) {
        this.subnet = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("munrdevkmliteski")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the DNS resolver.
     */
    @JvmName("jeskubmsbuvvxwsg")
    public suspend fun dnsResolverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsResolverName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ytvnjdvnptjthrfr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the outbound endpoint for the DNS resolver.
     */
    @JvmName("amohcsexvynxiaoa")
    public suspend fun outboundEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundEndpointName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lqrmqvtbjwujbxyp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The reference to the subnet used for the outbound endpoint.
     */
    @JvmName("ejqxsijqhghalvvr")
    public suspend fun subnet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument The reference to the subnet used for the outbound endpoint.
     */
    @JvmName("opnacvyxpjanbepx")
    public suspend fun subnet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("aieshjyqapsmqtis")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("bwsoogomuecsstgd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): OutboundEndpointArgs = OutboundEndpointArgs(
        dnsResolverName = dnsResolverName,
        location = location,
        outboundEndpointName = outboundEndpointName,
        resourceGroupName = resourceGroupName,
        subnet = subnet,
        tags = tags,
    )
}
