@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.P2SConnectionConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.VpnClientConnectionHealthResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.P2SConnectionConfigurationResponse.Companion.toKotlin as p2SConnectionConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin as subResourceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.VpnClientConnectionHealthResponse.Companion.toKotlin as vpnClientConnectionHealthResponseToKotlin

/**
 * Builder for [P2sVpnGateway].
 */
@PulumiTagMarker
public class P2sVpnGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: P2sVpnGatewayArgs = P2sVpnGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend P2sVpnGatewayArgsBuilder.() -> Unit) {
        val builder = P2sVpnGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): P2sVpnGateway {
        val builtJavaResource = com.pulumi.azurenative.network.P2sVpnGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return P2sVpnGateway(builtJavaResource)
    }
}

/**
 * P2SVpnGateway Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-07-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### P2SVpnGatewayPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var p2sVpnGateway = new AzureNative.Network.P2sVpnGateway("p2sVpnGateway", new()
 *     {
 *         CustomDnsServers = new[]
 *         {
 *             "1.1.1.1",
 *             "2.2.2.2",
 *         },
 *         GatewayName = "p2sVpnGateway1",
 *         IsRoutingPreferenceInternet = false,
 *         Location = "West US",
 *         P2SConnectionConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.P2SConnectionConfigurationArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/p2sVpnGateways/p2sVpnGateway1/p2sConnectionConfigurations/P2SConnectionConfig1",
 *                 Name = "P2SConnectionConfig1",
 *                 RoutingConfiguration = new AzureNative.Network.Inputs.RoutingConfigurationArgs
 *                 {
 *                     AssociatedRouteTable = new AzureNative.Network.Inputs.SubResourceArgs
 *                     {
 *                         Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1",
 *                     },
 *                     PropagatedRouteTables = new AzureNative.Network.Inputs.PropagatedRouteTableArgs
 *                     {
 *                         Ids = new[]
 *                         {
 *                             new AzureNative.Network.Inputs.SubResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1",
 *                             },
 *                             new AzureNative.Network.Inputs.SubResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable2",
 *                             },
 *                             new AzureNative.Network.Inputs.SubResourceArgs
 *                             {
 *                                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable3",
 *                             },
 *                         },
 *                         Labels = new[]
 *                         {
 *                             "label1",
 *                             "label2",
 *                         },
 *                     },
 *                     VnetRoutes = new AzureNative.Network.Inputs.VnetRouteArgs
 *                     {
 *                         StaticRoutes = new[] {},
 *                     },
 *                 },
 *                 VpnClientAddressPool = new AzureNative.Network.Inputs.AddressSpaceArgs
 *                 {
 *                     AddressPrefixes = new[]
 *                     {
 *                         "101.3.0.0/16",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualHub = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1",
 *         },
 *         VpnGatewayScaleUnit = 1,
 *         VpnServerConfiguration = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewP2sVpnGateway(ctx, "p2sVpnGateway", &network.P2sVpnGatewayArgs{
 * 			CustomDnsServers: pulumi.StringArray{
 * 				pulumi.String("1.1.1.1"),
 * 				pulumi.String("2.2.2.2"),
 * 			},
 * 			GatewayName:                 pulumi.String("p2sVpnGateway1"),
 * 			IsRoutingPreferenceInternet: pulumi.Bool(false),
 * 			Location:                    pulumi.String("West US"),
 * 			P2SConnectionConfigurations: []network.P2SConnectionConfigurationArgs{
 * 				{
 * 					Id:   pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/p2sVpnGateways/p2sVpnGateway1/p2sConnectionConfigurations/P2SConnectionConfig1"),
 * 					Name: pulumi.String("P2SConnectionConfig1"),
 * 					RoutingConfiguration: {
 * 						AssociatedRouteTable: {
 * 							Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
 * 						},
 * 						PropagatedRouteTables: {
 * 							Ids: network.SubResourceArray{
 * 								{
 * 									Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
 * 								},
 * 								{
 * 									Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable2"),
 * 								},
 * 								{
 * 									Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable3"),
 * 								},
 * 							},
 * 							Labels: pulumi.StringArray{
 * 								pulumi.String("label1"),
 * 								pulumi.String("label2"),
 * 							},
 * 						},
 * 						VnetRoutes: {
 * 							StaticRoutes: network.StaticRouteArray{},
 * 						},
 * 					},
 * 					VpnClientAddressPool: {
 * 						AddressPrefixes: pulumi.StringArray{
 * 							pulumi.String("101.3.0.0/16"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualHub: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1"),
 * 			},
 * 			VpnGatewayScaleUnit: pulumi.Int(1),
 * 			VpnServerConfiguration: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.P2sVpnGateway;
 * import com.pulumi.azurenative.network.P2sVpnGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var p2sVpnGateway = new P2sVpnGateway("p2sVpnGateway", P2sVpnGatewayArgs.builder()
 *             .customDnsServers(
 *                 "1.1.1.1",
 *                 "2.2.2.2")
 *             .gatewayName("p2sVpnGateway1")
 *             .isRoutingPreferenceInternet(false)
 *             .location("West US")
 *             .p2SConnectionConfigurations(Map.ofEntries(
 *                 Map.entry("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/p2sVpnGateways/p2sVpnGateway1/p2sConnectionConfigurations/P2SConnectionConfig1"),
 *                 Map.entry("name", "P2SConnectionConfig1"),
 *                 Map.entry("routingConfiguration", Map.ofEntries(
 *                     Map.entry("associatedRouteTable", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1")),
 *                     Map.entry("propagatedRouteTables", Map.ofEntries(
 *                         Map.entry("ids",
 *                             Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable1"),
 *                             Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable2"),
 *                             Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1/hubRouteTables/hubRouteTable3")),
 *                         Map.entry("labels",
 *                             "label1",
 *                             "label2")
 *                     )),
 *                     Map.entry("vnetRoutes", Map.of("staticRoutes", ))
 *                 )),
 *                 Map.entry("vpnClientAddressPool", Map.of("addressPrefixes", "101.3.0.0/16"))
 *             ))
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualHub(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/virtualHub1"))
 *             .vpnGatewayScaleUnit(1)
 *             .vpnServerConfiguration(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:P2sVpnGateway p2sVpnGateway1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/p2svpnGateways/{gatewayName}
 * ```
 */
public class P2sVpnGateway internal constructor(
    override val javaResource: com.pulumi.azurenative.network.P2sVpnGateway,
) : KotlinCustomResource(javaResource, P2sVpnGatewayMapper) {
    /**
     * List of all customer specified DNS servers IP addresses.
     */
    public val customDnsServers: Output<List<String>>?
        get() = javaResource.customDnsServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Enable Routing Preference property for the Public IP Interface of the P2SVpnGateway.
     */
    public val isRoutingPreferenceInternet: Output<Boolean>?
        get() = javaResource.isRoutingPreferenceInternet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of all p2s connection configurations of the gateway.
     */
    public val p2SConnectionConfigurations: Output<List<P2SConnectionConfigurationResponse>>?
        get() = javaResource.p2SConnectionConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        p2SConnectionConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the P2S VPN gateway resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The VirtualHub to which the gateway belongs.
     */
    public val virtualHub: Output<SubResourceResponse>?
        get() = javaResource.virtualHub().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * All P2S VPN clients' connection health status.
     */
    public val vpnClientConnectionHealth: Output<VpnClientConnectionHealthResponse>
        get() = javaResource.vpnClientConnectionHealth().applyValue({ args0 ->
            args0.let({ args0 ->
                vpnClientConnectionHealthResponseToKotlin(args0)
            })
        })

    /**
     * The scale unit for this p2s vpn gateway.
     */
    public val vpnGatewayScaleUnit: Output<Int>?
        get() = javaResource.vpnGatewayScaleUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The VpnServerConfiguration to which the p2sVpnGateway is attached to.
     */
    public val vpnServerConfiguration: Output<SubResourceResponse>?
        get() = javaResource.vpnServerConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> subResourceResponseToKotlin(args0) })
            }).orElse(null)
        })
}

public object P2sVpnGatewayMapper : ResourceMapper<P2sVpnGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.P2sVpnGateway::class == javaResource::class

    override fun map(javaResource: Resource): P2sVpnGateway = P2sVpnGateway(
        javaResource as
            com.pulumi.azurenative.network.P2sVpnGateway,
    )
}

/**
 * @see [P2sVpnGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [P2sVpnGateway].
 */
public suspend fun p2sVpnGateway(
    name: String,
    block: suspend P2sVpnGatewayResourceBuilder.() -> Unit,
): P2sVpnGateway {
    val builder = P2sVpnGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [P2sVpnGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun p2sVpnGateway(name: String): P2sVpnGateway {
    val builder = P2sVpnGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
