@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.ApplicationSecurityGroupResponse
import com.pulumi.azurenative.network.kotlin.outputs.CustomDnsConfigPropertiesFormatResponse
import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceResponse
import com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointIPConfigurationResponse
import com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceConnectionResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.ApplicationSecurityGroupResponse.Companion.toKotlin as applicationSecurityGroupResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.CustomDnsConfigPropertiesFormatResponse.Companion.toKotlin as customDnsConfigPropertiesFormatResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin as networkInterfaceResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointIPConfigurationResponse.Companion.toKotlin as privateEndpointIPConfigurationResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceConnectionResponse.Companion.toKotlin as privateLinkServiceConnectionResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin as subnetResponseToKotlin

/**
 * Builder for [PrivateEndpoint].
 */
@PulumiTagMarker
public class PrivateEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrivateEndpointArgs = PrivateEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrivateEndpointArgsBuilder.() -> Unit) {
        val builder = PrivateEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrivateEndpoint {
        val builtJavaResource = com.pulumi.azurenative.network.PrivateEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PrivateEndpoint(builtJavaResource)
    }
}

/**
 * Private endpoint resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2021-02-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create private endpoint
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpoint = new AzureNative.Network.PrivateEndpoint("privateEndpoint", new()
 *     {
 *         CustomNetworkInterfaceName = "testPeNic",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.PrivateEndpointIPConfigurationArgs
 *             {
 *                 GroupId = "file",
 *                 MemberName = "file",
 *                 Name = "pestaticconfig",
 *                 PrivateIPAddress = "192.168.0.6",
 *             },
 *         },
 *         Location = "eastus2euap",
 *         PrivateEndpointName = "testPe",
 *         PrivateLinkServiceConnections = new[]
 *         {
 *             new AzureNative.Network.Inputs.PrivateLinkServiceConnectionArgs
 *             {
 *                 GroupIds = new[]
 *                 {
 *                     "groupIdFromResource",
 *                 },
 *                 PrivateLinkServiceId = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls",
 *                 RequestMessage = "Please approve my connection.",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *         {
 *             Id = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateEndpoint(ctx, "privateEndpoint", &network.PrivateEndpointArgs{
 * 			CustomNetworkInterfaceName: pulumi.String("testPeNic"),
 * 			IpConfigurations: []network.PrivateEndpointIPConfigurationArgs{
 * 				{
 * 					GroupId:          pulumi.String("file"),
 * 					MemberName:       pulumi.String("file"),
 * 					Name:             pulumi.String("pestaticconfig"),
 * 					PrivateIPAddress: pulumi.String("192.168.0.6"),
 * 				},
 * 			},
 * 			Location:            pulumi.String("eastus2euap"),
 * 			PrivateEndpointName: pulumi.String("testPe"),
 * 			PrivateLinkServiceConnections: []network.PrivateLinkServiceConnectionArgs{
 * 				{
 * 					GroupIds: pulumi.StringArray{
 * 						pulumi.String("groupIdFromResource"),
 * 					},
 * 					PrivateLinkServiceId: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls"),
 * 					RequestMessage:       pulumi.String("Please approve my connection."),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnet: &network.SubnetTypeArgs{
 * 				Id: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateEndpoint;
 * import com.pulumi.azurenative.network.PrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpoint = new PrivateEndpoint("privateEndpoint", PrivateEndpointArgs.builder()
 *             .customNetworkInterfaceName("testPeNic")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("groupId", "file"),
 *                 Map.entry("memberName", "file"),
 *                 Map.entry("name", "pestaticconfig"),
 *                 Map.entry("privateIPAddress", "192.168.0.6")
 *             ))
 *             .location("eastus2euap")
 *             .privateEndpointName("testPe")
 *             .privateLinkServiceConnections(Map.ofEntries(
 *                 Map.entry("groupIds", "groupIdFromResource"),
 *                 Map.entry("privateLinkServiceId", "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls"),
 *                 Map.entry("requestMessage", "Please approve my connection.")
 *             ))
 *             .resourceGroupName("rg1")
 *             .subnet(Map.of("id", "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create private endpoint with application security groups
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpoint = new AzureNative.Network.PrivateEndpoint("privateEndpoint", new()
 *     {
 *         ApplicationSecurityGroups = new[]
 *         {
 *             new AzureNative.Network.Inputs.ApplicationSecurityGroupArgs
 *             {
 *                 Id = "/subscriptions/subId/resourceGroups/rg1/provders/Microsoft.Network/applicationSecurityGroup/asg1",
 *             },
 *         },
 *         Location = "eastus2euap",
 *         PrivateEndpointName = "testPe",
 *         PrivateLinkServiceConnections = new[]
 *         {
 *             new AzureNative.Network.Inputs.PrivateLinkServiceConnectionArgs
 *             {
 *                 GroupIds = new[]
 *                 {
 *                     "groupIdFromResource",
 *                 },
 *                 PrivateLinkServiceId = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls",
 *                 RequestMessage = "Please approve my connection.",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *         {
 *             Id = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateEndpoint(ctx, "privateEndpoint", &network.PrivateEndpointArgs{
 * 			ApplicationSecurityGroups: []network.ApplicationSecurityGroupTypeArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptions/subId/resourceGroups/rg1/provders/Microsoft.Network/applicationSecurityGroup/asg1"),
 * 				},
 * 			},
 * 			Location:            pulumi.String("eastus2euap"),
 * 			PrivateEndpointName: pulumi.String("testPe"),
 * 			PrivateLinkServiceConnections: []network.PrivateLinkServiceConnectionArgs{
 * 				{
 * 					GroupIds: pulumi.StringArray{
 * 						pulumi.String("groupIdFromResource"),
 * 					},
 * 					PrivateLinkServiceId: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls"),
 * 					RequestMessage:       pulumi.String("Please approve my connection."),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnet: &network.SubnetTypeArgs{
 * 				Id: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateEndpoint;
 * import com.pulumi.azurenative.network.PrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpoint = new PrivateEndpoint("privateEndpoint", PrivateEndpointArgs.builder()
 *             .applicationSecurityGroups(Map.of("id", "/subscriptions/subId/resourceGroups/rg1/provders/Microsoft.Network/applicationSecurityGroup/asg1"))
 *             .location("eastus2euap")
 *             .privateEndpointName("testPe")
 *             .privateLinkServiceConnections(Map.ofEntries(
 *                 Map.entry("groupIds", "groupIdFromResource"),
 *                 Map.entry("privateLinkServiceId", "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls"),
 *                 Map.entry("requestMessage", "Please approve my connection.")
 *             ))
 *             .resourceGroupName("rg1")
 *             .subnet(Map.of("id", "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create private endpoint with manual approval connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpoint = new AzureNative.Network.PrivateEndpoint("privateEndpoint", new()
 *     {
 *         CustomNetworkInterfaceName = "testPeNic",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.PrivateEndpointIPConfigurationArgs
 *             {
 *                 GroupId = "file",
 *                 MemberName = "file",
 *                 Name = "pestaticconfig",
 *                 PrivateIPAddress = "192.168.0.5",
 *             },
 *         },
 *         Location = "eastus",
 *         ManualPrivateLinkServiceConnections = new[]
 *         {
 *             new AzureNative.Network.Inputs.PrivateLinkServiceConnectionArgs
 *             {
 *                 GroupIds = new[]
 *                 {
 *                     "groupIdFromResource",
 *                 },
 *                 PrivateLinkServiceId = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls",
 *                 RequestMessage = "Please manually approve my connection.",
 *             },
 *         },
 *         PrivateEndpointName = "testPe",
 *         ResourceGroupName = "rg1",
 *         Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *         {
 *             Id = "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateEndpoint(ctx, "privateEndpoint", &network.PrivateEndpointArgs{
 * 			CustomNetworkInterfaceName: pulumi.String("testPeNic"),
 * 			IpConfigurations: []network.PrivateEndpointIPConfigurationArgs{
 * 				{
 * 					GroupId:          pulumi.String("file"),
 * 					MemberName:       pulumi.String("file"),
 * 					Name:             pulumi.String("pestaticconfig"),
 * 					PrivateIPAddress: pulumi.String("192.168.0.5"),
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			ManualPrivateLinkServiceConnections: []network.PrivateLinkServiceConnectionArgs{
 * 				{
 * 					GroupIds: pulumi.StringArray{
 * 						pulumi.String("groupIdFromResource"),
 * 					},
 * 					PrivateLinkServiceId: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls"),
 * 					RequestMessage:       pulumi.String("Please manually approve my connection."),
 * 				},
 * 			},
 * 			PrivateEndpointName: pulumi.String("testPe"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			Subnet: &network.SubnetTypeArgs{
 * 				Id: pulumi.String("/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateEndpoint;
 * import com.pulumi.azurenative.network.PrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpoint = new PrivateEndpoint("privateEndpoint", PrivateEndpointArgs.builder()
 *             .customNetworkInterfaceName("testPeNic")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("groupId", "file"),
 *                 Map.entry("memberName", "file"),
 *                 Map.entry("name", "pestaticconfig"),
 *                 Map.entry("privateIPAddress", "192.168.0.5")
 *             ))
 *             .location("eastus")
 *             .manualPrivateLinkServiceConnections(Map.ofEntries(
 *                 Map.entry("groupIds", "groupIdFromResource"),
 *                 Map.entry("privateLinkServiceId", "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/privateLinkServices/testPls"),
 *                 Map.entry("requestMessage", "Please manually approve my connection.")
 *             ))
 *             .privateEndpointName("testPe")
 *             .resourceGroupName("rg1")
 *             .subnet(Map.of("id", "/subscriptions/subId/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/myVnet/subnets/mySubnet"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PrivateEndpoint testPe /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateEndpoints/{privateEndpointName}
 * ```
 */
public class PrivateEndpoint internal constructor(
    override val javaResource: com.pulumi.azurenative.network.PrivateEndpoint,
) : KotlinCustomResource(javaResource, PrivateEndpointMapper) {
    /**
     * Application security groups in which the private endpoint IP configuration is included.
     */
    public val applicationSecurityGroups: Output<List<ApplicationSecurityGroupResponse>>?
        get() = javaResource.applicationSecurityGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationSecurityGroupResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * An array of custom dns configurations.
     */
    public val customDnsConfigs: Output<List<CustomDnsConfigPropertiesFormatResponse>>?
        get() = javaResource.customDnsConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        customDnsConfigPropertiesFormatResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The custom name of the network interface attached to the private endpoint.
     */
    public val customNetworkInterfaceName: Output<String>?
        get() = javaResource.customNetworkInterfaceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The extended location of the load balancer.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A list of IP configurations of the private endpoint. This will be used to map to the First Party Service's endpoints.
     */
    public val ipConfigurations: Output<List<PrivateEndpointIPConfigurationResponse>>?
        get() = javaResource.ipConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        privateEndpointIPConfigurationResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A grouping of information about the connection to the remote resource. Used when the network admin does not have access to approve connections to the remote resource.
     */
    public val manualPrivateLinkServiceConnections:
        Output<List<PrivateLinkServiceConnectionResponse>>?
        get() = javaResource.manualPrivateLinkServiceConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        privateLinkServiceConnectionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * An array of references to the network interfaces created for this private endpoint.
     */
    public val networkInterfaces: Output<List<NetworkInterfaceResponse>>
        get() = javaResource.networkInterfaces().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkInterfaceResponseToKotlin(args0) })
            })
        })

    /**
     * A grouping of information about the connection to the remote resource.
     */
    public val privateLinkServiceConnections: Output<List<PrivateLinkServiceConnectionResponse>>?
        get() = javaResource.privateLinkServiceConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        privateLinkServiceConnectionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The provisioning state of the private endpoint resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The ID of the subnet from which the private IP will be allocated.
     */
    public val subnet: Output<SubnetResponse>?
        get() = javaResource.subnet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subnetResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PrivateEndpointMapper : ResourceMapper<PrivateEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.PrivateEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): PrivateEndpoint = PrivateEndpoint(
        javaResource as
            com.pulumi.azurenative.network.PrivateEndpoint,
    )
}

/**
 * @see [PrivateEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrivateEndpoint].
 */
public suspend fun privateEndpoint(
    name: String,
    block: suspend PrivateEndpointResourceBuilder.() -> Unit,
): PrivateEndpoint {
    val builder = PrivateEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrivateEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun privateEndpoint(name: String): PrivateEndpoint {
    val builder = PrivateEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
