@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.PrivateResolverVirtualNetworkLinkArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a virtual network link.
 * Azure REST API version: 2022-07-01.
 * Other available API versions: 2020-04-01-preview.
 * ## Example Usage
 * ### Upsert virtual network link to a DNS forwarding ruleset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateResolverVirtualNetworkLink = new AzureNative.Network.PrivateResolverVirtualNetworkLink("privateResolverVirtualNetworkLink", new()
 *     {
 *         DnsForwardingRulesetName = "sampleDnsForwardingRuleset",
 *         Metadata =
 *         {
 *             { "additionalProp1", "value1" },
 *         },
 *         ResourceGroupName = "sampleResourceGroup",
 *         VirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork",
 *         },
 *         VirtualNetworkLinkName = "sampleVirtualNetworkLink",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPrivateResolverVirtualNetworkLink(ctx, "privateResolverVirtualNetworkLink", &network.PrivateResolverVirtualNetworkLinkArgs{
 * 			DnsForwardingRulesetName: pulumi.String("sampleDnsForwardingRuleset"),
 * 			Metadata: pulumi.StringMap{
 * 				"additionalProp1": pulumi.String("value1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("sampleResourceGroup"),
 * 			VirtualNetwork: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork"),
 * 			},
 * 			VirtualNetworkLinkName: pulumi.String("sampleVirtualNetworkLink"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PrivateResolverVirtualNetworkLink;
 * import com.pulumi.azurenative.network.PrivateResolverVirtualNetworkLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateResolverVirtualNetworkLink = new PrivateResolverVirtualNetworkLink("privateResolverVirtualNetworkLink", PrivateResolverVirtualNetworkLinkArgs.builder()
 *             .dnsForwardingRulesetName("sampleDnsForwardingRuleset")
 *             .metadata(Map.of("additionalProp1", "value1"))
 *             .resourceGroupName("sampleResourceGroup")
 *             .virtualNetwork(Map.of("id", "/subscriptions/0403cfa9-9659-4f33-9f30-1f191c51d111/resourceGroups/sampleVnetResourceGroupName/providers/Microsoft.Network/virtualNetworks/sampleVirtualNetwork"))
 *             .virtualNetworkLinkName("sampleVirtualNetworkLink")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PrivateResolverVirtualNetworkLink sampleVirtualNetworkLink /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsForwardingRulesets/{dnsForwardingRulesetName}/virtualNetworkLinks/{virtualNetworkLinkName}
 * ```
 * @property dnsForwardingRulesetName The name of the DNS forwarding ruleset.
 * @property metadata Metadata attached to the virtual network link.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property virtualNetwork The reference to the virtual network. This cannot be changed after creation.
 * @property virtualNetworkLinkName The name of the virtual network link.
 */
public data class PrivateResolverVirtualNetworkLinkArgs(
    public val dnsForwardingRulesetName: Output<String>? = null,
    public val metadata: Output<Map<String, String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val virtualNetwork: Output<SubResourceArgs>? = null,
    public val virtualNetworkLinkName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.PrivateResolverVirtualNetworkLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.network.PrivateResolverVirtualNetworkLinkArgs =
        com.pulumi.azurenative.network.PrivateResolverVirtualNetworkLinkArgs.builder()
            .dnsForwardingRulesetName(dnsForwardingRulesetName?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .virtualNetwork(virtualNetwork?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .virtualNetworkLinkName(virtualNetworkLinkName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateResolverVirtualNetworkLinkArgs].
 */
@PulumiTagMarker
public class PrivateResolverVirtualNetworkLinkArgsBuilder internal constructor() {
    private var dnsForwardingRulesetName: Output<String>? = null

    private var metadata: Output<Map<String, String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var virtualNetwork: Output<SubResourceArgs>? = null

    private var virtualNetworkLinkName: Output<String>? = null

    /**
     * @param value The name of the DNS forwarding ruleset.
     */
    @JvmName("tbhgwggtuiawsyjs")
    public suspend fun dnsForwardingRulesetName(`value`: Output<String>) {
        this.dnsForwardingRulesetName = value
    }

    /**
     * @param value Metadata attached to the virtual network link.
     */
    @JvmName("ayakcdsftvritebe")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eqlepobltykvyirh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The reference to the virtual network. This cannot be changed after creation.
     */
    @JvmName("ihtpqnnrgxrrvbgh")
    public suspend fun virtualNetwork(`value`: Output<SubResourceArgs>) {
        this.virtualNetwork = value
    }

    /**
     * @param value The name of the virtual network link.
     */
    @JvmName("qbnxdsqayetxqgts")
    public suspend fun virtualNetworkLinkName(`value`: Output<String>) {
        this.virtualNetworkLinkName = value
    }

    /**
     * @param value The name of the DNS forwarding ruleset.
     */
    @JvmName("whlgisduykpvvsdw")
    public suspend fun dnsForwardingRulesetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsForwardingRulesetName = mapped
    }

    /**
     * @param value Metadata attached to the virtual network link.
     */
    @JvmName("hipbdybtgdnwxqms")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values Metadata attached to the virtual network link.
     */
    @JvmName("amtbdvicpfvekpus")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yhlixbnfkabfcuyh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The reference to the virtual network. This cannot be changed after creation.
     */
    @JvmName("uwyhcujeiolhvngg")
    public suspend fun virtualNetwork(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetwork = mapped
    }

    /**
     * @param argument The reference to the virtual network. This cannot be changed after creation.
     */
    @JvmName("ktgkoeijadjltmob")
    public suspend fun virtualNetwork(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetwork = mapped
    }

    /**
     * @param value The name of the virtual network link.
     */
    @JvmName("kjiatwxmmgimfkqo")
    public suspend fun virtualNetworkLinkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkLinkName = mapped
    }

    internal fun build(): PrivateResolverVirtualNetworkLinkArgs =
        PrivateResolverVirtualNetworkLinkArgs(
            dnsForwardingRulesetName = dnsForwardingRulesetName,
            metadata = metadata,
            resourceGroupName = resourceGroupName,
            virtualNetwork = virtualNetwork,
            virtualNetworkLinkName = virtualNetworkLinkName,
        )
}
