@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.DnsConfigResponse
import com.pulumi.azurenative.network.kotlin.outputs.EndpointResponse
import com.pulumi.azurenative.network.kotlin.outputs.MonitorConfigResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.network.kotlin.outputs.DnsConfigResponse.Companion.toKotlin as dnsConfigResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.EndpointResponse.Companion.toKotlin as endpointResponseToKotlin
import com.pulumi.azurenative.network.kotlin.outputs.MonitorConfigResponse.Companion.toKotlin as monitorConfigResponseToKotlin

/**
 * Builder for [Profile].
 */
@PulumiTagMarker
public class ProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProfileArgs = ProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProfileArgsBuilder.() -> Unit) {
        val builder = ProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Profile {
        val builtJavaResource = com.pulumi.azurenative.network.Profile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Profile(builtJavaResource)
    }
}

/**
 * Class representing a Traffic Manager profile.
 * Azure REST API version: 2022-04-01. Prior API version in Azure Native 1.x: 2018-08-01.
 * Other available API versions: 2017-03-01, 2018-02-01, 2022-04-01-preview.
 * ## Example Usage
 * ### Profile-PUT-MultiValue
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.Network.Profile("profile", new()
 *     {
 *         DnsConfig = new AzureNative.Network.Inputs.DnsConfigArgs
 *         {
 *             RelativeName = "azsmnet6386",
 *             Ttl = 35,
 *         },
 *         Location = "global",
 *         MaxReturn = 2,
 *         MonitorConfig = new AzureNative.Network.Inputs.MonitorConfigArgs
 *         {
 *             Path = "/testpath.aspx",
 *             Port = 80,
 *             Protocol = "HTTP",
 *         },
 *         ProfileName = "azsmnet6386",
 *         ProfileStatus = "Enabled",
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager1421",
 *         TrafficRoutingMethod = "MultiValue",
 *         TrafficViewEnrollmentStatus = "Disabled",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewProfile(ctx, "profile", &network.ProfileArgs{
 * 			DnsConfig: &network.DnsConfigArgs{
 * 				RelativeName: pulumi.String("azsmnet6386"),
 * 				Ttl:          pulumi.Float64(35),
 * 			},
 * 			Location:  pulumi.String("global"),
 * 			MaxReturn: pulumi.Float64(2),
 * 			MonitorConfig: &network.MonitorConfigArgs{
 * 				Path:     pulumi.String("/testpath.aspx"),
 * 				Port:     pulumi.Float64(80),
 * 				Protocol: pulumi.String("HTTP"),
 * 			},
 * 			ProfileName:                 pulumi.String("azsmnet6386"),
 * 			ProfileStatus:               pulumi.String("Enabled"),
 * 			ResourceGroupName:           pulumi.String("azuresdkfornetautoresttrafficmanager1421"),
 * 			TrafficRoutingMethod:        pulumi.String("MultiValue"),
 * 			TrafficViewEnrollmentStatus: pulumi.String("Disabled"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Profile;
 * import com.pulumi.azurenative.network.ProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .dnsConfig(Map.ofEntries(
 *                 Map.entry("relativeName", "azsmnet6386"),
 *                 Map.entry("ttl", 35)
 *             ))
 *             .location("global")
 *             .maxReturn(2)
 *             .monitorConfig(Map.ofEntries(
 *                 Map.entry("path", "/testpath.aspx"),
 *                 Map.entry("port", 80),
 *                 Map.entry("protocol", "HTTP")
 *             ))
 *             .profileName("azsmnet6386")
 *             .profileStatus("Enabled")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager1421")
 *             .trafficRoutingMethod("MultiValue")
 *             .trafficViewEnrollmentStatus("Disabled")
 *             .build());
 *     }
 * }
 * ```
 * ### Profile-PUT-NoEndpoints
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.Network.Profile("profile", new()
 *     {
 *         DnsConfig = new AzureNative.Network.Inputs.DnsConfigArgs
 *         {
 *             RelativeName = "azsmnet6386",
 *             Ttl = 35,
 *         },
 *         Location = "global",
 *         MonitorConfig = new AzureNative.Network.Inputs.MonitorConfigArgs
 *         {
 *             Path = "/testpath.aspx",
 *             Port = 80,
 *             Protocol = "HTTP",
 *         },
 *         ProfileName = "azsmnet6386",
 *         ProfileStatus = "Enabled",
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager1421",
 *         TrafficRoutingMethod = "Performance",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewProfile(ctx, "profile", &network.ProfileArgs{
 * 			DnsConfig: &network.DnsConfigArgs{
 * 				RelativeName: pulumi.String("azsmnet6386"),
 * 				Ttl:          pulumi.Float64(35),
 * 			},
 * 			Location: pulumi.String("global"),
 * 			MonitorConfig: &network.MonitorConfigArgs{
 * 				Path:     pulumi.String("/testpath.aspx"),
 * 				Port:     pulumi.Float64(80),
 * 				Protocol: pulumi.String("HTTP"),
 * 			},
 * 			ProfileName:          pulumi.String("azsmnet6386"),
 * 			ProfileStatus:        pulumi.String("Enabled"),
 * 			ResourceGroupName:    pulumi.String("azuresdkfornetautoresttrafficmanager1421"),
 * 			TrafficRoutingMethod: pulumi.String("Performance"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Profile;
 * import com.pulumi.azurenative.network.ProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .dnsConfig(Map.ofEntries(
 *                 Map.entry("relativeName", "azsmnet6386"),
 *                 Map.entry("ttl", 35)
 *             ))
 *             .location("global")
 *             .monitorConfig(Map.ofEntries(
 *                 Map.entry("path", "/testpath.aspx"),
 *                 Map.entry("port", 80),
 *                 Map.entry("protocol", "HTTP")
 *             ))
 *             .profileName("azsmnet6386")
 *             .profileStatus("Enabled")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager1421")
 *             .trafficRoutingMethod("Performance")
 *             .build());
 *     }
 * }
 * ```
 * ### Profile-PUT-WithAliasing
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.Network.Profile("profile", new()
 *     {
 *         AllowedEndpointRecordTypes = new[]
 *         {
 *             "DomainName",
 *         },
 *         DnsConfig = new AzureNative.Network.Inputs.DnsConfigArgs
 *         {
 *             RelativeName = "azuresdkfornetautoresttrafficmanager6192",
 *             Ttl = 35,
 *         },
 *         Endpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.EndpointArgs
 *             {
 *                 EndpointLocation = "North Europe",
 *                 EndpointStatus = "Enabled",
 *                 Name = "My external endpoint",
 *                 Target = "foobar.contoso.com",
 *                 Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *             },
 *         },
 *         Location = "global",
 *         MonitorConfig = new AzureNative.Network.Inputs.MonitorConfigArgs
 *         {
 *             IntervalInSeconds = 10,
 *             Path = "/testpath.aspx",
 *             Port = 80,
 *             Protocol = "HTTP",
 *             TimeoutInSeconds = 5,
 *             ToleratedNumberOfFailures = 2,
 *         },
 *         ProfileName = "azuresdkfornetautoresttrafficmanager6192",
 *         ProfileStatus = "Enabled",
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager2583",
 *         TrafficRoutingMethod = "Performance",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewProfile(ctx, "profile", &network.ProfileArgs{
 * 			AllowedEndpointRecordTypes: pulumi.StringArray{
 * 				pulumi.String("DomainName"),
 * 			},
 * 			DnsConfig: &network.DnsConfigArgs{
 * 				RelativeName: pulumi.String("azuresdkfornetautoresttrafficmanager6192"),
 * 				Ttl:          pulumi.Float64(35),
 * 			},
 * 			Endpoints: []network.EndpointTypeArgs{
 * 				{
 * 					EndpointLocation: pulumi.String("North Europe"),
 * 					EndpointStatus:   pulumi.String("Enabled"),
 * 					Name:             pulumi.String("My external endpoint"),
 * 					Target:           pulumi.String("foobar.contoso.com"),
 * 					Type:             pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 				},
 * 			},
 * 			Location: pulumi.String("global"),
 * 			MonitorConfig: &network.MonitorConfigArgs{
 * 				IntervalInSeconds:         pulumi.Float64(10),
 * 				Path:                      pulumi.String("/testpath.aspx"),
 * 				Port:                      pulumi.Float64(80),
 * 				Protocol:                  pulumi.String("HTTP"),
 * 				TimeoutInSeconds:          pulumi.Float64(5),
 * 				ToleratedNumberOfFailures: pulumi.Float64(2),
 * 			},
 * 			ProfileName:          pulumi.String("azuresdkfornetautoresttrafficmanager6192"),
 * 			ProfileStatus:        pulumi.String("Enabled"),
 * 			ResourceGroupName:    pulumi.String("azuresdkfornetautoresttrafficmanager2583"),
 * 			TrafficRoutingMethod: pulumi.String("Performance"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Profile;
 * import com.pulumi.azurenative.network.ProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .allowedEndpointRecordTypes("DomainName")
 *             .dnsConfig(Map.ofEntries(
 *                 Map.entry("relativeName", "azuresdkfornetautoresttrafficmanager6192"),
 *                 Map.entry("ttl", 35)
 *             ))
 *             .endpoints(Map.ofEntries(
 *                 Map.entry("endpointLocation", "North Europe"),
 *                 Map.entry("endpointStatus", "Enabled"),
 *                 Map.entry("name", "My external endpoint"),
 *                 Map.entry("target", "foobar.contoso.com"),
 *                 Map.entry("type", "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *             ))
 *             .location("global")
 *             .monitorConfig(Map.ofEntries(
 *                 Map.entry("intervalInSeconds", 10),
 *                 Map.entry("path", "/testpath.aspx"),
 *                 Map.entry("port", 80),
 *                 Map.entry("protocol", "HTTP"),
 *                 Map.entry("timeoutInSeconds", 5),
 *                 Map.entry("toleratedNumberOfFailures", 2)
 *             ))
 *             .profileName("azuresdkfornetautoresttrafficmanager6192")
 *             .profileStatus("Enabled")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager2583")
 *             .trafficRoutingMethod("Performance")
 *             .build());
 *     }
 * }
 * ```
 * ### Profile-PUT-WithCustomHeaders
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.Network.Profile("profile", new()
 *     {
 *         DnsConfig = new AzureNative.Network.Inputs.DnsConfigArgs
 *         {
 *             RelativeName = "azuresdkfornetautoresttrafficmanager6192",
 *             Ttl = 35,
 *         },
 *         Endpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.EndpointArgs
 *             {
 *                 CustomHeaders = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.EndpointPropertiesCustomHeadersArgs
 *                     {
 *                         Name = "header-2",
 *                         Value = "value-2-overridden",
 *                     },
 *                 },
 *                 EndpointLocation = "North Europe",
 *                 EndpointStatus = "Enabled",
 *                 Name = "My external endpoint",
 *                 Target = "foobar.contoso.com",
 *                 Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *             },
 *         },
 *         Location = "global",
 *         MonitorConfig = new AzureNative.Network.Inputs.MonitorConfigArgs
 *         {
 *             CustomHeaders = new[]
 *             {
 *                 new AzureNative.Network.Inputs.MonitorConfigCustomHeadersArgs
 *                 {
 *                     Name = "header-1",
 *                     Value = "value-1",
 *                 },
 *                 new AzureNative.Network.Inputs.MonitorConfigCustomHeadersArgs
 *                 {
 *                     Name = "header-2",
 *                     Value = "value-2",
 *                 },
 *             },
 *             ExpectedStatusCodeRanges = new[]
 *             {
 *                 new AzureNative.Network.Inputs.MonitorConfigExpectedStatusCodeRangesArgs
 *                 {
 *                     Max = 205,
 *                     Min = 200,
 *                 },
 *                 new AzureNative.Network.Inputs.MonitorConfigExpectedStatusCodeRangesArgs
 *                 {
 *                     Max = 410,
 *                     Min = 400,
 *                 },
 *             },
 *             IntervalInSeconds = 10,
 *             Path = "/testpath.aspx",
 *             Port = 80,
 *             Protocol = "HTTP",
 *             TimeoutInSeconds = 5,
 *             ToleratedNumberOfFailures = 2,
 *         },
 *         ProfileName = "azuresdkfornetautoresttrafficmanager6192",
 *         ProfileStatus = "Enabled",
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager2583",
 *         TrafficRoutingMethod = "Performance",
 *         TrafficViewEnrollmentStatus = "Disabled",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewProfile(ctx, "profile", &network.ProfileArgs{
 * 			DnsConfig: &network.DnsConfigArgs{
 * 				RelativeName: pulumi.String("azuresdkfornetautoresttrafficmanager6192"),
 * 				Ttl:          pulumi.Float64(35),
 * 			},
 * 			Endpoints: []network.EndpointTypeArgs{
 * 				{
 * 					CustomHeaders: network.EndpointPropertiesCustomHeadersArray{
 * 						{
 * 							Name:  pulumi.String("header-2"),
 * 							Value: pulumi.String("value-2-overridden"),
 * 						},
 * 					},
 * 					EndpointLocation: pulumi.String("North Europe"),
 * 					EndpointStatus:   pulumi.String("Enabled"),
 * 					Name:             pulumi.String("My external endpoint"),
 * 					Target:           pulumi.String("foobar.contoso.com"),
 * 					Type:             pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 				},
 * 			},
 * 			Location: pulumi.String("global"),
 * 			MonitorConfig: network.MonitorConfigResponse{
 * 				CustomHeaders: network.MonitorConfigCustomHeadersArray{
 * 					&network.MonitorConfigCustomHeadersArgs{
 * 						Name:  pulumi.String("header-1"),
 * 						Value: pulumi.String("value-1"),
 * 					},
 * 					&network.MonitorConfigCustomHeadersArgs{
 * 						Name:  pulumi.String("header-2"),
 * 						Value: pulumi.String("value-2"),
 * 					},
 * 				},
 * 				ExpectedStatusCodeRanges: network.MonitorConfigExpectedStatusCodeRangesArray{
 * 					&network.MonitorConfigExpectedStatusCodeRangesArgs{
 * 						Max: pulumi.Int(205),
 * 						Min: pulumi.Int(200),
 * 					},
 * 					&network.MonitorConfigExpectedStatusCodeRangesArgs{
 * 						Max: pulumi.Int(410),
 * 						Min: pulumi.Int(400),
 * 					},
 * 				},
 * 				IntervalInSeconds:         pulumi.Float64(10),
 * 				Path:                      pulumi.String("/testpath.aspx"),
 * 				Port:                      pulumi.Float64(80),
 * 				Protocol:                  pulumi.String("HTTP"),
 * 				TimeoutInSeconds:          pulumi.Float64(5),
 * 				ToleratedNumberOfFailures: pulumi.Float64(2),
 * 			},
 * 			ProfileName:                 pulumi.String("azuresdkfornetautoresttrafficmanager6192"),
 * 			ProfileStatus:               pulumi.String("Enabled"),
 * 			ResourceGroupName:           pulumi.String("azuresdkfornetautoresttrafficmanager2583"),
 * 			TrafficRoutingMethod:        pulumi.String("Performance"),
 * 			TrafficViewEnrollmentStatus: pulumi.String("Disabled"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Profile;
 * import com.pulumi.azurenative.network.ProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .dnsConfig(Map.ofEntries(
 *                 Map.entry("relativeName", "azuresdkfornetautoresttrafficmanager6192"),
 *                 Map.entry("ttl", 35)
 *             ))
 *             .endpoints(Map.ofEntries(
 *                 Map.entry("customHeaders", Map.ofEntries(
 *                     Map.entry("name", "header-2"),
 *                     Map.entry("value", "value-2-overridden")
 *                 )),
 *                 Map.entry("endpointLocation", "North Europe"),
 *                 Map.entry("endpointStatus", "Enabled"),
 *                 Map.entry("name", "My external endpoint"),
 *                 Map.entry("target", "foobar.contoso.com"),
 *                 Map.entry("type", "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *             ))
 *             .location("global")
 *             .monitorConfig(Map.ofEntries(
 *                 Map.entry("customHeaders",
 *                     Map.ofEntries(
 *                         Map.entry("name", "header-1"),
 *                         Map.entry("value", "value-1")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("name", "header-2"),
 *                         Map.entry("value", "value-2")
 *                     )),
 *                 Map.entry("expectedStatusCodeRanges",
 *                     Map.ofEntries(
 *                         Map.entry("max", 205),
 *                         Map.entry("min", 200)
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("max", 410),
 *                         Map.entry("min", 400)
 *                     )),
 *                 Map.entry("intervalInSeconds", 10),
 *                 Map.entry("path", "/testpath.aspx"),
 *                 Map.entry("port", 80),
 *                 Map.entry("protocol", "HTTP"),
 *                 Map.entry("timeoutInSeconds", 5),
 *                 Map.entry("toleratedNumberOfFailures", 2)
 *             ))
 *             .profileName("azuresdkfornetautoresttrafficmanager6192")
 *             .profileStatus("Enabled")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager2583")
 *             .trafficRoutingMethod("Performance")
 *             .trafficViewEnrollmentStatus("Disabled")
 *             .build());
 *     }
 * }
 * ```
 * ### Profile-PUT-WithEndpoints
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.Network.Profile("profile", new()
 *     {
 *         DnsConfig = new AzureNative.Network.Inputs.DnsConfigArgs
 *         {
 *             RelativeName = "azuresdkfornetautoresttrafficmanager6192",
 *             Ttl = 35,
 *         },
 *         Endpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.EndpointArgs
 *             {
 *                 EndpointLocation = "North Europe",
 *                 EndpointStatus = "Enabled",
 *                 Name = "My external endpoint",
 *                 Target = "foobar.contoso.com",
 *                 Type = "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints",
 *             },
 *         },
 *         Location = "global",
 *         MonitorConfig = new AzureNative.Network.Inputs.MonitorConfigArgs
 *         {
 *             IntervalInSeconds = 10,
 *             Path = "/testpath.aspx",
 *             Port = 80,
 *             Protocol = "HTTP",
 *             TimeoutInSeconds = 5,
 *             ToleratedNumberOfFailures = 2,
 *         },
 *         ProfileName = "azuresdkfornetautoresttrafficmanager6192",
 *         ProfileStatus = "Enabled",
 *         ResourceGroupName = "azuresdkfornetautoresttrafficmanager2583",
 *         TrafficRoutingMethod = "Performance",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewProfile(ctx, "profile", &network.ProfileArgs{
 * 			DnsConfig: &network.DnsConfigArgs{
 * 				RelativeName: pulumi.String("azuresdkfornetautoresttrafficmanager6192"),
 * 				Ttl:          pulumi.Float64(35),
 * 			},
 * 			Endpoints: []network.EndpointTypeArgs{
 * 				{
 * 					EndpointLocation: pulumi.String("North Europe"),
 * 					EndpointStatus:   pulumi.String("Enabled"),
 * 					Name:             pulumi.String("My external endpoint"),
 * 					Target:           pulumi.String("foobar.contoso.com"),
 * 					Type:             pulumi.String("Microsoft.network/TrafficManagerProfiles/ExternalEndpoints"),
 * 				},
 * 			},
 * 			Location: pulumi.String("global"),
 * 			MonitorConfig: &network.MonitorConfigArgs{
 * 				IntervalInSeconds:         pulumi.Float64(10),
 * 				Path:                      pulumi.String("/testpath.aspx"),
 * 				Port:                      pulumi.Float64(80),
 * 				Protocol:                  pulumi.String("HTTP"),
 * 				TimeoutInSeconds:          pulumi.Float64(5),
 * 				ToleratedNumberOfFailures: pulumi.Float64(2),
 * 			},
 * 			ProfileName:          pulumi.String("azuresdkfornetautoresttrafficmanager6192"),
 * 			ProfileStatus:        pulumi.String("Enabled"),
 * 			ResourceGroupName:    pulumi.String("azuresdkfornetautoresttrafficmanager2583"),
 * 			TrafficRoutingMethod: pulumi.String("Performance"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Profile;
 * import com.pulumi.azurenative.network.ProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .dnsConfig(Map.ofEntries(
 *                 Map.entry("relativeName", "azuresdkfornetautoresttrafficmanager6192"),
 *                 Map.entry("ttl", 35)
 *             ))
 *             .endpoints(Map.ofEntries(
 *                 Map.entry("endpointLocation", "North Europe"),
 *                 Map.entry("endpointStatus", "Enabled"),
 *                 Map.entry("name", "My external endpoint"),
 *                 Map.entry("target", "foobar.contoso.com"),
 *                 Map.entry("type", "Microsoft.network/TrafficManagerProfiles/ExternalEndpoints")
 *             ))
 *             .location("global")
 *             .monitorConfig(Map.ofEntries(
 *                 Map.entry("intervalInSeconds", 10),
 *                 Map.entry("path", "/testpath.aspx"),
 *                 Map.entry("port", 80),
 *                 Map.entry("protocol", "HTTP"),
 *                 Map.entry("timeoutInSeconds", 5),
 *                 Map.entry("toleratedNumberOfFailures", 2)
 *             ))
 *             .profileName("azuresdkfornetautoresttrafficmanager6192")
 *             .profileStatus("Enabled")
 *             .resourceGroupName("azuresdkfornetautoresttrafficmanager2583")
 *             .trafficRoutingMethod("Performance")
 *             .build());
 *     }
 * }
 * ```
 * ### Profile-PUT-WithNestedEndpoints
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var profile = new AzureNative.Network.Profile("profile", new()
 *     {
 *         DnsConfig = new AzureNative.Network.Inputs.DnsConfigArgs
 *         {
 *             RelativeName = "parentprofile",
 *             Ttl = 35,
 *         },
 *         Endpoints = new[]
 *         {
 *             new AzureNative.Network.Inputs.EndpointArgs
 *             {
 *                 EndpointStatus = "Enabled",
 *                 MinChildEndpoints = 2,
 *                 MinChildEndpointsIPv4 = 1,
 *                 MinChildEndpointsIPv6 = 2,
 *                 Name = "MyFirstNestedEndpoint",
 *                 Priority = 1,
 *                 Target = "firstnestedprofile.tmpreview.watmtest.azure-test.net",
 *                 Type = "Microsoft.Network/trafficManagerProfiles/nestedEndpoints",
 *                 Weight = 1,
 *             },
 *             new AzureNative.Network.Inputs.EndpointArgs
 *             {
 *                 EndpointStatus = "Enabled",
 *                 MinChildEndpoints = 2,
 *                 MinChildEndpointsIPv4 = 2,
 *                 MinChildEndpointsIPv6 = 1,
 *                 Name = "MySecondNestedEndpoint",
 *                 Priority = 2,
 *                 Target = "secondnestedprofile.tmpreview.watmtest.azure-test.net",
 *                 Type = "Microsoft.Network/trafficManagerProfiles/nestedEndpoints",
 *                 Weight = 1,
 *             },
 *         },
 *         Location = "global",
 *         MonitorConfig = new AzureNative.Network.Inputs.MonitorConfigArgs
 *         {
 *             IntervalInSeconds = 10,
 *             Path = "/testpath.aspx",
 *             Port = 80,
 *             Protocol = "HTTP",
 *             TimeoutInSeconds = 5,
 *             ToleratedNumberOfFailures = 2,
 *         },
 *         ProfileName = "parentprofile",
 *         ProfileStatus = "Enabled",
 *         ResourceGroupName = "myresourcegroup",
 *         TrafficRoutingMethod = "Priority",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewProfile(ctx, "profile", &network.ProfileArgs{
 * 			DnsConfig: &network.DnsConfigArgs{
 * 				RelativeName: pulumi.String("parentprofile"),
 * 				Ttl:          pulumi.Float64(35),
 * 			},
 * 			Endpoints: []network.EndpointTypeArgs{
 * 				{
 * 					EndpointStatus:        pulumi.String("Enabled"),
 * 					MinChildEndpoints:     pulumi.Float64(2),
 * 					MinChildEndpointsIPv4: pulumi.Float64(1),
 * 					MinChildEndpointsIPv6: pulumi.Float64(2),
 * 					Name:                  pulumi.String("MyFirstNestedEndpoint"),
 * 					Priority:              pulumi.Float64(1),
 * 					Target:                pulumi.String("firstnestedprofile.tmpreview.watmtest.azure-test.net"),
 * 					Type:                  pulumi.String("Microsoft.Network/trafficManagerProfiles/nestedEndpoints"),
 * 					Weight:                pulumi.Float64(1),
 * 				},
 * 				{
 * 					EndpointStatus:        pulumi.String("Enabled"),
 * 					MinChildEndpoints:     pulumi.Float64(2),
 * 					MinChildEndpointsIPv4: pulumi.Float64(2),
 * 					MinChildEndpointsIPv6: pulumi.Float64(1),
 * 					Name:                  pulumi.String("MySecondNestedEndpoint"),
 * 					Priority:              pulumi.Float64(2),
 * 					Target:                pulumi.String("secondnestedprofile.tmpreview.watmtest.azure-test.net"),
 * 					Type:                  pulumi.String("Microsoft.Network/trafficManagerProfiles/nestedEndpoints"),
 * 					Weight:                pulumi.Float64(1),
 * 				},
 * 			},
 * 			Location: pulumi.String("global"),
 * 			MonitorConfig: &network.MonitorConfigArgs{
 * 				IntervalInSeconds:         pulumi.Float64(10),
 * 				Path:                      pulumi.String("/testpath.aspx"),
 * 				Port:                      pulumi.Float64(80),
 * 				Protocol:                  pulumi.String("HTTP"),
 * 				TimeoutInSeconds:          pulumi.Float64(5),
 * 				ToleratedNumberOfFailures: pulumi.Float64(2),
 * 			},
 * 			ProfileName:          pulumi.String("parentprofile"),
 * 			ProfileStatus:        pulumi.String("Enabled"),
 * 			ResourceGroupName:    pulumi.String("myresourcegroup"),
 * 			TrafficRoutingMethod: pulumi.String("Priority"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Profile;
 * import com.pulumi.azurenative.network.ProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var profile = new Profile("profile", ProfileArgs.builder()
 *             .dnsConfig(Map.ofEntries(
 *                 Map.entry("relativeName", "parentprofile"),
 *                 Map.entry("ttl", 35)
 *             ))
 *             .endpoints(
 *                 Map.ofEntries(
 *                     Map.entry("endpointStatus", "Enabled"),
 *                     Map.entry("minChildEndpoints", 2),
 *                     Map.entry("minChildEndpointsIPv4", 1),
 *                     Map.entry("minChildEndpointsIPv6", 2),
 *                     Map.entry("name", "MyFirstNestedEndpoint"),
 *                     Map.entry("priority", 1),
 *                     Map.entry("target", "firstnestedprofile.tmpreview.watmtest.azure-test.net"),
 *                     Map.entry("type", "Microsoft.Network/trafficManagerProfiles/nestedEndpoints"),
 *                     Map.entry("weight", 1)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("endpointStatus", "Enabled"),
 *                     Map.entry("minChildEndpoints", 2),
 *                     Map.entry("minChildEndpointsIPv4", 2),
 *                     Map.entry("minChildEndpointsIPv6", 1),
 *                     Map.entry("name", "MySecondNestedEndpoint"),
 *                     Map.entry("priority", 2),
 *                     Map.entry("target", "secondnestedprofile.tmpreview.watmtest.azure-test.net"),
 *                     Map.entry("type", "Microsoft.Network/trafficManagerProfiles/nestedEndpoints"),
 *                     Map.entry("weight", 1)
 *                 ))
 *             .location("global")
 *             .monitorConfig(Map.ofEntries(
 *                 Map.entry("intervalInSeconds", 10),
 *                 Map.entry("path", "/testpath.aspx"),
 *                 Map.entry("port", 80),
 *                 Map.entry("protocol", "HTTP"),
 *                 Map.entry("timeoutInSeconds", 5),
 *                 Map.entry("toleratedNumberOfFailures", 2)
 *             ))
 *             .profileName("parentprofile")
 *             .profileStatus("Enabled")
 *             .resourceGroupName("myresourcegroup")
 *             .trafficRoutingMethod("Priority")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:Profile parentprofile /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficmanagerprofiles/{profileName}
 * ```
 */
public class Profile internal constructor(
    override val javaResource: com.pulumi.azurenative.network.Profile,
) : KotlinCustomResource(javaResource, ProfileMapper) {
    /**
     * The list of allowed endpoint record types.
     */
    public val allowedEndpointRecordTypes: Output<List<String>>?
        get() = javaResource.allowedEndpointRecordTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The DNS settings of the Traffic Manager profile.
     */
    public val dnsConfig: Output<DnsConfigResponse>?
        get() = javaResource.dnsConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dnsConfigResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The list of endpoints in the Traffic Manager profile.
     */
    public val endpoints: Output<List<EndpointResponse>>?
        get() = javaResource.endpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> endpointResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The Azure Region where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Maximum number of endpoints to be returned for MultiValue routing type.
     */
    public val maxReturn: Output<Double>?
        get() = javaResource.maxReturn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The endpoint monitoring settings of the Traffic Manager profile.
     */
    public val monitorConfig: Output<MonitorConfigResponse>?
        get() = javaResource.monitorConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> monitorConfigResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of the Traffic Manager profile.
     */
    public val profileStatus: Output<String>?
        get() = javaResource.profileStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The traffic routing method of the Traffic Manager profile.
     */
    public val trafficRoutingMethod: Output<String>?
        get() = javaResource.trafficRoutingMethod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether Traffic View is 'Enabled' or 'Disabled' for the Traffic Manager profile. Null, indicates 'Disabled'. Enabling this feature will increase the cost of the Traffic Manage profile.
     */
    public val trafficViewEnrollmentStatus: Output<String>?
        get() = javaResource.trafficViewEnrollmentStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ProfileMapper : ResourceMapper<Profile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.Profile::class == javaResource::class

    override fun map(javaResource: Resource): Profile = Profile(
        javaResource as
            com.pulumi.azurenative.network.Profile,
    )
}

/**
 * @see [Profile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Profile].
 */
public suspend fun profile(name: String, block: suspend ProfileResourceBuilder.() -> Unit):
    Profile {
    val builder = ProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Profile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun profile(name: String): Profile {
    val builder = ProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
