@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.PublicIPPrefixArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.IPVersion
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.IpTagArgs
import com.pulumi.azurenative.network.kotlin.inputs.IpTagArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.NatGatewayArgs
import com.pulumi.azurenative.network.kotlin.inputs.NatGatewayArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.PublicIPPrefixSkuArgs
import com.pulumi.azurenative.network.kotlin.inputs.PublicIPPrefixSkuArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Public IP prefix resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-06-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create public IP prefix allocation method
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publicIPPrefix = new AzureNative.Network.PublicIPPrefix("publicIPPrefix", new()
 *     {
 *         Location = "westus",
 *         PrefixLength = 30,
 *         PublicIPAddressVersion = "IPv4",
 *         PublicIpPrefixName = "test-ipprefix",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.PublicIPPrefixSkuArgs
 *         {
 *             Name = "Standard",
 *             Tier = "Regional",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPublicIPPrefix(ctx, "publicIPPrefix", &network.PublicIPPrefixArgs{
 * 			Location:               pulumi.String("westus"),
 * 			PrefixLength:           pulumi.Int(30),
 * 			PublicIPAddressVersion: pulumi.String("IPv4"),
 * 			PublicIpPrefixName:     pulumi.String("test-ipprefix"),
 * 			ResourceGroupName:      pulumi.String("rg1"),
 * 			Sku: &network.PublicIPPrefixSkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 				Tier: pulumi.String("Regional"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PublicIPPrefix;
 * import com.pulumi.azurenative.network.PublicIPPrefixArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publicIPPrefix = new PublicIPPrefix("publicIPPrefix", PublicIPPrefixArgs.builder()
 *             .location("westus")
 *             .prefixLength(30)
 *             .publicIPAddressVersion("IPv4")
 *             .publicIpPrefixName("test-ipprefix")
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Standard"),
 *                 Map.entry("tier", "Regional")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create public IP prefix defaults
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var publicIPPrefix = new AzureNative.Network.PublicIPPrefix("publicIPPrefix", new()
 *     {
 *         Location = "westus",
 *         PrefixLength = 30,
 *         PublicIpPrefixName = "test-ipprefix",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.PublicIPPrefixSkuArgs
 *         {
 *             Name = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewPublicIPPrefix(ctx, "publicIPPrefix", &network.PublicIPPrefixArgs{
 * 			Location:           pulumi.String("westus"),
 * 			PrefixLength:       pulumi.Int(30),
 * 			PublicIpPrefixName: pulumi.String("test-ipprefix"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			Sku: &network.PublicIPPrefixSkuArgs{
 * 				Name: pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.PublicIPPrefix;
 * import com.pulumi.azurenative.network.PublicIPPrefixArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var publicIPPrefix = new PublicIPPrefix("publicIPPrefix", PublicIPPrefixArgs.builder()
 *             .location("westus")
 *             .prefixLength(30)
 *             .publicIpPrefixName("test-ipprefix")
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("name", "Standard"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:PublicIPPrefix test-ipprefix /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/publicIPPrefixes/{publicIpPrefixName}
 * ```
 * @property customIPPrefix The customIpPrefix that this prefix is associated with.
 * @property extendedLocation The extended location of the public ip address.
 * @property id Resource ID.
 * @property ipTags The list of tags associated with the public IP prefix.
 * @property location Resource location.
 * @property natGateway NatGateway of Public IP Prefix.
 * @property prefixLength The Length of the Public IP Prefix.
 * @property publicIPAddressVersion The public IP address version.
 * @property publicIpPrefixName The name of the public IP prefix.
 * @property resourceGroupName The name of the resource group.
 * @property sku The public IP prefix SKU.
 * @property tags Resource tags.
 * @property zones A list of availability zones denoting the IP allocated for the resource needs to come from.
 */
public data class PublicIPPrefixArgs(
    public val customIPPrefix: Output<SubResourceArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val id: Output<String>? = null,
    public val ipTags: Output<List<IpTagArgs>>? = null,
    public val location: Output<String>? = null,
    public val natGateway: Output<NatGatewayArgs>? = null,
    public val prefixLength: Output<Int>? = null,
    public val publicIPAddressVersion: Output<Either<String, IPVersion>>? = null,
    public val publicIpPrefixName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<PublicIPPrefixSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.PublicIPPrefixArgs> {
    override fun toJava(): com.pulumi.azurenative.network.PublicIPPrefixArgs =
        com.pulumi.azurenative.network.PublicIPPrefixArgs.builder()
            .customIPPrefix(customIPPrefix?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .ipTags(ipTags?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .natGateway(natGateway?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .prefixLength(prefixLength?.applyValue({ args0 -> args0 }))
            .publicIPAddressVersion(
                publicIPAddressVersion?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicIpPrefixName(publicIpPrefixName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PublicIPPrefixArgs].
 */
@PulumiTagMarker
public class PublicIPPrefixArgsBuilder internal constructor() {
    private var customIPPrefix: Output<SubResourceArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var id: Output<String>? = null

    private var ipTags: Output<List<IpTagArgs>>? = null

    private var location: Output<String>? = null

    private var natGateway: Output<NatGatewayArgs>? = null

    private var prefixLength: Output<Int>? = null

    private var publicIPAddressVersion: Output<Either<String, IPVersion>>? = null

    private var publicIpPrefixName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<PublicIPPrefixSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value The customIpPrefix that this prefix is associated with.
     */
    @JvmName("xujwnlypioopoqki")
    public suspend fun customIPPrefix(`value`: Output<SubResourceArgs>) {
        this.customIPPrefix = value
    }

    /**
     * @param value The extended location of the public ip address.
     */
    @JvmName("nuxvgokboocfayve")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("dvfjiqydysltoegr")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The list of tags associated with the public IP prefix.
     */
    @JvmName("jndiyceegvjvmnrd")
    public suspend fun ipTags(`value`: Output<List<IpTagArgs>>) {
        this.ipTags = value
    }

    @JvmName("kacrwwtutptvgvqb")
    public suspend fun ipTags(vararg values: Output<IpTagArgs>) {
        this.ipTags = Output.all(values.asList())
    }

    /**
     * @param values The list of tags associated with the public IP prefix.
     */
    @JvmName("qnlrjafvpmlouecv")
    public suspend fun ipTags(values: List<Output<IpTagArgs>>) {
        this.ipTags = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("fkyykesvlbwgggra")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value NatGateway of Public IP Prefix.
     */
    @JvmName("xthrnlxeqhofclyb")
    public suspend fun natGateway(`value`: Output<NatGatewayArgs>) {
        this.natGateway = value
    }

    /**
     * @param value The Length of the Public IP Prefix.
     */
    @JvmName("rfvwbcmngvwtgpre")
    public suspend fun prefixLength(`value`: Output<Int>) {
        this.prefixLength = value
    }

    /**
     * @param value The public IP address version.
     */
    @JvmName("wgysvwafslipadig")
    public suspend fun publicIPAddressVersion(`value`: Output<Either<String, IPVersion>>) {
        this.publicIPAddressVersion = value
    }

    /**
     * @param value The name of the public IP prefix.
     */
    @JvmName("ngpljxyjwsiypsts")
    public suspend fun publicIpPrefixName(`value`: Output<String>) {
        this.publicIpPrefixName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vpvljbegxfpvyrrx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The public IP prefix SKU.
     */
    @JvmName("iyaxatuqagegvlrc")
    public suspend fun sku(`value`: Output<PublicIPPrefixSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lmllgpynlprabyvn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("fimctetfjhsrmnmq")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("smeafaryilmrnukb")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("ajaunhvtigipksiv")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value The customIpPrefix that this prefix is associated with.
     */
    @JvmName("leoxbhikebuhoeil")
    public suspend fun customIPPrefix(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customIPPrefix = mapped
    }

    /**
     * @param argument The customIpPrefix that this prefix is associated with.
     */
    @JvmName("xhmkwgcijvmpfljr")
    public suspend fun customIPPrefix(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customIPPrefix = mapped
    }

    /**
     * @param value The extended location of the public ip address.
     */
    @JvmName("dobpxfxgfllfjicx")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the public ip address.
     */
    @JvmName("tbaqyembiinhdnhj")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("fsyjemyvtvtxkilh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The list of tags associated with the public IP prefix.
     */
    @JvmName("ralsibaqldtvybyf")
    public suspend fun ipTags(`value`: List<IpTagArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipTags = mapped
    }

    /**
     * @param argument The list of tags associated with the public IP prefix.
     */
    @JvmName("upjeyjftpqfexggi")
    public suspend fun ipTags(argument: List<suspend IpTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpTagArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param argument The list of tags associated with the public IP prefix.
     */
    @JvmName("juslqlsokgdwhdmu")
    public suspend fun ipTags(vararg argument: suspend IpTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpTagArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param argument The list of tags associated with the public IP prefix.
     */
    @JvmName("udgcyawcjvorxskt")
    public suspend fun ipTags(argument: suspend IpTagArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpTagArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipTags = mapped
    }

    /**
     * @param values The list of tags associated with the public IP prefix.
     */
    @JvmName("aqvtjhwwtyoeoumv")
    public suspend fun ipTags(vararg values: IpTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipTags = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("iowfwupimfycmcxy")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value NatGateway of Public IP Prefix.
     */
    @JvmName("gbbtljsrarwkipyp")
    public suspend fun natGateway(`value`: NatGatewayArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGateway = mapped
    }

    /**
     * @param argument NatGateway of Public IP Prefix.
     */
    @JvmName("roifpvednicvktpg")
    public suspend fun natGateway(argument: suspend NatGatewayArgsBuilder.() -> Unit) {
        val toBeMapped = NatGatewayArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.natGateway = mapped
    }

    /**
     * @param value The Length of the Public IP Prefix.
     */
    @JvmName("pyiyjfnfusebdpea")
    public suspend fun prefixLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixLength = mapped
    }

    /**
     * @param value The public IP address version.
     */
    @JvmName("oedppdmwwuppxukb")
    public suspend fun publicIPAddressVersion(`value`: Either<String, IPVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAddressVersion = mapped
    }

    /**
     * @param value The public IP address version.
     */
    @JvmName("loemcducrrnqwyut")
    public fun publicIPAddressVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAddressVersion = mapped
    }

    /**
     * @param value The public IP address version.
     */
    @JvmName("dypjpuxmpgjoabfh")
    public fun publicIPAddressVersion(`value`: IPVersion) {
        val toBeMapped = Either.ofRight<String, IPVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicIPAddressVersion = mapped
    }

    /**
     * @param value The name of the public IP prefix.
     */
    @JvmName("xffneaagqaifajvw")
    public suspend fun publicIpPrefixName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpPrefixName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ngapgobisgvrfnox")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The public IP prefix SKU.
     */
    @JvmName("qgptdtbvkopykqpw")
    public suspend fun sku(`value`: PublicIPPrefixSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The public IP prefix SKU.
     */
    @JvmName("tupaaxmoeovncuhf")
    public suspend fun sku(argument: suspend PublicIPPrefixSkuArgsBuilder.() -> Unit) {
        val toBeMapped = PublicIPPrefixSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("divieqtoqiltlswb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("suvoblgqgwfddbqe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("ccklqxthoxxfpnag")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values A list of availability zones denoting the IP allocated for the resource needs to come from.
     */
    @JvmName("grjsxgrvbjsrogyy")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): PublicIPPrefixArgs = PublicIPPrefixArgs(
        customIPPrefix = customIPPrefix,
        extendedLocation = extendedLocation,
        id = id,
        ipTags = ipTags,
        location = location,
        natGateway = natGateway,
        prefixLength = prefixLength,
        publicIPAddressVersion = publicIPAddressVersion,
        publicIpPrefixName = publicIpPrefixName,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        zones = zones,
    )
}
