@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ScopeConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Scope Connections resource
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-02-01-preview.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create or Update Network Manager Scope Connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var scopeConnection = new AzureNative.Network.ScopeConnection("scopeConnection", new()
 *     {
 *         Description = "This is a scope connection to a cross tenant subscription.",
 *         NetworkManagerName = "testNetworkManager",
 *         ResourceGroupName = "rg1",
 *         ResourceId = "subscriptions/f0dc2b34-dfad-40e4-83e0-2309fed8d00b",
 *         ScopeConnectionName = "TestScopeConnection",
 *         TenantId = "6babcaad-604b-40ac-a9d7-9fd97c0b779f",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewScopeConnection(ctx, "scopeConnection", &network.ScopeConnectionArgs{
 * 			Description:         pulumi.String("This is a scope connection to a cross tenant subscription."),
 * 			NetworkManagerName:  pulumi.String("testNetworkManager"),
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			ResourceId:          pulumi.String("subscriptions/f0dc2b34-dfad-40e4-83e0-2309fed8d00b"),
 * 			ScopeConnectionName: pulumi.String("TestScopeConnection"),
 * 			TenantId:            pulumi.String("6babcaad-604b-40ac-a9d7-9fd97c0b779f"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.ScopeConnection;
 * import com.pulumi.azurenative.network.ScopeConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var scopeConnection = new ScopeConnection("scopeConnection", ScopeConnectionArgs.builder()
 *             .description("This is a scope connection to a cross tenant subscription.")
 *             .networkManagerName("testNetworkManager")
 *             .resourceGroupName("rg1")
 *             .resourceId("subscriptions/f0dc2b34-dfad-40e4-83e0-2309fed8d00b")
 *             .scopeConnectionName("TestScopeConnection")
 *             .tenantId("6babcaad-604b-40ac-a9d7-9fd97c0b779f")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:ScopeConnection TestScopeConnection /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkManagers/{networkManagerName}/scopeConnections/{scopeConnectionName}
 * ```
 * @property description A description of the scope connection.
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 * @property resourceId Resource ID.
 * @property scopeConnectionName Name for the cross-tenant connection.
 * @property tenantId Tenant ID.
 */
public data class ScopeConnectionArgs(
    public val description: Output<String>? = null,
    public val networkManagerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val scopeConnectionName: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ScopeConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ScopeConnectionArgs =
        com.pulumi.azurenative.network.ScopeConnectionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .networkManagerName(networkManagerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .scopeConnectionName(scopeConnectionName?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScopeConnectionArgs].
 */
@PulumiTagMarker
public class ScopeConnectionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var networkManagerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var scopeConnectionName: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value A description of the scope connection.
     */
    @JvmName("yswuhgebrjbktloh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("uypekkchshmhmvxe")
    public suspend fun networkManagerName(`value`: Output<String>) {
        this.networkManagerName = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nbmmdrpsuisjfscp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("paoycueqowvobdus")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Name for the cross-tenant connection.
     */
    @JvmName("ldqpsnvveiiwvfgv")
    public suspend fun scopeConnectionName(`value`: Output<String>) {
        this.scopeConnectionName = value
    }

    /**
     * @param value Tenant ID.
     */
    @JvmName("fkdasndoufvmhnip")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value A description of the scope connection.
     */
    @JvmName("gcvlsogsfxgsqrcs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("wokmkjelawaiwnqr")
    public suspend fun networkManagerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("bftuyglolggqxjgt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("psbvebyqiyxgekem")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Name for the cross-tenant connection.
     */
    @JvmName("kscqqhqmoyeotrtu")
    public suspend fun scopeConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeConnectionName = mapped
    }

    /**
     * @param value Tenant ID.
     */
    @JvmName("ncedjtmcybclloef")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): ScopeConnectionArgs = ScopeConnectionArgs(
        description = description,
        networkManagerName = networkManagerName,
        resourceGroupName = resourceGroupName,
        resourceId = resourceId,
        scopeConnectionName = scopeConnectionName,
        tenantId = tenantId,
    )
}
