@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SecurityPartnerProvider].
 */
@PulumiTagMarker
public class SecurityPartnerProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityPartnerProviderArgs = SecurityPartnerProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityPartnerProviderArgsBuilder.() -> Unit) {
        val builder = SecurityPartnerProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SecurityPartnerProvider {
        val builtJavaResource =
            com.pulumi.azurenative.network.SecurityPartnerProvider(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SecurityPartnerProvider(builtJavaResource)
    }
}

/**
 * Security Partner Provider resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create Security Partner Provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityPartnerProvider = new AzureNative.Network.SecurityPartnerProvider("securityPartnerProvider", new()
 *     {
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         SecurityPartnerProviderName = "securityPartnerProvider",
 *         SecurityProviderName = "ZScaler",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualHub = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewSecurityPartnerProvider(ctx, "securityPartnerProvider", &network.SecurityPartnerProviderArgs{
 * 			Location:                    pulumi.String("West US"),
 * 			ResourceGroupName:           pulumi.String("rg1"),
 * 			SecurityPartnerProviderName: pulumi.String("securityPartnerProvider"),
 * 			SecurityProviderName:        pulumi.String("ZScaler"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualHub: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.SecurityPartnerProvider;
 * import com.pulumi.azurenative.network.SecurityPartnerProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityPartnerProvider = new SecurityPartnerProvider("securityPartnerProvider", SecurityPartnerProviderArgs.builder()
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .securityPartnerProviderName("securityPartnerProvider")
 *             .securityProviderName("ZScaler")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualHub(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:SecurityPartnerProvider securityPartnerProvider /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/securityPartnerProviders/{securityPartnerProviderName}
 * ```
 */
public class SecurityPartnerProvider internal constructor(
    override val javaResource: com.pulumi.azurenative.network.SecurityPartnerProvider,
) : KotlinCustomResource(javaResource, SecurityPartnerProviderMapper) {
    /**
     * The connection status with the Security Partner Provider.
     */
    public val connectionStatus: Output<String>
        get() = javaResource.connectionStatus().applyValue({ args0 -> args0 })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the Security Partner Provider resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The security provider name.
     */
    public val securityProviderName: Output<String>?
        get() = javaResource.securityProviderName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The virtualHub to which the Security Partner Provider belongs.
     */
    public val virtualHub: Output<SubResourceResponse>?
        get() = javaResource.virtualHub().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object SecurityPartnerProviderMapper : ResourceMapper<SecurityPartnerProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.SecurityPartnerProvider::class == javaResource::class

    override fun map(javaResource: Resource): SecurityPartnerProvider =
        SecurityPartnerProvider(
            javaResource as
                com.pulumi.azurenative.network.SecurityPartnerProvider,
        )
}

/**
 * @see [SecurityPartnerProvider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityPartnerProvider].
 */
public suspend fun securityPartnerProvider(
    name: String,
    block: suspend SecurityPartnerProviderResourceBuilder.() -> Unit,
): SecurityPartnerProvider {
    val builder = SecurityPartnerProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityPartnerProvider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityPartnerProvider(name: String): SecurityPartnerProvider {
    val builder = SecurityPartnerProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
