@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.SecurityPartnerProviderArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.SecurityProviderName
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Security Partner Provider resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create Security Partner Provider
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityPartnerProvider = new AzureNative.Network.SecurityPartnerProvider("securityPartnerProvider", new()
 *     {
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         SecurityPartnerProviderName = "securityPartnerProvider",
 *         SecurityProviderName = "ZScaler",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualHub = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewSecurityPartnerProvider(ctx, "securityPartnerProvider", &network.SecurityPartnerProviderArgs{
 * 			Location:                    pulumi.String("West US"),
 * 			ResourceGroupName:           pulumi.String("rg1"),
 * 			SecurityPartnerProviderName: pulumi.String("securityPartnerProvider"),
 * 			SecurityProviderName:        pulumi.String("ZScaler"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualHub: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.SecurityPartnerProvider;
 * import com.pulumi.azurenative.network.SecurityPartnerProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityPartnerProvider = new SecurityPartnerProvider("securityPartnerProvider", SecurityPartnerProviderArgs.builder()
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .securityPartnerProviderName("securityPartnerProvider")
 *             .securityProviderName("ZScaler")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualHub(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:SecurityPartnerProvider securityPartnerProvider /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/securityPartnerProviders/{securityPartnerProviderName}
 * ```
 * @property id Resource ID.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property securityPartnerProviderName The name of the Security Partner Provider.
 * @property securityProviderName The security provider name.
 * @property tags Resource tags.
 * @property virtualHub The virtualHub to which the Security Partner Provider belongs.
 */
public data class SecurityPartnerProviderArgs(
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val securityPartnerProviderName: Output<String>? = null,
    public val securityProviderName: Output<Either<String, SecurityProviderName>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualHub: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.SecurityPartnerProviderArgs> {
    override fun toJava(): com.pulumi.azurenative.network.SecurityPartnerProviderArgs =
        com.pulumi.azurenative.network.SecurityPartnerProviderArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .securityPartnerProviderName(securityPartnerProviderName?.applyValue({ args0 -> args0 }))
            .securityProviderName(
                securityProviderName?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualHub(virtualHub?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SecurityPartnerProviderArgs].
 */
@PulumiTagMarker
public class SecurityPartnerProviderArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var securityPartnerProviderName: Output<String>? = null

    private var securityProviderName: Output<Either<String, SecurityProviderName>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualHub: Output<SubResourceArgs>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("hjjvockvkbmnauva")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("komioxoivqniwpak")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("gjjhrufokvlskbxm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Security Partner Provider.
     */
    @JvmName("jotkyhrwxklaphpd")
    public suspend fun securityPartnerProviderName(`value`: Output<String>) {
        this.securityPartnerProviderName = value
    }

    /**
     * @param value The security provider name.
     */
    @JvmName("gyfmvydvycfmwehh")
    public suspend fun securityProviderName(`value`: Output<Either<String, SecurityProviderName>>) {
        this.securityProviderName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ebkvroekhtwgmbgr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The virtualHub to which the Security Partner Provider belongs.
     */
    @JvmName("vbnpbfjylcrqqwww")
    public suspend fun virtualHub(`value`: Output<SubResourceArgs>) {
        this.virtualHub = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("kvgoggnlcwdmebcn")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("bpdgmjvqtkjbqjie")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rfejnigufgrwgbuc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Security Partner Provider.
     */
    @JvmName("rotybcacrrxbeysr")
    public suspend fun securityPartnerProviderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityPartnerProviderName = mapped
    }

    /**
     * @param value The security provider name.
     */
    @JvmName("wpiaxyhfadmrxryo")
    public suspend fun securityProviderName(`value`: Either<String, SecurityProviderName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProviderName = mapped
    }

    /**
     * @param value The security provider name.
     */
    @JvmName("qqxultolpdikkphb")
    public fun securityProviderName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityProviderName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityProviderName = mapped
    }

    /**
     * @param value The security provider name.
     */
    @JvmName("hiviojnwuqtaigyx")
    public fun securityProviderName(`value`: SecurityProviderName) {
        val toBeMapped = Either.ofRight<String, SecurityProviderName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityProviderName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("huhtbunekymtoqby")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wfatdwdumtdavkdi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The virtualHub to which the Security Partner Provider belongs.
     */
    @JvmName("cxgempiebawvempb")
    public suspend fun virtualHub(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHub = mapped
    }

    /**
     * @param argument The virtualHub to which the Security Partner Provider belongs.
     */
    @JvmName("dredmhotojcgixfk")
    public suspend fun virtualHub(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualHub = mapped
    }

    internal fun build(): SecurityPartnerProviderArgs = SecurityPartnerProviderArgs(
        id = id,
        location = location,
        resourceGroupName = resourceGroupName,
        securityPartnerProviderName = securityPartnerProviderName,
        securityProviderName = securityProviderName,
        tags = tags,
        virtualHub = virtualHub,
    )
}
