@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.SubscriptionNetworkManagerConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Network Manager Connection resource
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2022-02-01-preview.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create or Update Subscription Network Manager Connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subscriptionNetworkManagerConnection = new AzureNative.Network.SubscriptionNetworkManagerConnection("subscriptionNetworkManagerConnection", new()
 *     {
 *         NetworkManagerConnectionName = "TestNMConnection",
 *         NetworkManagerId = "/subscriptions/subscriptionC/resourceGroup/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewSubscriptionNetworkManagerConnection(ctx, "subscriptionNetworkManagerConnection", &network.SubscriptionNetworkManagerConnectionArgs{
 * 			NetworkManagerConnectionName: pulumi.String("TestNMConnection"),
 * 			NetworkManagerId:             pulumi.String("/subscriptions/subscriptionC/resourceGroup/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.SubscriptionNetworkManagerConnection;
 * import com.pulumi.azurenative.network.SubscriptionNetworkManagerConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subscriptionNetworkManagerConnection = new SubscriptionNetworkManagerConnection("subscriptionNetworkManagerConnection", SubscriptionNetworkManagerConnectionArgs.builder()
 *             .networkManagerConnectionName("TestNMConnection")
 *             .networkManagerId("/subscriptions/subscriptionC/resourceGroup/rg1/providers/Microsoft.Network/networkManagers/testNetworkManager")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:SubscriptionNetworkManagerConnection TestNMConnection /subscriptions/{subscriptionId}/providers/Microsoft.Network/networkManagerConnections/{networkManagerConnectionName}
 * ```
 * @property description A description of the network manager connection.
 * @property networkManagerConnectionName Name for the network manager connection.
 * @property networkManagerId Network Manager Id.
 */
public data class SubscriptionNetworkManagerConnectionArgs(
    public val description: Output<String>? = null,
    public val networkManagerConnectionName: Output<String>? = null,
    public val networkManagerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.SubscriptionNetworkManagerConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.SubscriptionNetworkManagerConnectionArgs =
        com.pulumi.azurenative.network.SubscriptionNetworkManagerConnectionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .networkManagerConnectionName(networkManagerConnectionName?.applyValue({ args0 -> args0 }))
            .networkManagerId(networkManagerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriptionNetworkManagerConnectionArgs].
 */
@PulumiTagMarker
public class SubscriptionNetworkManagerConnectionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var networkManagerConnectionName: Output<String>? = null

    private var networkManagerId: Output<String>? = null

    /**
     * @param value A description of the network manager connection.
     */
    @JvmName("wkadcrnfqolmlaon")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name for the network manager connection.
     */
    @JvmName("eiarhcohegydtsho")
    public suspend fun networkManagerConnectionName(`value`: Output<String>) {
        this.networkManagerConnectionName = value
    }

    /**
     * @param value Network Manager Id.
     */
    @JvmName("npcchrkplpegudli")
    public suspend fun networkManagerId(`value`: Output<String>) {
        this.networkManagerId = value
    }

    /**
     * @param value A description of the network manager connection.
     */
    @JvmName("iqmkmcbwullbvevm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name for the network manager connection.
     */
    @JvmName("vdcfxucuhrvcsdlt")
    public suspend fun networkManagerConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerConnectionName = mapped
    }

    /**
     * @param value Network Manager Id.
     */
    @JvmName("bttdnopiwijtutqi")
    public suspend fun networkManagerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkManagerId = mapped
    }

    internal fun build(): SubscriptionNetworkManagerConnectionArgs =
        SubscriptionNetworkManagerConnectionArgs(
            description = description,
            networkManagerConnectionName = networkManagerConnectionName,
            networkManagerId = networkManagerId,
        )
}
