@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualHubBgpConnectionArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Virtual Appliance Site resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### VirtualHubRouteTableV2Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualHubBgpConnection = new AzureNative.Network.VirtualHubBgpConnection("virtualHubBgpConnection", new()
 *     {
 *         ConnectionName = "conn1",
 *         HubVirtualNetworkConnection = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubVirtualNetworkConnections/hubVnetConn1",
 *         },
 *         PeerAsn = 20000,
 *         PeerIp = "192.168.1.5",
 *         ResourceGroupName = "rg1",
 *         VirtualHubName = "hub1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualHubBgpConnection(ctx, "virtualHubBgpConnection", &network.VirtualHubBgpConnectionArgs{
 * 			ConnectionName: pulumi.String("conn1"),
 * 			HubVirtualNetworkConnection: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubVirtualNetworkConnections/hubVnetConn1"),
 * 			},
 * 			PeerAsn:           pulumi.Float64(20000),
 * 			PeerIp:            pulumi.String("192.168.1.5"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			VirtualHubName:    pulumi.String("hub1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualHubBgpConnection;
 * import com.pulumi.azurenative.network.VirtualHubBgpConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualHubBgpConnection = new VirtualHubBgpConnection("virtualHubBgpConnection", VirtualHubBgpConnectionArgs.builder()
 *             .connectionName("conn1")
 *             .hubVirtualNetworkConnection(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualHubs/hub1/hubVirtualNetworkConnections/hubVnetConn1"))
 *             .peerAsn(20000)
 *             .peerIp("192.168.1.5")
 *             .resourceGroupName("rg1")
 *             .virtualHubName("hub1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualHubBgpConnection conn1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/bgpConnections/{connectionName}
 * ```
 * @property connectionName The name of the connection.
 * @property hubVirtualNetworkConnection The reference to the HubVirtualNetworkConnection resource.
 * @property id Resource ID.
 * @property name Name of the connection.
 * @property peerAsn Peer ASN.
 * @property peerIp Peer IP.
 * @property resourceGroupName The resource group name of the VirtualHub.
 * @property virtualHubName The name of the VirtualHub.
 */
public data class VirtualHubBgpConnectionArgs(
    public val connectionName: Output<String>? = null,
    public val hubVirtualNetworkConnection: Output<SubResourceArgs>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val peerAsn: Output<Double>? = null,
    public val peerIp: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val virtualHubName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualHubBgpConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualHubBgpConnectionArgs =
        com.pulumi.azurenative.network.VirtualHubBgpConnectionArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .hubVirtualNetworkConnection(
                hubVirtualNetworkConnection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .peerAsn(peerAsn?.applyValue({ args0 -> args0 }))
            .peerIp(peerIp?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .virtualHubName(virtualHubName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualHubBgpConnectionArgs].
 */
@PulumiTagMarker
public class VirtualHubBgpConnectionArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var hubVirtualNetworkConnection: Output<SubResourceArgs>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var peerAsn: Output<Double>? = null

    private var peerIp: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var virtualHubName: Output<String>? = null

    /**
     * @param value The name of the connection.
     */
    @JvmName("yogjvfpavqqrkits")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value The reference to the HubVirtualNetworkConnection resource.
     */
    @JvmName("ctansgkfbgsutemh")
    public suspend fun hubVirtualNetworkConnection(`value`: Output<SubResourceArgs>) {
        this.hubVirtualNetworkConnection = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ftmsnadkxxfwugje")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the connection.
     */
    @JvmName("miollxqnierqdwfp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Peer ASN.
     */
    @JvmName("ojusamdnfwgmiekf")
    public suspend fun peerAsn(`value`: Output<Double>) {
        this.peerAsn = value
    }

    /**
     * @param value Peer IP.
     */
    @JvmName("vjjndjkvydymqjmt")
    public suspend fun peerIp(`value`: Output<String>) {
        this.peerIp = value
    }

    /**
     * @param value The resource group name of the VirtualHub.
     */
    @JvmName("scsqxnbgjjcmqocr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("xvumwusufkorcchg")
    public suspend fun virtualHubName(`value`: Output<String>) {
        this.virtualHubName = value
    }

    /**
     * @param value The name of the connection.
     */
    @JvmName("drrlaemlwcmkvwcy")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value The reference to the HubVirtualNetworkConnection resource.
     */
    @JvmName("rgkorpumnpanpjds")
    public suspend fun hubVirtualNetworkConnection(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hubVirtualNetworkConnection = mapped
    }

    /**
     * @param argument The reference to the HubVirtualNetworkConnection resource.
     */
    @JvmName("kfdowxqbvfxyfafk")
    public suspend
    fun hubVirtualNetworkConnection(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hubVirtualNetworkConnection = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("fclcrvffsmkxtmqg")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the connection.
     */
    @JvmName("vhdrlfsdgxhldsec")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Peer ASN.
     */
    @JvmName("vmsfbeufxtmonyqd")
    public suspend fun peerAsn(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAsn = mapped
    }

    /**
     * @param value Peer IP.
     */
    @JvmName("ihrrebnrwuopqssr")
    public suspend fun peerIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerIp = mapped
    }

    /**
     * @param value The resource group name of the VirtualHub.
     */
    @JvmName("klniqnpmuikyifix")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("ptisbjmxtplshakj")
    public suspend fun virtualHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHubName = mapped
    }

    internal fun build(): VirtualHubBgpConnectionArgs = VirtualHubBgpConnectionArgs(
        connectionName = connectionName,
        hubVirtualNetworkConnection = hubVirtualNetworkConnection,
        id = id,
        name = name,
        peerAsn = peerAsn,
        peerIp = peerIp,
        resourceGroupName = resourceGroupName,
        virtualHubName = virtualHubName,
    )
}
