@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualHubIpConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.IPAllocationMethod
import com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressArgs
import com.pulumi.azurenative.network.kotlin.inputs.PublicIPAddressArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubnetArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubnetArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * IpConfigurations.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### VirtualHubIpConfigurationPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualHubIpConfiguration = new AzureNative.Network.VirtualHubIpConfiguration("virtualHubIpConfiguration", new()
 *     {
 *         IpConfigName = "ipconfig1",
 *         ResourceGroupName = "rg1",
 *         Subnet = new AzureNative.Network.Inputs.SubnetArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1",
 *         },
 *         VirtualHubName = "hub1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualHubIpConfiguration(ctx, "virtualHubIpConfiguration", &network.VirtualHubIpConfigurationArgs{
 * 			IpConfigName:      pulumi.String("ipconfig1"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Subnet: &network.SubnetTypeArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
 * 			},
 * 			VirtualHubName: pulumi.String("hub1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualHubIpConfiguration;
 * import com.pulumi.azurenative.network.VirtualHubIpConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualHubIpConfiguration = new VirtualHubIpConfiguration("virtualHubIpConfiguration", VirtualHubIpConfigurationArgs.builder()
 *             .ipConfigName("ipconfig1")
 *             .resourceGroupName("rg1")
 *             .subnet(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"))
 *             .virtualHubName("hub1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualHubIpConfiguration ipconfig1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/ipConfigurations/{ipConfigName}
 * ```
 * @property id Resource ID.
 * @property ipConfigName The name of the ipconfig.
 * @property name Name of the Ip Configuration.
 * @property privateIPAddress The private IP address of the IP configuration.
 * @property privateIPAllocationMethod The private IP address allocation method.
 * @property publicIPAddress The reference to the public IP resource.
 * @property resourceGroupName The resource group name of the VirtualHub.
 * @property subnet The reference to the subnet resource.
 * @property virtualHubName The name of the VirtualHub.
 */
public data class VirtualHubIpConfigurationArgs(
    public val id: Output<String>? = null,
    public val ipConfigName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val privateIPAddress: Output<String>? = null,
    public val privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null,
    public val publicIPAddress: Output<PublicIPAddressArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val subnet: Output<SubnetArgs>? = null,
    public val virtualHubName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualHubIpConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualHubIpConfigurationArgs =
        com.pulumi.azurenative.network.VirtualHubIpConfigurationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .ipConfigName(ipConfigName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .privateIPAddress(privateIPAddress?.applyValue({ args0 -> args0 }))
            .privateIPAllocationMethod(
                privateIPAllocationMethod?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .publicIPAddress(publicIPAddress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .virtualHubName(virtualHubName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualHubIpConfigurationArgs].
 */
@PulumiTagMarker
public class VirtualHubIpConfigurationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var ipConfigName: Output<String>? = null

    private var name: Output<String>? = null

    private var privateIPAddress: Output<String>? = null

    private var privateIPAllocationMethod: Output<Either<String, IPAllocationMethod>>? = null

    private var publicIPAddress: Output<PublicIPAddressArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var subnet: Output<SubnetArgs>? = null

    private var virtualHubName: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("tpstantvfltobjpp")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the ipconfig.
     */
    @JvmName("qbrnyeophyfmvmxo")
    public suspend fun ipConfigName(`value`: Output<String>) {
        this.ipConfigName = value
    }

    /**
     * @param value Name of the Ip Configuration.
     */
    @JvmName("fsjfgodammabdsln")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The private IP address of the IP configuration.
     */
    @JvmName("nqqmtskpnmrnpoqd")
    public suspend fun privateIPAddress(`value`: Output<String>) {
        this.privateIPAddress = value
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("euspagtoltnplcsg")
    public suspend
    fun privateIPAllocationMethod(`value`: Output<Either<String, IPAllocationMethod>>) {
        this.privateIPAllocationMethod = value
    }

    /**
     * @param value The reference to the public IP resource.
     */
    @JvmName("kkjtitxbamlrhkva")
    public suspend fun publicIPAddress(`value`: Output<PublicIPAddressArgs>) {
        this.publicIPAddress = value
    }

    /**
     * @param value The resource group name of the VirtualHub.
     */
    @JvmName("uarlxmcprprumtmy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The reference to the subnet resource.
     */
    @JvmName("jhdaifuohlvjtyxc")
    public suspend fun subnet(`value`: Output<SubnetArgs>) {
        this.subnet = value
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("obxwgnfmtkaugjnw")
    public suspend fun virtualHubName(`value`: Output<String>) {
        this.virtualHubName = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("bcijrhhtupofqnsv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the ipconfig.
     */
    @JvmName("debxdckuaqfkgorx")
    public suspend fun ipConfigName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigName = mapped
    }

    /**
     * @param value Name of the Ip Configuration.
     */
    @JvmName("oijjftjfkwnigqtl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The private IP address of the IP configuration.
     */
    @JvmName("dannlbomxvxojwdy")
    public suspend fun privateIPAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAddress = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("xoahqlopwoncfpme")
    public suspend fun privateIPAllocationMethod(`value`: Either<String, IPAllocationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("anywwckdigplescw")
    public fun privateIPAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The private IP address allocation method.
     */
    @JvmName("qasseekunlxassmw")
    public fun privateIPAllocationMethod(`value`: IPAllocationMethod) {
        val toBeMapped = Either.ofRight<String, IPAllocationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateIPAllocationMethod = mapped
    }

    /**
     * @param value The reference to the public IP resource.
     */
    @JvmName("mvdttaqlboilylce")
    public suspend fun publicIPAddress(`value`: PublicIPAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIPAddress = mapped
    }

    /**
     * @param argument The reference to the public IP resource.
     */
    @JvmName("mornmqxkygpkumww")
    public suspend fun publicIPAddress(argument: suspend PublicIPAddressArgsBuilder.() -> Unit) {
        val toBeMapped = PublicIPAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIPAddress = mapped
    }

    /**
     * @param value The resource group name of the VirtualHub.
     */
    @JvmName("eyjirbpsccjbupan")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The reference to the subnet resource.
     */
    @JvmName("nsvsfwdvnxbakvpo")
    public suspend fun subnet(`value`: SubnetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument The reference to the subnet resource.
     */
    @JvmName("ldlcvvndrdpcghrb")
    public suspend fun subnet(argument: suspend SubnetArgsBuilder.() -> Unit) {
        val toBeMapped = SubnetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("ospdkwoerljewhlj")
    public suspend fun virtualHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHubName = mapped
    }

    internal fun build(): VirtualHubIpConfigurationArgs = VirtualHubIpConfigurationArgs(
        id = id,
        ipConfigName = ipConfigName,
        name = name,
        privateIPAddress = privateIPAddress,
        privateIPAllocationMethod = privateIPAllocationMethod,
        publicIPAddress = publicIPAddress,
        resourceGroupName = resourceGroupName,
        subnet = subnet,
        virtualHubName = virtualHubName,
    )
}
