@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualHubRouteTableV2Args.builder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualHubRouteV2Args
import com.pulumi.azurenative.network.kotlin.inputs.VirtualHubRouteV2ArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VirtualHubRouteTableV2 Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### VirtualHubRouteTableV2Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualHubRouteTableV2 = new AzureNative.Network.VirtualHubRouteTableV2("virtualHubRouteTableV2", new()
 *     {
 *         AttachedConnections = new[]
 *         {
 *             "All_Vnets",
 *         },
 *         ResourceGroupName = "rg1",
 *         RouteTableName = "virtualHubRouteTable1a",
 *         Routes = new[]
 *         {
 *             new AzureNative.Network.Inputs.VirtualHubRouteV2Args
 *             {
 *                 DestinationType = "CIDR",
 *                 Destinations = new[]
 *                 {
 *                     "20.10.0.0/16",
 *                     "20.20.0.0/16",
 *                 },
 *                 NextHopType = "IPAddress",
 *                 NextHops = new[]
 *                 {
 *                     "10.0.0.68",
 *                 },
 *             },
 *             new AzureNative.Network.Inputs.VirtualHubRouteV2Args
 *             {
 *                 DestinationType = "CIDR",
 *                 Destinations = new[]
 *                 {
 *                     "0.0.0.0/0",
 *                 },
 *                 NextHopType = "IPAddress",
 *                 NextHops = new[]
 *                 {
 *                     "10.0.0.68",
 *                 },
 *             },
 *         },
 *         VirtualHubName = "virtualHub1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualHubRouteTableV2(ctx, "virtualHubRouteTableV2", &network.VirtualHubRouteTableV2Args{
 * 			AttachedConnections: pulumi.StringArray{
 * 				pulumi.String("All_Vnets"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			RouteTableName:    pulumi.String("virtualHubRouteTable1a"),
 * 			Routes: []network.VirtualHubRouteV2Args{
 * 				{
 * 					DestinationType: pulumi.String("CIDR"),
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("20.10.0.0/16"),
 * 						pulumi.String("20.20.0.0/16"),
 * 					},
 * 					NextHopType: pulumi.String("IPAddress"),
 * 					NextHops: pulumi.StringArray{
 * 						pulumi.String("10.0.0.68"),
 * 					},
 * 				},
 * 				{
 * 					DestinationType: pulumi.String("CIDR"),
 * 					Destinations: pulumi.StringArray{
 * 						pulumi.String("0.0.0.0/0"),
 * 					},
 * 					NextHopType: pulumi.String("IPAddress"),
 * 					NextHops: pulumi.StringArray{
 * 						pulumi.String("10.0.0.68"),
 * 					},
 * 				},
 * 			},
 * 			VirtualHubName: pulumi.String("virtualHub1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualHubRouteTableV2;
 * import com.pulumi.azurenative.network.VirtualHubRouteTableV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualHubRouteTableV2 = new VirtualHubRouteTableV2("virtualHubRouteTableV2", VirtualHubRouteTableV2Args.builder()
 *             .attachedConnections("All_Vnets")
 *             .resourceGroupName("rg1")
 *             .routeTableName("virtualHubRouteTable1a")
 *             .routes(
 *                 Map.ofEntries(
 *                     Map.entry("destinationType", "CIDR"),
 *                     Map.entry("destinations",
 *                         "20.10.0.0/16",
 *                         "20.20.0.0/16"),
 *                     Map.entry("nextHopType", "IPAddress"),
 *                     Map.entry("nextHops", "10.0.0.68")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("destinationType", "CIDR"),
 *                     Map.entry("destinations", "0.0.0.0/0"),
 *                     Map.entry("nextHopType", "IPAddress"),
 *                     Map.entry("nextHops", "10.0.0.68")
 *                 ))
 *             .virtualHubName("virtualHub1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualHubRouteTableV2 virtualHubRouteTable1a /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualHubs/{virtualHubName}/routeTables/{routeTableName}
 * ```
 * @property attachedConnections List of all connections attached to this route table v2.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property resourceGroupName The resource group name of the VirtualHub.
 * @property routeTableName The name of the VirtualHubRouteTableV2.
 * @property routes List of all routes.
 * @property virtualHubName The name of the VirtualHub.
 */
public data class VirtualHubRouteTableV2Args(
    public val attachedConnections: Output<List<String>>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routeTableName: Output<String>? = null,
    public val routes: Output<List<VirtualHubRouteV2Args>>? = null,
    public val virtualHubName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualHubRouteTableV2Args> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualHubRouteTableV2Args =
        com.pulumi.azurenative.network.VirtualHubRouteTableV2Args.builder()
            .attachedConnections(attachedConnections?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routeTableName(routeTableName?.applyValue({ args0 -> args0 }))
            .routes(routes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .virtualHubName(virtualHubName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualHubRouteTableV2Args].
 */
@PulumiTagMarker
public class VirtualHubRouteTableV2ArgsBuilder internal constructor() {
    private var attachedConnections: Output<List<String>>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routeTableName: Output<String>? = null

    private var routes: Output<List<VirtualHubRouteV2Args>>? = null

    private var virtualHubName: Output<String>? = null

    /**
     * @param value List of all connections attached to this route table v2.
     */
    @JvmName("fyjaacmjbttybcsa")
    public suspend fun attachedConnections(`value`: Output<List<String>>) {
        this.attachedConnections = value
    }

    @JvmName("holmmgqisfefwetq")
    public suspend fun attachedConnections(vararg values: Output<String>) {
        this.attachedConnections = Output.all(values.asList())
    }

    /**
     * @param values List of all connections attached to this route table v2.
     */
    @JvmName("awpiboxyictaatrw")
    public suspend fun attachedConnections(values: List<Output<String>>) {
        this.attachedConnections = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("evxiiqfffiiadtsm")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("tfifrwplhxhjkris")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The resource group name of the VirtualHub.
     */
    @JvmName("dcqcidcbgohnwrds")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the VirtualHubRouteTableV2.
     */
    @JvmName("vdselslrrpurpewt")
    public suspend fun routeTableName(`value`: Output<String>) {
        this.routeTableName = value
    }

    /**
     * @param value List of all routes.
     */
    @JvmName("yerkxkyumjmagioq")
    public suspend fun routes(`value`: Output<List<VirtualHubRouteV2Args>>) {
        this.routes = value
    }

    @JvmName("uawhkjrwjrfoanxo")
    public suspend fun routes(vararg values: Output<VirtualHubRouteV2Args>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values List of all routes.
     */
    @JvmName("mybcbhmvlssbalqt")
    public suspend fun routes(values: List<Output<VirtualHubRouteV2Args>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("wkgqtksvavslnucf")
    public suspend fun virtualHubName(`value`: Output<String>) {
        this.virtualHubName = value
    }

    /**
     * @param value List of all connections attached to this route table v2.
     */
    @JvmName("uwryppvxgjwvgnlw")
    public suspend fun attachedConnections(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachedConnections = mapped
    }

    /**
     * @param values List of all connections attached to this route table v2.
     */
    @JvmName("dwrpoehucikmneel")
    public suspend fun attachedConnections(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attachedConnections = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("vbvcrkfdotnowdbp")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("rgsoytfrmaicmipj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The resource group name of the VirtualHub.
     */
    @JvmName("vwbdhdmjpglhturs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VirtualHubRouteTableV2.
     */
    @JvmName("giclmheqkstlaqvy")
    public suspend fun routeTableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableName = mapped
    }

    /**
     * @param value List of all routes.
     */
    @JvmName("bmgrabklcchvfhig")
    public suspend fun routes(`value`: List<VirtualHubRouteV2Args>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument List of all routes.
     */
    @JvmName("nncpwyrnfjhevwbq")
    public suspend fun routes(argument: List<suspend VirtualHubRouteV2ArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualHubRouteV2ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument List of all routes.
     */
    @JvmName("rrocabujxomvsosx")
    public suspend fun routes(vararg argument: suspend VirtualHubRouteV2ArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VirtualHubRouteV2ArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument List of all routes.
     */
    @JvmName("hbcdqnykiscapkcb")
    public suspend fun routes(argument: suspend VirtualHubRouteV2ArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualHubRouteV2ArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values List of all routes.
     */
    @JvmName("jopfiqdgnvaumqps")
    public suspend fun routes(vararg values: VirtualHubRouteV2Args) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("pdsftxbenxqicqex")
    public suspend fun virtualHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualHubName = mapped
    }

    internal fun build(): VirtualHubRouteTableV2Args = VirtualHubRouteTableV2Args(
        attachedConnections = attachedConnections,
        id = id,
        name = name,
        resourceGroupName = resourceGroupName,
        routeTableName = routeTableName,
        routes = routes,
        virtualHubName = virtualHubName,
    )
}
