@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualNetworkGatewayArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AdminState
import com.pulumi.azurenative.network.kotlin.enums.VirtualNetworkGatewayType
import com.pulumi.azurenative.network.kotlin.enums.VpnGatewayGeneration
import com.pulumi.azurenative.network.kotlin.enums.VpnType
import com.pulumi.azurenative.network.kotlin.inputs.AddressSpaceArgs
import com.pulumi.azurenative.network.kotlin.inputs.AddressSpaceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.BgpSettingsArgs
import com.pulumi.azurenative.network.kotlin.inputs.BgpSettingsArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.network.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkGatewayIPConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkGatewayIPConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkGatewayNatRuleArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkGatewayNatRuleArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkGatewayPolicyGroupArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkGatewayPolicyGroupArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkGatewaySkuArgs
import com.pulumi.azurenative.network.kotlin.inputs.VirtualNetworkGatewaySkuArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VpnClientConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnClientConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A common class for general resource information.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2016-06-01, 2016-09-01, 2019-08-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### UpdateVirtualNetworkGateway
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkGateway = new AzureNative.Network.VirtualNetworkGateway("virtualNetworkGateway", new()
 *     {
 *         ActiveActive = false,
 *         AllowRemoteVnetTraffic = false,
 *         AllowVirtualWanTraffic = false,
 *         BgpSettings = new AzureNative.Network.Inputs.BgpSettingsArgs
 *         {
 *             Asn = 65515,
 *             BgpPeeringAddress = "10.0.1.30",
 *             PeerWeight = 0,
 *         },
 *         CustomRoutes = new AzureNative.Network.Inputs.AddressSpaceArgs
 *         {
 *             AddressPrefixes = new[]
 *             {
 *                 "101.168.0.6/32",
 *             },
 *         },
 *         DisableIPSecReplayProtection = false,
 *         EnableBgp = false,
 *         EnableBgpRouteTranslationForNat = false,
 *         EnableDnsForwarding = true,
 *         GatewayType = "Vpn",
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.Network.Inputs.VirtualNetworkGatewayIPConfigurationArgs
 *             {
 *                 Name = "gwipconfig1",
 *                 PrivateIPAllocationMethod = "Dynamic",
 *                 PublicIPAddress = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip",
 *                 },
 *                 Subnet = new AzureNative.Network.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet",
 *                 },
 *             },
 *         },
 *         Location = "centralus",
 *         NatRules = new[]
 *         {
 *             new AzureNative.Network.Inputs.VirtualNetworkGatewayNatRuleArgs
 *             {
 *                 ExternalMappings = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *                     {
 *                         AddressSpace = "50.0.0.0/24",
 *                     },
 *                 },
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule1",
 *                 InternalMappings = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *                     {
 *                         AddressSpace = "10.10.0.0/24",
 *                     },
 *                 },
 *                 IpConfigurationId = "",
 *                 Mode = "EgressSnat",
 *                 Name = "natRule1",
 *                 Type = "Static",
 *             },
 *             new AzureNative.Network.Inputs.VirtualNetworkGatewayNatRuleArgs
 *             {
 *                 ExternalMappings = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *                     {
 *                         AddressSpace = "30.0.0.0/24",
 *                     },
 *                 },
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule2",
 *                 InternalMappings = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *                     {
 *                         AddressSpace = "20.10.0.0/24",
 *                     },
 *                 },
 *                 IpConfigurationId = "",
 *                 Mode = "IngressSnat",
 *                 Name = "natRule2",
 *                 Type = "Static",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.Network.Inputs.VirtualNetworkGatewaySkuArgs
 *         {
 *             Name = "VpnGw1",
 *             Tier = "VpnGw1",
 *         },
 *         VirtualNetworkGatewayName = "vpngw",
 *         VpnClientConfiguration = new AzureNative.Network.Inputs.VpnClientConfigurationArgs
 *         {
 *             RadiusServers = new[]
 *             {
 *                 new AzureNative.Network.Inputs.RadiusServerArgs
 *                 {
 *                     RadiusServerAddress = "10.2.0.0",
 *                     RadiusServerScore = 20,
 *                     RadiusServerSecret = "radiusServerSecret",
 *                 },
 *             },
 *             VpnClientProtocols = new[]
 *             {
 *                 "OpenVPN",
 *             },
 *             VpnClientRevokedCertificates = new() { },
 *             VpnClientRootCertificates = new() { },
 *         },
 *         VpnType = "RouteBased",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetworkGateway(ctx, "virtualNetworkGateway", &network.VirtualNetworkGatewayArgs{
 * 			ActiveActive:           pulumi.Bool(false),
 * 			AllowRemoteVnetTraffic: pulumi.Bool(false),
 * 			AllowVirtualWanTraffic: pulumi.Bool(false),
 * 			BgpSettings: &network.BgpSettingsArgs{
 * 				Asn:               pulumi.Float64(65515),
 * 				BgpPeeringAddress: pulumi.String("10.0.1.30"),
 * 				PeerWeight:        pulumi.Int(0),
 * 			},
 * 			CustomRoutes: &network.AddressSpaceArgs{
 * 				AddressPrefixes: pulumi.StringArray{
 * 					pulumi.String("101.168.0.6/32"),
 * 				},
 * 			},
 * 			DisableIPSecReplayProtection:    pulumi.Bool(false),
 * 			EnableBgp:                       pulumi.Bool(false),
 * 			EnableBgpRouteTranslationForNat: pulumi.Bool(false),
 * 			EnableDnsForwarding:             pulumi.Bool(true),
 * 			GatewayType:                     pulumi.String("Vpn"),
 * 			IpConfigurations: []network.VirtualNetworkGatewayIPConfigurationArgs{
 * 				{
 * 					Name:                      pulumi.String("gwipconfig1"),
 * 					PrivateIPAllocationMethod: pulumi.String("Dynamic"),
 * 					PublicIPAddress: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip"),
 * 					},
 * 					Subnet: {
 * 						Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet"),
 * 					},
 * 				},
 * 			},
 * 			Location: pulumi.String("centralus"),
 * 			NatRules: []network.VirtualNetworkGatewayNatRuleTypeArgs{
 * 				{
 * 					ExternalMappings: network.VpnNatRuleMappingArray{
 * 						{
 * 							AddressSpace: pulumi.String("50.0.0.0/24"),
 * 						},
 * 					},
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule1"),
 * 					InternalMappings: network.VpnNatRuleMappingArray{
 * 						{
 * 							AddressSpace: pulumi.String("10.10.0.0/24"),
 * 						},
 * 					},
 * 					IpConfigurationId: pulumi.String(""),
 * 					Mode:              pulumi.String("EgressSnat"),
 * 					Name:              pulumi.String("natRule1"),
 * 					Type:              pulumi.String("Static"),
 * 				},
 * 				{
 * 					ExternalMappings: network.VpnNatRuleMappingArray{
 * 						{
 * 							AddressSpace: pulumi.String("30.0.0.0/24"),
 * 						},
 * 					},
 * 					Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule2"),
 * 					InternalMappings: network.VpnNatRuleMappingArray{
 * 						{
 * 							AddressSpace: pulumi.String("20.10.0.0/24"),
 * 						},
 * 					},
 * 					IpConfigurationId: pulumi.String(""),
 * 					Mode:              pulumi.String("IngressSnat"),
 * 					Name:              pulumi.String("natRule2"),
 * 					Type:              pulumi.String("Static"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &network.VirtualNetworkGatewaySkuArgs{
 * 				Name: pulumi.String("VpnGw1"),
 * 				Tier: pulumi.String("VpnGw1"),
 * 			},
 * 			VirtualNetworkGatewayName: pulumi.String("vpngw"),
 * 			VpnClientConfiguration: network.VpnClientConfigurationResponse{
 * 				RadiusServers: network.RadiusServerArray{
 * 					&network.RadiusServerArgs{
 * 						RadiusServerAddress: pulumi.String("10.2.0.0"),
 * 						RadiusServerScore:   pulumi.Float64(20),
 * 						RadiusServerSecret:  pulumi.String("radiusServerSecret"),
 * 					},
 * 				},
 * 				VpnClientProtocols: pulumi.StringArray{
 * 					pulumi.String("OpenVPN"),
 * 				},
 * 				VpnClientRevokedCertificates: network.VpnClientRevokedCertificateArray{},
 * 				VpnClientRootCertificates:    network.VpnClientRootCertificateArray{},
 * 			},
 * 			VpnType: pulumi.String("RouteBased"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetworkGateway;
 * import com.pulumi.azurenative.network.VirtualNetworkGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkGateway = new VirtualNetworkGateway("virtualNetworkGateway", VirtualNetworkGatewayArgs.builder()
 *             .activeActive(false)
 *             .allowRemoteVnetTraffic(false)
 *             .allowVirtualWanTraffic(false)
 *             .bgpSettings(Map.ofEntries(
 *                 Map.entry("asn", 65515),
 *                 Map.entry("bgpPeeringAddress", "10.0.1.30"),
 *                 Map.entry("peerWeight", 0)
 *             ))
 *             .customRoutes(Map.of("addressPrefixes", "101.168.0.6/32"))
 *             .disableIPSecReplayProtection(false)
 *             .enableBgp(false)
 *             .enableBgpRouteTranslationForNat(false)
 *             .enableDnsForwarding(true)
 *             .gatewayType("Vpn")
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "gwipconfig1"),
 *                 Map.entry("privateIPAllocationMethod", "Dynamic"),
 *                 Map.entry("publicIPAddress", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/publicIPAddresses/gwpip")),
 *                 Map.entry("subnet", Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/GatewaySubnet"))
 *             ))
 *             .location("centralus")
 *             .natRules(
 *                 Map.ofEntries(
 *                     Map.entry("externalMappings", Map.of("addressSpace", "50.0.0.0/24")),
 *                     Map.entry("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule1"),
 *                     Map.entry("internalMappings", Map.of("addressSpace", "10.10.0.0/24")),
 *                     Map.entry("ipConfigurationId", ""),
 *                     Map.entry("mode", "EgressSnat"),
 *                     Map.entry("name", "natRule1"),
 *                     Map.entry("type", "Static")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("externalMappings", Map.of("addressSpace", "30.0.0.0/24")),
 *                     Map.entry("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/vpngw/natRules/natRule2"),
 *                     Map.entry("internalMappings", Map.of("addressSpace", "20.10.0.0/24")),
 *                     Map.entry("ipConfigurationId", ""),
 *                     Map.entry("mode", "IngressSnat"),
 *                     Map.entry("name", "natRule2"),
 *                     Map.entry("type", "Static")
 *                 ))
 *             .resourceGroupName("rg1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "VpnGw1"),
 *                 Map.entry("tier", "VpnGw1")
 *             ))
 *             .virtualNetworkGatewayName("vpngw")
 *             .vpnClientConfiguration(Map.ofEntries(
 *                 Map.entry("radiusServers", Map.ofEntries(
 *                     Map.entry("radiusServerAddress", "10.2.0.0"),
 *                     Map.entry("radiusServerScore", 20),
 *                     Map.entry("radiusServerSecret", "radiusServerSecret")
 *                 )),
 *                 Map.entry("vpnClientProtocols", "OpenVPN"),
 *                 Map.entry("vpnClientRevokedCertificates", ),
 *                 Map.entry("vpnClientRootCertificates", )
 *             ))
 *             .vpnType("RouteBased")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualNetworkGateway vpngw /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}
 * ```
 * @property activeActive ActiveActive flag.
 * @property adminState Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in the vnet
 * @property allowRemoteVnetTraffic Configure this gateway to accept traffic from other Azure Virtual Networks. This configuration does not support connectivity to Azure Virtual WAN.
 * @property allowVirtualWanTraffic Configures this gateway to accept traffic from remote Virtual WAN networks.
 * @property bgpSettings Virtual network gateway's BGP speaker settings.
 * @property customRoutes The reference to the address space resource which represents the custom routes address space specified by the customer for virtual network gateway and VpnClient.
 * @property disableIPSecReplayProtection disableIPSecReplayProtection flag.
 * @property enableBgp Whether BGP is enabled for this virtual network gateway or not.
 * @property enableBgpRouteTranslationForNat EnableBgpRouteTranslationForNat flag.
 * @property enableDnsForwarding Whether dns forwarding is enabled or not.
 * @property enablePrivateIpAddress Whether private IP needs to be enabled on this gateway for connections or not.
 * @property extendedLocation The extended location of type local virtual network gateway.
 * @property gatewayDefaultSite The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
 * @property gatewayType The type of this virtual network gateway.
 * @property id Resource ID.
 * @property ipConfigurations IP configurations for virtual network gateway.
 * @property location Resource location.
 * @property natRules NatRules for virtual network gateway.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property resourceGroupName The name of the resource group.
 * @property sku The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
 * @property tags Resource tags.
 * @property vNetExtendedLocationResourceId Customer vnet resource id. VirtualNetworkGateway of type local gateway is associated with the customer vnet.
 * @property virtualNetworkGatewayName The name of the virtual network gateway.
 * @property virtualNetworkGatewayPolicyGroups The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
 * @property vpnClientConfiguration The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
 * @property vpnGatewayGeneration The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
 * @property vpnType The type of this virtual network gateway.
 */
public data class VirtualNetworkGatewayArgs(
    public val activeActive: Output<Boolean>? = null,
    public val adminState: Output<Either<String, AdminState>>? = null,
    public val allowRemoteVnetTraffic: Output<Boolean>? = null,
    public val allowVirtualWanTraffic: Output<Boolean>? = null,
    public val bgpSettings: Output<BgpSettingsArgs>? = null,
    public val customRoutes: Output<AddressSpaceArgs>? = null,
    public val disableIPSecReplayProtection: Output<Boolean>? = null,
    public val enableBgp: Output<Boolean>? = null,
    public val enableBgpRouteTranslationForNat: Output<Boolean>? = null,
    public val enableDnsForwarding: Output<Boolean>? = null,
    public val enablePrivateIpAddress: Output<Boolean>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val gatewayDefaultSite: Output<SubResourceArgs>? = null,
    public val gatewayType: Output<Either<String, VirtualNetworkGatewayType>>? = null,
    public val id: Output<String>? = null,
    public val ipConfigurations: Output<List<VirtualNetworkGatewayIPConfigurationArgs>>? = null,
    public val location: Output<String>? = null,
    public val natRules: Output<List<VirtualNetworkGatewayNatRuleArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<VirtualNetworkGatewaySkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vNetExtendedLocationResourceId: Output<String>? = null,
    public val virtualNetworkGatewayName: Output<String>? = null,
    public val virtualNetworkGatewayPolicyGroups: Output<List<VirtualNetworkGatewayPolicyGroupArgs>>? =
        null,
    public val vpnClientConfiguration: Output<VpnClientConfigurationArgs>? = null,
    public val vpnGatewayGeneration: Output<Either<String, VpnGatewayGeneration>>? = null,
    public val vpnType: Output<Either<String, VpnType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualNetworkGatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualNetworkGatewayArgs =
        com.pulumi.azurenative.network.VirtualNetworkGatewayArgs.builder()
            .activeActive(activeActive?.applyValue({ args0 -> args0 }))
            .adminState(
                adminState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .allowRemoteVnetTraffic(allowRemoteVnetTraffic?.applyValue({ args0 -> args0 }))
            .allowVirtualWanTraffic(allowVirtualWanTraffic?.applyValue({ args0 -> args0 }))
            .bgpSettings(bgpSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customRoutes(customRoutes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .disableIPSecReplayProtection(disableIPSecReplayProtection?.applyValue({ args0 -> args0 }))
            .enableBgp(enableBgp?.applyValue({ args0 -> args0 }))
            .enableBgpRouteTranslationForNat(enableBgpRouteTranslationForNat?.applyValue({ args0 -> args0 }))
            .enableDnsForwarding(enableDnsForwarding?.applyValue({ args0 -> args0 }))
            .enablePrivateIpAddress(enablePrivateIpAddress?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .gatewayDefaultSite(
                gatewayDefaultSite?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .gatewayType(
                gatewayType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .natRules(
                natRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vNetExtendedLocationResourceId(vNetExtendedLocationResourceId?.applyValue({ args0 -> args0 }))
            .virtualNetworkGatewayName(virtualNetworkGatewayName?.applyValue({ args0 -> args0 }))
            .virtualNetworkGatewayPolicyGroups(
                virtualNetworkGatewayPolicyGroups?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnClientConfiguration(
                vpnClientConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vpnGatewayGeneration(
                vpnGatewayGeneration?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .vpnType(
                vpnType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualNetworkGatewayArgs].
 */
@PulumiTagMarker
public class VirtualNetworkGatewayArgsBuilder internal constructor() {
    private var activeActive: Output<Boolean>? = null

    private var adminState: Output<Either<String, AdminState>>? = null

    private var allowRemoteVnetTraffic: Output<Boolean>? = null

    private var allowVirtualWanTraffic: Output<Boolean>? = null

    private var bgpSettings: Output<BgpSettingsArgs>? = null

    private var customRoutes: Output<AddressSpaceArgs>? = null

    private var disableIPSecReplayProtection: Output<Boolean>? = null

    private var enableBgp: Output<Boolean>? = null

    private var enableBgpRouteTranslationForNat: Output<Boolean>? = null

    private var enableDnsForwarding: Output<Boolean>? = null

    private var enablePrivateIpAddress: Output<Boolean>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var gatewayDefaultSite: Output<SubResourceArgs>? = null

    private var gatewayType: Output<Either<String, VirtualNetworkGatewayType>>? = null

    private var id: Output<String>? = null

    private var ipConfigurations: Output<List<VirtualNetworkGatewayIPConfigurationArgs>>? = null

    private var location: Output<String>? = null

    private var natRules: Output<List<VirtualNetworkGatewayNatRuleArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<VirtualNetworkGatewaySkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vNetExtendedLocationResourceId: Output<String>? = null

    private var virtualNetworkGatewayName: Output<String>? = null

    private var virtualNetworkGatewayPolicyGroups: Output<List<VirtualNetworkGatewayPolicyGroupArgs>>? =
        null

    private var vpnClientConfiguration: Output<VpnClientConfigurationArgs>? = null

    private var vpnGatewayGeneration: Output<Either<String, VpnGatewayGeneration>>? = null

    private var vpnType: Output<Either<String, VpnType>>? = null

    /**
     * @param value ActiveActive flag.
     */
    @JvmName("jsadoouekselrukn")
    public suspend fun activeActive(`value`: Output<Boolean>) {
        this.activeActive = value
    }

    /**
     * @param value Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in the vnet
     */
    @JvmName("wmrrotligkkjbcfb")
    public suspend fun adminState(`value`: Output<Either<String, AdminState>>) {
        this.adminState = value
    }

    /**
     * @param value Configure this gateway to accept traffic from other Azure Virtual Networks. This configuration does not support connectivity to Azure Virtual WAN.
     */
    @JvmName("caadgqytkflxhyyr")
    public suspend fun allowRemoteVnetTraffic(`value`: Output<Boolean>) {
        this.allowRemoteVnetTraffic = value
    }

    /**
     * @param value Configures this gateway to accept traffic from remote Virtual WAN networks.
     */
    @JvmName("vqsqghvyjjxgdame")
    public suspend fun allowVirtualWanTraffic(`value`: Output<Boolean>) {
        this.allowVirtualWanTraffic = value
    }

    /**
     * @param value Virtual network gateway's BGP speaker settings.
     */
    @JvmName("tpldspagrykifbqh")
    public suspend fun bgpSettings(`value`: Output<BgpSettingsArgs>) {
        this.bgpSettings = value
    }

    /**
     * @param value The reference to the address space resource which represents the custom routes address space specified by the customer for virtual network gateway and VpnClient.
     */
    @JvmName("qxldogwupseqdetn")
    public suspend fun customRoutes(`value`: Output<AddressSpaceArgs>) {
        this.customRoutes = value
    }

    /**
     * @param value disableIPSecReplayProtection flag.
     */
    @JvmName("sprpptyvhgynmpig")
    public suspend fun disableIPSecReplayProtection(`value`: Output<Boolean>) {
        this.disableIPSecReplayProtection = value
    }

    /**
     * @param value Whether BGP is enabled for this virtual network gateway or not.
     */
    @JvmName("agkmtaweofufkuqy")
    public suspend fun enableBgp(`value`: Output<Boolean>) {
        this.enableBgp = value
    }

    /**
     * @param value EnableBgpRouteTranslationForNat flag.
     */
    @JvmName("hvhcbmebvhflibbe")
    public suspend fun enableBgpRouteTranslationForNat(`value`: Output<Boolean>) {
        this.enableBgpRouteTranslationForNat = value
    }

    /**
     * @param value Whether dns forwarding is enabled or not.
     */
    @JvmName("envhtoehcdhkarwc")
    public suspend fun enableDnsForwarding(`value`: Output<Boolean>) {
        this.enableDnsForwarding = value
    }

    /**
     * @param value Whether private IP needs to be enabled on this gateway for connections or not.
     */
    @JvmName("yqrfdubbofmjjsrq")
    public suspend fun enablePrivateIpAddress(`value`: Output<Boolean>) {
        this.enablePrivateIpAddress = value
    }

    /**
     * @param value The extended location of type local virtual network gateway.
     */
    @JvmName("qoxtijlkvfbgrlxl")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
     */
    @JvmName("kvwlnhvgghjuyryo")
    public suspend fun gatewayDefaultSite(`value`: Output<SubResourceArgs>) {
        this.gatewayDefaultSite = value
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("nusriietribrykvc")
    public suspend fun gatewayType(`value`: Output<Either<String, VirtualNetworkGatewayType>>) {
        this.gatewayType = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("sbkdsquienpmkdcr")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value IP configurations for virtual network gateway.
     */
    @JvmName("qbiwjkuhpjbdovha")
    public suspend
    fun ipConfigurations(`value`: Output<List<VirtualNetworkGatewayIPConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("ficruiugvscmqrvf")
    public suspend fun ipConfigurations(
        vararg
        values: Output<VirtualNetworkGatewayIPConfigurationArgs>,
    ) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values IP configurations for virtual network gateway.
     */
    @JvmName("ruxycrnyhlmemxyp")
    public suspend
    fun ipConfigurations(values: List<Output<VirtualNetworkGatewayIPConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value Resource location.
     */
    @JvmName("avhirtfvlajsirbq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value NatRules for virtual network gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("pogjorrgtsilfmse")
    public suspend fun natRules(`value`: Output<List<VirtualNetworkGatewayNatRuleArgs>>) {
        this.natRules = value
    }

    @JvmName("boxjmrkvbiyfetlo")
    public suspend fun natRules(vararg values: Output<VirtualNetworkGatewayNatRuleArgs>) {
        this.natRules = Output.all(values.asList())
    }

    /**
     * @param values NatRules for virtual network gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("vobvppnrsfbgbujf")
    public suspend fun natRules(values: List<Output<VirtualNetworkGatewayNatRuleArgs>>) {
        this.natRules = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mlmeuvnvlrjxhlso")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
     */
    @JvmName("vbriptlvjcicmurb")
    public suspend fun sku(`value`: Output<VirtualNetworkGatewaySkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("opugsujqhobvhiyt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Customer vnet resource id. VirtualNetworkGateway of type local gateway is associated with the customer vnet.
     */
    @JvmName("wgjviycnrajtrmgu")
    public suspend fun vNetExtendedLocationResourceId(`value`: Output<String>) {
        this.vNetExtendedLocationResourceId = value
    }

    /**
     * @param value The name of the virtual network gateway.
     */
    @JvmName("epwyagwfspjnvilo")
    public suspend fun virtualNetworkGatewayName(`value`: Output<String>) {
        this.virtualNetworkGatewayName = value
    }

    /**
     * @param value The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
     */
    @JvmName("bhioetrxlhrnejtm")
    public suspend
    fun virtualNetworkGatewayPolicyGroups(`value`: Output<List<VirtualNetworkGatewayPolicyGroupArgs>>) {
        this.virtualNetworkGatewayPolicyGroups = value
    }

    @JvmName("aqyhossdnaumkdjx")
    public suspend fun virtualNetworkGatewayPolicyGroups(
        vararg
        values: Output<VirtualNetworkGatewayPolicyGroupArgs>,
    ) {
        this.virtualNetworkGatewayPolicyGroups = Output.all(values.asList())
    }

    /**
     * @param values The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
     */
    @JvmName("yflbdooevmmyksfk")
    public suspend
    fun virtualNetworkGatewayPolicyGroups(values: List<Output<VirtualNetworkGatewayPolicyGroupArgs>>) {
        this.virtualNetworkGatewayPolicyGroups = Output.all(values)
    }

    /**
     * @param value The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
     */
    @JvmName("becdymfijluujwoa")
    public suspend fun vpnClientConfiguration(`value`: Output<VpnClientConfigurationArgs>) {
        this.vpnClientConfiguration = value
    }

    /**
     * @param value The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
     */
    @JvmName("dmotskycgoiqanwn")
    public suspend fun vpnGatewayGeneration(`value`: Output<Either<String, VpnGatewayGeneration>>) {
        this.vpnGatewayGeneration = value
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("cekmennbaxercqff")
    public suspend fun vpnType(`value`: Output<Either<String, VpnType>>) {
        this.vpnType = value
    }

    /**
     * @param value ActiveActive flag.
     */
    @JvmName("xpjxowxdmsdokerm")
    public suspend fun activeActive(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeActive = mapped
    }

    /**
     * @param value Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in the vnet
     */
    @JvmName("tgfhsyqeljhktruj")
    public suspend fun adminState(`value`: Either<String, AdminState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminState = mapped
    }

    /**
     * @param value Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in the vnet
     */
    @JvmName("umugfiuybwpprsgc")
    public fun adminState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AdminState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminState = mapped
    }

    /**
     * @param value Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in the vnet
     */
    @JvmName("jmqsuqwtyxaorknv")
    public fun adminState(`value`: AdminState) {
        val toBeMapped = Either.ofRight<String, AdminState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminState = mapped
    }

    /**
     * @param value Configure this gateway to accept traffic from other Azure Virtual Networks. This configuration does not support connectivity to Azure Virtual WAN.
     */
    @JvmName("snifanmvlurbiyla")
    public suspend fun allowRemoteVnetTraffic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowRemoteVnetTraffic = mapped
    }

    /**
     * @param value Configures this gateway to accept traffic from remote Virtual WAN networks.
     */
    @JvmName("oqcbhfimpyxyqpge")
    public suspend fun allowVirtualWanTraffic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowVirtualWanTraffic = mapped
    }

    /**
     * @param value Virtual network gateway's BGP speaker settings.
     */
    @JvmName("ilbjwoqegsaxjetq")
    public suspend fun bgpSettings(`value`: BgpSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpSettings = mapped
    }

    /**
     * @param argument Virtual network gateway's BGP speaker settings.
     */
    @JvmName("waadsqyguycfcgey")
    public suspend fun bgpSettings(argument: suspend BgpSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = BgpSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bgpSettings = mapped
    }

    /**
     * @param value The reference to the address space resource which represents the custom routes address space specified by the customer for virtual network gateway and VpnClient.
     */
    @JvmName("nydoudscojikdoqe")
    public suspend fun customRoutes(`value`: AddressSpaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customRoutes = mapped
    }

    /**
     * @param argument The reference to the address space resource which represents the custom routes address space specified by the customer for virtual network gateway and VpnClient.
     */
    @JvmName("yjtuuqadqqwbbwri")
    public suspend fun customRoutes(argument: suspend AddressSpaceArgsBuilder.() -> Unit) {
        val toBeMapped = AddressSpaceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customRoutes = mapped
    }

    /**
     * @param value disableIPSecReplayProtection flag.
     */
    @JvmName("ddonxlclrifjluja")
    public suspend fun disableIPSecReplayProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableIPSecReplayProtection = mapped
    }

    /**
     * @param value Whether BGP is enabled for this virtual network gateway or not.
     */
    @JvmName("bvumykemaktapisn")
    public suspend fun enableBgp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBgp = mapped
    }

    /**
     * @param value EnableBgpRouteTranslationForNat flag.
     */
    @JvmName("oiuuneqtnehpvthu")
    public suspend fun enableBgpRouteTranslationForNat(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBgpRouteTranslationForNat = mapped
    }

    /**
     * @param value Whether dns forwarding is enabled or not.
     */
    @JvmName("dqvkakhhsmscqfkp")
    public suspend fun enableDnsForwarding(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDnsForwarding = mapped
    }

    /**
     * @param value Whether private IP needs to be enabled on this gateway for connections or not.
     */
    @JvmName("mxnyefkrycinphtv")
    public suspend fun enablePrivateIpAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePrivateIpAddress = mapped
    }

    /**
     * @param value The extended location of type local virtual network gateway.
     */
    @JvmName("hujslbpruunagiwn")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of type local virtual network gateway.
     */
    @JvmName("flwqkfshvihuggfe")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
     */
    @JvmName("fatkoodvwudkgotp")
    public suspend fun gatewayDefaultSite(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayDefaultSite = mapped
    }

    /**
     * @param argument The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
     */
    @JvmName("dptttgvfwfvsvmvs")
    public suspend fun gatewayDefaultSite(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gatewayDefaultSite = mapped
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("xmegoxpenedwhseq")
    public suspend fun gatewayType(`value`: Either<String, VirtualNetworkGatewayType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayType = mapped
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("bmaymmprpxbrojta")
    public fun gatewayType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VirtualNetworkGatewayType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gatewayType = mapped
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("daxqxcxslnltydtn")
    public fun gatewayType(`value`: VirtualNetworkGatewayType) {
        val toBeMapped = Either.ofRight<String, VirtualNetworkGatewayType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gatewayType = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("dekhrkwdnlirdgfh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value IP configurations for virtual network gateway.
     */
    @JvmName("ukphjodeasxbmlub")
    public suspend fun ipConfigurations(`value`: List<VirtualNetworkGatewayIPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IP configurations for virtual network gateway.
     */
    @JvmName("rtlfxnrgyxvmwcmt")
    public suspend
    fun ipConfigurations(argument: List<suspend VirtualNetworkGatewayIPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkGatewayIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IP configurations for virtual network gateway.
     */
    @JvmName("oqxmfswcsonnwois")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend VirtualNetworkGatewayIPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkGatewayIPConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IP configurations for virtual network gateway.
     */
    @JvmName("piquovrvacgsvjhw")
    public suspend
    fun ipConfigurations(argument: suspend VirtualNetworkGatewayIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNetworkGatewayIPConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values IP configurations for virtual network gateway.
     */
    @JvmName("vrmwokabroydljvb")
    public suspend fun ipConfigurations(vararg values: VirtualNetworkGatewayIPConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("uggpfdnhjvqyfgvv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value NatRules for virtual network gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("rcfickvormimbewo")
    public suspend fun natRules(`value`: List<VirtualNetworkGatewayNatRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natRules = mapped
    }

    /**
     * @param argument NatRules for virtual network gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("mnhnpqtniyyvamtk")
    public suspend
    fun natRules(argument: List<suspend VirtualNetworkGatewayNatRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkGatewayNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.natRules = mapped
    }

    /**
     * @param argument NatRules for virtual network gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("btawqeopprvxwfyg")
    public suspend fun natRules(
        vararg
        argument: suspend VirtualNetworkGatewayNatRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkGatewayNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.natRules = mapped
    }

    /**
     * @param argument NatRules for virtual network gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("asjxegrmudpdtpoe")
    public suspend
    fun natRules(argument: suspend VirtualNetworkGatewayNatRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNetworkGatewayNatRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.natRules = mapped
    }

    /**
     * @param values NatRules for virtual network gateway.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("cabqlbpsyrujewsy")
    public suspend fun natRules(vararg values: VirtualNetworkGatewayNatRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.natRules = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("raxkttihbpguhnlk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
     */
    @JvmName("xvenapoawstsoejf")
    public suspend fun sku(`value`: VirtualNetworkGatewaySkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
     */
    @JvmName("rvwgxmjslgjsybhx")
    public suspend fun sku(argument: suspend VirtualNetworkGatewaySkuArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkGatewaySkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("byrmyugahbgwfgmc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("punxrynpcpkspnbn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Customer vnet resource id. VirtualNetworkGateway of type local gateway is associated with the customer vnet.
     */
    @JvmName("rshrkimsptdsxymt")
    public suspend fun vNetExtendedLocationResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vNetExtendedLocationResourceId = mapped
    }

    /**
     * @param value The name of the virtual network gateway.
     */
    @JvmName("kxlxekfpgpwrdemj")
    public suspend fun virtualNetworkGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkGatewayName = mapped
    }

    /**
     * @param value The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
     */
    @JvmName("isijeffsklshfeho")
    public suspend
    fun virtualNetworkGatewayPolicyGroups(`value`: List<VirtualNetworkGatewayPolicyGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkGatewayPolicyGroups = mapped
    }

    /**
     * @param argument The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
     */
    @JvmName("psolhuysfrpkxkmy")
    public suspend
    fun virtualNetworkGatewayPolicyGroups(argument: List<suspend VirtualNetworkGatewayPolicyGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkGatewayPolicyGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkGatewayPolicyGroups = mapped
    }

    /**
     * @param argument The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
     */
    @JvmName("yqboswotbngndbcq")
    public suspend fun virtualNetworkGatewayPolicyGroups(
        vararg
        argument: suspend VirtualNetworkGatewayPolicyGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkGatewayPolicyGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkGatewayPolicyGroups = mapped
    }

    /**
     * @param argument The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
     */
    @JvmName("ytftigvjwgmugfjc")
    public suspend
    fun virtualNetworkGatewayPolicyGroups(argument: suspend VirtualNetworkGatewayPolicyGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNetworkGatewayPolicyGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.virtualNetworkGatewayPolicyGroups = mapped
    }

    /**
     * @param values The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
     */
    @JvmName("jjubkbhwrmwboqhh")
    public suspend fun virtualNetworkGatewayPolicyGroups(
        vararg
        values: VirtualNetworkGatewayPolicyGroupArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkGatewayPolicyGroups = mapped
    }

    /**
     * @param value The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
     */
    @JvmName("xncgsvmjckibknfp")
    public suspend fun vpnClientConfiguration(`value`: VpnClientConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientConfiguration = mapped
    }

    /**
     * @param argument The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
     */
    @JvmName("pgrrgisidkfvkxit")
    public suspend
    fun vpnClientConfiguration(argument: suspend VpnClientConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VpnClientConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpnClientConfiguration = mapped
    }

    /**
     * @param value The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
     */
    @JvmName("qqffugruibijshju")
    public suspend fun vpnGatewayGeneration(`value`: Either<String, VpnGatewayGeneration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnGatewayGeneration = mapped
    }

    /**
     * @param value The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
     */
    @JvmName("notoielmrvxxrsur")
    public fun vpnGatewayGeneration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VpnGatewayGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnGatewayGeneration = mapped
    }

    /**
     * @param value The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
     */
    @JvmName("tcljixrlpymjoqpm")
    public fun vpnGatewayGeneration(`value`: VpnGatewayGeneration) {
        val toBeMapped = Either.ofRight<String, VpnGatewayGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnGatewayGeneration = mapped
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("wwmethhdtlhpcvtm")
    public suspend fun vpnType(`value`: Either<String, VpnType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnType = mapped
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("pmtnpedlluitysui")
    public fun vpnType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VpnType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnType = mapped
    }

    /**
     * @param value The type of this virtual network gateway.
     */
    @JvmName("mqhgypwykfryjkxp")
    public fun vpnType(`value`: VpnType) {
        val toBeMapped = Either.ofRight<String, VpnType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnType = mapped
    }

    internal fun build(): VirtualNetworkGatewayArgs = VirtualNetworkGatewayArgs(
        activeActive = activeActive,
        adminState = adminState,
        allowRemoteVnetTraffic = allowRemoteVnetTraffic,
        allowVirtualWanTraffic = allowVirtualWanTraffic,
        bgpSettings = bgpSettings,
        customRoutes = customRoutes,
        disableIPSecReplayProtection = disableIPSecReplayProtection,
        enableBgp = enableBgp,
        enableBgpRouteTranslationForNat = enableBgpRouteTranslationForNat,
        enableDnsForwarding = enableDnsForwarding,
        enablePrivateIpAddress = enablePrivateIpAddress,
        extendedLocation = extendedLocation,
        gatewayDefaultSite = gatewayDefaultSite,
        gatewayType = gatewayType,
        id = id,
        ipConfigurations = ipConfigurations,
        location = location,
        natRules = natRules,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        vNetExtendedLocationResourceId = vNetExtendedLocationResourceId,
        virtualNetworkGatewayName = virtualNetworkGatewayName,
        virtualNetworkGatewayPolicyGroups = virtualNetworkGatewayPolicyGroups,
        vpnClientConfiguration = vpnClientConfiguration,
        vpnGatewayGeneration = vpnGatewayGeneration,
        vpnType = vpnType,
    )
}
