@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualNetworkGatewayNatRuleArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VpnNatRuleMode
import com.pulumi.azurenative.network.kotlin.enums.VpnNatRuleType
import com.pulumi.azurenative.network.kotlin.inputs.VpnNatRuleMappingArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnNatRuleMappingArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VirtualNetworkGatewayNatRule Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### VirtualNetworkGatewayNatRulePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkGatewayNatRule = new AzureNative.Network.VirtualNetworkGatewayNatRule("virtualNetworkGatewayNatRule", new()
 *     {
 *         ExternalMappings = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *             {
 *                 AddressSpace = "192.168.21.0/24",
 *                 PortRange = "300-400",
 *             },
 *         },
 *         InternalMappings = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnNatRuleMappingArgs
 *             {
 *                 AddressSpace = "10.4.0.0/24",
 *                 PortRange = "200-300",
 *             },
 *         },
 *         IpConfigurationId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/gateway1/ipConfigurations/default",
 *         Mode = "EgressSnat",
 *         NatRuleName = "natRule1",
 *         ResourceGroupName = "rg1",
 *         Type = "Static",
 *         VirtualNetworkGatewayName = "gateway1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetworkGatewayNatRule(ctx, "virtualNetworkGatewayNatRule", &network.VirtualNetworkGatewayNatRuleArgs{
 * 			ExternalMappings: []network.VpnNatRuleMappingArgs{
 * 				{
 * 					AddressSpace: pulumi.String("192.168.21.0/24"),
 * 					PortRange:    pulumi.String("300-400"),
 * 				},
 * 			},
 * 			InternalMappings: []network.VpnNatRuleMappingArgs{
 * 				{
 * 					AddressSpace: pulumi.String("10.4.0.0/24"),
 * 					PortRange:    pulumi.String("200-300"),
 * 				},
 * 			},
 * 			IpConfigurationId:         pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/gateway1/ipConfigurations/default"),
 * 			Mode:                      pulumi.String("EgressSnat"),
 * 			NatRuleName:               pulumi.String("natRule1"),
 * 			ResourceGroupName:         pulumi.String("rg1"),
 * 			Type:                      pulumi.String("Static"),
 * 			VirtualNetworkGatewayName: pulumi.String("gateway1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetworkGatewayNatRule;
 * import com.pulumi.azurenative.network.VirtualNetworkGatewayNatRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkGatewayNatRule = new VirtualNetworkGatewayNatRule("virtualNetworkGatewayNatRule", VirtualNetworkGatewayNatRuleArgs.builder()
 *             .externalMappings(Map.ofEntries(
 *                 Map.entry("addressSpace", "192.168.21.0/24"),
 *                 Map.entry("portRange", "300-400")
 *             ))
 *             .internalMappings(Map.ofEntries(
 *                 Map.entry("addressSpace", "10.4.0.0/24"),
 *                 Map.entry("portRange", "200-300")
 *             ))
 *             .ipConfigurationId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworkGateways/gateway1/ipConfigurations/default")
 *             .mode("EgressSnat")
 *             .natRuleName("natRule1")
 *             .resourceGroupName("rg1")
 *             .type("Static")
 *             .virtualNetworkGatewayName("gateway1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualNetworkGatewayNatRule natRule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/natRules/{natRuleName}
 * ```
 * @property externalMappings The private IP address external mapping for NAT.
 * @property id Resource ID.
 * @property internalMappings The private IP address internal mapping for NAT.
 * @property ipConfigurationId The IP Configuration ID this NAT rule applies to.
 * @property mode The Source NAT direction of a VPN NAT.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property natRuleName The name of the nat rule.
 * @property resourceGroupName The resource group name of the Virtual Network Gateway.
 * @property type The type of NAT rule for VPN NAT.
 * @property virtualNetworkGatewayName The name of the gateway.
 */
public data class VirtualNetworkGatewayNatRuleArgs(
    public val externalMappings: Output<List<VpnNatRuleMappingArgs>>? = null,
    public val id: Output<String>? = null,
    public val internalMappings: Output<List<VpnNatRuleMappingArgs>>? = null,
    public val ipConfigurationId: Output<String>? = null,
    public val mode: Output<Either<String, VpnNatRuleMode>>? = null,
    public val name: Output<String>? = null,
    public val natRuleName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val type: Output<Either<String, VpnNatRuleType>>? = null,
    public val virtualNetworkGatewayName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualNetworkGatewayNatRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualNetworkGatewayNatRuleArgs =
        com.pulumi.azurenative.network.VirtualNetworkGatewayNatRuleArgs.builder()
            .externalMappings(
                externalMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .internalMappings(
                internalMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ipConfigurationId(ipConfigurationId?.applyValue({ args0 -> args0 }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .natRuleName(natRuleName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .virtualNetworkGatewayName(virtualNetworkGatewayName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkGatewayNatRuleArgs].
 */
@PulumiTagMarker
public class VirtualNetworkGatewayNatRuleArgsBuilder internal constructor() {
    private var externalMappings: Output<List<VpnNatRuleMappingArgs>>? = null

    private var id: Output<String>? = null

    private var internalMappings: Output<List<VpnNatRuleMappingArgs>>? = null

    private var ipConfigurationId: Output<String>? = null

    private var mode: Output<Either<String, VpnNatRuleMode>>? = null

    private var name: Output<String>? = null

    private var natRuleName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var type: Output<Either<String, VpnNatRuleType>>? = null

    private var virtualNetworkGatewayName: Output<String>? = null

    /**
     * @param value The private IP address external mapping for NAT.
     */
    @JvmName("vptjlrisqbnnhsek")
    public suspend fun externalMappings(`value`: Output<List<VpnNatRuleMappingArgs>>) {
        this.externalMappings = value
    }

    @JvmName("cbrplvojyrbkwpqr")
    public suspend fun externalMappings(vararg values: Output<VpnNatRuleMappingArgs>) {
        this.externalMappings = Output.all(values.asList())
    }

    /**
     * @param values The private IP address external mapping for NAT.
     */
    @JvmName("krhvkuvnqvkbdkfy")
    public suspend fun externalMappings(values: List<Output<VpnNatRuleMappingArgs>>) {
        this.externalMappings = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ttgtdjvbkunkfufe")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The private IP address internal mapping for NAT.
     */
    @JvmName("bvhuddvqnsscnxwc")
    public suspend fun internalMappings(`value`: Output<List<VpnNatRuleMappingArgs>>) {
        this.internalMappings = value
    }

    @JvmName("obigcslmbshsnqym")
    public suspend fun internalMappings(vararg values: Output<VpnNatRuleMappingArgs>) {
        this.internalMappings = Output.all(values.asList())
    }

    /**
     * @param values The private IP address internal mapping for NAT.
     */
    @JvmName("nvnhbfhisdqwbrfe")
    public suspend fun internalMappings(values: List<Output<VpnNatRuleMappingArgs>>) {
        this.internalMappings = Output.all(values)
    }

    /**
     * @param value The IP Configuration ID this NAT rule applies to.
     */
    @JvmName("ehhfbspyvtepptqj")
    public suspend fun ipConfigurationId(`value`: Output<String>) {
        this.ipConfigurationId = value
    }

    /**
     * @param value The Source NAT direction of a VPN NAT.
     */
    @JvmName("jsafmxyolgmojgga")
    public suspend fun mode(`value`: Output<Either<String, VpnNatRuleMode>>) {
        this.mode = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("qjpgtijkakcaucth")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the nat rule.
     */
    @JvmName("warkdgsolyphwbdn")
    public suspend fun natRuleName(`value`: Output<String>) {
        this.natRuleName = value
    }

    /**
     * @param value The resource group name of the Virtual Network Gateway.
     */
    @JvmName("jtrmmtdyyvchqvud")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The type of NAT rule for VPN NAT.
     */
    @JvmName("vdatgasucsjtquda")
    public suspend fun type(`value`: Output<Either<String, VpnNatRuleType>>) {
        this.type = value
    }

    /**
     * @param value The name of the gateway.
     */
    @JvmName("nctwjvelsqfrxpkl")
    public suspend fun virtualNetworkGatewayName(`value`: Output<String>) {
        this.virtualNetworkGatewayName = value
    }

    /**
     * @param value The private IP address external mapping for NAT.
     */
    @JvmName("trfusqepqeeqmsrr")
    public suspend fun externalMappings(`value`: List<VpnNatRuleMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalMappings = mapped
    }

    /**
     * @param argument The private IP address external mapping for NAT.
     */
    @JvmName("eswkohrloodtulxh")
    public suspend
    fun externalMappings(argument: List<suspend VpnNatRuleMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnNatRuleMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.externalMappings = mapped
    }

    /**
     * @param argument The private IP address external mapping for NAT.
     */
    @JvmName("dujuvvmovuccrans")
    public suspend fun externalMappings(
        vararg
        argument: suspend VpnNatRuleMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnNatRuleMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.externalMappings = mapped
    }

    /**
     * @param argument The private IP address external mapping for NAT.
     */
    @JvmName("fmkpmowvcbnuyyiy")
    public suspend fun externalMappings(argument: suspend VpnNatRuleMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VpnNatRuleMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.externalMappings = mapped
    }

    /**
     * @param values The private IP address external mapping for NAT.
     */
    @JvmName("ivkkqcpgxnhpdnjx")
    public suspend fun externalMappings(vararg values: VpnNatRuleMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalMappings = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("lfaivhriorcffprk")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The private IP address internal mapping for NAT.
     */
    @JvmName("mfofyalilqfthjlc")
    public suspend fun internalMappings(`value`: List<VpnNatRuleMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internalMappings = mapped
    }

    /**
     * @param argument The private IP address internal mapping for NAT.
     */
    @JvmName("bxyekomrdopfkncr")
    public suspend
    fun internalMappings(argument: List<suspend VpnNatRuleMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnNatRuleMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.internalMappings = mapped
    }

    /**
     * @param argument The private IP address internal mapping for NAT.
     */
    @JvmName("ukkphvsrssyuphab")
    public suspend fun internalMappings(
        vararg
        argument: suspend VpnNatRuleMappingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnNatRuleMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.internalMappings = mapped
    }

    /**
     * @param argument The private IP address internal mapping for NAT.
     */
    @JvmName("lfjbxdodccgwrvoa")
    public suspend fun internalMappings(argument: suspend VpnNatRuleMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VpnNatRuleMappingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.internalMappings = mapped
    }

    /**
     * @param values The private IP address internal mapping for NAT.
     */
    @JvmName("nfgubonpjwjstlik")
    public suspend fun internalMappings(vararg values: VpnNatRuleMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.internalMappings = mapped
    }

    /**
     * @param value The IP Configuration ID this NAT rule applies to.
     */
    @JvmName("rrtwkohpoirhgmao")
    public suspend fun ipConfigurationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurationId = mapped
    }

    /**
     * @param value The Source NAT direction of a VPN NAT.
     */
    @JvmName("ofrkquxmhruxlugf")
    public suspend fun mode(`value`: Either<String, VpnNatRuleMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The Source NAT direction of a VPN NAT.
     */
    @JvmName("khjiexeyehcpgafv")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VpnNatRuleMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The Source NAT direction of a VPN NAT.
     */
    @JvmName("ynojdtqlcyiieytl")
    public fun mode(`value`: VpnNatRuleMode) {
        val toBeMapped = Either.ofRight<String, VpnNatRuleMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("ddiecjttdnhephjp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the nat rule.
     */
    @JvmName("ysgbyevlplsmpnyf")
    public suspend fun natRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natRuleName = mapped
    }

    /**
     * @param value The resource group name of the Virtual Network Gateway.
     */
    @JvmName("colatjodmonxhtuw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The type of NAT rule for VPN NAT.
     */
    @JvmName("hpytyayulhasloex")
    public suspend fun type(`value`: Either<String, VpnNatRuleType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of NAT rule for VPN NAT.
     */
    @JvmName("rhgoxfhonqfsqrps")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VpnNatRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of NAT rule for VPN NAT.
     */
    @JvmName("khriubrnmxlbjmsi")
    public fun type(`value`: VpnNatRuleType) {
        val toBeMapped = Either.ofRight<String, VpnNatRuleType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The name of the gateway.
     */
    @JvmName("xoibdsjktqauompt")
    public suspend fun virtualNetworkGatewayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkGatewayName = mapped
    }

    internal fun build(): VirtualNetworkGatewayNatRuleArgs = VirtualNetworkGatewayNatRuleArgs(
        externalMappings = externalMappings,
        id = id,
        internalMappings = internalMappings,
        ipConfigurationId = ipConfigurationId,
        mode = mode,
        name = name,
        natRuleName = natRuleName,
        resourceGroupName = resourceGroupName,
        type = type,
        virtualNetworkGatewayName = virtualNetworkGatewayName,
    )
}
