@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse
import com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [VirtualNetworkLink].
 */
@PulumiTagMarker
public class VirtualNetworkLinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualNetworkLinkArgs = VirtualNetworkLinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualNetworkLinkArgsBuilder.() -> Unit) {
        val builder = VirtualNetworkLinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualNetworkLink {
        val builtJavaResource =
            com.pulumi.azurenative.network.VirtualNetworkLink(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualNetworkLink(builtJavaResource)
    }
}

/**
 * Describes a link to virtual network for a Private DNS zone.
 * Azure REST API version: 2020-06-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * ## Example Usage
 * ### PUT Private DNS Zone Virtual Network Link
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkLink = new AzureNative.Network.VirtualNetworkLink("virtualNetworkLink", new()
 *     {
 *         Location = "Global",
 *         PrivateZoneName = "privatezone1.com",
 *         RegistrationEnabled = false,
 *         ResourceGroupName = "resourceGroup1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/virtualNetworkSubscriptionId/resourceGroups/virtualNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/virtualNetworkName",
 *         },
 *         VirtualNetworkLinkName = "virtualNetworkLink1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetworkLink(ctx, "virtualNetworkLink", &network.VirtualNetworkLinkArgs{
 * 			Location:            pulumi.String("Global"),
 * 			PrivateZoneName:     pulumi.String("privatezone1.com"),
 * 			RegistrationEnabled: pulumi.Bool(false),
 * 			ResourceGroupName:   pulumi.String("resourceGroup1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualNetwork: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/virtualNetworkSubscriptionId/resourceGroups/virtualNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/virtualNetworkName"),
 * 			},
 * 			VirtualNetworkLinkName: pulumi.String("virtualNetworkLink1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetworkLink;
 * import com.pulumi.azurenative.network.VirtualNetworkLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkLink = new VirtualNetworkLink("virtualNetworkLink", VirtualNetworkLinkArgs.builder()
 *             .location("Global")
 *             .privateZoneName("privatezone1.com")
 *             .registrationEnabled(false)
 *             .resourceGroupName("resourceGroup1")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualNetwork(Map.of("id", "/subscriptions/virtualNetworkSubscriptionId/resourceGroups/virtualNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/virtualNetworkName"))
 *             .virtualNetworkLinkName("virtualNetworkLink1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualNetworkLink virtualNetworkLink1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/virtualNetworkLinks/{virtualNetworkLinkName}
 * ```
 */
public class VirtualNetworkLink internal constructor(
    override val javaResource: com.pulumi.azurenative.network.VirtualNetworkLink,
) : KotlinCustomResource(javaResource, VirtualNetworkLinkMapper) {
    /**
     * The ETag of the virtual network link.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Azure Region where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the resource. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Is auto-registration of virtual machine records in the virtual network in the Private DNS zone enabled?
     */
    public val registrationEnabled: Output<Boolean>?
        get() = javaResource.registrationEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The reference of the virtual network.
     */
    public val virtualNetwork: Output<SubResourceResponse>?
        get() = javaResource.virtualNetwork().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The status of the virtual network link to the Private DNS zone. Possible values are 'InProgress' and 'Done'. This is a read-only property and any attempt to set this value will be ignored.
     */
    public val virtualNetworkLinkState: Output<String>
        get() = javaResource.virtualNetworkLinkState().applyValue({ args0 -> args0 })
}

public object VirtualNetworkLinkMapper : ResourceMapper<VirtualNetworkLink> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.network.VirtualNetworkLink::class == javaResource::class

    override fun map(javaResource: Resource): VirtualNetworkLink = VirtualNetworkLink(
        javaResource as
            com.pulumi.azurenative.network.VirtualNetworkLink,
    )
}

/**
 * @see [VirtualNetworkLink].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualNetworkLink].
 */
public suspend fun virtualNetworkLink(
    name: String,
    block: suspend VirtualNetworkLinkResourceBuilder.() -> Unit,
): VirtualNetworkLink {
    val builder = VirtualNetworkLinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualNetworkLink].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualNetworkLink(name: String): VirtualNetworkLink {
    val builder = VirtualNetworkLinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
