@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualNetworkLinkArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a link to virtual network for a Private DNS zone.
 * Azure REST API version: 2020-06-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * ## Example Usage
 * ### PUT Private DNS Zone Virtual Network Link
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkLink = new AzureNative.Network.VirtualNetworkLink("virtualNetworkLink", new()
 *     {
 *         Location = "Global",
 *         PrivateZoneName = "privatezone1.com",
 *         RegistrationEnabled = false,
 *         ResourceGroupName = "resourceGroup1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VirtualNetwork = new AzureNative.Network.Inputs.SubResourceArgs
 *         {
 *             Id = "/subscriptions/virtualNetworkSubscriptionId/resourceGroups/virtualNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/virtualNetworkName",
 *         },
 *         VirtualNetworkLinkName = "virtualNetworkLink1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetworkLink(ctx, "virtualNetworkLink", &network.VirtualNetworkLinkArgs{
 * 			Location:            pulumi.String("Global"),
 * 			PrivateZoneName:     pulumi.String("privatezone1.com"),
 * 			RegistrationEnabled: pulumi.Bool(false),
 * 			ResourceGroupName:   pulumi.String("resourceGroup1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VirtualNetwork: &network.SubResourceArgs{
 * 				Id: pulumi.String("/subscriptions/virtualNetworkSubscriptionId/resourceGroups/virtualNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/virtualNetworkName"),
 * 			},
 * 			VirtualNetworkLinkName: pulumi.String("virtualNetworkLink1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetworkLink;
 * import com.pulumi.azurenative.network.VirtualNetworkLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkLink = new VirtualNetworkLink("virtualNetworkLink", VirtualNetworkLinkArgs.builder()
 *             .location("Global")
 *             .privateZoneName("privatezone1.com")
 *             .registrationEnabled(false)
 *             .resourceGroupName("resourceGroup1")
 *             .tags(Map.of("key1", "value1"))
 *             .virtualNetwork(Map.of("id", "/subscriptions/virtualNetworkSubscriptionId/resourceGroups/virtualNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/virtualNetworkName"))
 *             .virtualNetworkLinkName("virtualNetworkLink1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualNetworkLink virtualNetworkLink1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/virtualNetworkLinks/{virtualNetworkLinkName}
 * ```
 * @property location The Azure Region where the resource lives
 * @property privateZoneName The name of the Private DNS zone (without a terminating dot).
 * @property registrationEnabled Is auto-registration of virtual machine records in the virtual network in the Private DNS zone enabled?
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 * @property virtualNetwork The reference of the virtual network.
 * @property virtualNetworkLinkName The name of the virtual network link.
 */
public data class VirtualNetworkLinkArgs(
    public val location: Output<String>? = null,
    public val privateZoneName: Output<String>? = null,
    public val registrationEnabled: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualNetwork: Output<SubResourceArgs>? = null,
    public val virtualNetworkLinkName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualNetworkLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualNetworkLinkArgs =
        com.pulumi.azurenative.network.VirtualNetworkLinkArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .privateZoneName(privateZoneName?.applyValue({ args0 -> args0 }))
            .registrationEnabled(registrationEnabled?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualNetwork(virtualNetwork?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .virtualNetworkLinkName(virtualNetworkLinkName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkLinkArgs].
 */
@PulumiTagMarker
public class VirtualNetworkLinkArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var privateZoneName: Output<String>? = null

    private var registrationEnabled: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualNetwork: Output<SubResourceArgs>? = null

    private var virtualNetworkLinkName: Output<String>? = null

    /**
     * @param value The Azure Region where the resource lives
     */
    @JvmName("lsxblpjarfshoqyx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the Private DNS zone (without a terminating dot).
     */
    @JvmName("rlsxsrvlgsbfgcry")
    public suspend fun privateZoneName(`value`: Output<String>) {
        this.privateZoneName = value
    }

    /**
     * @param value Is auto-registration of virtual machine records in the virtual network in the Private DNS zone enabled?
     */
    @JvmName("vwdgjabdckbwuhtk")
    public suspend fun registrationEnabled(`value`: Output<Boolean>) {
        this.registrationEnabled = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xqrlmcbyltclfkii")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ikwblgoeiwqlrokr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The reference of the virtual network.
     */
    @JvmName("qtbrusyrjcsylqtu")
    public suspend fun virtualNetwork(`value`: Output<SubResourceArgs>) {
        this.virtualNetwork = value
    }

    /**
     * @param value The name of the virtual network link.
     */
    @JvmName("shmsckfjkugunbrr")
    public suspend fun virtualNetworkLinkName(`value`: Output<String>) {
        this.virtualNetworkLinkName = value
    }

    /**
     * @param value The Azure Region where the resource lives
     */
    @JvmName("fmdbnnbcguxxysqu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the Private DNS zone (without a terminating dot).
     */
    @JvmName("jtmwleqocmxfnogi")
    public suspend fun privateZoneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateZoneName = mapped
    }

    /**
     * @param value Is auto-registration of virtual machine records in the virtual network in the Private DNS zone enabled?
     */
    @JvmName("vlofxoxciwvhsemf")
    public suspend fun registrationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationEnabled = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vsyrbsoeslhibbjl")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kdeuegvjvjrfbnqk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ccukudgfdfivdlvr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The reference of the virtual network.
     */
    @JvmName("apqajsdiggkdnkdb")
    public suspend fun virtualNetwork(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetwork = mapped
    }

    /**
     * @param argument The reference of the virtual network.
     */
    @JvmName("axbjfwmthgvngpms")
    public suspend fun virtualNetwork(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.virtualNetwork = mapped
    }

    /**
     * @param value The name of the virtual network link.
     */
    @JvmName("iigpfnepbkpquwqt")
    public suspend fun virtualNetworkLinkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkLinkName = mapped
    }

    internal fun build(): VirtualNetworkLinkArgs = VirtualNetworkLinkArgs(
        location = location,
        privateZoneName = privateZoneName,
        registrationEnabled = registrationEnabled,
        resourceGroupName = resourceGroupName,
        tags = tags,
        virtualNetwork = virtualNetwork,
        virtualNetworkLinkName = virtualNetworkLinkName,
    )
}
