@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualNetworkTapArgs.builder
import com.pulumi.azurenative.network.kotlin.inputs.FrontendIPConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.FrontendIPConfigurationArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.NetworkInterfaceIPConfigurationArgs
import com.pulumi.azurenative.network.kotlin.inputs.NetworkInterfaceIPConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Virtual Network Tap resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### Create Virtual Network Tap
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkTap = new AzureNative.Network.VirtualNetworkTap("virtualNetworkTap", new()
 *     {
 *         DestinationNetworkInterfaceIPConfiguration = new AzureNative.Network.Inputs.NetworkInterfaceIPConfigurationArgs
 *         {
 *             Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkInterfaces/testNetworkInterface/ipConfigurations/ipconfig1",
 *         },
 *         Location = "centraluseuap",
 *         ResourceGroupName = "rg1",
 *         TapName = "test-vtap",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualNetworkTap(ctx, "virtualNetworkTap", &network.VirtualNetworkTapArgs{
 * 			DestinationNetworkInterfaceIPConfiguration: &network.NetworkInterfaceIPConfigurationArgs{
 * 				Id: pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkInterfaces/testNetworkInterface/ipConfigurations/ipconfig1"),
 * 			},
 * 			Location:          pulumi.String("centraluseuap"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			TapName:           pulumi.String("test-vtap"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualNetworkTap;
 * import com.pulumi.azurenative.network.VirtualNetworkTapArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkTap = new VirtualNetworkTap("virtualNetworkTap", VirtualNetworkTapArgs.builder()
 *             .destinationNetworkInterfaceIPConfiguration(Map.of("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/networkInterfaces/testNetworkInterface/ipConfigurations/ipconfig1"))
 *             .location("centraluseuap")
 *             .resourceGroupName("rg1")
 *             .tapName("test-vtap")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualNetworkTap testvtap /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkTaps/{tapName}
 * ```
 * @property destinationLoadBalancerFrontEndIPConfiguration The reference to the private IP address on the internal Load Balancer that will receive the tap.
 * @property destinationNetworkInterfaceIPConfiguration The reference to the private IP Address of the collector nic that will receive the tap.
 * @property destinationPort The VXLAN destination port that will receive the tapped traffic.
 * @property id Resource ID.
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 * @property tapName The name of the virtual network tap.
 */
public data class VirtualNetworkTapArgs(
    public val destinationLoadBalancerFrontEndIPConfiguration: Output<FrontendIPConfigurationArgs>? =
        null,
    public val destinationNetworkInterfaceIPConfiguration:
    Output<NetworkInterfaceIPConfigurationArgs>? = null,
    public val destinationPort: Output<Int>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tapName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualNetworkTapArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualNetworkTapArgs =
        com.pulumi.azurenative.network.VirtualNetworkTapArgs.builder()
            .destinationLoadBalancerFrontEndIPConfiguration(
                destinationLoadBalancerFrontEndIPConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .destinationNetworkInterfaceIPConfiguration(
                destinationNetworkInterfaceIPConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .destinationPort(destinationPort?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tapName(tapName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkTapArgs].
 */
@PulumiTagMarker
public class VirtualNetworkTapArgsBuilder internal constructor() {
    private var destinationLoadBalancerFrontEndIPConfiguration: Output<FrontendIPConfigurationArgs>? =
        null

    private var destinationNetworkInterfaceIPConfiguration:
        Output<NetworkInterfaceIPConfigurationArgs>? = null

    private var destinationPort: Output<Int>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tapName: Output<String>? = null

    /**
     * @param value The reference to the private IP address on the internal Load Balancer that will receive the tap.
     */
    @JvmName("gltmhchyhydctdav")
    public suspend
    fun destinationLoadBalancerFrontEndIPConfiguration(`value`: Output<FrontendIPConfigurationArgs>) {
        this.destinationLoadBalancerFrontEndIPConfiguration = value
    }

    /**
     * @param value The reference to the private IP Address of the collector nic that will receive the tap.
     */
    @JvmName("butnqqfiscuefeqg")
    public suspend
    fun destinationNetworkInterfaceIPConfiguration(`value`: Output<NetworkInterfaceIPConfigurationArgs>) {
        this.destinationNetworkInterfaceIPConfiguration = value
    }

    /**
     * @param value The VXLAN destination port that will receive the tapped traffic.
     */
    @JvmName("bgpiugmnwvlldcyh")
    public suspend fun destinationPort(`value`: Output<Int>) {
        this.destinationPort = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("vgsfimiyskthwhpy")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("yykgnxpgavobbuch")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hgjabalhrfsnkpsg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qhgxuwoyevnlgmfw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the virtual network tap.
     */
    @JvmName("brccrbdwwdjbxetn")
    public suspend fun tapName(`value`: Output<String>) {
        this.tapName = value
    }

    /**
     * @param value The reference to the private IP address on the internal Load Balancer that will receive the tap.
     */
    @JvmName("nugxubxfjdscfxtu")
    public suspend
    fun destinationLoadBalancerFrontEndIPConfiguration(`value`: FrontendIPConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationLoadBalancerFrontEndIPConfiguration = mapped
    }

    /**
     * @param argument The reference to the private IP address on the internal Load Balancer that will receive the tap.
     */
    @JvmName("crgoxwjylxlvvddj")
    public suspend
    fun destinationLoadBalancerFrontEndIPConfiguration(argument: suspend FrontendIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = FrontendIPConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destinationLoadBalancerFrontEndIPConfiguration = mapped
    }

    /**
     * @param value The reference to the private IP Address of the collector nic that will receive the tap.
     */
    @JvmName("athmaeycaaryiujl")
    public suspend
    fun destinationNetworkInterfaceIPConfiguration(`value`: NetworkInterfaceIPConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationNetworkInterfaceIPConfiguration = mapped
    }

    /**
     * @param argument The reference to the private IP Address of the collector nic that will receive the tap.
     */
    @JvmName("rwowxplxndvtetwc")
    public suspend
    fun destinationNetworkInterfaceIPConfiguration(argument: suspend NetworkInterfaceIPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkInterfaceIPConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destinationNetworkInterfaceIPConfiguration = mapped
    }

    /**
     * @param value The VXLAN destination port that will receive the tapped traffic.
     */
    @JvmName("kfpkuidcaiooqxxj")
    public suspend fun destinationPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationPort = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("aidhpnywpshiktfe")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("krpqkpjnribkeldt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jkmhcjdyfulwpfjn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("aglrflmriwsaqqlg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tudspuncbwanebmb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the virtual network tap.
     */
    @JvmName("ikbdvipvjxrcsxgb")
    public suspend fun tapName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tapName = mapped
    }

    internal fun build(): VirtualNetworkTapArgs = VirtualNetworkTapArgs(
        destinationLoadBalancerFrontEndIPConfiguration = destinationLoadBalancerFrontEndIPConfiguration,
        destinationNetworkInterfaceIPConfiguration = destinationNetworkInterfaceIPConfiguration,
        destinationPort = destinationPort,
        id = id,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        tapName = tapName,
    )
}
