@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VirtualWanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * VirtualWAN Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2019-07-01, 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### VirtualWANCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualWan = new AzureNative.Network.VirtualWan("virtualWan", new()
 *     {
 *         DisableVpnEncryption = false,
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         Type = "Basic",
 *         VirtualWANName = "wan1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVirtualWan(ctx, "virtualWan", &network.VirtualWanArgs{
 * 			DisableVpnEncryption: pulumi.Bool(false),
 * 			Location:             pulumi.String("West US"),
 * 			ResourceGroupName:    pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			Type:           pulumi.String("Basic"),
 * 			VirtualWANName: pulumi.String("wan1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VirtualWan;
 * import com.pulumi.azurenative.network.VirtualWanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualWan = new VirtualWan("virtualWan", VirtualWanArgs.builder()
 *             .disableVpnEncryption(false)
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .type("Basic")
 *             .virtualWANName("wan1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VirtualWan wan1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{VirtualWANName}
 * ```
 * @property allowBranchToBranchTraffic True if branch to branch traffic is allowed.
 * @property allowVnetToVnetTraffic True if Vnet to Vnet traffic is allowed.
 * @property disableVpnEncryption Vpn encryption to be disabled or not.
 * @property id Resource ID.
 * @property location Resource location.
 * @property resourceGroupName The resource group name of the VirtualWan.
 * @property tags Resource tags.
 * @property type The type of the VirtualWAN.
 * @property virtualWANName The name of the VirtualWAN being created or updated.
 */
public data class VirtualWanArgs(
    public val allowBranchToBranchTraffic: Output<Boolean>? = null,
    public val allowVnetToVnetTraffic: Output<Boolean>? = null,
    public val disableVpnEncryption: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val virtualWANName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VirtualWanArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VirtualWanArgs =
        com.pulumi.azurenative.network.VirtualWanArgs.builder()
            .allowBranchToBranchTraffic(allowBranchToBranchTraffic?.applyValue({ args0 -> args0 }))
            .allowVnetToVnetTraffic(allowVnetToVnetTraffic?.applyValue({ args0 -> args0 }))
            .disableVpnEncryption(disableVpnEncryption?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .virtualWANName(virtualWANName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualWanArgs].
 */
@PulumiTagMarker
public class VirtualWanArgsBuilder internal constructor() {
    private var allowBranchToBranchTraffic: Output<Boolean>? = null

    private var allowVnetToVnetTraffic: Output<Boolean>? = null

    private var disableVpnEncryption: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var virtualWANName: Output<String>? = null

    /**
     * @param value True if branch to branch traffic is allowed.
     */
    @JvmName("ubobvktfldrxdrvh")
    public suspend fun allowBranchToBranchTraffic(`value`: Output<Boolean>) {
        this.allowBranchToBranchTraffic = value
    }

    /**
     * @param value True if Vnet to Vnet traffic is allowed.
     */
    @JvmName("jfwdmkkoxglmqddx")
    public suspend fun allowVnetToVnetTraffic(`value`: Output<Boolean>) {
        this.allowVnetToVnetTraffic = value
    }

    /**
     * @param value Vpn encryption to be disabled or not.
     */
    @JvmName("iytpmtgcifgngptg")
    public suspend fun disableVpnEncryption(`value`: Output<Boolean>) {
        this.disableVpnEncryption = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("atqtlujqpokhsldd")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("latphrmfcppcpwbw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource group name of the VirtualWan.
     */
    @JvmName("soxohsdqgrmegwfm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lswlighjaooberqd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of the VirtualWAN.
     */
    @JvmName("xddhvfdwajqrykwi")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the VirtualWAN being created or updated.
     */
    @JvmName("nqoqpkhwvfhhlsqm")
    public suspend fun virtualWANName(`value`: Output<String>) {
        this.virtualWANName = value
    }

    /**
     * @param value True if branch to branch traffic is allowed.
     */
    @JvmName("stdxqwfjyrftnows")
    public suspend fun allowBranchToBranchTraffic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowBranchToBranchTraffic = mapped
    }

    /**
     * @param value True if Vnet to Vnet traffic is allowed.
     */
    @JvmName("yyvnmhbfauqqdypr")
    public suspend fun allowVnetToVnetTraffic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowVnetToVnetTraffic = mapped
    }

    /**
     * @param value Vpn encryption to be disabled or not.
     */
    @JvmName("cqykfkbrqvugxage")
    public suspend fun disableVpnEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableVpnEncryption = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("rdfpygfcehbrmawo")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("drhgdnaxjylpnjam")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource group name of the VirtualWan.
     */
    @JvmName("newgajmolkxjucqv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gnkbycioiasvspxw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("oercbdcjpclnihvy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of the VirtualWAN.
     */
    @JvmName("sedduiuuwedwkmgt")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The name of the VirtualWAN being created or updated.
     */
    @JvmName("acxoytnglygdoxvw")
    public suspend fun virtualWANName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualWANName = mapped
    }

    internal fun build(): VirtualWanArgs = VirtualWanArgs(
        allowBranchToBranchTraffic = allowBranchToBranchTraffic,
        allowVnetToVnetTraffic = allowVnetToVnetTraffic,
        disableVpnEncryption = disableVpnEncryption,
        id = id,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        type = type,
        virtualWANName = virtualWANName,
    )
}
