@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.VpnServerConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.VpnAuthenticationType
import com.pulumi.azurenative.network.kotlin.enums.VpnGatewayTunnelingProtocol
import com.pulumi.azurenative.network.kotlin.inputs.AadAuthenticationParametersArgs
import com.pulumi.azurenative.network.kotlin.inputs.AadAuthenticationParametersArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.IpsecPolicyArgs
import com.pulumi.azurenative.network.kotlin.inputs.IpsecPolicyArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.RadiusServerArgs
import com.pulumi.azurenative.network.kotlin.inputs.RadiusServerArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigRadiusClientRootCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigRadiusClientRootCertificateArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigRadiusServerRootCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigRadiusServerRootCertificateArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigVpnClientRevokedCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigVpnClientRevokedCertificateArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigVpnClientRootCertificateArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigVpnClientRootCertificateArgsBuilder
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigurationPolicyGroupArgs
import com.pulumi.azurenative.network.kotlin.inputs.VpnServerConfigurationPolicyGroupArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * VpnServerConfiguration Resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2020-11-01.
 * Other available API versions: 2023-04-01, 2023-05-01, 2023-06-01, 2023-09-01.
 * ## Example Usage
 * ### VpnServerConfigurationCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpnServerConfiguration = new AzureNative.Network.VpnServerConfiguration("vpnServerConfiguration", new()
 *     {
 *         ConfigurationPolicyGroups = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1",
 *                 IsDefault = true,
 *                 Name = "policyGroup1",
 *                 PolicyMembers = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupMemberArgs
 *                     {
 *                         AttributeType = "RadiusAzureGroupId",
 *                         AttributeValue = "6ad1bd08",
 *                         Name = "policy1",
 *                     },
 *                 },
 *                 Priority = 0,
 *             },
 *             new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupArgs
 *             {
 *                 Id = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2",
 *                 IsDefault = true,
 *                 Name = "policyGroup2",
 *                 PolicyMembers = new[]
 *                 {
 *                     new AzureNative.Network.Inputs.VpnServerConfigurationPolicyGroupMemberArgs
 *                     {
 *                         AttributeType = "CertificateGroupId",
 *                         AttributeValue = "red.com",
 *                         Name = "policy2",
 *                     },
 *                 },
 *                 Priority = 0,
 *             },
 *         },
 *         Location = "West US",
 *         RadiusClientRootCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigRadiusClientRootCertificateArgs
 *             {
 *                 Name = "vpnServerConfigRadiusClientRootCert1",
 *                 Thumbprint = "83FFBFC8848B5A5836C94D0112367E16148A286F",
 *             },
 *         },
 *         RadiusServerRootCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigRadiusServerRootCertificateArgs
 *             {
 *                 Name = "vpnServerConfigRadiusServerRootCer1",
 *                 PublicCertData = "MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM",
 *             },
 *         },
 *         RadiusServers = new[]
 *         {
 *             new AzureNative.Network.Inputs.RadiusServerArgs
 *             {
 *                 RadiusServerAddress = "10.0.0.0",
 *                 RadiusServerScore = 25,
 *                 RadiusServerSecret = "radiusServerSecret",
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         VpnClientIpsecPolicies = new[]
 *         {
 *             new AzureNative.Network.Inputs.IpsecPolicyArgs
 *             {
 *                 DhGroup = "DHGroup14",
 *                 IkeEncryption = "AES256",
 *                 IkeIntegrity = "SHA384",
 *                 IpsecEncryption = "AES256",
 *                 IpsecIntegrity = "SHA256",
 *                 PfsGroup = "PFS14",
 *                 SaDataSizeKilobytes = 429497,
 *                 SaLifeTimeSeconds = 86472,
 *             },
 *         },
 *         VpnClientRevokedCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigVpnClientRevokedCertificateArgs
 *             {
 *                 Name = "vpnServerConfigVpnClientRevokedCert1",
 *                 Thumbprint = "83FFBFC8848B5A5836C94D0112367E16148A286F",
 *             },
 *         },
 *         VpnClientRootCertificates = new[]
 *         {
 *             new AzureNative.Network.Inputs.VpnServerConfigVpnClientRootCertificateArgs
 *             {
 *                 Name = "vpnServerConfigVpnClientRootCert1",
 *                 PublicCertData = "MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN",
 *             },
 *         },
 *         VpnProtocols = new[]
 *         {
 *             "IkeV2",
 *         },
 *         VpnServerConfigurationName = "vpnServerConfiguration1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewVpnServerConfiguration(ctx, "vpnServerConfiguration", &network.VpnServerConfigurationArgs{
 * 			ConfigurationPolicyGroups: []network.VpnServerConfigurationPolicyGroupArgs{
 * 				{
 * 					Id:        pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1"),
 * 					IsDefault: pulumi.Bool(true),
 * 					Name:      pulumi.String("policyGroup1"),
 * 					PolicyMembers: network.VpnServerConfigurationPolicyGroupMemberArray{
 * 						{
 * 							AttributeType:  pulumi.String("RadiusAzureGroupId"),
 * 							AttributeValue: pulumi.String("6ad1bd08"),
 * 							Name:           pulumi.String("policy1"),
 * 						},
 * 					},
 * 					Priority: pulumi.Int(0),
 * 				},
 * 				{
 * 					Id:        pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2"),
 * 					IsDefault: pulumi.Bool(true),
 * 					Name:      pulumi.String("policyGroup2"),
 * 					PolicyMembers: network.VpnServerConfigurationPolicyGroupMemberArray{
 * 						{
 * 							AttributeType:  pulumi.String("CertificateGroupId"),
 * 							AttributeValue: pulumi.String("red.com"),
 * 							Name:           pulumi.String("policy2"),
 * 						},
 * 					},
 * 					Priority: pulumi.Int(0),
 * 				},
 * 			},
 * 			Location: pulumi.String("West US"),
 * 			RadiusClientRootCertificates: []network.VpnServerConfigRadiusClientRootCertificateArgs{
 * 				{
 * 					Name:       pulumi.String("vpnServerConfigRadiusClientRootCert1"),
 * 					Thumbprint: pulumi.String("83FFBFC8848B5A5836C94D0112367E16148A286F"),
 * 				},
 * 			},
 * 			RadiusServerRootCertificates: []network.VpnServerConfigRadiusServerRootCertificateArgs{
 * 				{
 * 					Name:           pulumi.String("vpnServerConfigRadiusServerRootCer1"),
 * 					PublicCertData: pulumi.String("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM"),
 * 				},
 * 			},
 * 			RadiusServers: []network.RadiusServerArgs{
 * 				{
 * 					RadiusServerAddress: pulumi.String("10.0.0.0"),
 * 					RadiusServerScore:   pulumi.Float64(25),
 * 					RadiusServerSecret:  pulumi.String("radiusServerSecret"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			VpnClientIpsecPolicies: []network.IpsecPolicyArgs{
 * 				{
 * 					DhGroup:             pulumi.String("DHGroup14"),
 * 					IkeEncryption:       pulumi.String("AES256"),
 * 					IkeIntegrity:        pulumi.String("SHA384"),
 * 					IpsecEncryption:     pulumi.String("AES256"),
 * 					IpsecIntegrity:      pulumi.String("SHA256"),
 * 					PfsGroup:            pulumi.String("PFS14"),
 * 					SaDataSizeKilobytes: pulumi.Int(429497),
 * 					SaLifeTimeSeconds:   pulumi.Int(86472),
 * 				},
 * 			},
 * 			VpnClientRevokedCertificates: []network.VpnServerConfigVpnClientRevokedCertificateArgs{
 * 				{
 * 					Name:       pulumi.String("vpnServerConfigVpnClientRevokedCert1"),
 * 					Thumbprint: pulumi.String("83FFBFC8848B5A5836C94D0112367E16148A286F"),
 * 				},
 * 			},
 * 			VpnClientRootCertificates: []network.VpnServerConfigVpnClientRootCertificateArgs{
 * 				{
 * 					Name:           pulumi.String("vpnServerConfigVpnClientRootCert1"),
 * 					PublicCertData: pulumi.String("MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN"),
 * 				},
 * 			},
 * 			VpnProtocols: pulumi.StringArray{
 * 				pulumi.String("IkeV2"),
 * 			},
 * 			VpnServerConfigurationName: pulumi.String("vpnServerConfiguration1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.VpnServerConfiguration;
 * import com.pulumi.azurenative.network.VpnServerConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpnServerConfiguration = new VpnServerConfiguration("vpnServerConfiguration", VpnServerConfigurationArgs.builder()
 *             .configurationPolicyGroups(
 *                 Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup1"),
 *                     Map.entry("isDefault", true),
 *                     Map.entry("name", "policyGroup1"),
 *                     Map.entry("policyMembers", Map.ofEntries(
 *                         Map.entry("attributeType", "RadiusAzureGroupId"),
 *                         Map.entry("attributeValue", "6ad1bd08"),
 *                         Map.entry("name", "policy1")
 *                     )),
 *                     Map.entry("priority", 0)
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/vpnServerConfigurations/vpnServerConfiguration1/vpnServerConfigurationPolicyGroups/policyGroup2"),
 *                     Map.entry("isDefault", true),
 *                     Map.entry("name", "policyGroup2"),
 *                     Map.entry("policyMembers", Map.ofEntries(
 *                         Map.entry("attributeType", "CertificateGroupId"),
 *                         Map.entry("attributeValue", "red.com"),
 *                         Map.entry("name", "policy2")
 *                     )),
 *                     Map.entry("priority", 0)
 *                 ))
 *             .location("West US")
 *             .radiusClientRootCertificates(Map.ofEntries(
 *                 Map.entry("name", "vpnServerConfigRadiusClientRootCert1"),
 *                 Map.entry("thumbprint", "83FFBFC8848B5A5836C94D0112367E16148A286F")
 *             ))
 *             .radiusServerRootCertificates(Map.ofEntries(
 *                 Map.entry("name", "vpnServerConfigRadiusServerRootCer1"),
 *                 Map.entry("publicCertData", "MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuM")
 *             ))
 *             .radiusServers(Map.ofEntries(
 *                 Map.entry("radiusServerAddress", "10.0.0.0"),
 *                 Map.entry("radiusServerScore", 25),
 *                 Map.entry("radiusServerSecret", "radiusServerSecret")
 *             ))
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .vpnClientIpsecPolicies(Map.ofEntries(
 *                 Map.entry("dhGroup", "DHGroup14"),
 *                 Map.entry("ikeEncryption", "AES256"),
 *                 Map.entry("ikeIntegrity", "SHA384"),
 *                 Map.entry("ipsecEncryption", "AES256"),
 *                 Map.entry("ipsecIntegrity", "SHA256"),
 *                 Map.entry("pfsGroup", "PFS14"),
 *                 Map.entry("saDataSizeKilobytes", 429497),
 *                 Map.entry("saLifeTimeSeconds", 86472)
 *             ))
 *             .vpnClientRevokedCertificates(Map.ofEntries(
 *                 Map.entry("name", "vpnServerConfigVpnClientRevokedCert1"),
 *                 Map.entry("thumbprint", "83FFBFC8848B5A5836C94D0112367E16148A286F")
 *             ))
 *             .vpnClientRootCertificates(Map.ofEntries(
 *                 Map.entry("name", "vpnServerConfigVpnClientRootCert1"),
 *                 Map.entry("publicCertData", "MIIC5zCCAc+gAwIBAgIQErQ0Hk4aDJxIA+Q5RagB+jANBgkqhkiG9w0BAQsFADAWMRQwEgYDVQQDDAtQMlNSb290Q2VydDAeFw0xNzEyMTQyMTA3MzhaFw0xODEyMTQyMTI3MzhaMBYxFDASBgNVBAMMC1AyU1Jvb3RDZXJ0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArP7/NQXmW7cQ/ZR1mv3Y3I29Lt7HTOqzo/1KUOoVH3NItbQIRAQbwKy3UWrOFz4eGNX2GWtNRMdCyWsKeqy9Ltsdfcm1IbKXkl84DFeU/ZacXu4Dl3xX3gV5du4TLZjEowJELyur11Ea2YcjPRQ/FzAF9/hGuboS1HZQEPLx4FdUs9OxCYOtc0MxBCwLfVTTRqarb0Ne+arNYd4kCzIhAke1nOyKAJBda5ZL+VHy3S5S8qGlD46jm8HXugmAkUygS4oIIXOmj/1O9sNAi3LN60zufSzCmP8Rm/iUGX+DHAGGiXxwZOKQLEDaZXKqoHjMPP0XudmSWwOIbyeQVrLhkwIDAQABozEwLzAOBgNVHQ8BAf8EBAMCAgQwHQYDVR0OBBYEFEfeNU2trYxNLF9ONmuJUsT13pKDMA0GCSqGSIb3DQEBCwUAA4IBAQBmM6RJzsGGipxyMhimHKN2xlkejhVsgBoTAhOU0llW9aUSwINJ9zFUGgI8IzUFy1VG776fchHp0LMRmPSIUYk5btEPxbsrPtumPuMH8EQGrS+Rt4pD+78c8H1fEPkq5CmDl/PKu4JoFGv+aFcE+Od0hlILstIF10Qysf++QXDolKfzJa/56bgMeYKFiju73loiRM57ns8ddXpfLl792UVpRkFU62LNns6Y1LKTwapmUF4IvIuAIzd6LZNOQng64LAKXtKnViJ1JQiXwf4CEzhgvAti3/ejpb3U90hsrUcyZi6wBv9bZLcAJRWpz61JNYliM1d1grSwQDKGXNQE4xuN")
 *             ))
 *             .vpnProtocols("IkeV2")
 *             .vpnServerConfigurationName("vpnServerConfiguration1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:VpnServerConfiguration vpnServerConfiguration1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}
 * ```
 * @property aadAuthenticationParameters The set of aad vpn authentication parameters.
 * @property configurationPolicyGroups List of all VpnServerConfigurationPolicyGroups.
 * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name The name of the VpnServerConfiguration that is unique within a resource group.
 * @property radiusClientRootCertificates Radius client root certificate of VpnServerConfiguration.
 * @property radiusServerAddress The radius server address property of the VpnServerConfiguration resource for point to site client connection.
 * @property radiusServerRootCertificates Radius Server root certificate of VpnServerConfiguration.
 * @property radiusServerSecret The radius secret property of the VpnServerConfiguration resource for point to site client connection.
 * @property radiusServers Multiple Radius Server configuration for VpnServerConfiguration.
 * @property resourceGroupName The resource group name of the VpnServerConfiguration.
 * @property tags Resource tags.
 * @property vpnAuthenticationTypes VPN authentication types for the VpnServerConfiguration.
 * @property vpnClientIpsecPolicies VpnClientIpsecPolicies for VpnServerConfiguration.
 * @property vpnClientRevokedCertificates VPN client revoked certificate of VpnServerConfiguration.
 * @property vpnClientRootCertificates VPN client root certificate of VpnServerConfiguration.
 * @property vpnProtocols VPN protocols for the VpnServerConfiguration.
 * @property vpnServerConfigurationName The name of the VpnServerConfiguration being created or updated.
 */
public data class VpnServerConfigurationArgs(
    public val aadAuthenticationParameters: Output<AadAuthenticationParametersArgs>? = null,
    public val configurationPolicyGroups: Output<List<VpnServerConfigurationPolicyGroupArgs>>? = null,
    public val id: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val radiusClientRootCertificates:
    Output<List<VpnServerConfigRadiusClientRootCertificateArgs>>? = null,
    public val radiusServerAddress: Output<String>? = null,
    public val radiusServerRootCertificates:
    Output<List<VpnServerConfigRadiusServerRootCertificateArgs>>? = null,
    public val radiusServerSecret: Output<String>? = null,
    public val radiusServers: Output<List<RadiusServerArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpnAuthenticationTypes: Output<List<Either<String, VpnAuthenticationType>>>? = null,
    public val vpnClientIpsecPolicies: Output<List<IpsecPolicyArgs>>? = null,
    public val vpnClientRevokedCertificates:
    Output<List<VpnServerConfigVpnClientRevokedCertificateArgs>>? = null,
    public val vpnClientRootCertificates: Output<List<VpnServerConfigVpnClientRootCertificateArgs>>? =
        null,
    public val vpnProtocols: Output<List<Either<String, VpnGatewayTunnelingProtocol>>>? = null,
    public val vpnServerConfigurationName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.VpnServerConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.VpnServerConfigurationArgs =
        com.pulumi.azurenative.network.VpnServerConfigurationArgs.builder()
            .aadAuthenticationParameters(
                aadAuthenticationParameters?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .configurationPolicyGroups(
                configurationPolicyGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .radiusClientRootCertificates(
                radiusClientRootCertificates?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .radiusServerAddress(radiusServerAddress?.applyValue({ args0 -> args0 }))
            .radiusServerRootCertificates(
                radiusServerRootCertificates?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .radiusServerSecret(radiusServerSecret?.applyValue({ args0 -> args0 }))
            .radiusServers(
                radiusServers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpnAuthenticationTypes(
                vpnAuthenticationTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .vpnClientIpsecPolicies(
                vpnClientIpsecPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vpnClientRevokedCertificates(
                vpnClientRevokedCertificates?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .vpnClientRootCertificates(
                vpnClientRootCertificates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vpnProtocols(
                vpnProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .vpnServerConfigurationName(vpnServerConfigurationName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpnServerConfigurationArgs].
 */
@PulumiTagMarker
public class VpnServerConfigurationArgsBuilder internal constructor() {
    private var aadAuthenticationParameters: Output<AadAuthenticationParametersArgs>? = null

    private var configurationPolicyGroups: Output<List<VpnServerConfigurationPolicyGroupArgs>>? = null

    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var radiusClientRootCertificates:
        Output<List<VpnServerConfigRadiusClientRootCertificateArgs>>? = null

    private var radiusServerAddress: Output<String>? = null

    private var radiusServerRootCertificates:
        Output<List<VpnServerConfigRadiusServerRootCertificateArgs>>? = null

    private var radiusServerSecret: Output<String>? = null

    private var radiusServers: Output<List<RadiusServerArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpnAuthenticationTypes: Output<List<Either<String, VpnAuthenticationType>>>? = null

    private var vpnClientIpsecPolicies: Output<List<IpsecPolicyArgs>>? = null

    private var vpnClientRevokedCertificates:
        Output<List<VpnServerConfigVpnClientRevokedCertificateArgs>>? = null

    private var vpnClientRootCertificates: Output<List<VpnServerConfigVpnClientRootCertificateArgs>>? =
        null

    private var vpnProtocols: Output<List<Either<String, VpnGatewayTunnelingProtocol>>>? = null

    private var vpnServerConfigurationName: Output<String>? = null

    /**
     * @param value The set of aad vpn authentication parameters.
     */
    @JvmName("mhaccowkbdwujuos")
    public suspend fun aadAuthenticationParameters(`value`: Output<AadAuthenticationParametersArgs>) {
        this.aadAuthenticationParameters = value
    }

    /**
     * @param value List of all VpnServerConfigurationPolicyGroups.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("rkaknkgjmhuxddbl")
    public suspend
    fun configurationPolicyGroups(`value`: Output<List<VpnServerConfigurationPolicyGroupArgs>>) {
        this.configurationPolicyGroups = value
    }

    @JvmName("qudhvercrljcyvfp")
    public suspend fun configurationPolicyGroups(
        vararg
        values: Output<VpnServerConfigurationPolicyGroupArgs>,
    ) {
        this.configurationPolicyGroups = Output.all(values.asList())
    }

    /**
     * @param values List of all VpnServerConfigurationPolicyGroups.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("hvrknirlgpfxwplm")
    public suspend
    fun configurationPolicyGroups(values: List<Output<VpnServerConfigurationPolicyGroupArgs>>) {
        this.configurationPolicyGroups = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("tiishlytjqnqqbyi")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("qjqrpxgvmrhdmliy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the VpnServerConfiguration that is unique within a resource group.
     */
    @JvmName("oidojealiubqwatw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Radius client root certificate of VpnServerConfiguration.
     */
    @JvmName("mrstveoucsyyldkd")
    public suspend
    fun radiusClientRootCertificates(`value`: Output<List<VpnServerConfigRadiusClientRootCertificateArgs>>) {
        this.radiusClientRootCertificates = value
    }

    @JvmName("yjuohgoedyslpwto")
    public suspend fun radiusClientRootCertificates(
        vararg
        values: Output<VpnServerConfigRadiusClientRootCertificateArgs>,
    ) {
        this.radiusClientRootCertificates = Output.all(values.asList())
    }

    /**
     * @param values Radius client root certificate of VpnServerConfiguration.
     */
    @JvmName("epvfhbmtjvcdddaj")
    public suspend
    fun radiusClientRootCertificates(values: List<Output<VpnServerConfigRadiusClientRootCertificateArgs>>) {
        this.radiusClientRootCertificates = Output.all(values)
    }

    /**
     * @param value The radius server address property of the VpnServerConfiguration resource for point to site client connection.
     */
    @JvmName("fuxlwdujchxiwivg")
    public suspend fun radiusServerAddress(`value`: Output<String>) {
        this.radiusServerAddress = value
    }

    /**
     * @param value Radius Server root certificate of VpnServerConfiguration.
     */
    @JvmName("kbtktokrwhsgfrbs")
    public suspend
    fun radiusServerRootCertificates(`value`: Output<List<VpnServerConfigRadiusServerRootCertificateArgs>>) {
        this.radiusServerRootCertificates = value
    }

    @JvmName("qhbardtxnweddbru")
    public suspend fun radiusServerRootCertificates(
        vararg
        values: Output<VpnServerConfigRadiusServerRootCertificateArgs>,
    ) {
        this.radiusServerRootCertificates = Output.all(values.asList())
    }

    /**
     * @param values Radius Server root certificate of VpnServerConfiguration.
     */
    @JvmName("aidcqqynwstycays")
    public suspend
    fun radiusServerRootCertificates(values: List<Output<VpnServerConfigRadiusServerRootCertificateArgs>>) {
        this.radiusServerRootCertificates = Output.all(values)
    }

    /**
     * @param value The radius secret property of the VpnServerConfiguration resource for point to site client connection.
     */
    @JvmName("fkirmictmthogpri")
    public suspend fun radiusServerSecret(`value`: Output<String>) {
        this.radiusServerSecret = value
    }

    /**
     * @param value Multiple Radius Server configuration for VpnServerConfiguration.
     */
    @JvmName("hkhdbqklwmyumktk")
    public suspend fun radiusServers(`value`: Output<List<RadiusServerArgs>>) {
        this.radiusServers = value
    }

    @JvmName("uyvfuocaglnaanyy")
    public suspend fun radiusServers(vararg values: Output<RadiusServerArgs>) {
        this.radiusServers = Output.all(values.asList())
    }

    /**
     * @param values Multiple Radius Server configuration for VpnServerConfiguration.
     */
    @JvmName("volstwwpkuofyesy")
    public suspend fun radiusServers(values: List<Output<RadiusServerArgs>>) {
        this.radiusServers = Output.all(values)
    }

    /**
     * @param value The resource group name of the VpnServerConfiguration.
     */
    @JvmName("eugnwogppyiokyea")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("alelondjhsyuijue")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value VPN authentication types for the VpnServerConfiguration.
     */
    @JvmName("rgpcxsuoccsbdtiu")
    public suspend
    fun vpnAuthenticationTypes(`value`: Output<List<Either<String, VpnAuthenticationType>>>) {
        this.vpnAuthenticationTypes = value
    }

    @JvmName("qdmehrflqwxlxpdr")
    public suspend fun vpnAuthenticationTypes(
        vararg
        values: Output<Either<String, VpnAuthenticationType>>,
    ) {
        this.vpnAuthenticationTypes = Output.all(values.asList())
    }

    /**
     * @param values VPN authentication types for the VpnServerConfiguration.
     */
    @JvmName("qmqosfvpluagtbsh")
    public suspend
    fun vpnAuthenticationTypes(values: List<Output<Either<String, VpnAuthenticationType>>>) {
        this.vpnAuthenticationTypes = Output.all(values)
    }

    /**
     * @param value VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    @JvmName("avbcdvwlnxpnwwer")
    public suspend fun vpnClientIpsecPolicies(`value`: Output<List<IpsecPolicyArgs>>) {
        this.vpnClientIpsecPolicies = value
    }

    @JvmName("ngfpvpxeqkpusxdc")
    public suspend fun vpnClientIpsecPolicies(vararg values: Output<IpsecPolicyArgs>) {
        this.vpnClientIpsecPolicies = Output.all(values.asList())
    }

    /**
     * @param values VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    @JvmName("bwjabnamjatgynte")
    public suspend fun vpnClientIpsecPolicies(values: List<Output<IpsecPolicyArgs>>) {
        this.vpnClientIpsecPolicies = Output.all(values)
    }

    /**
     * @param value VPN client revoked certificate of VpnServerConfiguration.
     */
    @JvmName("oopfomvnxwyvtimq")
    public suspend
    fun vpnClientRevokedCertificates(`value`: Output<List<VpnServerConfigVpnClientRevokedCertificateArgs>>) {
        this.vpnClientRevokedCertificates = value
    }

    @JvmName("tqktrdtueucipfxg")
    public suspend fun vpnClientRevokedCertificates(
        vararg
        values: Output<VpnServerConfigVpnClientRevokedCertificateArgs>,
    ) {
        this.vpnClientRevokedCertificates = Output.all(values.asList())
    }

    /**
     * @param values VPN client revoked certificate of VpnServerConfiguration.
     */
    @JvmName("hbnpxwmgobcoyirs")
    public suspend
    fun vpnClientRevokedCertificates(values: List<Output<VpnServerConfigVpnClientRevokedCertificateArgs>>) {
        this.vpnClientRevokedCertificates = Output.all(values)
    }

    /**
     * @param value VPN client root certificate of VpnServerConfiguration.
     */
    @JvmName("ondrfkjnbjsoguyx")
    public suspend
    fun vpnClientRootCertificates(`value`: Output<List<VpnServerConfigVpnClientRootCertificateArgs>>) {
        this.vpnClientRootCertificates = value
    }

    @JvmName("dtaaliihvsysowvk")
    public suspend fun vpnClientRootCertificates(
        vararg
        values: Output<VpnServerConfigVpnClientRootCertificateArgs>,
    ) {
        this.vpnClientRootCertificates = Output.all(values.asList())
    }

    /**
     * @param values VPN client root certificate of VpnServerConfiguration.
     */
    @JvmName("micoehsdimwvrain")
    public suspend
    fun vpnClientRootCertificates(values: List<Output<VpnServerConfigVpnClientRootCertificateArgs>>) {
        this.vpnClientRootCertificates = Output.all(values)
    }

    /**
     * @param value VPN protocols for the VpnServerConfiguration.
     */
    @JvmName("olxykichjutljnwu")
    public suspend
    fun vpnProtocols(`value`: Output<List<Either<String, VpnGatewayTunnelingProtocol>>>) {
        this.vpnProtocols = value
    }

    @JvmName("uvasgsvumvwccdro")
    public suspend fun vpnProtocols(
        vararg
        values: Output<Either<String, VpnGatewayTunnelingProtocol>>,
    ) {
        this.vpnProtocols = Output.all(values.asList())
    }

    /**
     * @param values VPN protocols for the VpnServerConfiguration.
     */
    @JvmName("njghwrtjdqweeiiw")
    public suspend
    fun vpnProtocols(values: List<Output<Either<String, VpnGatewayTunnelingProtocol>>>) {
        this.vpnProtocols = Output.all(values)
    }

    /**
     * @param value The name of the VpnServerConfiguration being created or updated.
     */
    @JvmName("hcvxyawxlbmipqww")
    public suspend fun vpnServerConfigurationName(`value`: Output<String>) {
        this.vpnServerConfigurationName = value
    }

    /**
     * @param value The set of aad vpn authentication parameters.
     */
    @JvmName("keoyoxmgpvexukql")
    public suspend fun aadAuthenticationParameters(`value`: AadAuthenticationParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadAuthenticationParameters = mapped
    }

    /**
     * @param argument The set of aad vpn authentication parameters.
     */
    @JvmName("vrgprurafmgbxrmf")
    public suspend
    fun aadAuthenticationParameters(argument: suspend AadAuthenticationParametersArgsBuilder.() -> Unit) {
        val toBeMapped = AadAuthenticationParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aadAuthenticationParameters = mapped
    }

    /**
     * @param value List of all VpnServerConfigurationPolicyGroups.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("xyeychrfnckmxogv")
    public suspend
    fun configurationPolicyGroups(`value`: List<VpnServerConfigurationPolicyGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationPolicyGroups = mapped
    }

    /**
     * @param argument List of all VpnServerConfigurationPolicyGroups.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("jgmiuakhuurfbylh")
    public suspend
    fun configurationPolicyGroups(argument: List<suspend VpnServerConfigurationPolicyGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigurationPolicyGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configurationPolicyGroups = mapped
    }

    /**
     * @param argument List of all VpnServerConfigurationPolicyGroups.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("jrdmtrncjtokvjke")
    public suspend fun configurationPolicyGroups(
        vararg
        argument: suspend VpnServerConfigurationPolicyGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigurationPolicyGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.configurationPolicyGroups = mapped
    }

    /**
     * @param argument List of all VpnServerConfigurationPolicyGroups.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("nanoylqcqvkbldgg")
    public suspend
    fun configurationPolicyGroups(argument: suspend VpnServerConfigurationPolicyGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnServerConfigurationPolicyGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configurationPolicyGroups = mapped
    }

    /**
     * @param values List of all VpnServerConfigurationPolicyGroups.
     * These are also available as standalone resources. Do not mix inline and standalone resource as they will conflict with each other, leading to resources deletion.
     */
    @JvmName("lutpcuoookhempqy")
    public suspend fun configurationPolicyGroups(
        vararg
        values: VpnServerConfigurationPolicyGroupArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurationPolicyGroups = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("dihubnkmnyceakqp")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("lutinsanwsyjpsgk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the VpnServerConfiguration that is unique within a resource group.
     */
    @JvmName("ljgjjvwmxkopdexp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Radius client root certificate of VpnServerConfiguration.
     */
    @JvmName("gbbasolwchfeygxi")
    public suspend
    fun radiusClientRootCertificates(`value`: List<VpnServerConfigRadiusClientRootCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusClientRootCertificates = mapped
    }

    /**
     * @param argument Radius client root certificate of VpnServerConfiguration.
     */
    @JvmName("baprruwtvbanjuho")
    public suspend
    fun radiusClientRootCertificates(argument: List<suspend VpnServerConfigRadiusClientRootCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigRadiusClientRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusClientRootCertificates = mapped
    }

    /**
     * @param argument Radius client root certificate of VpnServerConfiguration.
     */
    @JvmName("xxslujmwucssbviw")
    public suspend fun radiusClientRootCertificates(
        vararg
        argument: suspend VpnServerConfigRadiusClientRootCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigRadiusClientRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusClientRootCertificates = mapped
    }

    /**
     * @param argument Radius client root certificate of VpnServerConfiguration.
     */
    @JvmName("eclwccvwapqweegx")
    public suspend
    fun radiusClientRootCertificates(argument: suspend VpnServerConfigRadiusClientRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnServerConfigRadiusClientRootCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.radiusClientRootCertificates = mapped
    }

    /**
     * @param values Radius client root certificate of VpnServerConfiguration.
     */
    @JvmName("huxfbcmlngsffluo")
    public suspend fun radiusClientRootCertificates(
        vararg
        values: VpnServerConfigRadiusClientRootCertificateArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.radiusClientRootCertificates = mapped
    }

    /**
     * @param value The radius server address property of the VpnServerConfiguration resource for point to site client connection.
     */
    @JvmName("sjumsihvcvgryqan")
    public suspend fun radiusServerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerAddress = mapped
    }

    /**
     * @param value Radius Server root certificate of VpnServerConfiguration.
     */
    @JvmName("iovifxubcrcbhfbn")
    public suspend
    fun radiusServerRootCertificates(`value`: List<VpnServerConfigRadiusServerRootCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerRootCertificates = mapped
    }

    /**
     * @param argument Radius Server root certificate of VpnServerConfiguration.
     */
    @JvmName("ellwyeaenrnvfolq")
    public suspend
    fun radiusServerRootCertificates(argument: List<suspend VpnServerConfigRadiusServerRootCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigRadiusServerRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusServerRootCertificates = mapped
    }

    /**
     * @param argument Radius Server root certificate of VpnServerConfiguration.
     */
    @JvmName("rudryatqrasadipj")
    public suspend fun radiusServerRootCertificates(
        vararg
        argument: suspend VpnServerConfigRadiusServerRootCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigRadiusServerRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusServerRootCertificates = mapped
    }

    /**
     * @param argument Radius Server root certificate of VpnServerConfiguration.
     */
    @JvmName("gcejxhjvsklxupji")
    public suspend
    fun radiusServerRootCertificates(argument: suspend VpnServerConfigRadiusServerRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnServerConfigRadiusServerRootCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.radiusServerRootCertificates = mapped
    }

    /**
     * @param values Radius Server root certificate of VpnServerConfiguration.
     */
    @JvmName("hegnvbanpuswomjg")
    public suspend fun radiusServerRootCertificates(
        vararg
        values: VpnServerConfigRadiusServerRootCertificateArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.radiusServerRootCertificates = mapped
    }

    /**
     * @param value The radius secret property of the VpnServerConfiguration resource for point to site client connection.
     */
    @JvmName("keqaaxwqlgsdqwti")
    public suspend fun radiusServerSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServerSecret = mapped
    }

    /**
     * @param value Multiple Radius Server configuration for VpnServerConfiguration.
     */
    @JvmName("ylkwkbrpbphcbkbv")
    public suspend fun radiusServers(`value`: List<RadiusServerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.radiusServers = mapped
    }

    /**
     * @param argument Multiple Radius Server configuration for VpnServerConfiguration.
     */
    @JvmName("jqelwvvwjjryrjfs")
    public suspend fun radiusServers(argument: List<suspend RadiusServerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RadiusServerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusServers = mapped
    }

    /**
     * @param argument Multiple Radius Server configuration for VpnServerConfiguration.
     */
    @JvmName("ethvlonqxmrgnmkj")
    public suspend fun radiusServers(vararg argument: suspend RadiusServerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RadiusServerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.radiusServers = mapped
    }

    /**
     * @param argument Multiple Radius Server configuration for VpnServerConfiguration.
     */
    @JvmName("jpfspmnmmwclueot")
    public suspend fun radiusServers(argument: suspend RadiusServerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RadiusServerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.radiusServers = mapped
    }

    /**
     * @param values Multiple Radius Server configuration for VpnServerConfiguration.
     */
    @JvmName("bymfvsrarmdmwlnd")
    public suspend fun radiusServers(vararg values: RadiusServerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.radiusServers = mapped
    }

    /**
     * @param value The resource group name of the VpnServerConfiguration.
     */
    @JvmName("lnmlmiewvvqvhcuo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vhldeemrbimmfprk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("bgaqsrmbfwvcnyxa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value VPN authentication types for the VpnServerConfiguration.
     */
    @JvmName("apdjtssvbgxxxoba")
    public suspend fun vpnAuthenticationTypes(`value`: List<Either<String, VpnAuthenticationType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnAuthenticationTypes = mapped
    }

    /**
     * @param values VPN authentication types for the VpnServerConfiguration.
     */
    @JvmName("oixvhqtctnjflaxn")
    public suspend fun vpnAuthenticationTypes(vararg values: Either<String, VpnAuthenticationType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnAuthenticationTypes = mapped
    }

    /**
     * @param value VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    @JvmName("nbpbevmxvmyqgamc")
    public suspend fun vpnClientIpsecPolicies(`value`: List<IpsecPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    @JvmName("pxwmtweeoqrankne")
    public suspend
    fun vpnClientIpsecPolicies(argument: List<suspend IpsecPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    @JvmName("xjuedqrnjrtswsgf")
    public suspend fun vpnClientIpsecPolicies(
        vararg
        argument: suspend IpsecPolicyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { IpsecPolicyArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param argument VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    @JvmName("ptiqqywcmraihuvn")
    public suspend fun vpnClientIpsecPolicies(argument: suspend IpsecPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpsecPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param values VpnClientIpsecPolicies for VpnServerConfiguration.
     */
    @JvmName("fueadvudrimmosxh")
    public suspend fun vpnClientIpsecPolicies(vararg values: IpsecPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientIpsecPolicies = mapped
    }

    /**
     * @param value VPN client revoked certificate of VpnServerConfiguration.
     */
    @JvmName("gayhqmjhuavwsbfl")
    public suspend
    fun vpnClientRevokedCertificates(`value`: List<VpnServerConfigVpnClientRevokedCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VPN client revoked certificate of VpnServerConfiguration.
     */
    @JvmName("fboixihewkvueddi")
    public suspend
    fun vpnClientRevokedCertificates(argument: List<suspend VpnServerConfigVpnClientRevokedCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigVpnClientRevokedCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VPN client revoked certificate of VpnServerConfiguration.
     */
    @JvmName("jiccopsovcffeqww")
    public suspend fun vpnClientRevokedCertificates(
        vararg
        argument: suspend VpnServerConfigVpnClientRevokedCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigVpnClientRevokedCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param argument VPN client revoked certificate of VpnServerConfiguration.
     */
    @JvmName("wbefgwgehoqfwywr")
    public suspend
    fun vpnClientRevokedCertificates(argument: suspend VpnServerConfigVpnClientRevokedCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnServerConfigVpnClientRevokedCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param values VPN client revoked certificate of VpnServerConfiguration.
     */
    @JvmName("ajjmeqjdoadolffg")
    public suspend fun vpnClientRevokedCertificates(
        vararg
        values: VpnServerConfigVpnClientRevokedCertificateArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientRevokedCertificates = mapped
    }

    /**
     * @param value VPN client root certificate of VpnServerConfiguration.
     */
    @JvmName("cdsyouachbbpcltk")
    public suspend
    fun vpnClientRootCertificates(`value`: List<VpnServerConfigVpnClientRootCertificateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param argument VPN client root certificate of VpnServerConfiguration.
     */
    @JvmName("ovecnijvepmolycq")
    public suspend
    fun vpnClientRootCertificates(argument: List<suspend VpnServerConfigVpnClientRootCertificateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigVpnClientRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param argument VPN client root certificate of VpnServerConfiguration.
     */
    @JvmName("nfarixqycvhcoawp")
    public suspend fun vpnClientRootCertificates(
        vararg
        argument: suspend VpnServerConfigVpnClientRootCertificateArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VpnServerConfigVpnClientRootCertificateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param argument VPN client root certificate of VpnServerConfiguration.
     */
    @JvmName("sevvxddwuqwxykki")
    public suspend
    fun vpnClientRootCertificates(argument: suspend VpnServerConfigVpnClientRootCertificateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VpnServerConfigVpnClientRootCertificateArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param values VPN client root certificate of VpnServerConfiguration.
     */
    @JvmName("nududhwbpkpsbfil")
    public suspend fun vpnClientRootCertificates(
        vararg
        values: VpnServerConfigVpnClientRootCertificateArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnClientRootCertificates = mapped
    }

    /**
     * @param value VPN protocols for the VpnServerConfiguration.
     */
    @JvmName("gkillsjxtmlfcujq")
    public suspend fun vpnProtocols(`value`: List<Either<String, VpnGatewayTunnelingProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnProtocols = mapped
    }

    /**
     * @param values VPN protocols for the VpnServerConfiguration.
     */
    @JvmName("mwfmvywdpgccjtnk")
    public suspend fun vpnProtocols(vararg values: Either<String, VpnGatewayTunnelingProtocol>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpnProtocols = mapped
    }

    /**
     * @param value The name of the VpnServerConfiguration being created or updated.
     */
    @JvmName("gmwyeajvdhjjbhgj")
    public suspend fun vpnServerConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnServerConfigurationName = mapped
    }

    internal fun build(): VpnServerConfigurationArgs = VpnServerConfigurationArgs(
        aadAuthenticationParameters = aadAuthenticationParameters,
        configurationPolicyGroups = configurationPolicyGroups,
        id = id,
        location = location,
        name = name,
        radiusClientRootCertificates = radiusClientRootCertificates,
        radiusServerAddress = radiusServerAddress,
        radiusServerRootCertificates = radiusServerRootCertificates,
        radiusServerSecret = radiusServerSecret,
        radiusServers = radiusServers,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vpnAuthenticationTypes = vpnAuthenticationTypes,
        vpnClientIpsecPolicies = vpnClientIpsecPolicies,
        vpnClientRevokedCertificates = vpnClientRevokedCertificates,
        vpnClientRootCertificates = vpnClientRootCertificates,
        vpnProtocols = vpnProtocols,
        vpnServerConfigurationName = vpnServerConfigurationName,
    )
}
