@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin

import com.pulumi.azurenative.network.ZoneArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ZoneType
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.network.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a DNS zone.
 * Azure REST API version: 2018-05-01. Prior API version in Azure Native 1.x: 2018-05-01.
 * Other available API versions: 2015-05-04-preview, 2016-04-01, 2023-07-01-preview.
 * ## Example Usage
 * ### Create zone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var zone = new AzureNative.Network.Zone("zone", new()
 *     {
 *         Location = "Global",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         ZoneName = "zone1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/network/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := network.NewZone(ctx, "zone", &network.ZoneArgs{
 * 			Location:          pulumi.String("Global"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			ZoneName: pulumi.String("zone1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.network.Zone;
 * import com.pulumi.azurenative.network.ZoneArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var zone = new Zone("zone", ZoneArgs.builder()
 *             .location("Global")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .zoneName("zone1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:network:Zone zone1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/dnsZones/{zoneName}
 * ```
 * @property location Resource location.
 * @property registrationVirtualNetworks A list of references to virtual networks that register hostnames in this DNS zone. This is a only when ZoneType is Private.
 * @property resolutionVirtualNetworks A list of references to virtual networks that resolve records in this DNS zone. This is a only when ZoneType is Private.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags.
 * @property zoneName The name of the DNS zone (without a terminating dot).
 * @property zoneType The type of this DNS zone (Public or Private).
 */
public data class ZoneArgs(
    public val location: Output<String>? = null,
    public val registrationVirtualNetworks: Output<List<SubResourceArgs>>? = null,
    public val resolutionVirtualNetworks: Output<List<SubResourceArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zoneName: Output<String>? = null,
    public val zoneType: Output<ZoneType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.ZoneArgs> {
    override fun toJava(): com.pulumi.azurenative.network.ZoneArgs =
        com.pulumi.azurenative.network.ZoneArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .registrationVirtualNetworks(
                registrationVirtualNetworks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resolutionVirtualNetworks(
                resolutionVirtualNetworks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneName(zoneName?.applyValue({ args0 -> args0 }))
            .zoneType(zoneType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ZoneArgs].
 */
@PulumiTagMarker
public class ZoneArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var registrationVirtualNetworks: Output<List<SubResourceArgs>>? = null

    private var resolutionVirtualNetworks: Output<List<SubResourceArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zoneName: Output<String>? = null

    private var zoneType: Output<ZoneType>? = null

    /**
     * @param value Resource location.
     */
    @JvmName("exjvdidyrebdgbgl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value A list of references to virtual networks that register hostnames in this DNS zone. This is a only when ZoneType is Private.
     */
    @JvmName("wlcxrnbcawcxcehy")
    public suspend fun registrationVirtualNetworks(`value`: Output<List<SubResourceArgs>>) {
        this.registrationVirtualNetworks = value
    }

    @JvmName("skviqnqxqxrhjvsg")
    public suspend fun registrationVirtualNetworks(vararg values: Output<SubResourceArgs>) {
        this.registrationVirtualNetworks = Output.all(values.asList())
    }

    /**
     * @param values A list of references to virtual networks that register hostnames in this DNS zone. This is a only when ZoneType is Private.
     */
    @JvmName("desceiqpapyevuwc")
    public suspend fun registrationVirtualNetworks(values: List<Output<SubResourceArgs>>) {
        this.registrationVirtualNetworks = Output.all(values)
    }

    /**
     * @param value A list of references to virtual networks that resolve records in this DNS zone. This is a only when ZoneType is Private.
     */
    @JvmName("dyhscyfskrjlglca")
    public suspend fun resolutionVirtualNetworks(`value`: Output<List<SubResourceArgs>>) {
        this.resolutionVirtualNetworks = value
    }

    @JvmName("opluauoifqmudnsn")
    public suspend fun resolutionVirtualNetworks(vararg values: Output<SubResourceArgs>) {
        this.resolutionVirtualNetworks = Output.all(values.asList())
    }

    /**
     * @param values A list of references to virtual networks that resolve records in this DNS zone. This is a only when ZoneType is Private.
     */
    @JvmName("xkecstcaiilykjtd")
    public suspend fun resolutionVirtualNetworks(values: List<Output<SubResourceArgs>>) {
        this.resolutionVirtualNetworks = Output.all(values)
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("kbfyufsetddnnytc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("utwmarsqxbplctlm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the DNS zone (without a terminating dot).
     */
    @JvmName("altoclvqgsdtknat")
    public suspend fun zoneName(`value`: Output<String>) {
        this.zoneName = value
    }

    /**
     * @param value The type of this DNS zone (Public or Private).
     */
    @JvmName("wbeuxubkrvmcugjd")
    public suspend fun zoneType(`value`: Output<ZoneType>) {
        this.zoneType = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("krjdjrqlkvpttfyt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value A list of references to virtual networks that register hostnames in this DNS zone. This is a only when ZoneType is Private.
     */
    @JvmName("qbbghuylmmwakmwp")
    public suspend fun registrationVirtualNetworks(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationVirtualNetworks = mapped
    }

    /**
     * @param argument A list of references to virtual networks that register hostnames in this DNS zone. This is a only when ZoneType is Private.
     */
    @JvmName("tibhlqnnbbfkqykn")
    public suspend
    fun registrationVirtualNetworks(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.registrationVirtualNetworks = mapped
    }

    /**
     * @param argument A list of references to virtual networks that register hostnames in this DNS zone. This is a only when ZoneType is Private.
     */
    @JvmName("buwbtvlxhwakurgv")
    public suspend fun registrationVirtualNetworks(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.registrationVirtualNetworks = mapped
    }

    /**
     * @param argument A list of references to virtual networks that register hostnames in this DNS zone. This is a only when ZoneType is Private.
     */
    @JvmName("lfdosmiyhgglgskp")
    public suspend
    fun registrationVirtualNetworks(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.registrationVirtualNetworks = mapped
    }

    /**
     * @param values A list of references to virtual networks that register hostnames in this DNS zone. This is a only when ZoneType is Private.
     */
    @JvmName("jpfkwvdufoneveqe")
    public suspend fun registrationVirtualNetworks(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.registrationVirtualNetworks = mapped
    }

    /**
     * @param value A list of references to virtual networks that resolve records in this DNS zone. This is a only when ZoneType is Private.
     */
    @JvmName("lqygwlljfftswryd")
    public suspend fun resolutionVirtualNetworks(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resolutionVirtualNetworks = mapped
    }

    /**
     * @param argument A list of references to virtual networks that resolve records in this DNS zone. This is a only when ZoneType is Private.
     */
    @JvmName("vwmmdhakltwmmlpi")
    public suspend
    fun resolutionVirtualNetworks(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.resolutionVirtualNetworks = mapped
    }

    /**
     * @param argument A list of references to virtual networks that resolve records in this DNS zone. This is a only when ZoneType is Private.
     */
    @JvmName("dirmuxhhrnprfpax")
    public suspend fun resolutionVirtualNetworks(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.resolutionVirtualNetworks = mapped
    }

    /**
     * @param argument A list of references to virtual networks that resolve records in this DNS zone. This is a only when ZoneType is Private.
     */
    @JvmName("nnexdavotfnqawyy")
    public suspend
    fun resolutionVirtualNetworks(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.resolutionVirtualNetworks = mapped
    }

    /**
     * @param values A list of references to virtual networks that resolve records in this DNS zone. This is a only when ZoneType is Private.
     */
    @JvmName("ahmcmkwsruhmwgxf")
    public suspend fun resolutionVirtualNetworks(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resolutionVirtualNetworks = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vypwxorkpemskeep")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("txkwikdfkkxcevwu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qntrrowndnfjhntn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the DNS zone (without a terminating dot).
     */
    @JvmName("vvoapugclwcslkwi")
    public suspend fun zoneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneName = mapped
    }

    /**
     * @param value The type of this DNS zone (Public or Private).
     */
    @JvmName("edvscbtefmvylesd")
    public suspend fun zoneType(`value`: ZoneType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneType = mapped
    }

    internal fun build(): ZoneArgs = ZoneArgs(
        location = location,
        registrationVirtualNetworks = registrationVirtualNetworks,
        resolutionVirtualNetworks = resolutionVirtualNetworks,
        resourceGroupName = resourceGroupName,
        tags = tags,
        zoneName = zoneName,
        zoneType = zoneType,
    )
}
