@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The access type of the rule.
 */
public enum class Access(
    public val javaValue: com.pulumi.azurenative.network.enums.Access,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.Access> {
    Allow(com.pulumi.azurenative.network.enums.Access.Allow),
    Deny(com.pulumi.azurenative.network.enums.Access.Deny),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.Access = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.Access): Access =
            Access.values().first { it.javaValue == javaType }
    }
}
