@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The commissioned state of the Custom IP Prefix.
 */
public enum class CommissionedState(
    public val javaValue: com.pulumi.azurenative.network.enums.CommissionedState,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.CommissionedState> {
    Provisioning(com.pulumi.azurenative.network.enums.CommissionedState.Provisioning),
    Provisioned(com.pulumi.azurenative.network.enums.CommissionedState.Provisioned),
    Commissioning(com.pulumi.azurenative.network.enums.CommissionedState.Commissioning),
    CommissionedNoInternetAdvertise(com.pulumi.azurenative.network.enums.CommissionedState.CommissionedNoInternetAdvertise),
    Commissioned(com.pulumi.azurenative.network.enums.CommissionedState.Commissioned),
    Decommissioning(com.pulumi.azurenative.network.enums.CommissionedState.Decommissioning),
    Deprovisioning(com.pulumi.azurenative.network.enums.CommissionedState.Deprovisioning),
    Deprovisioned(com.pulumi.azurenative.network.enums.CommissionedState.Deprovisioned),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.CommissionedState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.CommissionedState):
            CommissionedState = CommissionedState.values().first { it.javaValue == javaType }
    }
}
