@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The Geo for CIDR advertising. Should be an Geo code.
 */
public enum class Geo(
    public val javaValue: com.pulumi.azurenative.network.enums.Geo,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.Geo> {
    GLOBAL(com.pulumi.azurenative.network.enums.Geo.GLOBAL),
    AFRI(com.pulumi.azurenative.network.enums.Geo.AFRI),
    APAC(com.pulumi.azurenative.network.enums.Geo.APAC),
    EURO(com.pulumi.azurenative.network.enums.Geo.EURO),
    LATAM(com.pulumi.azurenative.network.enums.Geo.LATAM),
    NAM(com.pulumi.azurenative.network.enums.Geo.NAM),
    ME(com.pulumi.azurenative.network.enums.Geo.ME),
    OCEANIA(com.pulumi.azurenative.network.enums.Geo.OCEANIA),
    AQ(com.pulumi.azurenative.network.enums.Geo.AQ),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.Geo = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.Geo): Geo =
            Geo.values().first { it.javaValue == javaType }
    }
}
