@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The IKE encryption algorithm (IKE phase 2).
 */
public enum class IkeEncryption(
    public val javaValue: com.pulumi.azurenative.network.enums.IkeEncryption,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.IkeEncryption> {
    DES(com.pulumi.azurenative.network.enums.IkeEncryption.DES),
    DES3(com.pulumi.azurenative.network.enums.IkeEncryption.DES3),
    AES128(com.pulumi.azurenative.network.enums.IkeEncryption.AES128),
    AES192(com.pulumi.azurenative.network.enums.IkeEncryption.AES192),
    AES256(com.pulumi.azurenative.network.enums.IkeEncryption.AES256),
    GCMAES256(com.pulumi.azurenative.network.enums.IkeEncryption.GCMAES256),
    GCMAES128(com.pulumi.azurenative.network.enums.IkeEncryption.GCMAES128),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.IkeEncryption = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.IkeEncryption): IkeEncryption =
            IkeEncryption.values().first { it.javaValue == javaType }
    }
}
