@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The peering sync status of the virtual network peering.
 */
public enum class VirtualNetworkPeeringLevel(
    public val javaValue: com.pulumi.azurenative.network.enums.VirtualNetworkPeeringLevel,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.VirtualNetworkPeeringLevel> {
    FullyInSync(com.pulumi.azurenative.network.enums.VirtualNetworkPeeringLevel.FullyInSync),
    RemoteNotInSync(com.pulumi.azurenative.network.enums.VirtualNetworkPeeringLevel.RemoteNotInSync),
    LocalNotInSync(com.pulumi.azurenative.network.enums.VirtualNetworkPeeringLevel.LocalNotInSync),
    LocalAndRemoteNotInSync(com.pulumi.azurenative.network.enums.VirtualNetworkPeeringLevel.LocalAndRemoteNotInSync),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.VirtualNetworkPeeringLevel = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.VirtualNetworkPeeringLevel):
            VirtualNetworkPeeringLevel =
            VirtualNetworkPeeringLevel.values().first { it.javaValue == javaType }
    }
}
