@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of this DNS zone (Public or Private).
 */
public enum class ZoneType(
    public val javaValue: com.pulumi.azurenative.network.enums.ZoneType,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.ZoneType> {
    Public(com.pulumi.azurenative.network.enums.ZoneType.Public),
    Private(com.pulumi.azurenative.network.enums.ZoneType.Private),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.ZoneType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.ZoneType): ZoneType =
            ZoneType.values().first { it.javaValue == javaType }
    }
}
