@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.AaaaRecordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An AAAA record.
 * @property ipv6Address The IPv6 address of this AAAA record.
 */
public data class AaaaRecordArgs(
    public val ipv6Address: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.AaaaRecordArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.AaaaRecordArgs =
        com.pulumi.azurenative.network.inputs.AaaaRecordArgs.builder()
            .ipv6Address(ipv6Address?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AaaaRecordArgs].
 */
@PulumiTagMarker
public class AaaaRecordArgsBuilder internal constructor() {
    private var ipv6Address: Output<String>? = null

    /**
     * @param value The IPv6 address of this AAAA record.
     */
    @JvmName("tihbtrrnwipfwxfp")
    public suspend fun ipv6Address(`value`: Output<String>) {
        this.ipv6Address = value
    }

    /**
     * @param value The IPv6 address of this AAAA record.
     */
    @JvmName("mdfbchoouvbwvdhr")
    public suspend fun ipv6Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Address = mapped
    }

    internal fun build(): AaaaRecordArgs = AaaaRecordArgs(
        ipv6Address = ipv6Address,
    )
}
